/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui.gradjevinarstvo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jdesktop.application.Application;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.commons.PzIdGen;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturaparameter;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.RadniNalog;
import rs.pezar.db.entity.Taksafaktura;
import rs.pezar.db.entity.TaksafakturaPK;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.Tekuciracun;
import rs.pezar.db.entity.Uplata;
import rs.pezar.db.management.PzPorukeManager;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.proizvodnja.gui.gradjevinarstvo.ZatvoriFakturuAvansom;
import rs.pezar.reports.PzReportManager;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.sifarnici.util.KomitentPrometUtility;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextAreaPanel;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class ArhivaFaktura
extends PzDialog {
    public static String ZATVARANJE_FAKTURE_AVANSOM_DISCRIMINATOR = "ZFA";
    public static final String SA_POREZOM = "Sa porezom";
    public static final String BEZ_POREZA = "Bez poreza";
    public static final String SA_PRAVOM = "Sa pravom na odbitak";
    public static final String BEZ_PRAVA = "Bez prava na odbitak";
    private static final long serialVersionUID = -4289120963825324524L;
    private PzDateField dfDatumValute;
    private JLabel lblDatumValute;
    private PzNumericOnlyTextField nfBrojDanaValute;
    private JLabel lblBrojDanaValute;
    private PzDateField dfDatumIzrade;
    private JLabel lblTekuciRacuni;
    private PzPanel pnlAvans;
    private PzButton btnAvans;
    private PzDoubleField tfOstatakAvansa;
    private JLabel lblOstatakAvansa;
    private PzRadioGroup panelRBs2;
    private PzRadioGroup panelRBs1;
    private PzPanel pnlRBS;
    private JLabel lblDatumIzrade;
    private PzPanel plGornji;
    private PzTable tblRacuni;
    private JScrollPane scPaneRacuni;
    private PzPanel plDonji;
    private JLabel lblStandardnePoruke;
    private PzTextAreaPanel taStandardnePoruke;
    private JScrollPane scPaneOpis;
    private PzButton btnPotvrdi;
    private Vector<Uplata> uplataList;
    private Faktura f;
    private Radnajedinica rj;

    public ArhivaFaktura(PzDialog dialog) {
        super(dialog);
        this.initGUI();
        this.postInit();
        this.paintPanel();
    }

    private void postInit() {
        try {
            this.tfOstatakAvansa.setVal((Object)KomitentPrometUtility.getOstatakAvansaKupci((String)((Komitent)this.getSession().getParameter("komitent")).getSfrKomitent()));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void paintPanel() {
        this.plDonji.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.plDonji.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.plDonji.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Arhiva fakture ");
            this.plDonji = new PzPanel();
            GridBagLayout plDonjiLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.plDonji, "Center");
            this.plDonji.setPreferredSize(new Dimension(576, 274));
            plDonjiLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.0, 0.0};
            plDonjiLayout.rowHeights = new int[]{42, 83, 27, 140, 33};
            plDonjiLayout.columnWeights = new double[]{0.1, 0.1};
            plDonjiLayout.columnWidths = new int[]{355, 355};
            this.plDonji.setLayout((LayoutManager)plDonjiLayout);
            this.scPaneRacuni = new JScrollPane();
            this.plDonji.add((Component)this.scPaneRacuni, (Object)new GridBagConstraints(0, 2, 1, 2, 0.0, 0.0, 10, 1, new Insets(25, 5, 0, 5), 0, 0));
            List data = PzFirma.getFirma().getTekuciracuns();
            this.tblRacuni = new PzTable(data, Tekuciracun.class);
            this.tblRacuni.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ArhivaFaktura.this.taStandardnePoruke.getArea().requestFocusInWindow();
                }
            });
            this.tblRacuni.hideColumnByName("Podrazumevani");
            if (this.tblRacuni.getDataSize() > 0) {
                int index = -1;
                int i = 0;
                while (i < this.tblRacuni.getDataSize()) {
                    index = Integer.parseInt(this.tblRacuni.getModel().getValueAt(this.tblRacuni.convertRowIndexToModel(i), 0).toString());
                    if (index == 1) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                this.tblRacuni.setRowSelectionInterval(index, index);
            }
            this.scPaneRacuni.setViewportView((Component)this.tblRacuni);
            this.tblRacuni.setPreferredSize(new Dimension(348, 142));
            this.btnPotvrdi = new PzButton();
            this.plDonji.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/check.png")));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setPreferredSize(new Dimension(120, 30));
            this.btnPotvrdi.setShortcut("ctrl+w");
            this.scPaneOpis = new JScrollPane();
            this.plDonji.add((Component)this.scPaneOpis, (Object)new GridBagConstraints(1, 2, 1, 2, 0.0, 0.0, 10, 1, new Insets(25, 0, 0, 5), 0, 0));
            this.taStandardnePoruke = new PzTextAreaPanel();
            this.scPaneOpis.setViewportView((Component)this.taStandardnePoruke);
            this.lblStandardnePoruke = new JLabel();
            this.plDonji.add((Component)this.lblStandardnePoruke, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 1, 0, 0), 0, 0));
            this.lblStandardnePoruke.setText("Standardne poruke");
            this.lblStandardnePoruke.setName("lblStandardnePoruke");
            this.lblTekuciRacuni = new JLabel();
            this.plDonji.add((Component)this.lblTekuciRacuni, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 6, 0, 0), 0, 0));
            this.lblTekuciRacuni.setText("Teku\u0107i ra\u010duni");
            this.lblTekuciRacuni.setName("lblTekuciRacuni");
            this.plGornji = new PzPanel();
            this.plDonji.add((Component)this.plGornji, (Object)new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            GridBagLayout plGornjiLayout = new GridBagLayout();
            plGornjiLayout.rowWeights = new double[]{0.0};
            plGornjiLayout.rowHeights = new int[]{30};
            plGornjiLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            plGornjiLayout.columnWidths = new int[]{86, 90, 99, 90, 86, 90, 20};
            this.plGornji.setLayout((LayoutManager)plGornjiLayout);
            this.plGornji.setOpaque(false);
            this.lblDatumIzrade = new JLabel();
            this.plGornji.add((Component)this.lblDatumIzrade, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 10, 0, 5), 0, 0));
            this.lblDatumIzrade.setText("Datum izrade");
            this.dfDatumIzrade = new PzDateField();
            this.plGornji.add((Component)this.dfDatumIzrade, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.dfDatumIzrade.setFont(new Font("Tahoma", 0, 14));
            this.dfDatumIzrade.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (ArhivaFaktura.this.dfDatumIzrade.getYear() != 0 && ArhivaFaktura.this.dfDatumIzrade.getYear() != PzDateUtility.getCurrentYear()) {
                        int rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Datum nije iz teku\u0107e godine! Nastavak rada?", (String)"Pitanje", null, (boolean)false);
                        return rez == 0;
                    }
                    return ArhivaFaktura.this.dfDatumIzrade.getYear() != 0;
                }
            });
            this.dfDatumIzrade.setDefaultDate(PzDateUtility.getCurrentDate());
            this.lblBrojDanaValute = new JLabel();
            this.plGornji.add((Component)this.lblBrojDanaValute, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 10, 0, 5), 0, 0));
            this.lblBrojDanaValute.setText("Broj dana valute");
            this.nfBrojDanaValute = new PzNumericOnlyTextField();
            this.plGornji.add((Component)this.nfBrojDanaValute, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.nfBrojDanaValute.setFont(new Font("Tahoma", 0, 14));
            this.nfBrojDanaValute.setPreferredSize(new Dimension(49, 24));
            this.nfBrojDanaValute.setVal((Object)0);
            this.nfBrojDanaValute.setMaxLength(5);
            this.nfBrojDanaValute.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    ArhivaFaktura.this.keyRel(evt);
                }
            });
            this.lblDatumValute = new JLabel();
            this.plGornji.add((Component)this.lblDatumValute, (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 10, 0, 5), 0, 0));
            this.lblDatumValute.setText("Datum valute");
            this.dfDatumValute = new PzDateField();
            this.plGornji.add((Component)this.dfDatumValute, (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.dfDatumValute.setFont(new Font("Tahoma", 0, 14));
            this.dfDatumValute.setDefaultDate(PzDateUtility.getCurrentDate());
            this.dfDatumValute.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (ArhivaFaktura.this.dfDatumValute.getYear() != 0 && ArhivaFaktura.this.dfDatumValute.getYear() != PzDateUtility.getCurrentYear()) {
                        int rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Datum nije iz teku\u0107e godine! Nastavak rada?", (String)"Pitanje", null, (boolean)false);
                        return rez == 0;
                    }
                    return ArhivaFaktura.this.dfDatumValute.getYear() != 0;
                }
            });
            this.pnlRBS = new PzPanel();
            GridBagLayout pnlRBSLayout = new GridBagLayout();
            this.plDonji.add((Component)this.pnlRBS, (Object)new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlRBSLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlRBSLayout.rowHeights = new int[]{7, 7, 7, 7};
            pnlRBSLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlRBSLayout.columnWidths = new int[]{8, 133, 142, 7};
            this.pnlRBS.setLayout((LayoutManager)pnlRBSLayout);
            this.pnlRBS.setOpaque(false);
            this.panelRBs1 = new PzRadioGroup((Object[])new String[]{SA_POREZOM, BEZ_POREZA});
            this.panelRBs1.setOpaque(false);
            BoxLayout panelTipDokLayout1 = new BoxLayout((Container)this.panelRBs1, 1);
            this.panelRBs1.setLayout((LayoutManager)panelTipDokLayout1);
            this.pnlRBS.add((Component)this.panelRBs1, (Object)new GridBagConstraints(1, 0, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRBs1.setBorder((Border)BorderFactory.createTitledBorder("Tip dokumenta"));
            this.panelRBs1.setSelectedValue((Object)SA_POREZOM);
            this.panelRBs1.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getValue().equals(ArhivaFaktura.SA_POREZOM)) {
                        ArhivaFaktura.this.panelRBs2.setEnabled(false);
                    } else {
                        ArhivaFaktura.this.panelRBs2.setEnabled(true);
                    }
                }
            });
            this.panelRBs2 = new PzRadioGroup((Object[])new String[]{SA_PRAVOM, BEZ_PRAVA});
            BoxLayout panelBezPLayout = new BoxLayout((Container)this.panelRBs2, 1);
            this.panelRBs2.setLayout((LayoutManager)panelBezPLayout);
            this.pnlRBS.add((Component)this.panelRBs2, (Object)new GridBagConstraints(2, 0, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRBs2.setBorder((Border)BorderFactory.createTitledBorder(BEZ_POREZA));
            this.panelRBs2.setSelectedValue((Object)SA_PRAVOM);
            this.panelRBs2.setEnabled(false);
            this.panelRBs2.setOpaque(false);
            this.pnlAvans = new PzPanel();
            GridBagLayout pnlAvansLayout = new GridBagLayout();
            this.pnlRBS.add((Component)this.pnlAvans, (Object)new GridBagConstraints(3, 0, 1, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlAvansLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlAvansLayout.rowHeights = new int[]{7, 25, 7, 7};
            pnlAvansLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlAvansLayout.columnWidths = new int[]{16, 85, 166, 7};
            this.pnlAvans.setLayout((LayoutManager)pnlAvansLayout);
            this.pnlAvans.setOpaque(false);
            this.lblOstatakAvansa = new JLabel();
            this.pnlAvans.add((Component)this.lblOstatakAvansa, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblOstatakAvansa.setText("Ostatak avansa");
            this.lblOstatakAvansa.setEnabled(false);
            this.tfOstatakAvansa = new PzDoubleField();
            this.pnlAvans.add((Component)this.tfOstatakAvansa, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tfOstatakAvansa.setEnabled(false);
            this.tfOstatakAvansa.setEditable(false);
            this.tfOstatakAvansa.setFocusable(false);
            this.btnAvans = new PzButton();
            this.pnlAvans.add((Component)this.btnAvans, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnAvans.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/check.png")));
            this.btnAvans.setPreferredSize(new Dimension(115, 55));
            this.btnAvans.setText("Zatvori fakturu avansom");
            this.btnAvans.setActionCommand("avans");
            this.btnAvans.addActionListener((ActionListener)((Object)this));
            this.btnAvans.setEnabled(false);
            this.pack();
            this.setSize(637, 385);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void keyRel(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            Date date1 = this.dfDatumIzrade.getVal();
            int val = this.nfBrojDanaValute.getIntVal();
            this.dfDatumValute.setVal((Object)PzDateUtility.add((Date)date1, (int)val));
        }
    }

    public void actionPerformed(ActionEvent e) {
        block25: {
            PzButton button = (PzButton)e.getSource();
            String actionCommand = button.getActionCommand();
            EntityManager em = PzEntityManager.getEm();
            HashMap elementi = (HashMap)this.getSession().getParameter("elementiFakture");
            try {
                if (actionCommand.equalsIgnoreCase("potvrdi")) {
                    this.f = new Faktura();
                    this.f.setTip(TipDokumentConfig.get().FAKTURA);
                    this.f.setPodTip("TRENUTNA_SITUACIJA");
                    this.f.setArhiviran((short)1);
                    this.f.setDatum((Date)this.getSession().getParameter("datumFakture"));
                    this.f.setDatArh(this.dfDatumIzrade.getVal());
                    this.f.setDatPrometa(this.dfDatumIzrade.getVal());
                    this.f.setDatValute(this.dfDatumValute.getVal());
                    this.f.setPoruka(this.taStandardnePoruke.getVal());
                    this.f.setPotvrda((String)this.getSession().getParameter("opis"));
                    Tekuciracun tekuci = (Tekuciracun)this.tblRacuni.getSelectedEntity();
                    this.f.setTekuciRacun(String.valueOf(tekuci.getBrRacuna()) + ", " + tekuci.getBanka());
                    this.f.setTaksafakturas(null);
                    this.f.setRadninalog((RadniNalog)this.getSession().getParameter("radninalog"));
                    this.f.setIznosBezPoreza((BigDecimal)elementi.get("iznosBezPDV"));
                    this.f.setKomitent((Komitent)this.getSession().getParameter("komitent"));
                    int rbroj = PzIdGen.getNextId((String)"FAKTURA_TRENUTNE_SIT_ID", (int)1).getIdVal();
                    this.f.setrBroj(rbroj);
                    this.f.formirajOznaku();
                    this.f.setKurs(((Double)this.getSession().getParameter("kurs")).doubleValue());
                    if (this.panelRBs1.getSelectedValue().equals(SA_POREZOM)) {
                        this.f.setIznos((BigDecimal)elementi.get("iznosSaPDV"));
                        this.f.setSaPorezom(1);
                    } else {
                        if (this.panelRBs2.getSelectedValue().equals(SA_PRAVOM)) {
                            this.f.setSaPravomNaOdbitak(1);
                        } else {
                            this.f.setSaPravomNaOdbitak(0);
                        }
                        this.f.setIznos((BigDecimal)elementi.get("iznosBezPDV"));
                    }
                    this.f.setArtikalfakturas(null);
                    if (this.panelRBs1.getSelectedValue().equals(SA_POREZOM)) {
                        Tarifnagrupa tg = (Tarifnagrupa)this.getSession().getParameter("tarifnaGrupa");
                        Taksafaktura taksa = new Taksafaktura();
                        TaksafakturaPK id = new TaksafakturaPK();
                        id.setIdDok(this.f.getIdDok());
                        id.setOznTarGr(tg.getOznTarGr());
                        taksa.setTarifnagrupa(tg);
                        taksa.setDokument((PzDokument)this.f);
                        taksa.setId(id);
                        taksa.setIznos(this.f.getIznos().subtract(this.f.getIznosBezPoreza()));
                        taksa.setOsnovica(this.f.getIznosBezPoreza());
                        taksa.setVrsta("PDV");
                        taksa.setTip(PzTaksaDokument.TIP_IZRACUNATI);
                        this.f.setTaksafakturas(new Vector());
                        this.f.getTaksafakturas().add(taksa);
                    }
                    this.btnPotvrdi.setText("Kraj");
                    this.btnPotvrdi.setActionCommand("kraj");
                    if (this.tfOstatakAvansa.getVal() > 0.0) {
                        this.lblOstatakAvansa.setEnabled(true);
                        this.tfOstatakAvansa.setEnabled(true);
                        this.btnAvans.setEnabled(true);
                    }
                    this.setDisabledComponents();
                    List poruke = PzPorukeManager.getPoruke((PzDokument)this.f, (EntityManager)em);
                    if (poruke.size() != 0) {
                        this.taStandardnePoruke.setVal(poruke.get(0));
                    }
                    break block25;
                }
                if (actionCommand.equalsIgnoreCase("avans")) {
                    this.f.setUplata(new BigDecimal(0));
                    this.getSession().putParameter("komitent", (Object)this.f.getKomitent());
                    this.getSession().putParameter("datumDokumenta", (Object)this.f.getDatum());
                    this.getSession().putParameter("dokument", (Object)this.f);
                    this.showDialog(ZatvoriFakturuAvansom.class);
                    this.uplataList = new Vector();
                    this.uplataList = (Vector)this.getSession().getParameter(String.valueOf(this.f.getIdDok()) + "avansi");
                    break block25;
                }
                if (!actionCommand.equalsIgnoreCase("kraj")) break block25;
                this.rj = PzDialogRJ.getRJExcluding((PzDialog)this, (Character[])new Character[]{Character.valueOf('E')});
                if (this.rj == null) {
                    return;
                }
                try {
                    em.getTransaction().begin();
                    this.f.setRadnajedinica(this.rj);
                    PzDokumentManager.getInstance().snimiDokument((PzDokument)this.f, false, null, em);
                    Fakturaparameter rad = new Fakturaparameter(this.f.getIdDok(), "rad", ((BigDecimal)elementi.get("rad")).toString(), "");
                    Fakturaparameter materijal = new Fakturaparameter(this.f.getIdDok(), "materijal", ((BigDecimal)elementi.get("materijal")).toString(), "");
                    Fakturaparameter indtroskovi = new Fakturaparameter(this.f.getIdDok(), "indtroskovi", ((BigDecimal)elementi.get("indTroskovi")).toString(), "");
                    this.f.addFakturaparameter(rad);
                    this.f.addFakturaparameter(materijal);
                    this.f.addFakturaparameter(indtroskovi);
                    this.f.setPoruka(this.taStandardnePoruke.getVal());
                    RadniNalog r = (RadniNalog)em.find(RadniNalog.class, (Object)this.f.getRadninalog().getOznRadniNalog());
                    r.setDirektanRad(r.getDirektanRad().add((BigDecimal)elementi.get("rad")));
                    if (this.uplataList != null) {
                        int i = 0;
                        while (i < this.uplataList.size()) {
                            this.f.setUplata(this.f.getUplata().add(this.uplataList.get(i).getIznos()));
                            ++i;
                        }
                    }
                    for (Faktura fr : r.getFakturas()) {
                        this.f.setFakturas(new Vector());
                        this.f.getFakturas().add(fr);
                    }
                    PzDokumentManager.getInstance().arhivirajDokument((PzDokument)this.f, false, null, em);
                    if (this.uplataList != null && this.uplataList.size() != 0) {
                        int i = 0;
                        while (i < this.uplataList.size()) {
                            this.uplataList.get(i).setOznDokumenta(this.f.getOznDokumenta());
                            this.uplataList.get(i).setPoDokumentu(this.f.getIdDok());
                            PzDokumentManager.getInstance().arhivirajDokument((PzDokument)this.uplataList.get(i), true, null, em);
                            ++i;
                        }
                        Fakturaparameter fakP = new Fakturaparameter(this.f.getIdDok(), ZATVARANJE_FAKTURE_AVANSOM_DISCRIMINATOR, "true", "Zatvaranje fakture avansom");
                        em.persist((Object)fakP);
                    }
                    em.getTransaction().commit();
                    if (this.getSession().getParameter("tabelaFak") != null) {
                        ((PzTable)this.getSession().getParameter("tabelaFak")).insert((PzEntity)this.f, false);
                    }
                    if (this.getSession().getParameter("radninalog") != null) {
                        ((RadniNalog)this.getSession().getParameter("radninalog")).getFakturas().add(this.f);
                    }
                    PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.f);
                    ((Window)SwingUtilities.getRoot((Component)this.btnPotvrdi)).dispose();
                    ((PzDialog)SwingUtilities.getRoot((Component)this.btnPotvrdi)).getOwner().dispose();
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                }
            }
            finally {
                if (em.isOpen()) {
                    em.close();
                }
            }
        }
    }

    public void setDisabledComponents() {
        this.lblBrojDanaValute.setEnabled(false);
        this.lblDatumIzrade.setEnabled(false);
        this.lblDatumValute.setEnabled(false);
        this.dfDatumIzrade.setEnabled(false);
        this.dfDatumValute.setEnabled(false);
        this.panelRBs1.setEnabled(false);
        this.panelRBs2.setEnabled(false);
        this.nfBrojDanaValute.setEnabled(false);
        this.tblRacuni.setEnabled(false);
    }
}

