/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.db.PZDBF;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.proizvodnja.PzExtensionLoader;
import rs.pezar.proizvodnja.gui.trebovanje.PzDialogIzrada;
import rs.pezar.proizvodnja.util.ProizvodnjaGradientUtil;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogTrebovanje
extends PzDialog {
    private static final long serialVersionUID = 1L;
    protected static Opstidokument selected;
    private JToolBar toolbar;
    private PzToolBarIcon icnBrisanje;
    private PzToolBarIcon icnIzmena;
    private PzToolBarIcon icnDodavanje;
    private JScrollPane scrollPane;
    private PzTable table;
    private PzPanel mainPanel;
    private PzComponentGroup kIcnGroup;
    private PzComponentGroup fIcnGroup;
    private Opstidokument trebovanjeBrisanje;
    private String parameter;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    private boolean izradaGradjevinarstvo = false;
    private String tipDokumenta;
    private String tableID;

    public PzDialogTrebovanje(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogTrebovanje(PzDialog dialog) {
        super(dialog);
        this.parameter = "trebovanje";
        this.izradaGradjevinarstvo = (Boolean)this.getSession().getParameter("gradjevinarstvo") != null ? (Boolean)this.getSession().getParameter("gradjevinarstvo") : false;
        this.tipDokumenta = "TREBOVANJE";
        this.tableID = "TABLE_TREBOVANJE";
        this.setId("TREBOVANJE");
        this.initGUI();
        this.postInit();
    }

    public PzDialogTrebovanje(JFrame frame, String parameter) {
        super(frame);
        this.parameter = parameter;
        this.tipDokumenta = "TREBOVANJE";
        if (parameter.equals("trebovanje_sastavnice")) {
            this.tipDokumenta = "TREBOVANJE_SASTAVNICE";
        } else if (parameter.equals("predajnica")) {
            this.tipDokumenta = "PREDAJNICA";
        }
        this.tableID = "TABLE_TREBOVANJE";
        this.setId("TREBOVANJE");
        if (this.tipDokumenta.equals("TREBOVANJE_SASTAVNICE")) {
            this.tableID = "TABLE_TREBOVANJE_SASTAVNICE";
            this.setId("TREBOVANJE_SASTAVNICE");
        } else if (this.tipDokumenta.equals("PREDAJNICA")) {
            this.tableID = "TABLE_PREDAJNICA";
            this.setId("PREDAJNICA");
        }
        this.initGUI();
        this.postInit();
    }

    public PzDialogTrebovanje(PzDialog parent, String parameter) {
        super(parent);
        this.parameter = parameter;
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        if (this.parameter.equalsIgnoreCase("Trebovanje")) {
            this.fIcnGroup.hideAll();
            if (this.izradaGradjevinarstvo) {
                EntityManager em = PzEntityManager.getEm();
                Query query = em.createQuery("select d from Opstidokument d where d.userKraj = :user and d.arhiviran=:arhiviran and d.storno = :storno and d.tip=:tip and d.radninalog=:radninalog");
                query.setParameter("user", (Object)PzExtensionLoader.getLoggedUser());
                query.setParameter("storno", (Object)0);
                query.setParameter("arhiviran", (Object)0);
                query.setParameter("tip", (Object)"TREBOVANJE");
                query.setParameter("radninalog", this.getSession().getParameter("radninalog"));
                Vector v = (Vector)query.getResultList();
                this.table = new PzTable((List)v, Opstidokument.class);
            } else {
                this.table = new PzTable((List)PZDBF.getDokumenti((Pzuser)PzExtensionLoader.getLoggedUser(), (String)"Opstidokument", (int)0, (int)0, (String)"TREBOVANJE"), Opstidokument.class);
            }
        } else if (this.parameter.equalsIgnoreCase("trebovanje_sastavnice")) {
            this.fIcnGroup.hideAll();
            this.table = new PzTable((List)PZDBF.getDokumenti((Pzuser)PzExtensionLoader.getLoggedUser(), (String)"Opstidokument", (int)0, (int)0, (String)"TREBOVANJE_SASTAVNICE"), Opstidokument.class);
        } else if (this.parameter.equalsIgnoreCase("predajnica")) {
            this.fIcnGroup.hideAll();
            this.table = new PzTable((List)PZDBF.getDokumenti((Pzuser)PzExtensionLoader.getLoggedUser(), (String)"Opstidokument", (int)0, (int)0, (String)"PREDAJNICA"), Opstidokument.class);
        }
        this.table.setEnterAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PzDialogTrebovanje.this.table.getSelectedRow() != -1) {
                    PzDialogTrebovanje.this.getSession().putParameter("update", (Object)true);
                    PzDialogTrebovanje.this.getSession().putParameter("trebovanje", (Object)PzDialogTrebovanje.this.table.getSelectedEntity());
                    PzDialogTrebovanje.this.getSession().putParameter("tabela", (Object)PzDialogTrebovanje.this.table);
                    PzDialogTrebovanje.this.getSession().putParameter("tipDokumenta", (Object)PzDialogTrebovanje.this.tipDokumenta);
                    PzDialogTrebovanje.this.getSession().putParameter("gradjevinarstvo", (Object)PzDialogTrebovanje.this.izradaGradjevinarstvo);
                    PzDialogTrebovanje.this.showDialog(PzDialogIzrada.class);
                }
            }
        });
        this.scrollPane.setViewportView((Component)this.table);
        this.refresh();
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogTrebovanje.this.brDok.setText(Integer.toString(PzDialogTrebovanje.this.table.getDataSize()));
            }
        });
    }

    private void initGUI() {
        try {
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{104, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.kIcnGroup = new PzComponentGroup();
            this.fIcnGroup = new PzComponentGroup();
            this.toolbar.setOpaque(false);
            this.icnDodavanje = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnDodavanje);
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Novo|trebovanje|(Insert)");
            if (this.parameter.equalsIgnoreCase("predajnica")) {
                this.icnDodavanje.setText("Nova|predajnica|(Insert)");
            }
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/document_add.png")));
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setActionCommand("insert_trebovanje");
            this.icnDodavanje.setShortcut("insert");
            this.icnIzmena = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnIzmena);
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena|trebovanja|(F3)");
            if (this.parameter.equalsIgnoreCase("predajnica")) {
                this.icnIzmena.setText("Izmena|predajnice|(F3)");
            }
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/document_edit.png")));
            this.icnIzmena.setActionCommand("update_trebovanje");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("f3");
            this.icnBrisanje = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnBrisanje);
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|trebovanja|(Delete)");
            if (this.parameter.equalsIgnoreCase("predajnica")) {
                this.icnBrisanje.setText("Brisanje|predajnice|(Delete)");
            }
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/document_delete.png")));
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setActionCommand("delete_trebovanje");
            this.icnBrisanje.setShortcut("delete");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj dokumenata");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setSize(1000, 600);
            this.setMinimumSize(new Dimension(800, 600));
            this.setTitle("Trebovanja u pripremi");
            if (this.parameter.equalsIgnoreCase("predajnica")) {
                this.setTitle("Predajnice u pripremi");
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = ((PzToolBarIcon)e.getSource()).getActionCommand();
        if (actionCommand.equals("insert_trebovanje")) {
            this.getSession().putParameter("update", (Object)false);
            this.getSession().putParameter("tabela", (Object)this.table);
            this.getSession().putParameter("tipDokumenta", (Object)this.tipDokumenta);
            this.getSession().putParameter("gradjevinarstvo", (Object)this.izradaGradjevinarstvo);
            if (this.izradaGradjevinarstvo) {
                this.getSession().putParameter("radninalog", this.getSession().getParameter("radninalog"));
                this.getSession().putParameter("tabelaTreb", this.getSession().getParameter("tabelaTrebovanja"));
            }
            this.showDialog(PzDialogIzrada.class);
        } else if (actionCommand.equals("update_trebovanje")) {
            if (this.table.getSelectedRow() == -1) {
                return;
            }
            this.getSession().putParameter("update", (Object)true);
            this.getSession().putParameter("trebovanje", (Object)this.table.getSelectedEntity());
            this.getSession().putParameter("tabela", (Object)this.table);
            this.getSession().putParameter("gradjevinarstvo", (Object)this.izradaGradjevinarstvo);
            if (this.izradaGradjevinarstvo) {
                this.getSession().putParameter("radninalog", this.getSession().getParameter("radninalog"));
                this.getSession().putParameter("tabelaTreb", this.getSession().getParameter("tabelaTrebovanja"));
            }
            this.getSession().putParameter("tipDokumenta", (Object)this.tipDokumenta);
            this.showDialog(PzDialogIzrada.class);
        } else if (actionCommand.equals("delete_trebovanje")) {
            EntityManager em = PzEntityManager.getEm();
            this.trebovanjeBrisanje = (Opstidokument)this.table.getSelectedEntity();
            if (this.trebovanjeBrisanje == null) {
                return;
            }
            int rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Da li ste sigurni?", (String)"Brisanje", null, (boolean)false);
            if (rez != 0) {
                return;
            }
            try {
                em.getTransaction().begin();
                em.remove(em.find(Opstidokument.class, (Object)this.trebovanjeBrisanje.getIdDok()));
                em.getTransaction().commit();
                this.table.removeSelectedEntity(false, false);
                this.refresh();
                return;
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
            finally {
                em.close();
            }
        }
        this.table.refreshData();
        this.refresh();
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogTrebovanje(Boolean.FALSE);
    }

    public PzDialogTrebovanje(Boolean initGUI) {
    }

    public void finish() {
        this.table.removeSelectedEntity(false, false);
    }

    public static Opstidokument getTrebovanjeUPripermi(PzDialog parent, String parameter) {
        PzDialogTrebovanje dlg = new PzDialogTrebovanje(parent, parameter);
        if (!dlg.shouldBeShown()) {
            return null;
        }
        dlg.table.setEnterAction(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                selected = (Opstidokument)PzDialogTrebovanje.this.table.getSelectedEntity();
                PzDialogTrebovanje.this.dispose();
            }
        });
        dlg.restoreSize();
        dlg.setModal(true);
        dlg.setVisible(true);
        Opstidokument res = selected;
        selected = null;
        return res;
    }

    public boolean shouldBeShown() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(ProizvodnjaGradientUtil.PROIZVODNJA_GRADIENT);
        }
        return true;
    }
}

