/*
 * Decompiled with CFR 0.152.
 */
package org.cheffo.jeplite;

import org.cheffo.jeplite.Token;
import org.cheffo.jeplite.TokenMgrError;

public class ParseException
extends Exception {
    protected boolean specialConstructor;
    public Token currentToken;
    protected static final String eol = System.getProperty("line.separator", "\n");
    public int[][] expectedTokenSequences;
    public String[] tokenImage;

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    public ParseException(Token currentTokenVal, String message) {
        super(message);
        this.specialConstructor = false;
        this.currentToken = currentTokenVal;
    }

    @Override
    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        String expected = "";
        int maxSize = 0;
        int i = 0;
        while (i < this.expectedTokenSequences.length) {
            if (maxSize < this.expectedTokenSequences[i].length) {
                maxSize = this.expectedTokenSequences[i].length;
            }
            int j = 0;
            while (j < this.expectedTokenSequences[i].length) {
                expected = String.valueOf(expected) + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
                ++j;
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                expected = String.valueOf(expected) + "...";
            }
            expected = String.valueOf(expected) + eol + "    ";
            ++i;
        }
        String retval = "Encountered \"";
        Token tok = this.currentToken.next;
        int i2 = 0;
        while (i2 < maxSize) {
            if (i2 != 0) {
                retval = String.valueOf(retval) + " ";
            }
            if (tok.kind == 0) {
                retval = String.valueOf(retval) + this.tokenImage[0];
                break;
            }
            retval = String.valueOf(retval) + TokenMgrError.addEscapes(tok.image);
            tok = tok.next;
            ++i2;
        }
        retval = this.expectedTokenSequences.length == 1 ? String.valueOf(retval) + "Was expecting:" + eol + "    " : String.valueOf(retval) + "Was expecting one of:" + eol + "    ";
        retval = String.valueOf(retval) + expected;
        return retval;
    }

    public String getErrorInfo() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        String expected = "";
        int maxSize = 0;
        int i = 0;
        while (i < this.expectedTokenSequences.length) {
            if (maxSize < this.expectedTokenSequences[i].length) {
                maxSize = this.expectedTokenSequences[i].length;
            }
            int j = 0;
            while (j < this.expectedTokenSequences[i].length) {
                expected = String.valueOf(expected) + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
                ++j;
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                expected = String.valueOf(expected) + "...";
            }
            expected = String.valueOf(expected) + eol + "    ";
            ++i;
        }
        String retval = "Unexpected \"";
        Token tok = this.currentToken.next;
        int i2 = 0;
        while (i2 < maxSize) {
            if (i2 != 0) {
                retval = String.valueOf(retval) + " ";
            }
            if (tok.kind == 0) {
                retval = String.valueOf(retval) + this.tokenImage[0];
                break;
            }
            retval = String.valueOf(retval) + TokenMgrError.addEscapes(tok.image);
            tok = tok.next;
            ++i2;
        }
        return retval;
    }
}

