/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.potrazivanja;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.util.PzDateUtility;

public class PzDialogPotrazivajna
extends PzDialog {
    private static List dokumentiDob;
    private static List dokumentiKupac;
    private static Date datumDo;
    private static Date datumOd;
    private PzPanel mainPanel;
    private JToolBar toolbar;
    private JSplitPane panelTables;
    private PzTable tblDokumentiDob;
    private PzTable tblDokumentiKupac;
    private JScrollPane scrollPaneDob;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    private JScrollPane scrollPaneKupac;
    private PzToolBarIcon icnSlikaDob;
    private PzToolBarIcon icnSlikaKupac;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogPotrazivajna inst = new PzDialogPotrazivajna(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogPotrazivajna(JFrame frame) {
        super(frame);
    }

    public PzDialogPotrazivajna() {
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("slikaD")) {
            PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)((PzDokument)this.tblDokumentiDob.getSelectedEntity()));
        } else if (actionCommand.equals("slikaK")) {
            PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)((PzDokument)this.tblDokumentiKupac.getSelectedEntity()));
        }
    }

    private void postInit() {
        this.tblDokumentiDob.setData(dokumentiDob, Dokument.class);
        this.tblDokumentiKupac.setData(dokumentiKupac, Dokument.class);
        int dob = dokumentiDob.size();
        int kupac = dokumentiKupac.size();
        this.brDok.setText(String.valueOf(dob + kupac) + " (" + dob + "+" + kupac + ")");
    }

    private void initGUI() {
        try {
            BorderLayout bLayout = new BorderLayout();
            this.setLayout(bLayout);
            this.setTitle("Nepla\u0107ene fakture koje se bli\u017ee zakonom propisanoj toleranciji od 60 dana");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{101, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnSlikaDob = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSlikaDob);
            this.icnSlikaDob.setText("Slika dokumenta|(Dobavlja\u010d)|(F2)");
            this.icnSlikaDob.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/potrazivanja/resource/img/presentation_chart.png")));
            this.icnSlikaDob.setActionCommand("slikaD");
            this.icnSlikaDob.addActionListener((ActionListener)((Object)this));
            this.icnSlikaKupac = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSlikaKupac);
            this.icnSlikaKupac.setText("Slika dokumenta|(Kupac)|(F3)");
            this.icnSlikaKupac.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/potrazivanja/resource/img/presentation_chart.png")));
            this.icnSlikaKupac.setActionCommand("slikaK");
            this.icnSlikaKupac.addActionListener((ActionListener)((Object)this));
            this.panelTables = new JSplitPane();
            this.panelTables.setContinuousLayout(true);
            this.panelTables.setResizeWeight(0.5);
            this.mainPanel.add((Component)this.panelTables, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            GridBagLayout panelTablesLayout = new GridBagLayout();
            panelTablesLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            panelTablesLayout.rowHeights = new int[]{7, 7, 7, 7};
            panelTablesLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            panelTablesLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.scrollPaneDob = new JScrollPane();
            this.panelTables.add((Component)this.scrollPaneDob, "left");
            this.scrollPaneDob.setBorder(BorderFactory.createTitledBorder(null, "Dobavlja\u010di", 4, 0, new Font("Segoe UI", 1, 12), new Color(0, 0, 160)));
            this.tblDokumentiDob = new PzTable();
            this.scrollPaneDob.setViewportView((Component)this.tblDokumentiDob);
            this.tblDokumentiDob.setId("TABLE_DOBAVLJAC");
            this.tblDokumentiDob.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Dokument dok = (Dokument)entity;
                    return new Object[]{"[ " + dok.getKomitent().getSfrKomitent() + " ] " + dok.getKomitent().getNaziv(), dok.getOznDokumenta(), dok.getDatum(), 60 - PzDateUtility.subtract((Date)PzDateUtility.getCurrentDate(), (Date)dok.getDatum()), dok.getIznos().subtract(dok.getStornoIznos()).subtract(dok.getUplata())};
                }

                public String[] getColumnNames() {
                    return new String[]{"Komitent", "Oznaka dokumenta", "Datum dok.", "Br. dana do isteka", "Dug"};
                }
            });
            this.scrollPaneKupac = new JScrollPane();
            this.panelTables.add((Component)this.scrollPaneKupac, "right");
            this.scrollPaneKupac.setBorder(BorderFactory.createTitledBorder(null, "Kupci", 4, 0, new Font("Segoe UI", 1, 12), new Color(0, 0, 160)));
            this.tblDokumentiKupac = new PzTable();
            this.scrollPaneKupac.setViewportView((Component)this.tblDokumentiKupac);
            this.tblDokumentiKupac.setId("TABLE_KUPAC");
            this.tblDokumentiKupac.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Dokument dok = (Dokument)entity;
                    return new Object[]{"[ " + dok.getKomitent().getSfrKomitent() + " ] " + dok.getKomitent().getNaziv(), dok.getOznDokumenta(), dok.getDatum(), 60 - PzDateUtility.subtract((Date)PzDateUtility.getCurrentDate(), (Date)dok.getDatum()), dok.getIznos().subtract(dok.getStornoIznos()).subtract(dok.getUplata())};
                }

                public String[] getColumnNames() {
                    return new String[]{"Komitent", "Oznaka dokumenta", "Datum dok.", "Br. dana do isteka", "Dug"};
                }
            });
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj dokumenata (dobavlja\u010d+kupac)");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setSize(659, 435);
            this.setMinimumSize(new Dimension(659, 435));
            this.pack();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private static boolean getDokumenta() {
        boolean res = false;
        datumDo = PzDateUtility.add((Date)PzDateUtility.getCurrentDate(), (int)-55);
        datumOd = PzDateUtility.add((Date)PzDateUtility.getCurrentDate(), (int)-60);
        try {
            dokumentiDob = PzEntityManager.getList((String)("Select d From Dokument d join fetch d.komitent where d.vrstaDuga='D' and d.datum<='" + datumDo + "' and d.arhiviran = 1 and d.storno = 0 " + "and d.tip !='GRESKA' and d.iznos-d.stornoIznos-d.uplata <> 0 order by d.datum ASC"));
            dokumentiKupac = PzEntityManager.getList((String)("Select d From Dokument d join fetch d.komitent where d.vrstaDuga='P' and d.datum<='" + datumDo + "' and d.arhiviran = 1 and d.storno = 0 " + "and d.tip !='GRESKA' and d.iznos-d.stornoIznos-d.uplata <> 0 order by d.datum ASC"));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
        if (dokumentiDob.size() > 0 || dokumentiKupac.size() > 0) {
            res = true;
        }
        return res;
    }

    public static void showDialogPotrazivanja() {
        Pzuser usr = PzApplication.getApplication().getSession().getLoggedUser();
        if ((usr.isManager() || usr.getDozvola("POSEBNA DOZVOLA", "ALARM_RACUNI_DOBAVLJACA") != null) && PzApplication.getApplication().getWorkbench() != null && PzDialogPotrazivajna.getDokumenta()) {
            PzDialogPotrazivajna dlg = new PzDialogPotrazivajna(PzApplication.getApplication().getWorkbench().getMainFrame());
            dlg.initGUI();
            dlg.postInit();
            dlg.setVisible(true);
        }
    }
}

