/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prostoKnjigovodstvo.gui.knjizenje;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import javax.persistence.EntityManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Nzk;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Stavkanzk;
import rs.pezar.prostoKnjigovodstvo.gui.util.Tools;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;

public class IzborStampe
extends PzDialog {
    private static final long serialVersionUID = -5673051789312370519L;
    private final JPanel contentPanel = new JPanel();
    private PzPanelHeader pnlHeader;
    private PzPanel pnlForm;
    private PzDateField datDatum;
    private JLabel lblDatumNaloga;
    private PzRadioGroup<String> rgrIzbor;
    private final String DETALJAN = "Detaljan nalog";
    private final String ZBIRNI = "Zbirni nalog";
    private final String OBA = "Oba oblika";
    public static Date DATE;
    public static boolean EXECUTED;

    static {
        EXECUTED = false;
    }

    public static void main(String[] args) {
        try {
            IzborStampe dialog = new IzborStampe();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IzborStampe() {
        this.initGUI();
    }

    public IzborStampe(PzDialog parent) {
        super(parent);
        this.initGUI();
    }

    private void initGUI() {
        this.setBounds(100, 100, 450, 300);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.contentPanel.add((Component)buttonPane, "South");
        JButton okButton = new JButton("OK");
        okButton.setIcon(new ImageIcon(IzborStampe.class.getResource("/rs/pezar/finansije/resource/img/check.png")));
        okButton.addActionListener((ActionListener)((Object)this));
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.pnlHeader = new PzPanelHeader();
        this.pnlHeader.setText("Probno \u0161tampanje naloga u pripremi");
        this.pnlHeader.setTitle("Izbor \u0161tampe");
        this.pnlHeader.setIcon(new ImageIcon(IzborStampe.class.getResource("/rs/pezar/finansije/resource/img/printer_preferences.png")));
        this.contentPanel.add((Component)this.pnlHeader, "North");
        this.pnlForm = new PzPanel();
        this.pnlForm.setBorder(null);
        this.contentPanel.add((Component)this.pnlForm, "Center");
        GridBagLayout gbl_pnlForm = new GridBagLayout();
        int[] nArray = new int[5];
        nArray[0] = 67;
        nArray[1] = 100;
        nArray[2] = 110;
        nArray[3] = 84;
        gbl_pnlForm.columnWidths = nArray;
        gbl_pnlForm.rowHeights = new int[3];
        gbl_pnlForm.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_pnlForm.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        this.pnlForm.setLayout((LayoutManager)gbl_pnlForm);
        this.lblDatumNaloga = new JLabel("Datum naloga:");
        GridBagConstraints gbc_lblDatumNaloga = new GridBagConstraints();
        gbc_lblDatumNaloga.insets = new Insets(0, 0, 5, 5);
        gbc_lblDatumNaloga.anchor = 13;
        gbc_lblDatumNaloga.gridx = 1;
        gbc_lblDatumNaloga.gridy = 0;
        this.pnlForm.add((Component)this.lblDatumNaloga, (Object)gbc_lblDatumNaloga);
        this.datDatum = new PzDateField();
        GridBagConstraints gbc_datDatum = new GridBagConstraints();
        gbc_datDatum.insets = new Insets(0, 0, 5, 5);
        gbc_datDatum.fill = 2;
        gbc_datDatum.gridx = 2;
        gbc_datDatum.gridy = 0;
        this.pnlForm.add((Component)this.datDatum, (Object)gbc_datDatum);
        this.rgrIzbor = PzRadioGroup.create((Object[])new String[]{"Detaljan nalog", "Zbirni nalog", "Oba oblika"});
        this.rgrIzbor.setSelectedIndex(0);
        this.rgrIzbor.setLayoutAxis(1);
        GridBagConstraints gbc_rgrIzbor = new GridBagConstraints();
        gbc_rgrIzbor.gridwidth = 2;
        gbc_rgrIzbor.insets = new Insets(0, 0, 0, 5);
        gbc_rgrIzbor.fill = 1;
        gbc_rgrIzbor.gridx = 1;
        gbc_rgrIzbor.gridy = 1;
        this.pnlForm.add(this.rgrIzbor, (Object)gbc_rgrIzbor);
    }

    public void actionPerformed(ActionEvent e) {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                Nzk nzk = (Nzk)this.getSession().getParameter("nzk");
                if (this.getSession().getParameter("arhiva").equals(Boolean.TRUE)) {
                    em.getTransaction().begin();
                    nzk = (Nzk)em.find(Nzk.class, (Object)nzk.getIdNalog());
                    nzk.setDatum(this.datDatum.getVal());
                    nzk.setDuguje((BigDecimal)this.getSession().getParameter("duguje"));
                    nzk.setPotrazuje((BigDecimal)this.getSession().getParameter("potrazuje"));
                    nzk.setPzuser((Pzuser)em.find(Pzuser.class, (Object)PzApplication.getApplication().getSession().getLoggedUser().getPzusername()));
                    nzk.setArhiviran(Integer.valueOf(1));
                    for (Stavkanzk stavka : nzk.getStavkanzks()) {
                        Tools.updateKonto(em, stavka);
                    }
                    em.getTransaction().commit();
                }
                if (((String)this.rgrIzbor.getSelectedValue()).equals("Detaljan nalog")) {
                    Tools.prikaziIzvestaj(nzk, this, true);
                } else if (((String)this.rgrIzbor.getSelectedValue()).equals("Zbirni nalog")) {
                    Tools.prikaziIzvestaj(nzk, this, false);
                } else {
                    Tools.prikaziIzvestaj(nzk, this, true);
                    Tools.prikaziIzvestaj(nzk, this, false);
                }
                EXECUTED = true;
                DATE = this.datDatum.getVal();
                this.dispose();
            }
            catch (Exception e1) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                if (em.isOpen()) {
                    em.close();
                }
            }
        }
        finally {
            if (em.isOpen()) {
                em.close();
            }
        }
    }
}

