/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prostoKnjigovodstvo.gui.izvod;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.jdesktop.swingx.VerticalLayout;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.PzRacun;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Tekuciracun;
import rs.pezar.db.entity.Uplata;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.prostoKnjigovodstvo.engine.izvod.IzvodDbManager;
import rs.pezar.prostoKnjigovodstvo.engine.izvod.IzvodManager;
import rs.pezar.prostoKnjigovodstvo.engine.izvod.TransakcijaIzvodaBanke;
import rs.pezar.prostoKnjigovodstvo.engine.izvod.uplataLoader.DokumentFinderManager;
import rs.pezar.prostoKnjigovodstvo.engine.izvod.uplataLoader.UplataLoader;
import rs.pezar.prostoKnjigovodstvo.gui.izvod.PzDialogIzvodImport;
import rs.pezar.prostoKnjigovodstvo.gui.izvod.uplate.UplataComponent;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class PzPanelTransakcija
extends PzPanel {
    private static final long serialVersionUID = 8509836754236205109L;
    private JLabel lblNaziv;
    private JLabel lblSediste;
    private JLabel lblSvrhaPlacanja;
    private JLabel lblPozivNaBroj;
    private PzTextField txtSediste;
    private JScrollPane scp;
    private JPanel pnlUplate;
    private PzTextField txtNazivKomitent;
    private PzNumericOnlyTextField numSfrKomitent;
    private JLabel lblKomitent;
    private PzPanel pnlUplata;
    private PzTextField txtPozivNaBroj;
    private PzNumericOnlyTextField numModel;
    private PzDateField datDatum;
    private PzNumericOnlyTextField numSifraPlacanja;
    private PzTextField txtSvrhaPlacanja;
    private PzDoubleField dblIznos;
    private PzTextField txtNaziv;
    private PzTextField txtNazivBanke;
    private PzTextField txtBrojRacuna;
    private JLabel lblModel;
    private JLabel lblDatum;
    private JLabel lblSifraPlacanja;
    private JLabel lblIznos;
    private JLabel lblNazivBanke;
    private JLabel lblBrRacuna;
    private PzPanel pnlTransakcija;
    private TransakcijaIzvodaBanke t;
    private Komitent k;
    private boolean current = false;
    private List<Uplata> uplate;
    private List<UplataComponent> lpu;
    private IzvodManager izvodManager;
    private EntityManager tempEm;
    private static final String[] ULAZNI = new String[]{TipDokumentConfig.get().UPLATA_DAT_AVANS_POVRACAJ, TipDokumentConfig.get().UPLATA_DOBAVLJACU_POVRACAJ, TipDokumentConfig.get().UPLATA_KUPCA, TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS, TipDokumentConfig.get().UPLATA_PAZARA};
    private static final String[] IZLAZNI = new String[]{TipDokumentConfig.get().UPLATA_DAT_AVANS, TipDokumentConfig.get().UPLATA_DOBAVLJACU, TipDokumentConfig.get().UPLATA_KUPCA_POVRACAJ, TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS_POVRACAJ};
    private JPanel pnlIkonel;
    private JButton btnPonisti;
    private JButton btnOsvezi;
    private JLabel lblError;
    private PzBusyPainterUI layerUI;
    private JLabel lblSmerKnjienja;
    private JTextField txtSmer;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add((Component)((Object)new PzPanelTransakcija()));
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public PzPanelTransakcija() {
        this.initGUI();
    }

    public PzPanelTransakcija(IzvodManager izvodManager) {
        this.initGUI();
        this.izvodManager = izvodManager;
        this.izvodManager.getListPnlTransakcija().add(this);
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setPreferredSize(new Dimension(879, 228));
            thisLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0};
            int[] nArray = new int[10];
            nArray[1] = 7;
            nArray[2] = 7;
            nArray[3] = 7;
            nArray[4] = 7;
            nArray[5] = 7;
            nArray[6] = 7;
            nArray[7] = 7;
            nArray[8] = 7;
            nArray[9] = 7;
            thisLayout.rowHeights = nArray;
            thisLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 1.0};
            thisLayout.columnWidths = new int[]{63, 37, 68, 121, 141};
            FlowLayout thisLayout1 = new FlowLayout();
            this.setLayout(thisLayout1);
            thisLayout1.setHgap(1);
            thisLayout1.setAlignment(0);
            thisLayout1.setVgap(1);
            this.pnlTransakcija = new PzPanel();
            this.pnlTransakcija.setLayout((LayoutManager)thisLayout);
            this.add((Component)this.pnlTransakcija);
            this.pnlTransakcija.setBorder((Border)BorderFactory.createTitledBorder("Podaci o transakciji"));
            this.pnlTransakcija.setPreferredSize(new Dimension(400, 220));
            this.pnlUplata = new PzPanel();
            GridBagLayout pnlUplataLayout = new GridBagLayout();
            this.add((Component)this.pnlUplata);
            this.pnlUplata.setPreferredSize(new Dimension(441, 220));
            this.pnlUplata.setBorder((Border)BorderFactory.createTitledBorder("Podaci o uplati"));
            pnlUplataLayout.rowWeights = new double[]{0.0, 1.0, 0.0};
            int[] nArray2 = new int[3];
            nArray2[0] = 7;
            nArray2[1] = 7;
            pnlUplataLayout.rowHeights = nArray2;
            pnlUplataLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1, 0.1};
            pnlUplataLayout.columnWidths = new int[]{7, 57, 62, 7, 7};
            this.pnlUplata.setLayout((LayoutManager)pnlUplataLayout);
            this.lblKomitent = new JLabel();
            this.lblKomitent.setText("Komitent:");
            this.pnlUplata.add((Component)this.lblKomitent, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            this.lblKomitent.setName("lblKomitent");
            this.numSfrKomitent = new PzNumericOnlyTextField();
            this.numSfrKomitent.setFont(new Font("SansSerif", 0, 10));
            this.pnlUplata.add((Component)this.numSfrKomitent, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.numSfrKomitent.setName("numSfrKomitent");
            this.numSfrKomitent.addFocusListener((FocusListener)this.createFocusAdapter());
            this.numSfrKomitent.setFKField(Komitent.class, PzDialogKomintenti.class, false, null);
            this.txtNazivKomitent = new PzTextField();
            this.txtNazivKomitent.setFocusable(false);
            this.txtNazivKomitent.setEditable(false);
            this.txtNazivKomitent.setFont(new Font("SansSerif", 0, 10));
            this.pnlUplata.add((Component)this.txtNazivKomitent, (Object)new GridBagConstraints(2, 0, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 1), 0, 0));
            this.txtNazivKomitent.setName("txtNazivKomitent");
            this.scp = new JScrollPane();
            this.pnlUplata.add((Component)this.scp, (Object)new GridBagConstraints(0, 1, 5, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlUplate = new JPanel();
            this.pnlUplate.setBorder(new EmptyBorder(2, 0, 2, 0));
            this.pnlUplate.setLayout((LayoutManager)new VerticalLayout(2));
            this.scp.setViewportView(this.pnlUplate);
            this.lblError = new JLabel("Greska");
            this.lblError.setVisible(false);
            this.lblError.setForeground(Color.RED);
            GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
            gbc_lblNewLabel.anchor = 17;
            gbc_lblNewLabel.gridwidth = 5;
            gbc_lblNewLabel.gridx = 0;
            gbc_lblNewLabel.gridy = 2;
            this.pnlUplata.add((Component)this.lblError, (Object)gbc_lblNewLabel);
            this.lblSmerKnjienja = new JLabel("Smer knji\u017eenja:");
            GridBagConstraints gbc_lblSmerKnjienja = new GridBagConstraints();
            gbc_lblSmerKnjienja.anchor = 17;
            gbc_lblSmerKnjienja.insets = new Insets(0, 5, 1, 5);
            gbc_lblSmerKnjienja.gridx = 0;
            gbc_lblSmerKnjienja.gridy = 0;
            this.pnlTransakcija.add((Component)this.lblSmerKnjienja, (Object)gbc_lblSmerKnjienja);
            this.txtSmer = new JTextField();
            this.txtSmer.setFont(new Font("SansSerif", 1, 11));
            this.txtSmer.setFocusable(false);
            this.txtSmer.setEditable(false);
            GridBagConstraints gbc_txtSmer = new GridBagConstraints();
            gbc_txtSmer.gridwidth = 2;
            gbc_txtSmer.insets = new Insets(0, 0, 1, 5);
            gbc_txtSmer.fill = 2;
            gbc_txtSmer.gridx = 1;
            gbc_txtSmer.gridy = 0;
            this.pnlTransakcija.add((Component)this.txtSmer, (Object)gbc_txtSmer);
            this.txtSmer.setColumns(10);
            this.lblNaziv = new JLabel();
            this.lblNaziv.setText("Naziv:");
            this.pnlTransakcija.add((Component)this.lblNaziv, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 1, 5), 0, 0));
            this.lblNaziv.setName("lblNaziv");
            this.lblSediste = new JLabel();
            this.lblSediste.setText("Sedi\u0161te:");
            this.pnlTransakcija.add((Component)this.lblSediste, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 1, 5), 0, 0));
            this.lblSediste.setName("lblSediste");
            this.lblBrRacuna = new JLabel();
            this.lblBrRacuna.setText("Broj ra\u010duna:");
            this.pnlTransakcija.add((Component)this.lblBrRacuna, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 1, 5), 0, 0));
            this.lblBrRacuna.setName("lblBrRacuna");
            this.lblNazivBanke = new JLabel();
            this.lblNazivBanke.setText("Naziv banke:");
            this.pnlTransakcija.add((Component)this.lblNazivBanke, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 1, 5), 0, 0));
            this.lblNazivBanke.setName("lblNazivBanke");
            this.lblIznos = new JLabel();
            this.lblIznos.setText("Iznos:");
            this.pnlTransakcija.add((Component)this.lblIznos, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 1, 5), 0, 0));
            this.lblIznos.setName("lblIznos");
            this.lblSvrhaPlacanja = new JLabel();
            this.lblSvrhaPlacanja.setText("Svrha pla\u0107anja:");
            this.pnlTransakcija.add((Component)this.lblSvrhaPlacanja, (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 1, 5), 0, 0));
            this.lblSvrhaPlacanja.setName("lblSvrhaPlacanja");
            this.lblSifraPlacanja = new JLabel();
            this.lblSifraPlacanja.setText("\u0160ifra pla\u0107anja:");
            this.pnlTransakcija.add((Component)this.lblSifraPlacanja, (Object)new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 1, 5), 0, 0));
            this.lblSifraPlacanja.setName("lblSifraPlacanja");
            this.lblDatum = new JLabel();
            this.lblDatum.setText("Datum:");
            this.pnlTransakcija.add((Component)this.lblDatum, (Object)new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 1, 5), 0, 0));
            this.lblDatum.setName("lblDatum");
            this.lblModel = new JLabel();
            this.lblModel.setText("Model:");
            this.pnlTransakcija.add((Component)this.lblModel, (Object)new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 1, 5), 0, 0));
            this.lblModel.setName("lblModel");
            this.lblPozivNaBroj = new JLabel();
            this.lblPozivNaBroj.setText("Poziv na broj:");
            this.pnlTransakcija.add((Component)this.lblPozivNaBroj, (Object)new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 1, 5), 0, 0));
            this.lblPozivNaBroj.setName("lblPozivNaBroj");
            this.txtBrojRacuna = new PzTextField();
            this.txtBrojRacuna.setFocusable(false);
            this.txtBrojRacuna.setEditable(false);
            this.txtBrojRacuna.setFont(new Font("SansSerif", 0, 10));
            this.pnlTransakcija.add((Component)this.txtBrojRacuna, (Object)new GridBagConstraints(1, 1, 4, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 1, 5), 0, 0));
            this.txtBrojRacuna.setName("txtBrojRacuna");
            this.txtNazivBanke = new PzTextField();
            this.txtNazivBanke.setFocusable(false);
            this.txtNazivBanke.setEditable(false);
            this.txtNazivBanke.setFont(new Font("SansSerif", 0, 10));
            this.pnlTransakcija.add((Component)this.txtNazivBanke, (Object)new GridBagConstraints(1, 2, 4, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 1, 5), 0, 0));
            this.txtNazivBanke.setName("txtNazivBanke");
            this.txtNaziv = new PzTextField();
            this.txtNaziv.setFocusable(false);
            this.txtNaziv.setEditable(false);
            this.txtNaziv.setFont(new Font("SansSerif", 0, 10));
            this.pnlTransakcija.add((Component)this.txtNaziv, (Object)new GridBagConstraints(1, 3, 4, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 1, 5), 0, 0));
            this.txtNaziv.setName("txtNaziv");
            this.txtSediste = new PzTextField();
            this.txtSediste.setFocusable(false);
            this.txtSediste.setEditable(false);
            this.txtSediste.setFont(new Font("SansSerif", 0, 10));
            this.pnlTransakcija.add((Component)this.txtSediste, (Object)new GridBagConstraints(1, 4, 4, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 1, 5), 0, 0));
            this.txtSediste.setName("txtSediste");
            this.dblIznos = new PzDoubleField();
            this.dblIznos.setFocusable(false);
            this.dblIznos.setEditable(false);
            this.dblIznos.setFont(new Font("SansSerif", 0, 10));
            this.pnlTransakcija.add((Component)this.dblIznos, (Object)new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 1, 5), 0, 0));
            this.dblIznos.setName("dblIznos");
            this.txtSvrhaPlacanja = new PzTextField();
            this.txtSvrhaPlacanja.setFocusable(false);
            this.txtSvrhaPlacanja.setEditable(false);
            this.txtSvrhaPlacanja.setFont(new Font("SansSerif", 0, 10));
            this.pnlTransakcija.add((Component)this.txtSvrhaPlacanja, (Object)new GridBagConstraints(1, 6, 4, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 1, 5), 0, 0));
            this.txtSvrhaPlacanja.setName("txtSvrhaPlacanja");
            this.numSifraPlacanja = new PzNumericOnlyTextField();
            this.numSifraPlacanja.setFocusable(false);
            this.numSifraPlacanja.setEditable(false);
            this.numSifraPlacanja.setFont(new Font("SansSerif", 0, 10));
            this.pnlTransakcija.add((Component)this.numSifraPlacanja, (Object)new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 1, 5), 0, 0));
            this.numSifraPlacanja.setName("numSifraPlacanja");
            this.datDatum = new PzDateField();
            this.datDatum.setFocusable(false);
            this.datDatum.setEditable(false);
            this.datDatum.setFont(new Font("SansSerif", 0, 10));
            this.pnlTransakcija.add((Component)this.datDatum, (Object)new GridBagConstraints(3, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 1, 5), 0, 0));
            this.datDatum.setName("datDatum");
            this.numModel = new PzNumericOnlyTextField();
            this.numModel.setFocusable(false);
            this.numModel.setEditable(false);
            this.numModel.setFont(new Font("SansSerif", 0, 10));
            this.pnlTransakcija.add((Component)this.numModel, (Object)new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 1, 5), 0, 0));
            this.numModel.setName("numModel");
            this.txtPozivNaBroj = new PzTextField();
            this.txtPozivNaBroj.setFocusable(false);
            this.txtPozivNaBroj.setEditable(false);
            this.txtPozivNaBroj.setFont(new Font("SansSerif", 0, 10));
            this.pnlTransakcija.add((Component)this.txtPozivNaBroj, (Object)new GridBagConstraints(3, 8, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 1, 5), 0, 0));
            this.txtPozivNaBroj.setName("txtPozivNaBroj");
            this.pnlIkonel = new JPanel();
            this.pnlIkonel.setLayout((LayoutManager)new VerticalLayout(5));
            this.add(this.pnlIkonel);
            this.btnPonisti = new JButton();
            this.btnPonisti.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzPanelTransakcija.this.btnPonistiActionPerformed();
                }
            });
            this.btnPonisti.setFocusable(false);
            this.btnPonisti.setPreferredSize(new Dimension(23, 23));
            this.btnPonisti.setIcon(new ImageIcon(PzPanelTransakcija.class.getResource("/rs/pezar/finansije/resource/img/delete2.png")));
            this.btnPonisti.setToolTipText("Poni\u0161ti uplate");
            this.pnlIkonel.add(this.btnPonisti);
            this.btnOsvezi = new JButton("");
            this.btnOsvezi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PzPanelTransakcija.this.btnOsveziActionPerformed();
                }
            });
            this.btnOsvezi.setFocusable(false);
            this.btnOsvezi.setIcon(new ImageIcon(PzPanelTransakcija.class.getResource("/rs/pezar/finansije/resource/img/refresh.png")));
            this.btnOsvezi.setPreferredSize(new Dimension(23, 23));
            this.btnOsvezi.setToolTipText("Osve\u017ei uplate");
            this.pnlIkonel.add(this.btnOsvezi);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void btnOsveziActionPerformed() {
        if (PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Osve\u017eavanjem \u0107ete izgubiti sve \u0161to ste promenili na uplatama ove transakcije?\n\u017delite li da nastavite?", (String)"Upozorenje!", null, (boolean)true) != 0) {
            return;
        }
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        this.ponishtiUplate(false, false);
        this.setUplate(em, false, true);
        if (this.k != null) {
            this.setError(false);
        }
        em.close();
    }

    protected void btnPonistiActionPerformed() {
        if (PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Ovime \u0107ete poni\u0161titi sve uplate vezane za ovu transakciju?\n\u017delite li da nastavite?", (String)"Upozorenje!", null, (boolean)true) != 0) {
            return;
        }
        if (this.izvodManager.racunExists(this.t) && PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Postoji jo\u0161 transakcija sa istim ra\u010dunom komitenta.\nUkoliko nastavite, uplate na svim takvim transakcijama \u0107e biti poni\u0161tene.\nDa li \u017eelite da nastavite?", (String)"Upozorenje!", null, (boolean)true) == 0) {
            this.izvodManager.ponistiUplateByBrRacuna(this.t);
        }
        this.ponishtiUplate(true, true);
    }

    private void disableButtons() {
        this.btnPonisti.setEnabled(false);
    }

    public void setTransakcija(TransakcijaIzvodaBanke t, EntityManager em) throws Exception {
        this.t = t;
        if (t.getBrojRacuna() == null || t.getBrojRacuna().equals("")) {
            t.setBrojRacuna(String.valueOf(t.getIzvod().getKodBanke()) + "-XXXXX-XX");
        }
        this.setTransakcijaInfo();
        Komitent kom = IzvodDbManager.getKomitentByTekuciRacun(t.getBrojRacunaFormatiran(), em);
        if (kom == null && "97".equals(t.getModel())) {
            kom = IzvodDbManager.getKomitentByPozivNaBroj(t.getPozivNaBrojFormatiran(), em);
        }
        if (kom != null) {
            this.setKomitent(kom);
            this.numSfrKomitent.setEditable(false);
            this.numSfrKomitent.setFocusable(false);
            this.disableButtons();
            this.setUplate(em, true, true);
        } else {
            this.setKomitentError();
        }
    }

    private void setTransakcijaInfo() {
        this.txtBrojRacuna.setVal((Object)this.t.getBrojRacuna());
        this.txtNaziv.setVal((Object)this.t.getNazivKomitenta());
        this.txtNazivBanke.setVal((Object)this.t.getNazivBanke());
        this.txtPozivNaBroj.setVal((Object)this.t.getPozivNaBroj());
        this.txtSediste.setVal((Object)this.t.getSedisteKomitenta());
        this.txtSvrhaPlacanja.setVal((Object)this.t.getSvrhaPlacanja());
        this.numModel.setVal((Object)this.t.getModel());
        this.numSifraPlacanja.setVal((Object)this.t.getSifraPlacanja());
        this.datDatum.setVal((Object)this.t.getDatumPlacanja());
        this.dblIznos.setVal((Object)this.t.getIznos());
        this.txtSmer.setText(this.t.getStrana());
        if (this.t.getStrana().equals("ODOBRENJE")) {
            this.txtSmer.setForeground(Color.GREEN);
        } else {
            this.txtSmer.setForeground(Color.RED);
        }
    }

    public boolean setKomitentAndCheck(Komitent k) {
        int option;
        Komitent temp = this.izvodManager.getKomitentByBrRacuna(this.t.getBrojRacuna());
        if (temp != null && !temp.getSfrKomitent().equals(k.getSfrKomitent()) && (option = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)("Upozorenje!\nZa broj ra\u010duna banke " + this.t.getBrojRacuna() + " je ve\u0107 vezan drugi komitent.\nUkoliko nastavite, za sve transakcije sa pomenutim brojem ra\u010duna \u0107e biti vezan novi komitent. \nDa li \u017eelite da nastavite?"), (String)"Upozorenjne!", null, (boolean)true)) != 0) {
            return false;
        }
        this.setKomitent(k);
        return true;
    }

    private void setKomitentError() {
        this.setError(true);
        this.setErrorMessage("Komitent nije prona\u0111en. Unesite \u0161ifru komitenta.");
    }

    public void setKomitent(Komitent k) {
        this.k = k;
        this.ponishtiUplate(false, false);
        this.numSfrKomitent.setVal((Object)k.getSfrKomitent());
        this.txtNazivKomitent.setVal((Object)k.getNaziv());
        this.txtNazivKomitent.setForeground(Color.BLACK);
        this.setError(false);
    }

    public Komitent getKomitent() {
        return this.k;
    }

    public void setUplate(EntityManager em, boolean onLoad, boolean updateGUI) {
        if (this.k == null) {
            return;
        }
        this.pnlUplate.setVisible(false);
        this.pnlUplate.removeAll();
        this.lpu = new ArrayList<UplataComponent>();
        UplataLoader df = DokumentFinderManager.getInstance().getUplataLoader(this.t, this.k);
        BigDecimal iznos = this.t.getIznos();
        boolean jos = true;
        if (this.t.getModel() != null && this.t.getModel().equals("97")) {
            this.t.getPozivNaBrojFormatiran();
        }
        if (jos) {
            this.uplate = df.getUplate(this.k, this.t, iznos, em);
            if (this.izvodManager.komitentExistsByStrana(this.k, this.t) && !onLoad) {
                this.izvodManager.srediUplate(this.k, this.t.getStrana(), this.uplate, iznos, df, this);
            }
            BigDecimal tmpIznos = new BigDecimal(iznos.toString());
            for (Uplata uplata : this.uplate) {
                uplata.setIdTransakcije(this.t.getIdTransakcijeFormatiran());
                uplata.setPoruka("Uplata generisana prema izvodu br. " + this.t.getIzvod().getrBroj() + ", ozn. banke " + this.t.getIzvod().getKodBanke());
                UplataComponent pu = df.getGUIComponent(uplata);
                tmpIznos = tmpIznos.subtract(uplata.getIznos());
                if (updateGUI) {
                    this.pnlUplate.add(pu);
                }
                this.lpu.add(pu);
                pu.setPanelTransakcija(this);
            }
            if (tmpIznos.compareTo(new BigDecimal("0")) > 0) {
                this.setError(true);
                this.setErrorMessage("Neiskori\u0161\u0107en iznos: " + tmpIznos);
            }
        }
        this.pnlUplate.setVisible(true);
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean current) {
        this.current = current;
    }

    public void setError(final boolean b) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (b) {
                    PzPanelTransakcija.this.setBorder(new LineBorder(Color.RED));
                } else {
                    PzPanelTransakcija.this.setBorder(new EmptyBorder(0, 0, 0, 0));
                }
                PzPanelTransakcija.this.lblError.setVisible(b);
            }
        });
    }

    public void setErrorMessage(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzPanelTransakcija.this.lblError.setText(msg);
            }
        });
    }

    public void ponishtiUplate(boolean updateGUI, boolean ponistiKomitenta) {
        if (this.uplate != null && this.uplate.size() > 0) {
            for (Uplata u : this.uplate) {
                PzRacun r = (PzRacun)u.getDokumentUpl();
                if (r == null) continue;
                r.setUplata(r.getUplata().subtract(u.getIznos()));
            }
        }
        if (ponistiKomitenta) {
            this.k = null;
        }
        this.uplate = null;
        this.lpu = null;
        if (updateGUI) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PzPanelTransakcija.this.pnlUplate.setVisible(false);
                    PzPanelTransakcija.this.pnlUplate.removeAll();
                    PzPanelTransakcija.this.pnlUplate.setVisible(true);
                    PzPanelTransakcija.this.numSfrKomitent.setVal((Object)"");
                    PzPanelTransakcija.this.txtNazivKomitent.setVal((Object)"");
                    PzPanelTransakcija.this.setKomitentError();
                }
            });
        }
    }

    public TransakcijaIzvodaBanke getTransakcijaIzvodaBanke() {
        return this.t;
    }

    public List<Uplata> getUplateAll() {
        ArrayList<Uplata> uplate = new ArrayList<Uplata>();
        if (this.lpu == null || this.lpu.size() == 0) {
            return uplate;
        }
        for (UplataComponent pu : this.lpu) {
            pu.getUplata();
            uplate.add(pu.getUplata());
        }
        return uplate;
    }

    public List<Uplata> getUplateNonZero() {
        ArrayList<Uplata> uplate = new ArrayList<Uplata>();
        if (this.lpu == null || this.lpu.size() == 0) {
            return uplate;
        }
        for (UplataComponent pu : this.lpu) {
            Uplata u = pu.getUplata();
            if (u.getIznos().compareTo(new BigDecimal("0.00")) <= 0 || u == null) continue;
            uplate.add(pu.getUplata());
        }
        return uplate;
    }

    private FocusAdapter createFocusAdapter() {
        return new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                System.out.println("numSfrKomitent.focusGained, event=" + evt);
                ((PzDialogIzvodImport)((Object)SwingUtilities.getRoot((Component)PzPanelTransakcija.this.numSfrKomitent))).setCurrent(PzPanelTransakcija.this);
            }
        };
    }

    public JXLayer<JPanel> getLayer() {
        JXLayer layer = null;
        if (this.layerUI == null) {
            this.layerUI = new PzBusyPainterUI();
            layer = new JXLayer((Component)((Object)this), (LayerUI)this.layerUI);
        }
        return layer;
    }

    public void setUplataLocked() {
        this.layerUI.setLocked(true);
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){
            private EntityManager emLoc;

            @Override
            protected Object doInBackground() throws Exception {
                this.emLoc = PzEntityManagerFactory.getInstance().createEm();
                PzPanelTransakcija.this.setUplate(this.emLoc, false, false);
                this.emLoc.close();
                return null;
            }

            @Override
            protected void done() {
                for (UplataComponent pu : PzPanelTransakcija.this.lpu) {
                    PzPanelTransakcija.this.pnlUplate.add(pu);
                }
                PzPanelTransakcija.this.layerUI.setLocked(false);
                PzPanelTransakcija.this.izvodManager.setKomitentByBrRacuna(PzPanelTransakcija.this.t, PzPanelTransakcija.this.k, null);
            }
        };
        worker.execute();
    }

    public boolean validateUplate() {
        BigDecimal sum = new BigDecimal("0.00");
        boolean ok = true;
        if (this.lpu == null) {
            return false;
        }
        Iterator<UplataComponent> iterator = this.lpu.iterator();
        while (iterator.hasNext() && ok) {
            UplataComponent uc = iterator.next();
            ok = uc.validateUplata();
            if (uc.getUplata() == null) continue;
            sum = sum.add(uc.getUplata().getIznos());
        }
        if (!ok) {
            return ok;
        }
        if (sum.compareTo(this.t.getIznos()) < 0) {
            this.setError(true);
            ok = false;
            this.setErrorMessage("Nije iskori\u0161\u0107en ceo iznos uplate. Preostalo je jo\u0161 " + this.t.getIznos().subtract(sum));
        } else if (sum.compareTo(this.t.getIznos()) > 0) {
            this.setError(true);
            ok = false;
            this.setErrorMessage("Suma uplata je ve\u0107a od iznosa sa transakcije za " + sum.subtract(this.t.getIznos()));
        } else {
            this.setError(false);
        }
        return ok;
    }

    public List<UplataComponent> getUplatacomComponents() {
        return this.lpu;
    }

    public IzvodManager getIzvodManager() {
        return this.izvodManager;
    }

    public Tekuciracun getTekuciRacun(EntityManager em) {
        Tekuciracun t = (Tekuciracun)em.find(Tekuciracun.class, (Object)this.txtBrojRacuna.getVal());
        if (t == null) {
            t = new Tekuciracun(this.txtBrojRacuna.getVal(), this.txtNazivBanke.getVal(), null);
        }
        return t;
    }
}

