/*
 * Decompiled with CFR 0.152.
 */
package F;

public class H {
    public float x;
    public float y;
    public float z;

    public H() {
    }

    public H(H h) {
        this.set(h);
    }

    public static void computeNormal(H h, H h2, H h3) {
        h3.minusThenNormalize(h2);
        h2.minusThenNormalize(h);
        h.crossThenNormalize(h2, h3);
    }

    public void copy(H h) {
        this.set(h.x, h.y, h.z);
    }

    public void cross(H h, H h2) {
        this.set(h.y * h2.z - h.z * h2.y, h.z * h2.x - h.x * h2.z, h.x * h2.y - h.y * h2.x);
    }

    public void crossThenNormalize(H h, H h2) {
        this.cross(h, h2);
        this.normalize();
    }

    public float dot(H h) {
        return this.x * h.x + this.y * h.y + this.z * h.z;
    }

    public boolean equals(H h) {
        return this.equals(h.x, h.y, h.z);
    }

    public boolean equals(float f, float f2, float f3) {
        return f == this.x && f2 == this.y && f3 == this.z;
    }

    public void mid(H h, H h2) {
        this.set((h.x + h2.x) / 2.0f, (h.y + h2.y) / 2.0f, (h.z + h2.z) / 2.0f);
    }

    public void minus(H h) {
        this.set(this.x - h.x, this.y - h.y, this.z - h.z);
    }

    public void minusThenNormalize(H h) {
        this.minus(h);
        this.normalize();
    }

    public void normalize() {
        float f = this.sqrt();
        if (f != 0.0f) {
            this.set(this.x / f, this.y / f, this.z / f);
        }
    }

    public void set(H h) {
        this.set(h.x, h.y, h.z);
    }

    public void set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public float sqrt() {
        return (float)Math.sqrt((double)this.x * (double)this.x + (double)this.y * (double)this.y + (double)this.z * (double)this.z);
    }

    public String toString() {
        return super.toString();
    }
}

