/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.msg.StatusManager;

import java.util.Timer;
import java.util.TimerTask;
import rs.pezar.core.PzApplication;
import rs.pezar.msg.tools.system.OSValidator;
import rs.pezar.msg.tools.system.Win32IdleTime;

public class StatusManager {
    private static final int REFRESH_SECONDS = 5;
    private static final int IDLE_AFTER_SECONDS = 300;
    private static final int AWAY_AFTER_SECONDS = 1800;
    public static final String STATE_ACTIVE = "A";
    public static final String STATE_IDLE = "I";
    public static final String STATE_OFFLINE = "O";
    public static final String STATE_BUSY = "B";
    public static final String STATE_AWAY = "W";
    public static final String CHAT_STATUS = "CHAT_STATUS";
    private String activeLocalState = "A";
    private Object mutex = new Object();
    Timer timer;
    TimerTask t;

    public StatusManager() {
        String temp;
        try {
            temp = (String)PzApplication.getApplication().getLocalMachineUserSettings().getProperty(CHAT_STATUS);
        }
        catch (Exception exception) {
            temp = STATE_ACTIVE;
        }
        if (temp == null || temp.length() == 0) {
            this.activeLocalState = STATE_ACTIVE;
            PzApplication.getApplication().getLocalMachineUserSettings().setProperty(CHAT_STATUS, (Object)this.activeLocalState);
        } else {
            this.activeLocalState = temp;
        }
        this.t = new TimerTask(){

            @Override
            public void run() {
                StatusManager.this.refreshState();
            }
        };
        this.timer = new Timer();
        this.timer.schedule(this.t, 0L, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getActiveLocalState() {
        String temp;
        Object object = this.mutex;
        synchronized (object) {
            temp = this.activeLocalState;
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setActiveLocalState(String state) {
        Object object = this.mutex;
        synchronized (object) {
            this.activeLocalState = state;
            if (!(state.equals(STATE_OFFLINE) || state.equals(STATE_IDLE) || state.equals(STATE_AWAY))) {
                PzApplication.getApplication().getLocalMachineUserSettings().setProperty(CHAT_STATUS, (Object)this.activeLocalState);
            }
        }
    }

    private void refreshState() {
        int idleSec = 0;
        String newState = (String)PzApplication.getApplication().getLocalMachineUserSettings().getProperty(CHAT_STATUS);
        try {
            if (OSValidator.isWindows()) {
                idleSec = Win32IdleTime.getIdleTimeMillisWin32() / 1000;
            }
        }
        catch (Exception exception) {
            this.timer.cancel();
        }
        if (idleSec > 300) {
            newState = STATE_IDLE;
        }
        if (idleSec > 1800) {
            newState = STATE_AWAY;
        }
        this.setActiveLocalState(newState);
    }
}

