/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.msg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.jms.JMSException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import rs.pezar.core.PzApplication;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.msg.PzExtensionLoader;
import rs.pezar.msg.action.ActionSetup;
import rs.pezar.msg.chat.ChatSetupCollector;
import rs.pezar.msg.chat.interfaces.SetupPanelInterface;
import rs.pezar.msg.device.DeviceConfiguratorWindow;
import rs.pezar.msg.msg.MsgProtocol;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;

public class StartingMsgConnectionWindow
extends PzDialog
implements ActionListener {
    private static final String ICON_SUCCESS = "rs/pezar/msg/menu/resource/img/check_small.png";
    private static final String ICON_FAIL = "rs/pezar/msg/menu/resource/img/warning_small.png";
    private PzButton pzButton1;
    private static final String ICON_DISCONNECTED = "rs/pezar/msg/menu/resource/img/forbidden_small.png";
    private static final String MSG_SERVER_ADDRESS = "MSG_SERVER_ADDRESS";
    private PzPanel Uredjaji;
    private PzPanel Akcije;
    private PzPanel TekstualnePoruke;
    private JLabel lblAdresa;
    private PzPanel pnlServer;
    private PzButton btnDisconnect;
    private JTextField textServerAddress;
    private JLabel lblConnected;
    private PzPanel Konekcija;
    private JTabbedPane tabbedPane;
    private PzPanel jPanel1;
    private String connectedIcon;
    private String connectedMessage;
    private PzButton btnConnect;
    private MsgProtocol msgProtocol;
    private PzApplication application;
    private DeviceConfiguratorWindow deviceConfPanel;
    private SetupPanelInterface p;
    private ActionSetup actionConfPanel;

    public StartingMsgConnectionWindow() {
        this.initGUI();
    }

    public StartingMsgConnectionWindow(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public StartingMsgConnectionWindow(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    private void initGUI() {
        try {
            if (PzExtensionLoader.getInstance().getMsgProtocol() == null) {
                this.connectedIcon = ICON_FAIL;
                this.connectedMessage = "Konekcija se serverom nije uspostavljena.";
            } else {
                this.connectedIcon = ICON_SUCCESS;
                this.connectedMessage = "Konekcija se serverom je uspostavljena(" + PzExtensionLoader.getInstance().getMsgProtocol().getServerAddress() + ").";
            }
            String adresa = MsgProtocol.getInstance() != null ? MsgProtocol.getInstance().getServerAddress() : PzExtensionLoader.getInstance().getServerAddress();
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setPreferredSize(new Dimension(716, 552));
            this.setTitle("Pode\u0161avanja vezana za razmenu podataka izmedju korisnika");
            this.jPanel1 = new PzPanel();
            this.jPanel1.setBorder((Border)new EmptyBorder(10, 10, 10, 10));
            this.getContentPane().add((Component)this.jPanel1, "Center");
            this.jPanel1.setPreferredSize(new Dimension(708, 643));
            this.jPanel1.setLayout((LayoutManager)new BorderLayout(0, 0));
            this.tabbedPane = new JTabbedPane();
            this.jPanel1.add((Component)this.tabbedPane);
            this.tabbedPane.setOpaque(true);
            this.Konekcija = new PzPanel();
            this.tabbedPane.addTab("Konekcija", null, (Component)this.Konekcija, null);
            this.Konekcija.setBounds(34, 35, 269, 154);
            this.Konekcija.setLayout(null);
            this.pnlServer = new PzPanel();
            this.Konekcija.add((Component)this.pnlServer);
            this.pnlServer.setBounds(12, 12, 656, 123);
            this.pnlServer.setBorder((Border)BorderFactory.createTitledBorder("Server za razmenu poruka:"));
            this.pnlServer.setLayout(null);
            this.btnConnect = new PzButton();
            this.pnlServer.add((Component)this.btnConnect);
            this.btnConnect.setText("Pove\u017ei se");
            this.btnConnect.setBounds(444, 58, 92, 21);
            this.btnConnect.addActionListener((ActionListener)this);
            this.btnConnect.setToolTipText("Povezuje se na server na upisanoj adresi.");
            this.btnDisconnect = new PzButton();
            this.pnlServer.add((Component)this.btnDisconnect);
            this.btnDisconnect.setText("Prekini vezu");
            this.btnDisconnect.setBounds(547, 58, 92, 21);
            this.btnDisconnect.addActionListener((ActionListener)this);
            this.btnDisconnect.setToolTipText("raskida vezu sa serverum na koji je trenutno povezan.");
            this.textServerAddress = new JTextField();
            this.pnlServer.add((Component)this.textServerAddress);
            this.textServerAddress.setBounds(108, 31, 531, 21);
            if (adresa == null) {
                this.textServerAddress.setText("protocol://ipAddress:port");
            } else {
                this.textServerAddress.setText(adresa);
            }
            this.textServerAddress.setToolTipText("protocol://ipAddress:port");
            this.lblAdresa = new JLabel();
            this.pnlServer.add((Component)this.lblAdresa);
            this.lblAdresa.setText("Adresa servera:");
            this.lblAdresa.setBounds(17, 34, 91, 14);
            this.lblConnected = new JLabel();
            this.pnlServer.add((Component)this.lblConnected);
            this.lblConnected.setText(this.connectedMessage);
            this.lblConnected.setBounds(17, 90, 622, 19);
            this.lblConnected.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(this.connectedIcon)));
            this.pzButton1 = new PzButton();
            this.pnlServer.add((Component)this.pzButton1);
            this.pzButton1.setBounds(108, 58, 93, 21);
            this.pzButton1.setName("pzButton1");
            this.pzButton1.setText("Uobi\u010dajeno");
            this.pzButton1.addActionListener((ActionListener)this);
            this.pzButton1.setToolTipText("Preuzimanje parametra iz tekuce baze podataka.");
            this.Uredjaji = new PzPanel();
            this.tabbedPane.addTab("Uredjaji", null, (Component)this.Uredjaji, null);
            this.Uredjaji.setBounds(62, 22, 64, 71);
            this.Akcije = new PzPanel();
            this.tabbedPane.addTab("Akcije", null, (Component)this.Akcije, null);
            this.Akcije.setLayout((LayoutManager)new BorderLayout(0, 0));
            this.Akcije.setBounds(25, 171, 646, 268);
            this.TekstualnePoruke = new PzPanel();
            this.tabbedPane.addTab("TekstualnePoruke", null, (Component)this.TekstualnePoruke, null);
            this.TekstualnePoruke.setBounds(25, 171, 646, 268);
            this.TekstualnePoruke.setPreferredSize(new Dimension(344, 10));
            this.pack();
            this.setSize(716, 552);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getDeviceConfigPanel();
        if (this.deviceConfPanel != null) {
            this.Uredjaji.add((Component)((Object)this.deviceConfPanel));
        }
        if (ChatSetupCollector.getInstance() != null) {
            ChatSetupCollector csc = ChatSetupCollector.getInstance();
            this.p = csc.getChatSetup();
            this.TekstualnePoruke.add((Component)((Object)this.p));
            this.p.setExtensionLoader(PzExtensionLoader.getInstance());
            this.p.setWorkbench(PzExtensionLoader.getInstance().getApplication().getWorkbench());
            this.p.init();
        } else {
            JLabel lbl1 = new JLabel();
            lbl1.setText("Plugin za razmenu tekstualnih poruka nije dostupan.");
            this.TekstualnePoruke.add((Component)lbl1);
        }
        this.actionConfPanel = ActionSetup.getActionPanel();
        GridBagLayout gridBagLayout = (GridBagLayout)this.actionConfPanel.getLayout();
        int[] nArray = new int[3];
        nArray[0] = 23;
        nArray[1] = 615;
        gridBagLayout.columnWidths = nArray;
        this.actionConfPanel.setBorder(null);
        this.Akcije.add((Component)((Object)this.actionConfPanel));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource().equals(this.btnConnect)) {
            this.onConnectPressed();
        } else if (arg0.getSource().equals(this.btnDisconnect)) {
            this.onDisconnectPressed();
        } else if (arg0.getSource().equals(this.pzButton1)) {
            this.onDefaultPressed();
        }
    }

    private void onDefaultPressed() {
        String serverAddress = PzParameter.getParameterValue((String)MSG_SERVER_ADDRESS);
        if (serverAddress != null) {
            this.textServerAddress.setText(serverAddress);
        }
        if (serverAddress == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Parametar za uobicajanu adresu servera nije dostupan.", "Greska", 0);
        }
    }

    private void onConnectPressed() {
        if (this.msgProtocol != null) {
            this.onDisconnectPressed();
        }
        boolean connected = true;
        String user = String.valueOf(PzExtensionLoader.getInstance().getApplication().getSession().getLoggedUser().getPzusername()) + "(" + PzExtensionLoader.getInstance().getApplication().getSession().getLoggedUser().getIme() + PzExtensionLoader.getInstance().getApplication().getSession().getLoggedUser().getPrezime() + ")";
        String serverAddress = null;
        serverAddress = this.textServerAddress.getText().trim();
        try {
            this.msgProtocol = new MsgProtocol(serverAddress, user);
            this.msgProtocol.setDeviceManager(PzExtensionLoader.getInstance().getDeviceManager());
            this.msgProtocol.run();
            MsgProtocol.getInstance().getControl().addRefreshUsersListener(this.deviceConfPanel);
            PzExtensionLoader.getInstance().setMsgProtocol(this.msgProtocol);
            this.deviceConfPanel = this.getDeviceConfigPanel();
            PzExtensionLoader.getInstance().addRegisteredActions();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Povezivanje na server za razmenu poruka nemogu\u0107e.", "Gre\u0161ka", 0);
            this.connectedIcon = ICON_FAIL;
            this.connectedMessage = "Konekcija se serverom nije uspostavljena.";
            this.lblConnected.setText(this.connectedMessage);
            this.lblConnected.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(this.connectedIcon)));
            connected = false;
        }
        if (connected) {
            JOptionPane.showMessageDialog(null, "Povezivanje uspe\u0161no", "Uspe\u0161no", 1);
            this.connectedIcon = ICON_SUCCESS;
            this.connectedMessage = "Konekcija se serverom je uspostavljena(" + PzExtensionLoader.getInstance().getMsgProtocol().getServerAddress() + ").";
            this.lblConnected.setText(this.connectedMessage);
            this.lblConnected.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(this.connectedIcon)));
            this.deviceConfPanel.setLblConnected();
            PzApplication.getApplication().getLocalMachineUserSettings().setProperty(MSG_SERVER_ADDRESS, (Object)serverAddress);
            this.p.init();
        }
    }

    private void onDisconnectPressed() {
        MsgProtocol msgProtocol = PzExtensionLoader.getInstance().getMsgProtocol();
        boolean disconnected = true;
        if (msgProtocol == null) {
            return;
        }
        try {
            msgProtocol.close();
        }
        catch (JMSException jMSException) {
            disconnected = false;
        }
        this.p.destroyAllChatWindows();
        if (disconnected) {
            this.connectedIcon = ICON_DISCONNECTED;
            this.connectedMessage = "Konekcija se serverom prekinuta.";
            this.lblConnected.setText(this.connectedMessage);
            this.lblConnected.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(this.connectedIcon)));
            msgProtocol = null;
            PzExtensionLoader.getInstance().setMsgProtocol(null);
            MsgProtocol.setInstance(null);
            this.deviceConfPanel.setLblDisconnected();
        }
    }

    public static String getAddress(PzDialog parent) {
        StartingMsgConnectionWindow w = new StartingMsgConnectionWindow(parent);
        w.setVisible(true);
        w.setModal(true);
        return w.getTextServerAddress().getText();
    }

    public JTextField getTextServerAddress() {
        return this.textServerAddress;
    }

    private DeviceConfiguratorWindow getDeviceConfigPanel() {
        if (this.deviceConfPanel == null) {
            this.deviceConfPanel = DeviceConfiguratorWindow.getDeviceConfiguratorPanel();
        }
        return this.deviceConfPanel;
    }

    public static Object getGUIBuilderInstance() {
        return new StartingMsgConnectionWindow(Boolean.FALSE);
    }

    public StartingMsgConnectionWindow(Boolean initGUI) {
    }
}

