/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.gui.panelList;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import org.apache.commons.lang.math.RandomUtils;
import rs.pezar.msg.gui.devicePanel.PzDeviceButton;
import rs.pezar.msg.gui.devicePanel.PzDeviceListItem;
import rs.pezar.msg.gui.panelList.PzPanelListItem;
import rs.pezar.swing.PzPanel;

public class PzPanelList
extends PzPanel {
    private static final long REFRESH_SECONDS = 3000L;
    private Vector<PzPanelListItem> itemPool = new Vector();
    private Timer timerRefresher;
    private TimerTask timerTask;
    private Object mutex = new Object();
    private int p = 0;
    private JPanel mainList;
    private GridBagConstraints gbc;
    private MouseListener ml;
    private PzPanelListItem selectedItem;

    public PzPanelList() {
        this.initGUI();
        this.ml = this.getItemMouseListener();
    }

    private void initGUI() {
        try {
            this.setLayout(new BorderLayout());
            this.mainList = new JPanel(new GridBagLayout());
            this.gbc = new GridBagConstraints();
            this.gbc.gridwidth = 0;
            this.gbc.weightx = 1.0;
            this.gbc.weighty = 1.0;
            this.mainList.add((Component)new JPanel(), this.gbc);
            JScrollPane scrollPane = new JScrollPane(this.mainList);
            scrollPane.setBorder(null);
            this.add(scrollPane);
            JButton add = new JButton("Add");
            add.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PzDeviceListItem panel = new PzDeviceListItem();
                    PzDeviceButton button = new PzDeviceButton(){

                        @Override
                        public void onPressed() {
                            System.out.println("test");
                        }
                    };
                    button.setToolTipText("test");
                    button.setIcon("/rs/pezar/msg/widget/resource/gear_run.png");
                    PzDeviceButton button1 = new PzDeviceButton(){

                        @Override
                        public void onPressed() {
                            System.out.println("test1");
                        }
                    };
                    button1.setToolTipText("test1");
                    button1.setIcon("/rs/pezar/msg/widget/resource/users4.png");
                    panel.addButton(button);
                    panel.addButton(button1);
                    panel.setId("a1" + String.valueOf(RandomUtils.nextInt()));
                    PzPanelList.this.updatePanelList(panel);
                    PzPanelList.this.validate();
                    PzPanelList.this.repaint();
                }
            });
            this.add(add, "South");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private MouseListener getItemMouseListener() {
        MouseListener ml = new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (e.getComponent() instanceof PzPanelListItem) {
                    ((PzPanelListItem)((Object)e.getComponent())).setBorder(new MatteBorder(0, 3, 1, 0, Color.LIGHT_GRAY));
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.getComponent() instanceof PzPanelListItem) {
                    ((PzPanelListItem)((Object)e.getComponent())).setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 3, 0, 0, Color.RED), BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY)));
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int i = 0;
                while (i < PzPanelList.this.itemPool.size()) {
                    if (((PzPanelListItem)((Object)PzPanelList.this.itemPool.get(i))).isSelected()) {
                        ((PzPanelListItem)((Object)PzPanelList.this.itemPool.get(i))).setSelected(false);
                    }
                    PzPanelList.this.selectedItem = null;
                    ++i;
                }
                if (e.getComponent() instanceof PzPanelListItem) {
                    ((PzPanelListItem)((Object)e.getComponent())).setSelected(true);
                    PzPanelList.this.selectedItem = (PzPanelListItem)((Object)e.getComponent());
                }
                if (e.getClickCount() == 2) {
                    ((PzPanelListItem)((Object)e.getComponent())).onDoubleClicked();
                }
            }
        };
        return ml;
    }

    public void init() {
        this.timerRefresher = new Timer();
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                PzPanelList.this.refresher();
            }
        };
        this.timerRefresher.schedule(this.timerTask, 0L, 3000L);
    }

    private void refresher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePanelList(PzPanelListItem listItem) {
        PzPanelListItem temp = null;
        Object object = this.mutex;
        synchronized (object) {
            for (PzPanelListItem type : this.itemPool) {
                if (!type.getId().equals(listItem.getId())) continue;
                temp = type;
            }
            try {
                if (temp != null) {
                    temp.updateFields(listItem);
                } else {
                    this.addToPanelList(listItem);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addToPanelList(final PzPanelListItem listItem) throws Exception {
        Object object = this.mutex;
        synchronized (object) {
            for (PzPanelListItem type : this.itemPool) {
                if (!type.getId().equals(listItem.getId())) continue;
                throw new Exception("Id vec postoj u listi");
            }
            this.itemPool.add(listItem);
            listItem.addMouseListener(this.ml);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    listItem.setBorder(new MatteBorder(0, 3, 1, 0, Color.LIGHT_GRAY));
                    GridBagConstraints gbc = new GridBagConstraints();
                    gbc.gridwidth = 0;
                    gbc.weightx = 1.0;
                    gbc.fill = 2;
                    PzPanelList.this.mainList.add((Component)((Object)listItem), gbc, 0);
                    PzPanelList.this.validate();
                    PzPanelList.this.repaint();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeFromPanelList(PzPanelListItem listItem) {
        Object object = this.mutex;
        synchronized (object) {
            PzPanelListItem temp = null;
            for (PzPanelListItem type : this.itemPool) {
                if (!type.getId().equals(listItem.getId())) continue;
                temp = type;
            }
            if (temp != null) {
                this.itemPool.remove((Object)temp);
                this.mainList.remove((Component)((Object)listItem));
            }
        }
    }

    public static void main(String[] arg0) {
        JFrame frame = new JFrame();
        frame.getContentPane().add((Component)((Object)new PzPanelList()));
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    class EnterJLlist
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent ke) {
            if (ke.getKeyCode() == 10 && PzPanelList.this.selectedItem != null) {
                PzPanelList.this.selectedItem.onEnterAction();
            }
            System.out.println("aa");
        }
    }
}

