/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.device;

import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.commons.configuration.ConfigurationException;
import rs.pezar.core.PzApplication;
import rs.pezar.msg.PzExtensionLoader;
import rs.pezar.msg.device.DeviceDriverCollector;
import rs.pezar.msg.device.LockWrapper;
import rs.pezar.msg.device.NetDataWrapper;
import rs.pezar.msg.device.interfaces.DeviceDataInterface;
import rs.pezar.msg.device.interfaces.DeviceDriverInterface;
import rs.pezar.msg.device.interfaces.DeviceManagerInterface;
import rs.pezar.msg.msg.MsgProtocol;
import rs.pezar.msg.tools.xml.ConfigurationGetter;
import rs.pezar.msg.tools.xml.NetDeviceSettings;

public class DeviceManager
implements DeviceManagerInterface {
    private static String CONFIG_FILE = "Config";
    Vector<LockWrapper> devices;
    MsgProtocol msgProt;
    boolean sharedDevices;
    private String user = PzExtensionLoader.getInstance().getApplication().getSession().getLoggedUser().getPzusername();
    static ConfigurationGetter conf;

    public DeviceManager(MsgProtocol msgProtocol) {
        this.devices = new Vector();
        this.msgProt = msgProtocol;
        try {
            conf = new ConfigurationGetter(String.valueOf(CONFIG_FILE) + "_" + this.user);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void addDevice(DeviceDriverInterface device) {
        if (this.getDevice(device.getDeviceType(), device.getDeviceId()) != null) {
            return;
        }
        LockWrapper nw = new LockWrapper(device, this.msgProt);
        this.devices.add(nw);
        nw.start();
    }

    @Override
    public synchronized LockWrapper getDevice(String type, String id) {
        for (LockWrapper i : this.devices) {
            String deviceId = "";
            deviceId = i.getDrvr().getDeviceId();
            if (!id.equals(deviceId) || !i.getDrvr().getDeviceType().equals(type)) continue;
            return i;
        }
        return null;
    }

    @Override
    public synchronized String getInfoOnDevices() {
        String info = new String();
        for (LockWrapper i : this.devices) {
            info = String.valueOf(info) + i.getDrvr().getDeviceInfo() + "|";
        }
        return info;
    }

    @Override
    public synchronized void removeDevice(DeviceDriverInterface device) {
        this.devices.remove(device);
    }

    @Override
    public synchronized void removeDevice(String type, String id) {
        for (LockWrapper i : this.devices) {
            String deviceId = "";
            try {
                deviceId = i.getDrvr().getDeviceId();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!deviceId.equals(id) || !i.getDrvr().getDeviceType().equals(type)) continue;
            this.devices.remove(i);
        }
    }

    @Override
    public synchronized HashMap<String, String> pushDeviceData(NetDataWrapper data) {
        Object data1 = data.getData();
        if (data1 != null) {
            String id;
            String type = ((DeviceDataInterface)data1).getDeviceType();
            LockWrapper device = this.getDevice(type, id = ((DeviceDataInterface)data1).getDeviceId());
            if (device == null) {
                HashMap<String, String> badResult = new HashMap<String, String>();
                badResult.put("MESSAGE", "Uredjaj nije dobro inicijalizovan ili nije povezan.");
                badResult.put("CODE", "ERROR");
                return badResult;
            }
            device.addJob(data);
            if (data.isLocalDevice()) {
                try {
                    device.getLocalTransactionOver().acquire();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return null;
                }
                return device.getReturnData();
            }
        }
        return new HashMap<String, String>();
    }

    @Override
    public boolean isSharedDevices() {
        return this.sharedDevices;
    }

    @Override
    public void setSharedDevices(boolean sharedDevices) {
        this.sharedDevices = sharedDevices;
    }

    @Override
    public synchronized LockWrapper getDeviceAt(int i) {
        return this.devices.get(i);
    }

    @Override
    public synchronized int getNumerOfControledDevices() {
        return this.devices.size();
    }

    public void addLocalDevicesAndStartThem() throws Exception {
        if (conf == null) {
            conf = new ConfigurationGetter(CONFIG_FILE);
        }
        this.setSharedDevices(conf.getShared());
        Vector<NetDeviceSettings> temp = conf.getnetDevices();
        int i = 0;
        while (i < temp.size()) {
            if (temp.get(i).getLocal() != null && temp.get(i).getLocal().equals("yes")) {
                String type = temp.get(i).getType();
                String name = temp.get(i).getName();
                int j = 0;
                while (j < DeviceDriverCollector.getDeviceDrivers().size()) {
                    if (DeviceDriverCollector.getDeviceDrivers().get(j).getDeviceType().equals(type) && DeviceDriverCollector.getDeviceDrivers().get(j).getDeviceName().equals(name)) {
                        HashMap<String, String> param = new HashMap<String, String>();
                        if (temp.get(i).getType().equals("TYPE_CASHREGISTER")) {
                            param.put("PORT", temp.get(i).getPort());
                        }
                        param.put("BAUD", temp.get(i).getBaud());
                        param.put("PARAM1", temp.get(i).getParam1());
                        param.put("PARAM2", temp.get(i).getParam2());
                        param.put("PARAM3", temp.get(i).getParam3());
                        param.put("PARAM4", temp.get(i).getParam4());
                        param.put("PARAM5", temp.get(i).getParam5());
                        DeviceDriverCollector.getDeviceDrivers().get(j).initDriver(param);
                        DeviceDriverCollector.getDeviceDrivers().get(j).setWorkingDirectoryPath(PzApplication.getApplication().getDataFolder().getPath());
                        try {
                            DeviceDriverCollector.getDeviceDrivers().get(j).runDriver();
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(null, "Driver nije detektovao registrovani uredjaj.", "Greska", 0);
                        }
                        try {
                            DeviceDriverCollector.getDeviceDrivers().get(j).testDriver();
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(null, String.valueOf(e.getMessage()) + "\nJedan ili vi\u0161e prijavljeni uredjaja nije mogu\u0107e inicijalizovati.\nUklju\u010dite uredjaj i iskoristite opciju 'test' da bi ste detektovali kad je uredjaj povezan.\nOpcija test:Glavni meni: A:Pode\u0161avanja -> Razmena podataka -> Uredjaji -> Testiraj kase u upotrebi", "Gre\u0161ka pri inicijalizaciji uredjaja", 0);
                        }
                        this.addDevice(DeviceDriverCollector.getDeviceDrivers().get(j));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public static void putSettingsToFile() throws ConfigurationException {
        if (conf == null) {
            try {
                conf = new ConfigurationGetter(CONFIG_FILE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        conf.putSettingstoFile();
    }

    public static boolean getShared() {
        if (conf == null) {
            try {
                conf = new ConfigurationGetter(CONFIG_FILE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return conf.getShared();
    }

    public static void setSettings(Vector<NetDeviceSettings> netdevices, boolean shared) {
        if (conf == null) {
            try {
                conf = new ConfigurationGetter(CONFIG_FILE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        conf.setSettings(netdevices, shared);
    }

    public static Vector<NetDeviceSettings> getnetDevices() {
        if (conf == null) {
            try {
                conf = new ConfigurationGetter(CONFIG_FILE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return conf.getnetDevices();
    }

    public Vector<LockWrapper> getDevices() {
        return this.devices;
    }
}

