/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg;

import javax.swing.JMenuItem;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import rs.pezar.core.PzApplication;
import rs.pezar.core.PzExtension;
import rs.pezar.core.PzUserSettings;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.msg.action.ActionCollector;
import rs.pezar.msg.action.ActionManager;
import rs.pezar.msg.chat.ChatSetupCollector;
import rs.pezar.msg.device.DeviceManager;
import rs.pezar.msg.msg.MsgProtocol;
import rs.pezar.msg.widget.Widgetmsg;
import rs.pezar.swing.PzMenu;
import rs.pezar.swing.PzMenuItem;
import rs.pezar.util.PzFileUtility;

public class PzExtensionLoader
implements PzExtension {
    private MsgProtocol msgProtocol;
    private PzApplication application;
    private PzMenu menu;
    private static PzExtensionLoader instance;
    private String serverAddress;
    private DeviceManager deviceManager;
    private ActionManager actionManager;
    private Widgetmsg widgetKorisnici;

    public void initExtension(PzApplication application) {
        try {
            instance = this;
            this.application = application;
            application.getMenuRegistry().add(this.menu);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.widgetKorisnici = new Widgetmsg();
        this.widgetKorisnici.initData();
        this.application.getWidgetRegistry().add(this.widgetKorisnici);
        try {
            PzUserSettings settings = PzApplication.getApplication().getLocalMachineUserSettings();
            this.serverAddress = settings.getString("MSG_SERVER_ADDRESS");
            if (this.serverAddress == null || this.serverAddress.length() == 0) {
                this.serverAddress = PzParameter.getParameterValue((String)"MSG_SERVER_ADDRESS");
                PzApplication.getApplication().getLocalMachineUserSettings().setProperty("MSG_SERVER_ADDRESS", (Object)this.serverAddress);
            }
        }
        catch (Exception exception) {}
        if (this.serverAddress != null) {
            try {
                String user = String.valueOf(application.getSession().getLoggedUser().getPzusername()) + "(" + application.getSession().getLoggedUser().getIme() + application.getSession().getLoggedUser().getPrezime() + ")";
                this.msgProtocol = new MsgProtocol(this.serverAddress, user);
                this.deviceManager = new DeviceManager(this.msgProtocol);
                this.msgProtocol.setDeviceManager(this.deviceManager);
                this.msgProtocol.run();
            }
            catch (Exception exception) {
                this.deviceManager = new DeviceManager(null);
            }
        } else {
            this.deviceManager = new DeviceManager(this.msgProtocol);
        }
        this.addRegisteredActions();
        ChatSetupCollector.getInstance().getChatSetup().setExtensionLoader(this);
        ChatSetupCollector.getInstance().getChatSetup().init();
    }

    public void load() {
        try {
            Document m = PzFileUtility.loadXML((String)"rs/pezar/msg/menu/resource/menu.xml", (ClassLoader)this.getClass().getClassLoader());
            this.menu = new PzMenu((Node)m.getDocumentElement(), this.getClass().getClassLoader());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unload() {
        PzMenu menu1 = this.getApplication().getWorkbench().getWorkbenchMenuBar().getMenuById(this.menu.getId());
        for (PzMenuItem i : this.menu.getItems()) {
            menu1.remove((JMenuItem)i);
        }
    }

    public void addRegisteredActions() {
        if (this.msgProtocol != null) {
            this.actionManager = new ActionManager();
            int i = 0;
            while (i < ActionCollector.getInstance().getNumberOfGroups()) {
                int j = 0;
                while (j < ActionCollector.getInstance().getActionGroup(i).getGroup().size()) {
                    this.actionManager.addAction(ActionCollector.getInstance().getActionGroup(i).getGroup().get(j));
                    ++j;
                }
                ++i;
            }
            this.msgProtocol.setActionManager(this.actionManager);
        }
    }

    public PzApplication getApplication() {
        return this.application;
    }

    public static Pzuser getLoggedUser() {
        return instance.getApplication().getSession().getLoggedUser();
    }

    public static PzExtensionLoader getInstance() {
        return instance;
    }

    public MsgProtocol getMsgProtocol() {
        return this.msgProtocol;
    }

    public void setMsgProtocol(MsgProtocol msgProtocol) {
        this.msgProtocol = msgProtocol;
    }

    public DeviceManager getDeviceManager() {
        return this.deviceManager;
    }

    public void setDeviceManager(DeviceManager deviceManager) {
        this.deviceManager = deviceManager;
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    public void setActionManager(ActionManager actionManager) {
        this.actionManager = actionManager;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }
}

