/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.stack.RetroStackDockStationLayout;
import bibliothek.gui.dock.station.stack.StackDockPerspective;
import bibliothek.gui.dock.station.stack.StackDockProperty;
import bibliothek.gui.dock.station.stack.StackDockStationLayout;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class StackDockStationFactory
implements DockFactory<StackDockStation, StackDockPerspective, StackDockStationLayout> {
    public static final String ID = "StackDockStationFactory";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public StackDockStationLayout getLayout(StackDockStation station, Map<Dockable, Integer> children) {
        Dockable selectedDockable = station.getFrontDockable();
        int selected = -1;
        if (selectedDockable != null) {
            selected = station.indexOf(selectedDockable);
        }
        PlaceholderMap map = station.getPlaceholders(children);
        return new StackDockStationLayout(selected, map);
    }

    @Override
    public void estimateLocations(StackDockStationLayout layout, final LocationEstimationMap children) {
        if (layout instanceof RetroStackDockStationLayout) {
            RetroStackDockStationLayout retroLayout = (RetroStackDockStationLayout)layout;
            int[] nArray = retroLayout.getChildren();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                DockLayoutInfo info = children.getChild(id);
                if (info != null) {
                    StackDockProperty property = new StackDockProperty(id, info.getPlaceholder());
                    info.setLocation(property);
                }
                ++n2;
            }
        } else {
            DockablePlaceholderList.simulatedRead(layout.getPlaceholders(), new PlaceholderListItemAdapter<Dockable, PlaceholderListItem<Dockable>>(){

                @Override
                public PlaceholderListItem<Dockable> convert(ConvertedPlaceholderListItem item) {
                    int id = item.getInt("id");
                    int index = item.getInt("index");
                    Path placeholder = null;
                    if (item.contains("placeholder")) {
                        placeholder = new Path(item.getString("placeholder"));
                    }
                    StackDockProperty property = new StackDockProperty(index, placeholder);
                    children.getChild(id).setLocation(property);
                    int i = 0;
                    int n = children.getSubChildCount(id);
                    while (i < n) {
                        DockLayoutInfo info = children.getSubChild(id, i);
                        info.setLocation(new StackDockProperty(id, info.getPlaceholder()));
                        ++i;
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public void setLayout(StackDockStation station, StackDockStationLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        DockController controller = station.getController();
        try {
            if (controller != null) {
                controller.freezeLayout();
            }
            int i = station.getDockableCount() - 1;
            while (i >= 0) {
                station.remove(i);
                --i;
            }
            if (layout instanceof RetroStackDockStationLayout) {
                RetroStackDockStationLayout retroLayout = (RetroStackDockStationLayout)layout;
                int[] nArray = retroLayout.getChildren();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int id = nArray[n2];
                    Dockable dockable = children.get(id);
                    if (dockable != null) {
                        station.drop(dockable);
                    }
                    ++n2;
                }
            } else {
                station.setPlaceholders(layout.getPlaceholders().filter(placeholders), children);
            }
            Dockable selected = children.get(layout.getSelected());
            if (selected != null) {
                station.setFrontDockable(selected);
            }
        }
        finally {
            if (controller != null) {
                controller.meltLayout();
            }
        }
    }

    @Override
    public void setLayout(StackDockStation element, StackDockStationLayout layout, PlaceholderStrategy placeholders) {
    }

    @Override
    public StackDockPerspective layoutPerspective(StackDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
        StackDockPerspective perspective = new StackDockPerspective();
        this.layoutPerspective(perspective, layout, children);
        return perspective;
    }

    @Override
    public void layoutPerspective(StackDockPerspective perspective, StackDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
        perspective.read(layout.getPlaceholders(), children, layout.getSelected());
    }

    @Override
    public StackDockStation layout(StackDockStationLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        StackDockStation station = this.createStation();
        this.setLayout(station, layout, children, placeholders);
        return station;
    }

    @Override
    public StackDockStation layout(StackDockStationLayout layout, PlaceholderStrategy placeholders) {
        StackDockStation station = this.createStation();
        this.setLayout(station, layout, placeholders);
        return station;
    }

    @Override
    public StackDockStationLayout getPerspectiveLayout(StackDockPerspective element, Map<PerspectiveDockable, Integer> children) {
        Integer selected = null;
        if (children != null) {
            selected = children.get(element.getSelection());
        }
        return new StackDockStationLayout(selected == null ? -1 : selected, element.toMap(children));
    }

    @Override
    public void write(StackDockStationLayout layout, DataOutputStream out) throws IOException {
        if (layout instanceof RetroStackDockStationLayout) {
            RetroStackDockStationLayout retroLayout = (RetroStackDockStationLayout)layout;
            Version.write(out, Version.VERSION_1_0_4);
            out.writeInt(layout.getSelected());
            out.writeInt(retroLayout.getChildren().length);
            int[] nArray = retroLayout.getChildren();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int c = nArray[n2];
                out.writeInt(c);
                ++n2;
            }
        } else {
            Version.write(out, Version.VERSION_1_0_8);
            out.writeInt(layout.getSelected());
            layout.getPlaceholders().write(out);
        }
    }

    @Override
    public StackDockStationLayout read(DataInputStream in, PlaceholderStrategy placeholders) throws IOException {
        boolean version8;
        Version version = Version.read(in);
        version.checkCurrent();
        boolean bl = version8 = Version.VERSION_1_0_8.compareTo(version) <= 0;
        if (version8) {
            int selected = in.readInt();
            PlaceholderMap map = new PlaceholderMap(in, placeholders);
            map.setPlaceholderStrategy(null);
            return new StackDockStationLayout(selected, map);
        }
        int selected = in.readInt();
        int count = in.readInt();
        int[] ids = new int[count];
        int i = 0;
        while (i < count) {
            ids[i] = in.readInt();
            ++i;
        }
        return new RetroStackDockStationLayout(selected, ids);
    }

    @Override
    public void write(StackDockStationLayout layout, XElement element) {
        if (layout.getSelected() >= 0) {
            element.addElement("selected").setInt(layout.getSelected());
        }
        if (layout instanceof RetroStackDockStationLayout) {
            RetroStackDockStationLayout retroLayout = (RetroStackDockStationLayout)layout;
            XElement xchildren = element.addElement("children");
            int[] nArray = retroLayout.getChildren();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                xchildren.addElement("child").addInt("id", i);
                ++n2;
            }
        } else {
            layout.getPlaceholders().write(element.addElement("placeholders"));
        }
    }

    @Override
    public StackDockStationLayout read(XElement element, PlaceholderStrategy placeholders) {
        XElement xplaceholders;
        XElement xselected = element.getElement("selected");
        int selected = -1;
        if (xselected != null) {
            selected = xselected.getInt();
        }
        if ((xplaceholders = element.getElement("placeholders")) == null) {
            int[] ids;
            XElement xchildren = element.getElement("children");
            if (xchildren != null) {
                XElement[] children = xchildren.getElements("child");
                ids = new int[children.length];
                int i = 0;
                int n = children.length;
                while (i < n) {
                    ids[i] = children[i].getInt("id");
                    ++i;
                }
            } else {
                ids = new int[]{};
            }
            return new RetroStackDockStationLayout(selected, ids);
        }
        PlaceholderMap map = new PlaceholderMap(xplaceholders, placeholders);
        return new StackDockStationLayout(selected, map);
    }

    protected StackDockStation createStation() {
        return new StackDockStation();
    }
}

