/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.flap.FlapDockPerspective;
import bibliothek.gui.dock.station.flap.FlapDockProperty;
import bibliothek.gui.dock.station.flap.FlapDockStationLayout;
import bibliothek.gui.dock.station.flap.RetroFlapDockStationLayout;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class FlapDockStationFactory
implements DockFactory<FlapDockStation, FlapDockPerspective, FlapDockStationLayout> {
    public static final String ID = "flap dock";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public FlapDockStationLayout getLayout(FlapDockStation station, Map<Dockable, Integer> children) {
        PlaceholderMap map = station.getPlaceholders(children);
        return new FlapDockStationLayout(station.isAutoDirection(), station.getDirection(), map);
    }

    @Override
    public void setLayout(FlapDockStation station, FlapDockStationLayout layout, PlaceholderStrategy placeholders) {
        station.setDirection(layout.getDirection());
        station.setAutoDirection(layout.isAutoDirection());
    }

    @Override
    public void setLayout(FlapDockStation station, FlapDockStationLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        DockController controller = station.getController();
        try {
            if (controller != null) {
                controller.freezeLayout();
            }
            int i = station.getDockableCount() - 1;
            while (i >= 0) {
                station.remove(i);
                --i;
            }
            station.setDirection(layout.getDirection());
            station.setAutoDirection(layout.isAutoDirection());
            if (layout instanceof RetroFlapDockStationLayout) {
                RetroFlapDockStationLayout retroLayout = (RetroFlapDockStationLayout)layout;
                int[] ids = retroLayout.getChildren();
                boolean[] holding = retroLayout.getHolds();
                int[] sizes = retroLayout.getSizes();
                int i2 = 0;
                int n = ids.length;
                while (i2 < n) {
                    Dockable dockable = children.get(ids[i2]);
                    if (dockable != null) {
                        station.add(dockable);
                        station.setHold(dockable, holding[i2]);
                        station.setWindowSize(dockable, sizes[i2]);
                    }
                    ++i2;
                }
            } else {
                station.setPlaceholders(layout.getPlaceholders().filter(placeholders), children);
            }
        }
        finally {
            if (controller != null) {
                controller.meltLayout();
            }
        }
    }

    @Override
    public FlapDockPerspective layoutPerspective(FlapDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
        FlapDockPerspective perspective = new FlapDockPerspective();
        this.layoutPerspective(perspective, layout, children);
        return perspective;
    }

    @Override
    public void layoutPerspective(FlapDockPerspective perspective, FlapDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
        perspective.read(layout.getPlaceholders(), children);
    }

    @Override
    public FlapDockStationLayout getPerspectiveLayout(FlapDockPerspective element, Map<PerspectiveDockable, Integer> children) {
        boolean autoDirection = true;
        FlapDockStation.Direction direction = FlapDockStation.Direction.SOUTH;
        PlaceholderMap placeholders = element.toMap(children);
        return new FlapDockStationLayout(autoDirection, direction, placeholders);
    }

    @Override
    public void estimateLocations(FlapDockStationLayout layout, final LocationEstimationMap children) {
        if (layout instanceof RetroFlapDockStationLayout) {
            RetroFlapDockStationLayout retroLayout = (RetroFlapDockStationLayout)layout;
            int[] ids = retroLayout.getChildren();
            boolean[] holding = retroLayout.getHolds();
            int[] sizes = retroLayout.getSizes();
            int i = 0;
            int n = ids.length;
            while (i < n) {
                DockLayoutInfo info = children.getChild(ids[i]);
                if (info != null) {
                    FlapDockProperty property = new FlapDockProperty(i, holding[i], sizes[i], info.getPlaceholder());
                    info.setLocation(property);
                }
                ++i;
            }
        } else {
            DockablePlaceholderList.simulatedRead(layout.getPlaceholders(), new PlaceholderListItemAdapter<Dockable, PlaceholderListItem<Dockable>>(){

                @Override
                public PlaceholderListItem<Dockable> convert(ConvertedPlaceholderListItem item) {
                    int id = item.getInt("id");
                    int index = item.getInt("index");
                    boolean hold = item.getBoolean("hold");
                    int size = item.getInt("size");
                    Path placeholder = null;
                    if (item.contains("placeholder")) {
                        placeholder = new Path(item.getString("placeholder"));
                    }
                    FlapDockProperty property = new FlapDockProperty(index, hold, size, placeholder);
                    children.getChild(id).setLocation(property);
                    int i = 0;
                    int n = children.getSubChildCount(id);
                    while (i < n) {
                        DockLayoutInfo info = children.getSubChild(id, i);
                        info.setLocation(new FlapDockProperty(id, hold, size, info.getPlaceholder()));
                        ++i;
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public FlapDockStation layout(FlapDockStationLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        FlapDockStation station = this.createStation();
        this.setLayout(station, layout, children, placeholders);
        return station;
    }

    @Override
    public FlapDockStation layout(FlapDockStationLayout layout, PlaceholderStrategy placeholders) {
        FlapDockStation station = this.createStation();
        this.setLayout(station, layout, placeholders);
        return station;
    }

    @Override
    public void write(FlapDockStationLayout layout, DataOutputStream out) throws IOException {
        if (layout instanceof RetroFlapDockStationLayout) {
            RetroFlapDockStationLayout retroLayout = (RetroFlapDockStationLayout)layout;
            Version.write(out, Version.VERSION_1_0_4);
            out.writeBoolean(layout.isAutoDirection());
            out.writeInt(layout.getDirection().ordinal());
            int count = retroLayout.getChildren().length;
            out.writeInt(count);
            int i = 0;
            while (i < count) {
                out.writeInt(retroLayout.getChildren()[i]);
                out.writeBoolean(retroLayout.getHolds()[i]);
                out.writeInt(retroLayout.getSizes()[i]);
                ++i;
            }
        } else {
            Version.write(out, Version.VERSION_1_0_8);
            out.writeBoolean(layout.isAutoDirection());
            out.writeInt(layout.getDirection().ordinal());
            layout.getPlaceholders().write(out);
        }
    }

    @Override
    public FlapDockStationLayout read(DataInputStream in, PlaceholderStrategy placeholders) throws IOException {
        Version version = Version.read(in);
        version.checkCurrent();
        boolean version8 = Version.VERSION_1_0_8.compareTo(version) <= 0;
        boolean auto = in.readBoolean();
        FlapDockStation.Direction direction = FlapDockStation.Direction.values()[in.readInt()];
        if (version8) {
            PlaceholderMap map = new PlaceholderMap(in, placeholders);
            map.setPlaceholderStrategy(null);
            return new FlapDockStationLayout(auto, direction, map);
        }
        int count = in.readInt();
        int[] ids = new int[count];
        boolean[] holds = new boolean[count];
        int[] sizes = new int[count];
        int i = 0;
        while (i < count) {
            ids[i] = in.readInt();
            holds[i] = in.readBoolean();
            sizes[i] = in.readInt();
            ++i;
        }
        return new RetroFlapDockStationLayout(ids, holds, sizes, auto, direction);
    }

    @Override
    public void write(FlapDockStationLayout layout, XElement element) {
        if (layout instanceof RetroFlapDockStationLayout) {
            RetroFlapDockStationLayout retroLayout = (RetroFlapDockStationLayout)layout;
            XElement window = element.addElement("window");
            window.addBoolean("auto", layout.isAutoDirection());
            window.addString("direction", layout.getDirection().name());
            XElement children = element.addElement("children");
            int i = 0;
            int n = retroLayout.getChildren().length;
            while (i < n) {
                XElement child = children.addElement("child");
                child.addInt("id", retroLayout.getChildren()[i]);
                child.addBoolean("hold", retroLayout.getHolds()[i]);
                child.addInt("size", retroLayout.getSizes()[i]);
                ++i;
            }
        } else {
            XElement window = element.addElement("window");
            window.addBoolean("auto", layout.isAutoDirection());
            window.addString("direction", layout.getDirection().name());
            XElement children = element.addElement("placeholders");
            layout.getPlaceholders().write(children);
        }
    }

    @Override
    public FlapDockStationLayout read(XElement element, PlaceholderStrategy placeholders) {
        int n;
        int i;
        XElement window = element.getElement("window");
        XElement xplaceholders = element.getElement("placeholders");
        if (xplaceholders != null) {
            PlaceholderMap map = new PlaceholderMap(xplaceholders, placeholders);
            map.setPlaceholderStrategy(null);
            return new FlapDockStationLayout(window.getBoolean("auto"), FlapDockStation.Direction.valueOf(window.getString("direction")), map);
        }
        XElement children = element.getElement("children");
        XElement[] child = children.getElements("child");
        int[] ids = new int[child.length];
        boolean[] holds = new boolean[child.length];
        int[] sizes = new int[child.length];
        XAttribute sizeAttribute = window.getAttribute("size");
        if (sizeAttribute != null) {
            int size = sizeAttribute.getInt();
            int i2 = 0;
            while (i2 < sizes.length) {
                sizes[i2] = size;
                ++i2;
            }
        } else {
            i = 0;
            n = child.length;
            while (i < n) {
                sizes[i] = child[i].getInt("size");
                ++i;
            }
        }
        i = 0;
        n = child.length;
        while (i < n) {
            ids[i] = child[i].getInt("id");
            holds[i] = child[i].getBoolean("hold");
            ++i;
        }
        return new RetroFlapDockStationLayout(ids, holds, sizes, window.getBoolean("auto"), FlapDockStation.Direction.valueOf(window.getString("direction")));
    }

    protected FlapDockStation createStation() {
        return new FlapDockStation();
    }
}

