/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.station.split;

import bibliothek.gui.dock.facile.station.split.LockedResizeLayoutManager;
import bibliothek.gui.dock.facile.station.split.ResizeRequest;
import bibliothek.gui.dock.facile.station.split.ResizeRoot;

public abstract class ResizeElement<T> {
    private ResizeRequest request;
    private ResizeElement<T> parent;
    private LockedResizeLayoutManager<T> layout;

    public ResizeElement(ResizeElement<T> parent, LockedResizeLayoutManager<T> layout) {
        this.parent = parent;
        this.layout = layout;
    }

    public ResizeElement<T> getParent() {
        return this.parent;
    }

    public LockedResizeLayoutManager<T> getLayout() {
        return this.layout;
    }

    protected abstract ResizeRequest createRequest();

    public ResizeRequest getRequest() {
        return this.request;
    }

    protected abstract ResizeElement<T>[] getChildren();

    public void prepareResize() {
        ResizeElement<T>[] children = this.getChildren();
        if (children != null) {
            ResizeElement<T>[] resizeElementArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ResizeElement<T> child = resizeElementArray[n2];
                child.prepareResize();
                ++n2;
            }
        }
    }

    public void prepareRequests() {
        ResizeElement<T>[] children = this.getChildren();
        if (children != null) {
            ResizeElement<T>[] resizeElementArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ResizeElement<T> child = resizeElementArray[n2];
                child.prepareRequests();
                ++n2;
            }
        }
        this.request = this.createRequest();
    }

    public abstract void adapt(double var1, double var3);

    public ResizeRoot<T> getResizeRoot() {
        return this.parent.getResizeRoot();
    }
}

