/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode.status;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeManager;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablement;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablementListener;
import bibliothek.gui.dock.support.mode.ModeManager;
import bibliothek.gui.dock.support.mode.ModeManagerListener;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractExtendedModeEnablement
implements ExtendedModeEnablement {
    private List<ExtendedModeEnablementListener> listeners = new ArrayList<ExtendedModeEnablementListener>();
    private LocationModeManager<?> manager;
    private ModeManagerListener<Location, LocationMode> modeManagerListener = new ModeManagerListener<Location, LocationMode>(){

        @Override
        public void modeRemoved(ModeManager<? extends Location, ? extends LocationMode> manager, LocationMode mode) {
        }

        @Override
        public void modeChanged(ModeManager<? extends Location, ? extends LocationMode> manager, Dockable dockable, LocationMode oldMode, LocationMode newMode) {
        }

        @Override
        public void modeAdded(ModeManager<? extends Location, ? extends LocationMode> manager, LocationMode mode) {
        }

        @Override
        public void dockableRemoved(ModeManager<? extends Location, ? extends LocationMode> manager, Dockable dockable) {
            AbstractExtendedModeEnablement.this.disconnect(dockable);
        }

        @Override
        public void dockableAdded(ModeManager<? extends Location, ? extends LocationMode> manager, Dockable dockable) {
            AbstractExtendedModeEnablement.this.connect(dockable);
        }
    };

    public AbstractExtendedModeEnablement(LocationModeManager<?> manager) {
        this.manager = manager;
    }

    public LocationModeManager<?> getManager() {
        return this.manager;
    }

    protected void init() {
        this.manager.addModeManagerListener(this.modeManagerListener);
        for (Dockable dockable : this.manager.listDockables()) {
            this.connect(dockable);
        }
    }

    @Override
    public void addListener(ExtendedModeEnablementListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ExtendedModeEnablementListener listener) {
        this.listeners.remove(listener);
    }

    protected void fire(Dockable dockable, ExtendedMode mode, boolean available) {
        ExtendedModeEnablementListener[] array;
        ExtendedModeEnablementListener[] extendedModeEnablementListenerArray = array = this.listeners.toArray(new ExtendedModeEnablementListener[this.listeners.size()]);
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            ExtendedModeEnablementListener listener = extendedModeEnablementListenerArray[n2];
            listener.availabilityChanged(dockable, mode, available);
            ++n2;
        }
    }

    @Override
    public void destroy() {
        if (this.manager != null) {
            this.manager.removeModeManagerListener(this.modeManagerListener);
            for (Dockable dockable : this.manager.listDockables()) {
                this.disconnect(dockable);
            }
            this.manager = null;
        }
    }

    protected abstract void connect(Dockable var1);

    protected abstract void disconnect(Dockable var1);
}

