/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.relocator;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.control.ControllerSetupCollection;
import bibliothek.gui.dock.control.DirectRemoteRelocator;
import bibliothek.gui.dock.control.RemoteRelocator;
import bibliothek.gui.dock.control.relocator.AbstractDockRelocator;
import bibliothek.gui.dock.control.relocator.DefaultDockRelocatorEvent;
import bibliothek.gui.dock.control.relocator.DropOperation;
import bibliothek.gui.dock.control.relocator.MergeOperation;
import bibliothek.gui.dock.control.relocator.Merger;
import bibliothek.gui.dock.control.relocator.MoveOperation;
import bibliothek.gui.dock.control.relocator.MultiMerger;
import bibliothek.gui.dock.control.relocator.RelocateOperation;
import bibliothek.gui.dock.control.relocator.StackMerger;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.dockable.MovingImage;
import bibliothek.gui.dock.event.ControllerSetupListener;
import bibliothek.gui.dock.event.DockControllerRepresentativeListener;
import bibliothek.gui.dock.event.DockRelocatorListener;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.DockUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class DefaultDockRelocator
extends AbstractDockRelocator {
    private boolean onMove = false;
    private boolean onPut = false;
    private RelocateOperation operation;
    private ImageWindow movingImageWindow;
    private Point pressPointScreen;
    private Point pressPointLocal;
    private Point lastPoint;

    public DefaultDockRelocator(DockController controller, ControllerSetupCollection setup) {
        super(controller);
        setup.add(new ControllerSetupListener(){

            @Override
            public void done(DockController controller) {
                controller.addRepresentativeListener(new Listener());
            }
        });
        MultiMerger merger = new MultiMerger();
        merger.add(new StackMerger());
        this.setMerger(merger);
    }

    @Override
    public boolean isOnMove() {
        return this.onMove;
    }

    @Override
    public boolean isOnPut() {
        return this.onPut;
    }

    @Override
    public DirectRemoteRelocator createDirectRemote(Dockable dockable) {
        return this.createDirectRemote(dockable, false);
    }

    @Override
    public DirectRemoteRelocator createDirectRemote(Dockable dockable, boolean forceDrag) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        return new DefaultRemoteRelocator(dockable, forceDrag);
    }

    @Override
    public RemoteRelocator createRemote(Dockable dockable) {
        return this.createRemote(dockable, false);
    }

    @Override
    public RemoteRelocator createRemote(Dockable dockable, boolean forceDrag) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        return new DefaultRemoteRelocator(dockable, forceDrag);
    }

    protected void executeOperation(Dockable dockable, RelocateOperation operation) {
        this.onPut = true;
        DockController controller = this.getController();
        controller.getRegister().setStalled(true);
        this.disableAllModes();
        try {
            operation.execute(dockable, new DockRelocatorListener(){

                @Override
                public void init(DockController controller, Dockable dockable) {
                    DefaultDockRelocator.this.fireInit(dockable);
                }

                @Override
                public void drop(DockController controller, Dockable dockable, DockStation station) {
                    DefaultDockRelocator.this.fireDrop(dockable, station);
                }

                @Override
                public void drag(DockController controller, Dockable dockable, DockStation station) {
                    DefaultDockRelocator.this.fireDrag(dockable, station);
                }

                @Override
                public void cancel(DockController controller, Dockable dockable) {
                    DefaultDockRelocator.this.fireCancel(dockable);
                }
            });
        }
        finally {
            operation.getStation().forget();
            operation = null;
            this.onPut = false;
            controller.getRegister().setStalled(false);
        }
    }

    protected RelocateOperation preparePut(int mouseX, int mouseY, int titleX, int titleY, Dockable dockable) {
        List<DockStation> list = this.listStationsOrdered(mouseX, mouseY, dockable);
        int i = 0;
        while (i < 2) {
            boolean checkOverrideZone = i == 0;
            for (DockStation station : list) {
                boolean merge = this.canMerge(station, dockable);
                if (dockable.getDockParent() == station) {
                    if (!station.prepareMove(mouseX, mouseY, titleX, titleY, checkOverrideZone, dockable)) continue;
                    if (merge) {
                        return new MergeOperation(this.getController(), this.getMerger(), station);
                    }
                    return new MoveOperation(this.getController(), station);
                }
                if (!station.prepareDrop(mouseX, mouseY, titleX, titleY, checkOverrideZone, dockable)) continue;
                if (merge) {
                    return new MergeOperation(this.getController(), this.getMerger(), station);
                }
                return new DropOperation(this.getController(), station);
            }
            ++i;
        }
        return null;
    }

    protected boolean canMerge(DockStation parent, Dockable selection) {
        Merger merger = this.getMerger();
        if (merger == null) {
            return false;
        }
        DockStation child = selection.asDockStation();
        if (child == null) {
            return false;
        }
        if (DockUtilities.isAncestor(child, parent)) {
            return false;
        }
        if (selection.getDockParent() != null && !selection.getDockParent().canDrag(selection)) {
            return false;
        }
        MultiDockAcceptance acceptance = this.getController().getAcceptance();
        int i = 0;
        int n = child.getDockableCount();
        while (i < n) {
            Dockable dockable = child.getDockable(i);
            if (!child.canDrag(dockable)) {
                return false;
            }
            if (!parent.accept(dockable) || !dockable.accept(parent)) {
                return false;
            }
            if (!acceptance.accept(parent, dockable)) {
                return false;
            }
            ++i;
        }
        return merger.canMerge(parent, child);
    }

    protected List<DockStation> listStationsOrdered(int x, int y, Dockable moved) {
        LinkedList<DockStation> result = new LinkedList<DockStation>();
        DockStation movedStation = moved.asDockStation();
        DockController controller = this.getController();
        DockStation[] dockStationArray = controller.getRegister().listDockStations();
        int n = dockStationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Rectangle bounds;
            DockStation station = dockStationArray[n2];
            if ((movedStation == null || !DockUtilities.isAncestor(movedStation, station) && movedStation != station) && station.isStationVisible() && this.isStationValid(station) && ((bounds = station.getStationBounds()) == null || bounds.contains(x, y))) {
                int index = 0;
                for (DockStation resultStation : result) {
                    int compare = this.compare(resultStation, station);
                    if (compare < 0) break;
                    ++index;
                }
                result.add(index, station);
            }
            ++n2;
        }
        return result;
    }

    protected boolean isStationValid(DockStation station) {
        return true;
    }

    protected int compare(DockStation a, DockStation b) {
        int result;
        if (a == b) {
            return 0;
        }
        if (DockUtilities.isAncestor(a, b)) {
            return -1;
        }
        if (DockUtilities.isAncestor(b, a)) {
            return 1;
        }
        if (a.canCompare(b) && (result = a.compare(b)) != 0) {
            return result;
        }
        if (b.canCompare(a) && (result = -b.compare(a)) != 0) {
            return result;
        }
        Dockable dockA = a.asDockable();
        Dockable dockB = b.asDockable();
        if (dockA != null && dockB != null) {
            Component compA = dockA.getComponent();
            Component compB = dockB.getComponent();
            Window windowA = SwingUtilities.getWindowAncestor(compA);
            Window windowB = SwingUtilities.getWindowAncestor(compB);
            if (windowA != null && windowB != null) {
                if (windowA == windowB) {
                    if (DockUI.isOverlapping(compA, compB)) {
                        return 1;
                    }
                    if (DockUI.isOverlapping(compB, compA)) {
                        return -1;
                    }
                } else {
                    boolean mouseOverB;
                    if (this.isParent(windowA, windowB)) {
                        return -1;
                    }
                    if (this.isParent(windowB, windowA)) {
                        return 1;
                    }
                    boolean mouseOverA = windowA.getMousePosition() != null;
                    boolean bl = mouseOverB = windowB.getMousePosition() != null;
                    if (mouseOverA && !mouseOverB) {
                        return 1;
                    }
                    if (!mouseOverA && mouseOverB) {
                        return -1;
                    }
                }
            }
        }
        return 0;
    }

    private boolean isParent(Window parent, Window child) {
        Window temp = child.getOwner();
        while (temp != null) {
            if (temp == parent) {
                return true;
            }
            temp = temp.getOwner();
        }
        return false;
    }

    protected void dragMousePressed(MouseEvent e, DockTitle title, Dockable dockable) {
        if (dockable == null) {
            dockable = title.getDockable();
        }
        Point point = e.getPoint();
        SwingUtilities.convertPointToScreen(point, e.getComponent());
        RemoteRelocator.Reaction reaction = this.dragMousePressed(point.x, point.y, e.getX(), e.getY(), e.getModifiersEx(), dockable, false);
        if (reaction == RemoteRelocator.Reaction.BREAK_CONSUMED || reaction == RemoteRelocator.Reaction.CONTINUE_CONSUMED) {
            e.consume();
        }
    }

    protected RemoteRelocator.Reaction dragMousePressed(int x, int y, int dx, int dy, int modifiers, Dockable dockable, boolean forceDrag) {
        if (!forceDrag && dockable.getDockParent() == null) {
            return RemoteRelocator.Reaction.BREAK;
        }
        this.lastPoint = new Point(x, y);
        int onmask = 1024;
        int offmask = 6144;
        if ((modifiers & (onmask | offmask)) == onmask) {
            this.titleDragCancel();
            this.onMove = false;
            this.pressPointScreen = new Point(x, y);
            this.pressPointLocal = new Point(dx, dy);
            this.checkModes(modifiers);
            return RemoteRelocator.Reaction.CONTINUE;
        }
        if (this.pressPointScreen != null) {
            this.titleDragCancel();
            this.disableAllModes();
            this.fireCancel(dockable);
            DefaultDockRelocatorEvent event = new DefaultDockRelocatorEvent(this.getController(), dockable, this.operation == null ? null : this.operation.getStation());
            event.cancel();
            this.fireCanceled(event);
            return RemoteRelocator.Reaction.BREAK_CONSUMED;
        }
        return RemoteRelocator.Reaction.BREAK;
    }

    protected void dragMouseDragged(MouseEvent e, DockTitle title, Dockable dockable) {
        Point point = e.getPoint();
        SwingUtilities.convertPointToScreen(point, e.getComponent());
        RemoteRelocator.Reaction reaction = this.dragMouseDragged(point.x, point.y, e.getModifiersEx(), title, dockable, false, false);
        if (reaction == RemoteRelocator.Reaction.BREAK_CONSUMED || reaction == RemoteRelocator.Reaction.CONTINUE_CONSUMED) {
            e.consume();
        }
    }

    protected RemoteRelocator.Reaction dragMouseDragged(int x, int y, int modifiers, DockTitle title, Dockable dockable, boolean always, boolean forceDrag) {
        RemoteRelocator.Reaction result;
        if (this.pressPointScreen == null) {
            return RemoteRelocator.Reaction.BREAK;
        }
        this.checkModes(modifiers);
        if (dockable == null) {
            dockable = title.getDockable();
        }
        if (dockable == null) {
            return RemoteRelocator.Reaction.BREAK;
        }
        Point mouse = new Point(x, y);
        this.lastPoint = new Point(x, y);
        if (!this.onMove) {
            RemoteRelocator.Reaction result2;
            DockStation parent = dockable.getDockParent();
            if (!forceDrag && parent != null && !parent.canDrag(dockable)) {
                this.titleDragCancel();
                this.disableAllModes();
                return RemoteRelocator.Reaction.BREAK_CONSUMED;
            }
            int distance = Math.abs(x - this.pressPointScreen.x) + Math.abs(y - this.pressPointScreen.y);
            if ((always || distance >= this.getDragDistance()) && (result2 = this.initiateOperation(dockable, title, mouse)) != null) {
                return result2;
            }
        }
        if (this.onMove && (result = this.selectNextTarget(dockable, title, mouse)) != null) {
            return result;
        }
        return RemoteRelocator.Reaction.CONTINUE_CONSUMED;
    }

    private RemoteRelocator.Reaction initiateOperation(Dockable dockable, DockTitle title, Point mouse) {
        if (this.movingImageWindow != null) {
            this.movingImageWindow.close();
            this.movingImageWindow = null;
        }
        DefaultDockRelocatorEvent event = new DefaultDockRelocatorEvent(this.getController(), dockable, null);
        this.fireGrabbing(event);
        if (event.isCanceled()) {
            event = new DefaultDockRelocatorEvent(this.getController(), dockable, null);
            event.cancel();
            this.fireCanceled(event);
            return RemoteRelocator.Reaction.BREAK_CONSUMED;
        }
        if (!event.isForbidden()) {
            this.movingImageWindow = this.getTitleWindow(dockable, title);
            if (this.movingImageWindow != null) {
                this.updateTitleWindowPosition(mouse);
                this.movingImageWindow.setVisible(true);
            }
            this.onMove = true;
            this.fireInit(dockable);
            event = new DefaultDockRelocatorEvent(this.getController(), dockable, null);
            this.fireGrabbed(event);
            if (event.isCanceled() || event.isForbidden()) {
                this.cancel(dockable);
                return RemoteRelocator.Reaction.BREAK_CONSUMED;
            }
        }
        return null;
    }

    private RemoteRelocator.Reaction selectNextTarget(Dockable dockable, DockTitle title, Point mouse) {
        if (this.movingImageWindow != null) {
            this.updateTitleWindowPosition(mouse);
        }
        RelocateOperation next = this.preparePut(mouse.x, mouse.y, mouse.x - this.pressPointLocal.x, mouse.y - this.pressPointLocal.y, dockable);
        boolean drop = false;
        DefaultDockRelocatorEvent event = new DefaultDockRelocatorEvent(this.getController(), dockable, next == null ? null : next.getStation());
        this.fireDragged(event);
        if (event.isCanceled()) {
            this.cancel(dockable);
            return RemoteRelocator.Reaction.BREAK_CONSUMED;
        }
        if (event.isForbidden()) {
            next = null;
        }
        if (next != null) {
            boolean bl = drop = next != null && event.isDropping();
        }
        if (drop) {
            return this.dragMouseReleased(mouse.x, mouse.y, 0, dockable);
        }
        if (this.operation != null && (next == null || next.getStation() != this.operation.getStation())) {
            this.operation.getStation().forget();
        }
        this.operation = next;
        if (next != null) {
            next.getStation().draw();
        }
        return null;
    }

    private void updateTitleWindowPosition(Point mouse) {
        int width = Math.min(25, this.movingImageWindow.getWidth());
        int height = Math.min(25, this.movingImageWindow.getHeight());
        int delta = Math.min(width, height) + 1;
        int dx = Math.min(width, this.pressPointLocal.x);
        int dy = Math.min(height, this.pressPointLocal.y);
        this.movingImageWindow.setLocation(mouse.x - dx + delta, mouse.y - dy + delta);
    }

    protected void dragMouseReleased(MouseEvent e, DockTitle title, Dockable dockable) {
        if (dockable == null) {
            dockable = title.getDockable();
        }
        Point point = e.getPoint();
        SwingUtilities.convertPointToScreen(point, e.getComponent());
        RemoteRelocator.Reaction reaction = this.dragMouseReleased(point.x, point.y, e.getModifiersEx(), dockable);
        if (reaction == RemoteRelocator.Reaction.BREAK_CONSUMED || reaction == RemoteRelocator.Reaction.CONTINUE_CONSUMED) {
            e.consume();
        }
    }

    protected RemoteRelocator.Reaction dragMouseReleased(int x, int y, int modifiers, Dockable dockable) {
        boolean stop;
        this.checkModes(modifiers);
        int offmask = 7168;
        boolean bl = stop = !this.onMove || (modifiers & offmask) == 0;
        if (stop && this.onMove) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultDockRelocator.this.onMove = false;
                }
            });
        }
        if (!this.onMove) {
            boolean wasDragging = this.pressPointScreen != null;
            this.titleDragCancel();
            this.disableAllModes();
            if (stop) {
                DefaultDockRelocatorEvent event = new DefaultDockRelocatorEvent(this.getController(), dockable, null);
                event.cancel();
                this.fireCanceled(event);
                this.fireCancel(dockable);
                if (wasDragging) {
                    return RemoteRelocator.Reaction.BREAK_CONSUMED;
                }
                return RemoteRelocator.Reaction.BREAK;
            }
            return RemoteRelocator.Reaction.CONTINUE_CONSUMED;
        }
        boolean consume = false;
        DefaultDockRelocatorEvent dropped = null;
        if (stop) {
            if (this.pressPointScreen != null) {
                DefaultDockRelocatorEvent event;
                RelocateOperation operation = this.operation;
                if (x != this.lastPoint.x || y != this.lastPoint.y) {
                    RelocateOperation next = this.preparePut(x, y, x - this.pressPointLocal.x, y - this.pressPointLocal.y, dockable);
                    if (next != null) {
                        DefaultDockRelocatorEvent event2 = new DefaultDockRelocatorEvent(this.getController(), dockable, next.getStation());
                        this.fireDragged(event2);
                        if (event2.isCanceled() || event2.isForbidden()) {
                            next = null;
                        }
                    }
                    if (operation != null && (next == null || operation.getStation() != next.getStation())) {
                        operation.getStation().forget();
                    }
                    operation = next;
                }
                if (operation != null) {
                    event = new DefaultDockRelocatorEvent(this.getController(), dockable, operation.getStation());
                    event.drop();
                    this.fireDropping(event);
                    if (event.isCanceled() || event.isForbidden()) {
                        operation.getStation().forget();
                        operation = null;
                    }
                }
                if (operation != null) {
                    consume = true;
                    this.executeOperation(dockable, operation);
                    operation.getStation().forget();
                    this.operation = null;
                    dropped = new DefaultDockRelocatorEvent(this.getController(), dockable, operation.getStation());
                } else {
                    event = new DefaultDockRelocatorEvent(this.getController(), dockable, null);
                    event.cancel();
                    this.fireCanceled(event);
                }
            }
            if (this.movingImageWindow != null) {
                this.movingImageWindow.close();
            }
            this.movingImageWindow = null;
            this.pressPointScreen = null;
            this.pressPointLocal = null;
        }
        if (dropped != null) {
            this.fireDropped(dropped);
        }
        if (stop) {
            this.disableAllModes();
            return consume ? RemoteRelocator.Reaction.BREAK_CONSUMED : RemoteRelocator.Reaction.BREAK;
        }
        return consume ? RemoteRelocator.Reaction.CONTINUE_CONSUMED : RemoteRelocator.Reaction.CONTINUE;
    }

    private void cancel(Dockable dockable) {
        this.titleDragCancel();
        this.fireCancel(dockable);
        DefaultDockRelocatorEvent event = new DefaultDockRelocatorEvent(this.getController(), dockable, null);
        event.cancel();
        this.fireCanceled(event);
    }

    private void titleDragCancel() {
        if (!this.isOnPut()) {
            if (this.operation != null) {
                this.operation.getStation().forget();
                this.operation = null;
            }
            if (this.movingImageWindow != null) {
                this.movingImageWindow.close();
            }
            this.movingImageWindow = null;
            this.pressPointScreen = null;
            this.pressPointLocal = null;
        }
    }

    private ImageWindow getTitleWindow(Dockable dockable, DockTitle title) {
        DockController controller = this.getController();
        DockableMovingImageFactory factory = controller.getProperties().get(DockTheme.DOCKABLE_MOVING_IMAGE_FACTORY);
        MovingImage image = title == null ? factory.create(controller, dockable) : factory.create(controller, title);
        if (image == null) {
            return null;
        }
        Window parent = title == null ? SwingUtilities.getWindowAncestor(dockable.getComponent()) : SwingUtilities.getWindowAncestor(title.getComponent());
        ImageWindow window = new ImageWindow(parent, image);
        window.pack();
        return window;
    }

    private class DefaultRemoteRelocator
    implements RemoteRelocator,
    DirectRemoteRelocator {
        private Dockable dockable;
        private boolean forceDrag;

        public DefaultRemoteRelocator(Dockable dockable, boolean forceDrag) {
            this.dockable = dockable;
            this.forceDrag = forceDrag;
        }

        @Override
        public void cancel() {
            DefaultDockRelocator.this.titleDragCancel();
            DefaultDockRelocator.this.onMove = false;
        }

        @Override
        public void drag(int x, int y, boolean always) {
            DefaultDockRelocator.this.dragMouseDragged(x, y, 1024, null, this.dockable, always, this.forceDrag);
        }

        @Override
        public RemoteRelocator.Reaction drag(int x, int y, int modifiers) {
            return DefaultDockRelocator.this.dragMouseDragged(x, y, modifiers, null, this.dockable, false, this.forceDrag);
        }

        @Override
        public void drop(int x, int y) {
            this.drop(x, y, 0);
        }

        @Override
        public RemoteRelocator.Reaction drop(int x, int y, int modifiers) {
            return DefaultDockRelocator.this.dragMouseReleased(x, y, modifiers, this.dockable);
        }

        @Override
        public void init(int x, int y, int dx, int dy) {
            this.init(x, y, dx, dy, 1024);
        }

        @Override
        public RemoteRelocator.Reaction init(int x, int y, int dx, int dy, int modifiers) {
            return DefaultDockRelocator.this.dragMousePressed(x, y, dx, dy, modifiers, this.dockable, this.forceDrag);
        }
    }

    private class ImageWindow
    extends JWindow {
        private MovingImage image;

        public ImageWindow(Window parent, MovingImage image) {
            super(parent);
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentHidden(ComponentEvent e) {
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentResized(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    if (ImageWindow.this != DefaultDockRelocator.this.movingImageWindow) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ImageWindow.this.close();
                            }
                        });
                    }
                }
            });
            Container content = this.getContentPane();
            content.setLayout(new GridLayout(1, 1));
            this.setFocusableWindowState(false);
            try {
                this.setAlwaysOnTop(true);
            }
            catch (SecurityException securityException) {}
            image.bind();
            content.add(image.getComponent());
            this.image = image;
        }

        public void close() {
            this.dispose();
            if (this.image != null) {
                this.image.unbind();
                this.image = null;
            }
            this.getContentPane().removeAll();
        }
    }

    private class Listener
    implements DockControllerRepresentativeListener {
        private Map<DockElementRepresentative, MouseRepresentativeListener> listeners = new HashMap<DockElementRepresentative, MouseRepresentativeListener>();

        private Listener() {
        }

        @Override
        public void representativeAdded(DockController controller, DockElementRepresentative representative) {
            if (representative.getElement().asDockable() != null) {
                MouseRepresentativeListener listener = new MouseRepresentativeListener(representative);
                this.listeners.put(representative, listener);
                representative.addMouseInputListener(listener);
            }
        }

        @Override
        public void representativeRemoved(DockController controller, DockElementRepresentative representative) {
            MouseRepresentativeListener listener;
            if (representative.getElement().asDockable() != null && (listener = this.listeners.remove(representative)) != null) {
                representative.removeMouseInputListener(listener);
            }
        }
    }

    private class MouseRepresentativeListener
    extends MouseInputAdapter {
        private DockTitle title;
        private Dockable dockable;
        private DockElementRepresentative representative;

        public MouseRepresentativeListener(DockElementRepresentative representative) {
            this.representative = representative;
            if (representative instanceof DockTitle) {
                this.title = (DockTitle)representative;
            }
            this.dockable = representative.getElement().asDockable();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (!this.representative.isUsedAsTitle() && DefaultDockRelocator.this.isDragOnlyTitel()) {
                return;
            }
            DefaultDockRelocator.this.dragMousePressed(e, this.title, this.dockable);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (!this.representative.isUsedAsTitle() && DefaultDockRelocator.this.isDragOnlyTitel()) {
                return;
            }
            DefaultDockRelocator.this.dragMouseReleased(e, this.title, this.dockable);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (!this.representative.isUsedAsTitle() && DefaultDockRelocator.this.isDragOnlyTitel()) {
                return;
            }
            DefaultDockRelocator.this.dragMouseDragged(e, this.title, this.dockable);
        }
    }
}

