/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.perspective;

import bibliothek.gui.dock.common.perspective.CElementPerspective;
import bibliothek.gui.dock.common.perspective.CPerspective;
import bibliothek.gui.dock.common.perspective.CommonElementPerspective;
import bibliothek.gui.dock.common.perspective.MultipleCDockablePerspective;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CPerspectiveMultipleIdentifierCollection {
    private CPerspective perspective;
    private Map<String, MultipleCDockablePerspective> ids = new HashMap<String, MultipleCDockablePerspective>();

    public CPerspectiveMultipleIdentifierCollection(String factoryId, CPerspective perspective) {
        this.perspective = perspective;
        Iterator<PerspectiveElement> iterator = perspective.elements();
        while (iterator.hasNext()) {
            MultipleCDockablePerspective dockable;
            CElementPerspective celement;
            PerspectiveElement element = iterator.next();
            if (!(element instanceof CommonElementPerspective) || !((celement = ((CommonElementPerspective)element).getElement()) instanceof MultipleCDockablePerspective) || !(dockable = (MultipleCDockablePerspective)celement).getFactoryID().equals(factoryId) || dockable.getUniqueId() == null) continue;
            this.ids.put(dockable.getUniqueId(), dockable);
        }
    }

    public CPerspective getPerspective() {
        return this.perspective;
    }

    public String getUniqueId(MultipleCDockablePerspective element) {
        MultipleCDockablePerspective old;
        String id = element.getUniqueId();
        if (id == null) {
            String factory = element.getFactoryID();
            int count = 0;
            id = String.valueOf(count) + " " + factory;
            while (this.ids.containsKey(id)) {
                id = String.valueOf(++count) + " " + factory;
            }
            element.setUniqueId(id);
        }
        if ((old = this.ids.put(id, element)) != null && old != element) {
            throw new IllegalStateException("unique identifier collision, id='" + id + "', old item='" + old + "', new item='" + element + "'");
        }
        return id;
    }

    public void putDockable(String id, MultipleCDockablePerspective perspective) {
        this.ids.put(id, perspective);
    }
}

