/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.perspective;

import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.common.perspective.CDockablePerspective;
import bibliothek.gui.dock.common.perspective.CElementPerspective;
import bibliothek.gui.dock.common.perspective.CPerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.common.perspective.CommonElementPerspective;
import bibliothek.gui.dock.common.perspective.mode.CMinimizedModePerspective;
import bibliothek.gui.dock.common.perspective.mode.CModeAreaPerspective;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.flap.FlapDockPerspective;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.util.Path;

public class CMinimizePerspective
implements CStationPerspective {
    private CommonFlapDockPerspective delegate;
    private String id;
    private CPerspective perspective;
    private Path typeId;
    private CModeAreaPerspective mode = new CModeAreaPerspective(){

        @Override
        public String getUniqueId() {
            return CMinimizePerspective.this.getUniqueId();
        }

        @Override
        public boolean isChild(PerspectiveDockable dockable) {
            return dockable.getParent() == CMinimizePerspective.this.intern();
        }
    };

    public CMinimizePerspective(String id, Path typeId) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        this.id = id;
        this.typeId = typeId;
        this.delegate = new CommonFlapDockPerspective();
    }

    @Override
    public void setPerspective(CPerspective perspective) {
        CMinimizedModePerspective mode;
        if (this.perspective != null) {
            mode = (CMinimizedModePerspective)this.perspective.getLocationManager().getMode(ExtendedMode.MINIMIZED);
            mode.remove(this.mode);
        }
        this.perspective = perspective;
        if (this.perspective != null) {
            mode = (CMinimizedModePerspective)this.perspective.getLocationManager().getMode(ExtendedMode.MINIMIZED);
            mode.add(this.mode);
        }
    }

    @Override
    public Path getTypeId() {
        return this.typeId;
    }

    public void add(CDockablePerspective dockable) {
        this.delegate.add(dockable.intern().asDockable());
    }

    public void insert(int index, CDockablePerspective dockable) {
        this.delegate.insert(index, dockable.intern().asDockable());
    }

    public void addPlaceholder(CDockablePerspective dockable) {
        this.delegate.addPlaceholder(dockable.intern().asDockable());
    }

    public void insertPlaceholder(int index, CDockablePerspective dockable) {
        this.delegate.insertPlaceholder(index, dockable.intern().asDockable());
    }

    public int indexOf(CDockablePerspective dockable) {
        return this.delegate.indexOf(dockable.intern().asDockable());
    }

    public boolean remove(CDockablePerspective dockable) {
        return this.delegate.remove(dockable.intern().asDockable());
    }

    public CDockablePerspective remove(int index) {
        PerspectiveDockable dockable = this.delegate.remove(index);
        if (dockable instanceof CommonElementPerspective) {
            return ((CommonElementPerspective)((Object)dockable)).getElement().asDockable();
        }
        return null;
    }

    @Override
    public CDockablePerspective asDockable() {
        return null;
    }

    @Override
    public CStationPerspective asStation() {
        return this;
    }

    public String getFactoryID() {
        return this.delegate.getFactoryID();
    }

    @Override
    public String getUniqueId() {
        return this.id;
    }

    @Override
    public CommonFlapDockPerspective intern() {
        return this.delegate;
    }

    public PlaceholderMap getPlaceholders() {
        return this.delegate.getPlaceholders();
    }

    public void setPlaceholders(PlaceholderMap placeholders) {
        this.delegate.setPlaceholders(placeholders);
    }

    @Override
    public boolean isWorkingArea() {
        return false;
    }

    public class CommonFlapDockPerspective
    extends FlapDockPerspective
    implements CommonElementPerspective {
        @Override
        public CElementPerspective getElement() {
            return CMinimizePerspective.this;
        }
    }
}

