/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.actions;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.SelectableDockAction;
import bibliothek.gui.dock.action.actions.SimpleDropDownItemAction;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.SelectableDockActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;

public abstract class SimpleSelectableAction
extends SimpleDropDownItemAction
implements SelectableDockAction {
    private List<SelectableDockActionListener> listeners = new ArrayList<SelectableDockActionListener>();
    private boolean selected = false;
    private Icon selectedIcon;
    private Icon disabledSelectedIcon;
    private ActionType<SelectableDockAction> type;

    public SimpleSelectableAction(ActionType<SelectableDockAction> type) {
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null");
        }
        this.type = type;
    }

    @Override
    public <V> V createView(ViewTarget<V> target, ActionViewConverter converter, Dockable dockable) {
        return converter.createView(this.type, this, target, dockable);
    }

    @Override
    public void addSelectableListener(SelectableDockActionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeSelectableListener(SelectableDockActionListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireSelectedChanged() {
        Set<Dockable> dockables = this.getBoundDockables();
        SelectableDockActionListener[] selectableDockActionListenerArray = this.listeners.toArray(new SelectableDockActionListener[this.listeners.size()]);
        int n = selectableDockActionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SelectableDockActionListener listener = selectableDockActionListenerArray[n2];
            listener.selectedChanged(this, dockables);
            ++n2;
        }
    }

    @Override
    public boolean isSelected(Dockable dockable) {
        return this.selected;
    }

    @Override
    public void setSelected(Dockable dockable, boolean selected) {
        this.setSelected(selected);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        if (selected != this.selected) {
            this.selected = selected;
            this.fireSelectedChanged();
            this.fireActionIconChanged(this.getBoundDockables());
            this.fireActionDisabledIconChanged(this.getBoundDockables());
        }
    }

    @Override
    public Icon getIcon(Dockable dockable) {
        if (this.isSelected()) {
            return this.firstNonNull(this.selectedIcon, super.getIcon(dockable));
        }
        return super.getIcon(dockable);
    }

    protected Icon firstNonNull(Icon ... icons) {
        Icon[] iconArray = icons;
        int n = icons.length;
        int n2 = 0;
        while (n2 < n) {
            Icon icon = iconArray[n2];
            if (icon != null) {
                return icon;
            }
            ++n2;
        }
        return null;
    }

    public Icon getSelectedIcon() {
        return this.selectedIcon;
    }

    public void setSelectedIcon(Icon selectedIcon) {
        this.selectedIcon = selectedIcon;
        this.fireActionIconChanged(this.getBoundDockables());
    }

    public Icon getDisabledSelectedIcon() {
        return this.disabledSelectedIcon;
    }

    @Override
    public Icon getDisabledIcon(Dockable dockable) {
        if (this.selected) {
            return this.firstNonNull(this.disabledSelectedIcon, super.getDisabledIcon(dockable));
        }
        return super.getDisabledIcon(dockable);
    }

    public void setDisabledSelectedIcon(Icon disabledSelectedIcon) {
        this.disabledSelectedIcon = disabledSelectedIcon;
        this.fireActionDisabledIconChanged(this.getBoundDockables());
    }

    public static class Check
    extends SimpleSelectableAction {
        public Check() {
            super(ActionType.CHECK);
            this.setDropDownSelectable(false);
        }

        @Override
        public boolean trigger(Dockable dockable) {
            if (!this.isEnabled(dockable)) {
                return false;
            }
            this.setSelected(dockable, !this.isSelected(dockable));
            return true;
        }
    }

    public static class Radio
    extends SimpleSelectableAction {
        public Radio() {
            super(ActionType.RADIO);
            this.setDropDownTriggerableSelected(false);
        }

        @Override
        public boolean trigger(Dockable dockable) {
            if (!this.isEnabled(dockable) || this.isSelected(dockable)) {
                return false;
            }
            this.setSelected(dockable, true);
            return true;
        }
    }
}

