/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.actions;

import bibliothek.extension.gui.dock.preference.editor.KeyStrokeEditor;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.action.actions.AbstractStandardDockAction;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.KeyboardListener;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public abstract class SimpleDockAction
extends AbstractStandardDockAction {
    private Icon icon;
    private Icon disabledIcon;
    private String text;
    private String tooltip;
    private boolean enabled = true;
    private KeyStroke accelerator;
    private Dockable representative;
    private Map<Dockable, DockableKeyForwarder> forwarders = new HashMap<Dockable, DockableKeyForwarder>();

    @Override
    protected void bound(Dockable dockable) {
        super.bound(dockable);
        DockableKeyForwarder forwarder = new DockableKeyForwarder(dockable);
        this.forwarders.put(dockable, forwarder);
    }

    @Override
    protected void unbound(Dockable dockable) {
        super.unbound(dockable);
        DockableKeyForwarder forwarder = this.forwarders.remove(dockable);
        forwarder.destroy();
    }

    @Override
    public Icon getIcon(Dockable dockable) {
        return this.icon;
    }

    @Override
    public String getText(Dockable dockable) {
        return this.text;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.fireActionTextChanged(this.getBoundDockables());
    }

    @Override
    public String getTooltipText(Dockable dockable) {
        return this.getTooltipText();
    }

    public String getTooltipText() {
        if (this.accelerator == null) {
            return this.tooltip;
        }
        String acceleratorText = KeyStrokeEditor.toString(this.accelerator, true);
        if (this.tooltip == null) {
            return acceleratorText;
        }
        return String.valueOf(this.tooltip) + " (" + acceleratorText + ")";
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
        this.fireActionTooltipTextChanged(this.getBoundDockables());
    }

    @Override
    public boolean isEnabled(Dockable dockable) {
        return this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.fireActionEnabledChanged(this.getBoundDockables());
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.fireActionIconChanged(this.getBoundDockables());
    }

    public Icon getDisabledIcon() {
        return this.disabledIcon;
    }

    @Override
    public Icon getDisabledIcon(Dockable dockable) {
        return this.disabledIcon;
    }

    public void setDockableRepresentation(Dockable dockable) {
        if (this.representative != dockable) {
            this.representative = dockable;
            this.fireActionRepresentativeChanged(this.getBoundDockables());
        }
    }

    @Override
    public Dockable getDockableRepresentation(Dockable dockable) {
        return this.representative;
    }

    public Dockable getDockableRepresentation() {
        return this.representative;
    }

    public void setDisabledIcon(Icon disabledIcon) {
        this.disabledIcon = disabledIcon;
        this.fireActionDisabledIconChanged(this.getBoundDockables());
    }

    public KeyStroke getAccelerator() {
        return this.accelerator;
    }

    public void setAccelerator(KeyStroke accelerator) {
        this.accelerator = accelerator;
        this.fireActionTooltipTextChanged(this.getBoundDockables());
    }

    protected boolean trigger(KeyEvent event, Dockable dockable) {
        return this.trigger(dockable);
    }

    private class DockableKeyForwarder
    implements KeyboardListener,
    DockHierarchyListener {
        private Dockable dockable;
        private DockController controller;
        private boolean destroyed = false;

        public DockableKeyForwarder(Dockable dockable) {
            this.dockable = dockable;
            dockable.addDockHierarchyListener(this);
            this.setController(dockable.getController());
        }

        @Override
        public void hierarchyChanged(DockHierarchyEvent event) {
        }

        @Override
        public void controllerChanged(DockHierarchyEvent event) {
            this.setController(this.dockable.getController());
        }

        private void setController(DockController controller) {
            if (this.controller != null) {
                this.controller.getKeyboardController().removeListener(this);
            }
            this.controller = this.destroyed ? null : controller;
            if (this.controller != null) {
                this.controller.getKeyboardController().addListener(this);
            }
        }

        public void destroy() {
            this.destroyed = true;
            this.setController(null);
            this.dockable.removeDockHierarchyListener(this);
        }

        private boolean forward(DockElement element, KeyEvent event) {
            if (SimpleDockAction.this.accelerator != null && SimpleDockAction.this.accelerator.equals(KeyStroke.getKeyStrokeForEvent(event))) {
                return SimpleDockAction.this.trigger(event, this.dockable);
            }
            return false;
        }

        @Override
        public boolean keyPressed(DockElement element, KeyEvent event) {
            return this.forward(element, event);
        }

        @Override
        public boolean keyReleased(DockElement element, KeyEvent event) {
            return this.forward(element, event);
        }

        @Override
        public boolean keyTyped(DockElement element, KeyEvent event) {
            return this.forward(element, event);
        }

        @Override
        public DockElement getTreeLocation() {
            return this.dockable;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " -> " + this.dockable.getTitleText() + " -> " + SimpleDockAction.this.getText();
        }
    }
}

