/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.smooth;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public abstract class SmoothChanger
implements ActionListener {
    private long last;
    private int[] current;
    private int duration;
    private Timer timer;

    public SmoothChanger(int states) {
        this(250, states);
    }

    public SmoothChanger(int duration, int states) {
        this.duration = duration;
        this.timer = new Timer(15, this);
        this.current = new int[states];
    }

    protected abstract int destination();

    protected abstract void repaint(int[] var1);

    public void setDuration(int duration) {
        if (duration < 1) {
            throw new IllegalArgumentException("duration must be >= 1");
        }
        this.duration = duration;
        int i = 0;
        while (i < this.current.length) {
            this.current[i] = Math.min(this.current[i], duration);
            ++i;
        }
        this.repaint(this.current);
    }

    public boolean isRunning() {
        return this.timer.isRunning();
    }

    public int getDuration() {
        return this.duration;
    }

    public void trigger() {
        this.timer.start();
        this.last = System.currentTimeMillis();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        long time = System.currentTimeMillis();
        int delta = (int)(time - this.last);
        this.last = time;
        int destination = this.destination();
        boolean incomplete = false;
        int i = 0;
        while (i < this.current.length) {
            if (i == destination) {
                this.current[i] = Math.min(this.current[i] + delta, this.duration);
                incomplete = incomplete || this.current[i] < this.duration;
            } else {
                this.current[i] = Math.max(this.current[i] - delta, 0);
                incomplete = incomplete || this.current[i] > 0;
            }
            ++i;
        }
        if (!incomplete) {
            this.timer.stop();
        }
        this.repaint(this.current);
    }
}

