/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Timer;

public class BubbleColorAnimation {
    private int duration = 1000;
    private Map<String, Entry> colors = new HashMap<String, Entry>();
    private Timer timer;
    private long time = 0L;
    private List<Runnable> tasks = new ArrayList<Runnable>();

    public BubbleColorAnimation() {
        this.timer = new Timer(25, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BubbleColorAnimation.this.pulse();
            }
        });
        this.timer.setCoalesce(true);
    }

    public void putColors(String key, Color source, Color destination) {
        Entry entry = this.colors.get(key);
        if (entry == null) {
            entry = new Entry();
            this.colors.put(key, entry);
        }
        entry.setColors(source, destination);
    }

    public void putColor(String key, Color color) {
        Entry entry = this.colors.get(key);
        if (entry == null) {
            entry = new Entry();
            entry.age = 0;
            entry.source = color;
            this.colors.put(key, entry);
        } else {
            entry.setDestination(color);
            this.start();
        }
    }

    public Color getColor(String key) {
        Entry entry = this.colors.get(key);
        if (entry == null) {
            return null;
        }
        return entry.getColor();
    }

    public void addTask(Runnable runnable) {
        this.tasks.add(runnable);
    }

    public void removeTask(Runnable runnable) {
        this.tasks.remove(runnable);
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getDuration() {
        return this.duration;
    }

    public void stop() {
        this.timer.stop();
    }

    public void kick() {
        if (this.timer.isRunning()) {
            this.stop();
            for (Entry entry : this.colors.values()) {
                entry.kick();
            }
            for (Runnable task : this.tasks) {
                task.run();
            }
        }
    }

    protected void start() {
        if (!this.timer.isRunning()) {
            this.time = System.currentTimeMillis();
            this.timer.start();
        }
    }

    protected void pulse() {
        boolean run = false;
        long current = System.currentTimeMillis();
        int delta = (int)(current - this.time);
        this.time = current;
        for (Entry entry : this.colors.values()) {
            run = entry.step(delta) | run;
        }
        if (!run) {
            this.timer.stop();
        }
        for (Runnable task : this.tasks) {
            task.run();
        }
    }

    private class Entry {
        private Color source;
        private Color destination;
        private Color intermediate;
        private int age;

        private Entry() {
        }

        public Color getColor() {
            if (this.age <= 0) {
                return this.source;
            }
            if (this.age >= BubbleColorAnimation.this.duration) {
                return this.destination;
            }
            Color source = this.intermediate == null ? this.source : this.intermediate;
            double s = (double)(BubbleColorAnimation.this.duration - this.age) / (double)BubbleColorAnimation.this.duration;
            double d = (double)this.age / (double)BubbleColorAnimation.this.duration;
            return new Color(Math.max(0, Math.min(255, (int)(s * (double)source.getRed() + d * (double)this.destination.getRed()))), Math.max(0, Math.min(255, (int)(s * (double)source.getGreen() + d * (double)this.destination.getGreen()))), Math.max(0, Math.min(255, (int)(s * (double)source.getBlue() + d * (double)this.destination.getBlue()))));
        }

        public boolean step(int delta) {
            if (this.destination == null) {
                return false;
            }
            this.age += delta;
            if (this.age >= BubbleColorAnimation.this.duration) {
                this.age = 0;
                this.source = this.destination;
                this.destination = null;
                this.intermediate = null;
                return false;
            }
            return true;
        }

        public void kick() {
            this.age = 0;
            if (this.destination != null) {
                this.source = this.destination;
            }
            this.destination = null;
            this.intermediate = null;
        }

        public void setColors(Color source, Color destination) {
            if (this.age == 0) {
                this.source = destination;
            } else {
                this.source = source;
                this.destination = destination;
            }
        }

        public void setDestination(Color color) {
            if (this.destination == null || !this.destination.equals(color)) {
                if (this.age == 0) {
                    this.destination = color;
                    this.intermediate = null;
                } else if (this.source != null && this.source.equals(color)) {
                    this.intermediate = this.getColor();
                    this.source = this.destination;
                    this.destination = color;
                    this.age = 1;
                } else {
                    this.intermediate = this.getColor();
                    this.source = null;
                    this.destination = color;
                    this.age = 1;
                }
            }
        }
    }
}

