/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import bibliothek.extension.gui.dock.theme.bubble.AbstractBubbleDockTitle;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.FilteredDockActionSource;
import bibliothek.gui.dock.action.MultiDockActionSource;
import bibliothek.gui.dock.action.StationChildrenActionSource;
import bibliothek.gui.dock.event.DockTitleEvent;
import bibliothek.gui.dock.station.flap.button.ButtonContent;
import bibliothek.gui.dock.station.flap.button.ButtonContentFilter;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonContentValue;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.themes.font.TitleFont;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.util.Condition;
import bibliothek.util.Path;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JComponent;

public class BubbleButtonDockTitle
extends AbstractBubbleDockTitle {
    public static final DockTitleFactory FACTORY = new DockTitleFactory(){

        @Override
        public void install(DockTitleRequest request) {
        }

        @Override
        public void uninstall(DockTitleRequest request) {
        }

        @Override
        public void request(DockTitleRequest request) {
            request.answer(new BubbleButtonDockTitle(request.getTarget(), request.getVersion()));
        }
    };
    private final int KNOB_SIZE = 10;
    public static final String ANIMATION_KEY_KNOB_HIGHLIGHT = "knob.highlight";
    public static final String ANIMATION_KEY_KNOB_SHADOW = "knob.shadow";
    private ButtonContentValue behavior;
    private PropertyValue<ButtonContentFilter> connector = new PropertyValue<ButtonContentFilter>(FlapDockStation.BUTTON_CONTENT_FILTER){

        @Override
        protected void valueChanged(ButtonContentFilter oldValue, ButtonContentFilter newValue) {
            if (BubbleButtonDockTitle.this.behavior != null) {
                BubbleButtonDockTitle.this.updateActionSource(true);
            }
        }
    };
    private boolean selected = false;
    private MultiDockActionSource allActionsSource = new MultiDockActionSource(new DockActionSource[0]);
    private boolean showChildren = false;
    private boolean showActions = false;
    private boolean filterActions = false;

    public BubbleButtonDockTitle(Dockable dockable, DockTitleVersion origin) {
        if (origin != null) {
            this.connector.setProperties(origin.getController());
        }
        this.behavior = new ButtonContentValue(new ButtonContent(ButtonContent.TRUE, ButtonContent.TRUE, ButtonContent.IF_DOCKABLE, ButtonContent.IF_STATION, ButtonContent.TRUE, ButtonContent.TRUE)){

            @Override
            protected void propertyChanged() {
                BubbleButtonDockTitle.this.updateContent();
            }
        };
        if (origin != null) {
            this.behavior.setProperties(origin.getController());
        }
        this.init(dockable, origin, false);
        this.allActionsSource.setSeparateSources(true);
        this.behavior.setDockable(dockable);
        this.updateContent();
    }

    protected BubbleButtonDockTitle() {
    }

    @Override
    protected void init(Dockable dockable, DockTitleVersion origin, boolean showMiniButtons) {
        super.init(dockable, origin, showMiniButtons);
        this.initAnimation();
        this.updateAnimation();
        this.updateFonts();
    }

    private void initAnimation() {
        Path path = TitleColor.KIND_FLAP_BUTTON_COLOR;
        this.addColor("title.background.top.active.mouse.flap", path, Color.RED);
        this.addColor("title.background.top.active.flap", path, Color.LIGHT_GRAY);
        this.addColor("title.background.top.inactive.mouse.flap", path, Color.BLUE);
        this.addColor("title.background.top.inactive.flap", path, Color.DARK_GRAY);
        this.addColor("title.background.top.selected.mouse.flap", path, Color.BLUE);
        this.addColor("title.background.top.selected.flap", path, Color.DARK_GRAY);
        this.addColor("title.background.bottom.active.mouse.flap", path, Color.LIGHT_GRAY);
        this.addColor("title.background.bottom.active.flap", path, Color.WHITE);
        this.addColor("title.background.bottom.inactive.mouse.flap", path, Color.DARK_GRAY);
        this.addColor("title.background.bottom.inactive.flap", path, Color.BLACK);
        this.addColor("title.background.bottom.selected.mouse.flap", path, Color.DARK_GRAY);
        this.addColor("title.background.bottom.selected.flap", path, Color.BLACK);
        this.addColor("title.foreground.active.mouse.flap", path, Color.BLACK);
        this.addColor("title.foreground.active.flap", path, Color.BLACK);
        this.addColor("title.foreground.inactive.mouse.flap", path, Color.WHITE);
        this.addColor("title.foreground.inactive.flap", path, Color.WHITE);
        this.addColor("title.foreground.selected.mouse.flap", path, Color.WHITE);
        this.addColor("title.foreground.selected.flap", path, Color.WHITE);
        this.addColor("title.flap.active.knob.highlight", path, Color.WHITE);
        this.addColor("title.flap.active.knob.shadow", path, Color.BLACK);
        this.addColor("title.flap.active.mouse.knob.highlight", path, Color.WHITE);
        this.addColor("title.flap.active.mouse.knob.shadow", path, Color.BLACK);
        this.addColor("title.flap.inactive.knob.highlight", path, Color.WHITE);
        this.addColor("title.flap.inactive.knob.shadow", path, Color.BLACK);
        this.addColor("title.flap.inactive.mouse.knob.highlight", path, Color.WHITE);
        this.addColor("title.flap.inactive.mouse.knob.shadow", path, Color.BLACK);
        this.addColor("title.flap.selected.knob.highlight", path, Color.WHITE);
        this.addColor("title.flap.selected.knob.shadow", path, Color.BLACK);
        this.addColor("title.flap.selected.mouse.knob.highlight", path, Color.WHITE);
        this.addColor("title.flap.selected.mouse.knob.shadow", path, Color.BLACK);
        this.addConditionalFont("title.flap.active", TitleFont.KIND_FLAP_BUTTON_FONT, new Condition(){

            @Override
            public boolean getState() {
                return BubbleButtonDockTitle.this.isActive();
            }
        }, null);
        this.addConditionalFont("title.flap.selected", TitleFont.KIND_FLAP_BUTTON_FONT, new Condition(){

            @Override
            public boolean getState() {
                return BubbleButtonDockTitle.this.isSelected();
            }
        }, null);
        this.addConditionalFont("title.flap.inactive", TitleFont.KIND_FLAP_BUTTON_FONT, new Condition(){

            @Override
            public boolean getState() {
                return !BubbleButtonDockTitle.this.isActive();
            }
        }, null);
    }

    @Override
    public void changed(DockTitleEvent event) {
        this.selected = event.isActive() || event.isPreferred();
        super.setActive(event.isActive());
        this.updateAnimation();
        this.updateFonts();
    }

    @Override
    public void setActive(boolean active) {
        if (active != this.isActive()) {
            super.setActive(active);
            this.selected = active;
            this.updateAnimation();
            this.updateFonts();
        }
    }

    @Override
    protected void updateAnimation() {
        String postfix = "";
        postfix = this.isActive() ? (this.isMouseOver() ? "active.mouse" : "active") : (this.isSelected() ? (this.isMouseOver() ? "selected.mouse" : "selected") : (this.isMouseOver() ? "inactive.mouse" : "inactive"));
        String top = "title.background.top." + postfix + ".flap";
        String bottom = "title.background.bottom." + postfix + ".flap";
        String text = "title.foreground." + postfix + ".flap";
        String knobHighlight = "title.flap." + postfix + ".knob.highlight";
        String knobShadow = "title.flap." + postfix + ".knob.shadow";
        this.updateAnimation("text", text);
        this.updateAnimation("top", top);
        this.updateAnimation("bottom", bottom);
        this.updateAnimation(ANIMATION_KEY_KNOB_HIGHLIGHT, knobHighlight);
        this.updateAnimation(ANIMATION_KEY_KNOB_SHADOW, knobShadow);
    }

    public boolean isSelected() {
        return this.selected;
    }

    private void updateContent() {
        this.updateIcon();
        this.updateText();
        this.updateActionSource(false);
        if (this.behavior.isShowActions() || this.behavior.isShowChildren()) {
            this.setShowMiniButtons(true);
        } else {
            this.setShowMiniButtons(false);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void updateIcon() {
        if (this.behavior.isShowIcon()) {
            super.updateIcon();
        } else {
            this.setIcon(null);
        }
    }

    @Override
    protected void updateText() {
        if (this.behavior.isShowText()) {
            super.updateText();
        } else {
            this.setText("");
        }
    }

    @Override
    protected DockActionSource getActionSourceFor(Dockable dockable) {
        return this.allActionsSource;
    }

    private void updateActionSource(boolean force) {
        boolean showChildren = this.behavior.isShowChildren();
        boolean showActions = this.behavior.isShowActions();
        boolean filterActions = this.behavior.isFilterActions();
        if (force || this.showChildren != showChildren || this.showActions != showActions || this.filterActions != filterActions) {
            this.allActionsSource.removeAll();
            if (showChildren) {
                this.allActionsSource.add(this.getChildrenActionSourceFor(this.getDockable()));
            }
            if (showActions) {
                if (filterActions) {
                    this.allActionsSource.add(this.createFilter(this.getDefaultActionSourceFor(this.getDockable())));
                } else {
                    this.allActionsSource.add(this.getDefaultActionSourceFor(this.getDockable()));
                }
            }
            this.showChildren = showChildren;
            this.showActions = showActions;
        }
    }

    protected DockActionSource createFilter(DockActionSource actions) {
        final ButtonContentFilter connector = this.connector.getValue();
        return new FilteredDockActionSource(actions){

            @Override
            protected boolean include(DockAction action) {
                return connector.isButtonAction(action);
            }
        };
    }

    protected DockActionSource getDefaultActionSourceFor(Dockable dockable) {
        return super.getActionSourceFor(dockable);
    }

    protected DockActionSource getChildrenActionSourceFor(Dockable dockable) {
        return new StationChildrenActionSource(dockable, null);
    }

    @Override
    protected Insets getInnerInsets() {
        Insets base = super.getInnerInsets();
        if (this.behavior.isShowKnob()) {
            base = this.getOrientation().isHorizontal() ? new Insets(base.top, base.left + 10, base.bottom, base.right) : new Insets(base.top + 10, base.left, base.bottom, base.right);
        }
        return base;
    }

    @Override
    protected void paintForeground(Graphics g, JComponent component) {
        super.paintForeground(g, component);
        if (this.behavior.isShowKnob()) {
            Insets insets = this.getInnerInsets();
            if (this.getOrientation().isHorizontal()) {
                int x = insets.left - 10 + 3;
                int y1 = insets.top + 3;
                int y2 = this.getHeight() - insets.bottom - 4;
                g.setColor(this.getColor(ANIMATION_KEY_KNOB_HIGHLIGHT));
                g.drawLine(x, y1 + 1, x, y2 - 1);
                g.drawLine(x + 1, y1, x + 1, y1);
                g.setColor(this.getColor(ANIMATION_KEY_KNOB_SHADOW));
                g.drawLine(x + 1, y2, x + 1, y2);
                g.drawLine(x + 2, y1 + 1, x + 2, y2 - 1);
            } else {
                int y = insets.top - 10 + 3;
                int x1 = insets.left + 3;
                int x2 = this.getWidth() - insets.right - 4;
                g.setColor(this.getColor(ANIMATION_KEY_KNOB_HIGHLIGHT));
                g.drawLine(x1 + 1, y, x2 - 1, y);
                g.drawLine(x1, y + 1, x1, y + 1);
                g.setColor(this.getColor(ANIMATION_KEY_KNOB_SHADOW));
                g.drawLine(x1 + 1, y + 2, x2 - 1, y + 2);
                g.drawLine(x2, y + 1, x2, y + 2);
            }
        }
    }

    @Override
    public Point getPopupLocation(Point click, boolean popupTrigger) {
        if (popupTrigger) {
            return click;
        }
        return null;
    }

    @Override
    public void setOrientation(DockTitle.Orientation orientation) {
        switch (orientation) {
            case NORTH_SIDED: 
            case SOUTH_SIDED: 
            case FREE_HORIZONTAL: {
                orientation = DockTitle.Orientation.FREE_HORIZONTAL;
                break;
            }
            case EAST_SIDED: 
            case WEST_SIDED: 
            case FREE_VERTICAL: {
                orientation = DockTitle.Orientation.FREE_VERTICAL;
            }
        }
        super.setOrientation(orientation);
    }
}

