/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtimepiece.samples;

import java.util.Date;
import net.sourceforge.jtimepiece.JTimepiece;

public class AccessorSample {
    public void run() {
        System.out.println("JTimpiece Accessor Sample");
        System.out.println("-------------------------");
        JTimepiece jTimepiece = new JTimepiece();
        Date date = jTimepiece.createDate(2001, 8, 3, 20, 35, 23, 333);
        String dateString = jTimepiece.convertDateToString(date, "MMMM d, yyyy hh:mm:ss a");
        System.out.println("Date: " + dateString);
        System.out.println("Retrieve information about the date...");
        System.out.println("Year: " + jTimepiece.getYear(date));
        System.out.println("Month: " + jTimepiece.getMonth(date) + " (Months start at zero.)");
        System.out.println("Month Name: " + jTimepiece.getMonthName(date));
        System.out.println("Month Abrv: " + jTimepiece.getMonthAbrv(date));
        System.out.println("Last Day of Month: " + jTimepiece.getDayOfMonth(jTimepiece.getLastDateOfMonth(date)));
        System.out.println("Week of Month: " + jTimepiece.getWeekOfMonth(date));
        System.out.println("Week of Year: " + jTimepiece.getWeekOfYear(date));
        System.out.println("Day of Week: " + jTimepiece.getDayOfWeek(date));
        System.out.println("Day of Month: " + jTimepiece.getDayOfMonth(date));
        System.out.println("Day of Year: " + jTimepiece.getDayOfYear(date));
        System.out.println("Day Name: " + jTimepiece.getDayName(date));
        System.out.println("Day Abrv: " + jTimepiece.getDayAbrv(date));
        System.out.println("Hour: " + jTimepiece.getHour(date));
        System.out.println("Hour of Day: " + jTimepiece.getHourOfDay(date));
        System.out.println("Minute: " + jTimepiece.getMinute(date));
        System.out.println("Second: " + jTimepiece.getSecond(date));
        System.out.println("Millisecond: " + jTimepiece.getMillisecond(date));
        System.out.println("AM?: " + jTimepiece.isAM(date));
        System.out.println("PM?: " + jTimepiece.isPM(date));
        System.out.println("Leap Year?: " + jTimepiece.isLeapYear(date));
        System.out.println("Time Zone Offset: " + jTimepiece.getTimeZoneOffset(date));
        Date currentDate = jTimepiece.getCurrentDate();
        System.out.println("Equal to Current Date?: " + jTimepiece.isEqualTo(date, currentDate));
        System.out.println("Before Current Date?: " + jTimepiece.isBefore(date, currentDate));
        System.out.println("After Current Date?: " + jTimepiece.isAfter(date, currentDate));
    }

    public static void main(String[] args) {
        AccessorSample sample = new AccessorSample();
        sample.run();
    }
}

