/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.rabatnaSkala;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzIdGen;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Rabatnaskala;
import rs.pezar.db.entity.Robnagrupa;
import rs.pezar.sifarnici.gui.PzDialogArtikliExtended;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRobneGrupe;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class Dodavanje
extends PzDialogInsert {
    private static final long serialVersionUID = -3362895422040638148L;
    private PzPanel panel;
    private PzTextField artikalNaziv;
    private PzTextField kupacNaziv;
    private PzTextField rGrupaNaziv;
    private PzTextField rGrupa;
    private PzTextField kupac;
    private PzTextField artikal;
    private PzDoubleField pRabata;
    private PzButton btnOK;
    private JPanel pnlButtons;
    private JLabel jLabel4;
    private JLabel jLabel3;
    private JCheckBox cbZakljucan;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzPanelHeader header;
    private Robnagrupa entRG;
    private Komitent entKom;
    private Artikal entArt;
    private PzFieldIndikator indRGrupa;
    private PzFieldIndikator indPRabata;
    private PzFieldIndikator indKupac;
    private PzFieldIndikator indArtikal;
    private PzTable tabela;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                Dodavanje inst = new Dodavanje(frame);
                inst.setVisible(true);
            }
        });
    }

    public Dodavanje(JFrame frame) {
        super(frame);
    }

    public Dodavanje(PzDialog dialog) {
        super(dialog);
    }

    protected void initGUI() {
        try {
            this.panel = new PzPanel();
            this.panel.setTransferFocusOnEnter(true);
            GridBagLayout panelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panel, "Center");
            this.panel.setPreferredSize(new Dimension(435, 112));
            panelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            panelLayout.rowHeights = new int[]{25, 25, 25, 25, 20};
            panelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            panelLayout.columnWidths = new int[]{127, 53, 38, 22, 94, 18, 141};
            this.panel.setLayout((LayoutManager)panelLayout);
            this.jLabel1 = new JLabel();
            this.panel.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel1.setText("Robna grupa");
            this.jLabel2 = new JLabel();
            this.panel.add((Component)this.jLabel2, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel2.setText("Kupac");
            this.jLabel3 = new JLabel();
            this.panel.add((Component)this.jLabel3, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel3.setText("Artikal");
            this.jLabel4 = new JLabel();
            this.panel.add((Component)this.jLabel4, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel4.setText("% rabata");
            this.rGrupaNaziv = new PzTextField();
            this.panel.add((Component)this.rGrupaNaziv, (Object)new GridBagConstraints(4, 0, 3, 1, 0.0, 0.0, 17, 1, new Insets(0, 3, 1, 0), 0, 0));
            this.rGrupaNaziv.setText("");
            this.rGrupaNaziv.setEditable(false);
            this.rGrupaNaziv.setFocusable(false);
            this.rGrupaNaziv.setSize(40, 24);
            this.rGrupaNaziv.setForeground(new Color(0, 128, 0));
            this.kupacNaziv = new PzTextField();
            this.panel.add((Component)this.kupacNaziv, (Object)new GridBagConstraints(4, 1, 3, 1, 0.0, 0.0, 17, 1, new Insets(1, 3, 1, 0), 0, 0));
            this.kupacNaziv.setText("");
            this.kupacNaziv.setEditable(false);
            this.kupacNaziv.setFocusable(false);
            this.kupacNaziv.setSize(40, 24);
            this.kupacNaziv.setForeground(new Color(0, 128, 0));
            this.artikalNaziv = new PzTextField();
            this.panel.add((Component)this.artikalNaziv, (Object)new GridBagConstraints(4, 2, 3, 1, 0.0, 0.0, 17, 1, new Insets(1, 3, 0, 0), 0, 0));
            this.artikalNaziv.setText("");
            this.artikalNaziv.setFocusable(false);
            this.artikalNaziv.setEditable(false);
            this.artikalNaziv.setSize(40, 24);
            this.artikalNaziv.setForeground(new Color(0, 128, 0));
            this.rGrupa = new PzTextField();
            this.panel.add((Component)this.rGrupa, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.rGrupa.setFont(new Font("Tahoma", 0, 14));
            this.rGrupa.setMaxLength(3);
            this.rGrupa.setSize(80, 24);
            this.rGrupa.setVerifyInput(true);
            this.rGrupa.setFKField(Robnagrupa.class, PzDialogRobneGrupe.class, false, null);
            this.kupac = new PzTextField();
            this.panel.add((Component)this.kupac, (Object)new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.kupac.setFont(new Font("Tahoma", 0, 14));
            this.kupac.setSize(80, 24);
            this.kupac.setFKField(Komitent.class, PzDialogKomintenti.class, false, null);
            this.artikal = new PzTextField();
            this.panel.add((Component)this.artikal, (Object)new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.artikal.setFont(new Font("Tahoma", 0, 14));
            this.artikal.setSize(80, 24);
            this.artikal.setMaxLength(9);
            this.artikal.setFKField(Artikal.class, PzDialogArtikliExtended.class, false, null);
            this.pRabata = new PzDoubleField();
            this.panel.add((Component)this.pRabata, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pRabata.setFont(new Font("Tahoma", 0, 14));
            this.pRabata.setSize(80, 24);
            this.pRabata.setLimit(2, 3);
            this.indRGrupa = new PzFieldIndikator();
            this.panel.add((Component)this.indRGrupa, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indKupac = new PzFieldIndikator();
            this.panel.add((Component)this.indKupac, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indArtikal = new PzFieldIndikator();
            this.panel.add((Component)this.indArtikal, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.cbZakljucan = new JCheckBox("Zaklju\u010dan");
            this.panel.add((Component)this.cbZakljucan, (Object)new GridBagConstraints(1, 4, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.header = new PzPanelHeader();
            this.header.setIcon(this.getHeaderIcon());
            this.header.setTitle(this.getHeaderTitle());
            this.getContentPane().add((Component)this.header, "North");
            this.pnlButtons = new JPanel();
            this.getContentPane().add((Component)this.pnlButtons, "South");
            this.pnlButtons.setPreferredSize(new Dimension(435, 55));
            this.btnOK = new PzButton();
            this.pnlButtons.add((Component)this.btnOK);
            this.btnOK.setText("Potvrdi");
            this.btnOK.setBounds(48, 24, 133, 30);
            this.btnOK.setFont(new Font("Tahoma", 1, 12));
            this.btnOK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/check.png")));
            this.btnOK.setPreferredSize(new Dimension(140, 31));
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.rGrupa.setStateIndikator(this.indRGrupa);
            this.pRabata.setStateIndikator(this.indPRabata);
            this.kupac.setStateIndikator(this.indKupac);
            this.artikal.setStateIndikator(this.indArtikal);
            this.pack();
            this.setSize(633, 286);
            this.setResizable(false);
            this.setRestorable(false);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equalsIgnoreCase("odustajanje")) {
            this.dispose();
        }
        try {
            if (actionCommand.equals("insert") || actionCommand.equals("update")) {
                if (this.entArt == null && this.entKom == null && this.entRG == null) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Morate uneti najmanje jedno polje!");
                    this.rGrupa.requestFocus();
                    return;
                }
                if (this.entArt != null && this.entRG != null) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Ne mo\u017eete istovremeno definisati rabat i za robnu grupu i za artikal!");
                    this.cleanFields();
                    this.rGrupa.requestFocus();
                    return;
                }
                if (actionCommand.equals("insert")) {
                    if (!this.checkRabat()) {
                        this.cleanFields();
                        return;
                    }
                    Rabatnaskala rb = new Rabatnaskala(this.entRG, this.entKom, this.entArt, this.pRabata.getVal().doubleValue());
                    rb.setOznRabatnaSkala(PzIdGen.getNextId((String)"RABATNASKALA_ID", (int)1).getIdVal());
                    rb.setZakljucan(this.cbZakljucan.isSelected());
                    this.tabela.insert((PzEntity)rb, true);
                    this.dispose();
                } else if (actionCommand.equals("update")) {
                    Rabatnaskala rb = (Rabatnaskala)this.tabela.getSelectedEntity();
                    rb.setProcenat(this.pRabata.getVal().doubleValue());
                    rb.setKomitent(this.entKom);
                    rb.setArtikal(this.entArt);
                    rb.setRobnagrupa(this.entRG);
                    rb.setZakljucan(this.cbZakljucan.isSelected());
                    this.tabela.updateSelectedEntity((PzEntity)rb, true);
                    this.dispose();
                }
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    private void cleanFields() {
        this.entArt = null;
        this.entKom = null;
        this.entRG = null;
        this.rGrupa.setText("");
        this.rGrupaNaziv.setText("");
        this.indRGrupa.setState(PzFieldIndikator.STATE_OPTIONAL);
        this.kupac.setVal((Object)"");
        this.kupacNaziv.setVal((Object)"");
        this.indKupac.setState(PzFieldIndikator.STATE_OPTIONAL);
        this.artikal.setVal((Object)"");
        this.artikalNaziv.setVal((Object)"");
        this.indArtikal.setState(PzFieldIndikator.STATE_OPTIONAL);
    }

    private boolean checkRabat() throws Exception {
        List r;
        boolean rez = true;
        if (!this.rGrupa.getVal().equals("") && !this.kupac.getVal().equals("") && (r = PzEntityManager.getList((String)("Select rs From Rabatnaskala rs Where rs.robnagrupa.oznRobGr='" + this.rGrupa.getVal() + "' and rs.komitent.sfrKomitent='" + this.kupac.getVal() + "'"))).size() != 0) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Za odabranu robnu grupu i komitenta ve\u0107 postoji definisana rabatna skala!");
            this.rGrupa.requestFocus();
            rez = false;
        }
        if (!this.artikal.getVal().equals("") && !this.kupac.getVal().equals("") && (r = PzEntityManager.getList((String)("Select rs From Rabatnaskala rs Where rs.artikal.sfrProizvod='" + this.artikal.getVal() + "' and rs.komitent.sfrKomitent='" + this.kupac.getVal() + "'"))).size() != 0) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Za odabrani artikal i komitenta ve\u0107 postoji definisana rabatna skala!");
            this.rGrupa.requestFocus();
            rez = false;
        }
        if (this.artikal.getVal().equals("") && this.kupac.getVal().equals("") && (r = PzEntityManager.getList((String)("Select rs From Rabatnaskala rs Where rs.robnagrupa.oznRobGr='" + this.rGrupa.getVal() + "' and  rs.komitent is null and rs.artikal is null"))).size() != 0) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Za odabranu robnu grupu ve\u0107 postoji definisana rabatna skala!");
            this.rGrupa.requestFocus();
            rez = false;
        }
        if (this.rGrupa.getVal().equals("") && this.kupac.getVal().equals("") && (r = PzEntityManager.getList((String)("Select rs From Rabatnaskala rs Where rs.artikal.sfrProizvod='" + this.artikal.getVal() + "' and rs.robnagrupa is null and rs.komitent is null"))).size() != 0) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Za odabrani artikal ve\u0107 postoji definisana rabatna skala!");
            this.rGrupa.requestFocus();
            rez = false;
        }
        if (this.rGrupa.getVal().equals("") && this.artikal.getVal().equals("") && (r = PzEntityManager.getList((String)("Select rs From Rabatnaskala rs Where rs.komitent.sfrKomitent='" + this.kupac.getVal() + "' and rs.robnagrupa is null and rs.artikal is null"))).size() != 0) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Za odabranog komitenta ve\u0107 postoji definisana rabatna skala!");
            this.rGrupa.requestFocus();
            rez = false;
        }
        return rez;
    }

    protected void onInsert() {
        this.btnOK.setActionCommand("insert");
        this.tabela = (PzTable)this.getSession().getParameter("tabela");
    }

    protected void onUpdate() {
        this.btnOK.setActionCommand("update");
        this.tabela = (PzTable)this.getSession().getParameter("tabela");
        Rabatnaskala rb = (Rabatnaskala)this.tabela.getSelectedEntity();
        this.rGrupa.setVal((Object)(rb.getRobnagrupa() == null ? "" : rb.getRobnagrupa().getOznRobGr()));
        this.rGrupaNaziv.setVal((Object)(rb.getRobnagrupa() == null ? "" : rb.getRobnagrupa().getNaziv()));
        this.kupac.setVal((Object)(rb.getKomitent() == null ? "  " : rb.getKomitent().getSfrKomitent()));
        this.kupacNaziv.setVal((Object)(rb.getKomitent() == null ? "  " : rb.getKomitent().getNaziv()));
        this.artikal.setVal((Object)(rb.getArtikal() == null ? "" : rb.getArtikal().getSfrProizvod()));
        this.artikalNaziv.setVal((Object)(rb.getArtikal() == null ? "" : rb.getArtikal().getNaziv()));
        this.pRabata.setVal((Object)rb.getProcenat());
        this.cbZakljucan.setSelected(rb.isZakljucan());
        this.panel.updateAllFieldsState();
        this.entRG = rb.getRobnagrupa();
        this.entKom = rb.getKomitent();
        this.entArt = rb.getArtikal();
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity == null) {
            return;
        }
        if (component == this.rGrupa) {
            this.rGrupa.setVal((Object)((Robnagrupa)entity).getOznRobGr());
            this.entRG = (Robnagrupa)entity;
            this.rGrupaNaziv.setText(this.entRG.getNaziv());
        } else if (component == this.kupac) {
            this.kupac.setVal((Object)((Komitent)entity).getSfrKomitent());
            this.entKom = (Komitent)entity;
            this.kupacNaziv.setText(this.entKom.getNaziv());
        } else if (component == this.artikal) {
            this.artikal.setVal((Object)((Artikal)entity).getSfrProizvod());
            this.entArt = (Artikal)entity;
            this.artikalNaziv.setText(this.entArt.getNaziv());
        }
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Dodavanje rabatne skale");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/column_chart_new.png")));
    }

    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Izmena rabatne skale");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/column_chart_edit.png")));
    }
}

