/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.artikli.browser.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserComponent;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserTablePanel;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.renderers.StanjeRenderer;

public class BrowserZamenePanel
extends BrowserComponent {
    private static final long serialVersionUID = 6005674853559487678L;
    public static final String ID = "PANEL_ZAMENE";
    private JScrollPane scp;
    private PzTable table;
    private JXLayer<JScrollPane> layer;
    private PzBusyPainterUI layerUi;

    public BrowserZamenePanel() {
        this.initGUI();
        this.setComponentLocation(new BrowserComponent.Location(0, 2, 1, 1));
    }

    private void initGUI() {
        this.setLayout(new BorderLayout(0, 0));
        this.scp = new JScrollPane();
        this.layerUi = new PzBusyPainterUI();
        this.layer = new JXLayer((Component)this.scp, (LayerUI)this.layerUi);
        this.add((Component)this.layer);
        this.table = new PzTable();
        this.table.setId("TABLE_ZAMENE");
        this.scp.setViewportView((Component)this.table);
    }

    @Override
    public void updateData(Artikal a, Object parentComponent) {
        if (a == null) {
            return;
        }
        this.table.setData(a.getZamenas(), Artikal.class);
    }

    @Override
    public void updateData(final Stanjeartikal a, Object parentComponent) {
        if (a == null) {
            return;
        }
        this.layerUi.setLocked(true);
        final BrowserTablePanel tblPanel = (BrowserTablePanel)((Object)parentComponent);
        SwingWorker<List<Stanjeartikal>, Object> worker = new SwingWorker<List<Stanjeartikal>, Object>(){

            @Override
            protected List<Stanjeartikal> doInBackground() throws Exception {
                String query = "SELECT s FROM Stanjeartikal s WHERE s.id.oznRj=:oznRj AND s.id.oznOgranak=:oznOgranak AND (s.id.sfrProizvod IN (SELECT z1.id.zamena FROM Zamena z1 WHERE z1.id.artikal=:sifra) OR s.id.sfrProizvod IN (SELECT z2.id.artikal FROM Zamena z2 WHERE z2.id.zamena=:sifra))";
                EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                Query q = em.createQuery(query);
                q.setParameter("sifra", (Object)a.getId().getSfrProizvod());
                q.setParameter("oznRj", (Object)a.getId().getOznRj());
                q.setParameter("oznOgranak", (Object)a.getId().getOznOgranak());
                List res = q.getResultList();
                em.close();
                return res;
            }

            @Override
            protected void done() {
                try {
                    try {
                        BrowserZamenePanel.this.table.setData((List)this.get(), Stanjeartikal.class);
                        BrowserZamenePanel.this.table.getColumn(0).setMinWidth(20);
                        BrowserZamenePanel.this.table.getColumn(0).setMaxWidth(20);
                        BrowserZamenePanel.this.table.getColumn(0).setPreferredWidth(20);
                        BrowserZamenePanel.this.table.getColumn(0).setCellRenderer((TableCellRenderer)new StanjeRenderer());
                        BrowserZamenePanel.this.table.setVisibleColumns(tblPanel.getTable().getVisibleColumns());
                        BrowserZamenePanel.this.table.setColumnWidths(tblPanel.getTable().getColumnWidths());
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)BrowserZamenePanel.this), (Throwable)e);
                        BrowserZamenePanel.this.layerUi.setLocked(false);
                    }
                }
                finally {
                    BrowserZamenePanel.this.layerUi.setLocked(false);
                }
            }
        };
        worker.execute();
    }

    @Override
    public void focusGained() {
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getTitle() {
        return "Zamene";
    }

    @Override
    public boolean isCloseable() {
        return true;
    }

    @Override
    public PzToolBarIcon getSwitchIcon() {
        PzToolBarIcon icnZamena = new PzToolBarIcon();
        icnZamena.setText("Zamene|za artikle|(ALT+F5)");
        icnZamena.addActionListener(this.createSwitchActionListener());
        icnZamena.setActionCommand("zamena");
        icnZamena.setShortcut("alt+f5");
        icnZamena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_replace.png")));
        return icnZamena;
    }
}

