/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;
import rs.pezar.core.PzApplication;
import rs.pezar.sifarnici.gui.robneGrupe.Dodavanje;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.custom.PzTreeRobneGrupe;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.renderers.PzTreeCellRendererRG;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogRobneGrupe
extends PzDialog {
    private static final long serialVersionUID = -7745443644331406254L;
    private PzToolBarIcon icnDodavanje;
    private PzToolBarIcon icnBrisanje;
    private PzToolBarIcon icnIzmena;
    private JPanel jPanel1;
    private JScrollPane scpRgr;
    private JToolBar toolbar;
    private PzTreeRobneGrupe tree;
    private PzToolBarIcon icnRazvijStablo;
    private PzToolBarIcon icnSkupiStablo;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogRobneGrupe inst = new PzDialogRobneGrupe(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogRobneGrupe(JFrame frame) {
        super(frame);
        this.initGUI();
        try {
            this.tree.loadDataFromDB();
            this.tree.setCellRenderer((TreeCellRenderer)new PzTreeCellRendererRG());
            this.postInit();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public PzDialogRobneGrupe(PzDialog frame) {
        super(frame);
        this.initGUI();
        try {
            this.tree.loadDataFromDB();
            this.tree.setCellRenderer((TreeCellRenderer)new PzTreeCellRendererRG());
            this.postInit();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void postInit() {
        try {
            List stateTree = (List)PzApplication.getApplication().getPropManager().loadBufferedObject("stateTreeRg.sav");
            int i = 0;
            while (i < stateTree.size()) {
                this.tree.expandRow(((Integer)stateTree.get(i)).intValue());
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void initGUI() {
        try {
            this.setTitle("\u0160ifarnik robnih grupa");
            this.jPanel1 = new JPanel();
            GridBagLayout jPanel1Layout = new GridBagLayout();
            this.getContentPane().add((Component)this.jPanel1, "Center");
            this.jPanel1.setPreferredSize(new Dimension(592, 272));
            jPanel1Layout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            jPanel1Layout.rowHeights = new int[]{7, 7, 7, 7};
            jPanel1Layout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            jPanel1Layout.columnWidths = new int[]{7, 7, 7, 7};
            this.jPanel1.setLayout(jPanel1Layout);
            this.scpRgr = new JScrollPane();
            this.jPanel1.add((Component)this.scpRgr, new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.scpRgr.setBackground(new Color(211, 242, 210));
            this.tree = new PzTreeRobneGrupe();
            this.tree.setRootVisible(false);
            this.scpRgr.setViewportView((Component)this.tree);
            this.tree.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    PzDialogRobneGrupe.this.treeKeyReleased(evt);
                }
            });
            this.setSize(933, 603);
            this.toolbar = new JToolBar();
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.getContentPane().add((Component)this.toolbar, "North");
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/cubes_add.png")));
            this.icnDodavanje.setText("Dodavanje|(INS)");
            this.icnDodavanje.setActionCommand("Dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("INSERT");
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/cubes_edit.png")));
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setActionCommand("Izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("F3");
            this.icnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/cubes_delete.png")));
            this.icnBrisanje.setText("Brisanje| (DEL)");
            this.icnBrisanje.setActionCommand("brisanje");
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setShortcut("delete");
            this.icnRazvijStablo = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnRazvijStablo);
            this.icnRazvijStablo.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/branch_expand.png")));
            this.icnRazvijStablo.setText("Razvij stablo|(SHIFT+R)");
            this.icnRazvijStablo.setActionCommand("razvij");
            this.icnRazvijStablo.addActionListener((ActionListener)((Object)this));
            this.icnRazvijStablo.setShortcut("SHIFT+R");
            this.icnSkupiStablo = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSkupiStablo);
            this.icnSkupiStablo.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/branch_collapse.png")));
            this.icnSkupiStablo.setText("Skupi stablo|(SHIFT+S)");
            this.icnSkupiStablo.setActionCommand("skupi");
            this.icnSkupiStablo.addActionListener((ActionListener)((Object)this));
            this.icnSkupiStablo.setShortcut("SHIFT+S");
            this.setSize(500, 600);
            this.setLocationRelativeTo(null);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        try {
            String actionCommand = ((PzToolBarIcon)arg0.getSource()).getActionCommand();
            if (actionCommand.equals("Dodavanje")) {
                this.getSession().putParameter("tree", (Object)this.tree);
                this.getSession().putParameter("update", (Object)false);
                this.showDialog(Dodavanje.class);
            } else if (actionCommand.equals("brisanje")) {
                if (PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Da li ste sigurni?", (String)"Brisanje", null, (boolean)true) != 0) {
                    return;
                }
                this.tree.removeSelectedNode();
                PzApplication.getApplication().getPropManager().saveObject(null, "stateTreeRg.sav");
            } else if (actionCommand.equals("Izmena")) {
                if (this.tree.getSelectionCount() == 0) {
                    return;
                }
                this.getSession().putParameter("tree", (Object)this.tree);
                this.getSession().putParameter("update", (Object)true);
                this.showDialog(Dodavanje.class);
            } else if (actionCommand.equals("razvij")) {
                this.tree.expandAll();
            } else if (actionCommand.equals("skupi")) {
                this.tree.collapseAll();
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private List<Integer> getStateTree() {
        ArrayList<Integer> stablo = new ArrayList<Integer>();
        int i = 0;
        while (i < this.tree.getRowCount()) {
            if (this.tree.isExpanded(i)) {
                stablo.add(i);
            }
            ++i;
        }
        return stablo;
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
        try {
            PzApplication.getApplication().getPropManager().saveObject(this.getStateTree(), "stateTreeRg.sav");
        }
        catch (IOException e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void treeKeyReleased(KeyEvent evt) {
    }
}

