/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui.neocarinjenaRoba;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jdesktop.application.Application;
import rs.pezar.core.format.BDConverter;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalcarinadokument;
import rs.pezar.db.entity.CarinaDokument;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.sifarnici.gui.PzArtikliBrowser;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.event.PzEntityChecker;
import rs.pezar.swing.event.PzStanjeartikalChecker;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class Dodavanje
extends PzDialogInsert {
    private PzPanel mainPanel;
    private PzPanelHeader header;
    private PzPanel pnlFields;
    private PzDoubleField dfCenaUValuti;
    private JLabel lblCenaUDin;
    private JLabel lblCenaUValuti;
    private JLabel lblKolicina;
    private PzDoubleField dfCenaUDin;
    private PzDoubleField dfKolicina;
    private PzTextField tfNaziv;
    private PzFieldIndikator indSifra;
    private JLabel lblSifra;
    private PzTextField tfSifra;
    private PzButton btnPotvrdi;
    private Stanjeartikal stanjeArt;
    private PzFieldIndikator indCena;
    private PzFieldIndikator indKolicina;
    private PzTable tabela;
    private CarinaDokument prijemnica;
    private Artikalcarinadokument art;

    public Dodavanje(PzDialog dialog) {
        super(dialog);
        this.tfSifra.setParamToPass((Object)this.prijemnica.getRadnajedinica());
        this.tfSifra.setEntityChecker((PzEntityChecker)new PzStanjeartikalChecker((PzField)this.tfSifra, this.prijemnica.getRadnajedinica()));
        this.paintPanel();
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    protected void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.mainPanel = new PzPanel();
            BorderLayout mainPanelLayout = new BorderLayout();
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.header = new PzPanelHeader();
            this.header.setIcon(this.getHeaderIcon());
            this.header.setTitle(this.getHeaderTitle());
            this.mainPanel.add((Component)this.header, (Object)"North");
            this.header.setOpaque(false);
            this.header.setPreferredSize(new Dimension(436, 66));
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlFields, (Object)"Center");
            pnlFieldsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.rowHeights = new int[]{15, 25, 25, 24, 25, 26, 30, 7};
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.columnWidths = new int[]{30, 112, 120, 25, 284, 7};
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.pnlFields.setOpaque(false);
            this.lblSifra = new JLabel();
            this.pnlFields.add((Component)this.lblSifra, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblSifra.setText("Sifra artikla");
            this.tfSifra = new PzTextField();
            this.pnlFields.add((Component)this.tfSifra, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfSifra.setFKField(Stanjeartikal.class, PzArtikliBrowser.class, true, null);
            this.indSifra = new PzFieldIndikator();
            this.pnlFields.add((Component)this.indSifra, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.tfNaziv = new PzTextField();
            this.pnlFields.add((Component)this.tfNaziv, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfNaziv.setFocusable(false);
            this.tfNaziv.setEditable(false);
            this.dfKolicina = new PzDoubleField();
            this.pnlFields.add((Component)this.dfKolicina, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfKolicina.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    PzField field = (PzField)arg0;
                    if (Dodavanje.this.dfKolicina.getVal() == 0.0) {
                        field.setState(PzFieldIndikator.STATE_INVALID);
                        return false;
                    }
                    field.setState(PzFieldIndikator.STATE_VALID);
                    return true;
                }
            });
            this.lblKolicina = new JLabel();
            this.pnlFields.add((Component)this.lblKolicina, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblKolicina.setText("Koli\u010dina");
            this.lblCenaUValuti = new JLabel();
            this.pnlFields.add((Component)this.lblCenaUValuti, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblCenaUValuti.setText("Cena u stranoj valuti");
            this.lblCenaUDin = new JLabel();
            this.pnlFields.add((Component)this.lblCenaUDin, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblCenaUDin.setText("Cena u dinarima");
            this.dfCenaUValuti = new PzDoubleField();
            this.pnlFields.add((Component)this.dfCenaUValuti, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfCenaUValuti.setDecimalFormat(PzFormatFactory.getNabCenaFormat());
            this.dfCenaUValuti.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    PzField field = (PzField)arg0;
                    if (Dodavanje.this.dfCenaUValuti.getVal() <= 0.0) {
                        PzSwingUtility.showInformationMessage((Component)((Object)Dodavanje.this), (String)"Cena mora biti ve\u0107a od 0 !");
                        field.setState(PzFieldIndikator.STATE_INVALID);
                        return false;
                    }
                    Dodavanje.this.dfCenaUDin.setVal((Object)(Dodavanje.this.dfCenaUValuti.getVal() * Dodavanje.this.prijemnica.getKurs()));
                    field.setState(PzFieldIndikator.STATE_VALID);
                    return true;
                }
            });
            this.dfCenaUDin = new PzDoubleField();
            this.pnlFields.add((Component)this.dfCenaUDin, (Object)new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfCenaUDin.setDecimalFormat(PzFormatFactory.getNabCenaFormat());
            this.dfCenaUDin.setFocusable(false);
            this.dfCenaUDin.setEditable(false);
            this.btnPotvrdi = new PzButton();
            this.pnlFields.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 80, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(100, 33));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.indKolicina = new PzFieldIndikator();
            this.pnlFields.add((Component)this.indKolicina, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.indCena = new PzFieldIndikator();
            this.pnlFields.add((Component)this.indCena, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.tfSifra.setStateIndikator(this.indSifra);
            this.dfKolicina.setStateIndikator(this.indKolicina);
            this.dfCenaUValuti.setStateIndikator(this.indCena);
            this.pack();
            this.setSize(596, 293);
            this.setPreferredSize(new Dimension(596, 293));
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Stanjeartikal) {
            this.stanjeArt = (Stanjeartikal)entity;
            this.tfSifra.setVal((Object)this.stanjeArt.getId().getSfrProizvod());
            this.tfNaziv.setVal((Object)this.stanjeArt.getNaziv());
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.pnlFields.validateForm(true)) {
            return;
        }
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                if (actionCommand.equals("insert")) {
                    em.getTransaction().begin();
                    Artikal a = (Artikal)em.find(Artikal.class, (Object)this.stanjeArt.getId().getSfrProizvod());
                    Artikalcarinadokument art = new Artikalcarinadokument();
                    art.init(a, (PzDokument)this.prijemnica);
                    art.setNaziv(a.getNaziv());
                    art.setKolicina(BDConverter.getKolicina((double)this.dfKolicina.getVal()).doubleValue());
                    art.setCenaV(BDConverter.getFakturnaCena((double)this.dfCenaUValuti.getVal()).doubleValue());
                    art.setCenaD(BDConverter.getFakturnaCena((double)this.dfCenaUDin.getVal()).doubleValue());
                    this.tabela.insert((PzEntity)art, true);
                    em.getTransaction().commit();
                    this.tabela.commitInsert();
                } else if (actionCommand.equals("update")) {
                    em.getTransaction().begin();
                    this.art.setKolicina(BDConverter.getKolicina((double)this.dfKolicina.getVal()).doubleValue());
                    this.art.setCenaV(BDConverter.getFakturnaCena((double)this.dfCenaUValuti.getVal()).doubleValue());
                    this.art.setCenaD(BDConverter.getFakturnaCena((double)this.dfCenaUDin.getVal()).doubleValue());
                    this.tabela.updateSelectedEntity((PzEntity)this.art, em);
                    em.getTransaction().commit();
                    this.tabela.commitUpdate();
                }
                this.dispose();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Ispravka podataka");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/product_edit.png")));
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Unos podataka");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/product_add.png")));
    }

    protected void onUpdate() {
        this.tabela = (PzTable)this.getSession().getParameter("tabela");
        this.prijemnica = (CarinaDokument)this.getSession().getParameter("prijemnica");
        this.art = (Artikalcarinadokument)this.tabela.getSelectedEntity();
        this.tfSifra.setVal((Object)this.art.getId().getSfrProizvod());
        this.tfNaziv.setVal((Object)this.art.getNaziv());
        this.dfKolicina.setVal((Object)this.art.getKolicina());
        this.dfCenaUValuti.setVal((Object)this.art.getCenaV());
        this.dfCenaUDin.setVal((Object)this.art.getCenaD());
        this.tfSifra.setEditable(false);
        this.tfSifra.setFocusable(false);
        this.btnPotvrdi.setActionCommand("update");
        this.pnlFields.updateAllFieldsState();
    }

    protected void onInsert() {
        this.tabela = (PzTable)this.getSession().getParameter("tabela");
        this.prijemnica = (CarinaDokument)this.getSession().getParameter("prijemnica");
        this.btnPotvrdi.setActionCommand("insert");
    }
}

