/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Taksakalkulacija;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.nabavka.gui.unosNaknadneFakture.PzDialogUzmiDokument;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;

public class PzDialogKojeOtpremniceNaNaknadnoj
extends PzDialog {
    private static final long serialVersionUID = -7745443644331406254L;
    private PzTable table;
    private PzFieldIndikator indOznakaDokumenta;
    private PzPanel pnlButton;
    private PzButton btnTrazi;
    private PzTextField txtNZK;
    private PzDoubleField txtDug;
    private PzDoubleField txtStornoIznos;
    private JLabel jLabel5;
    private PzDateField txtDatum;
    private PzDoubleField txtUplate;
    private PzDoubleField txtIznosZapisnika;
    private PzFieldIndikator indDobavljac;
    private PzTextField txtNazivDobavljaca;
    private PzTextField txtSfrDobavljaca;
    private JLabel jLabel8;
    private JLabel jLabel7;
    private JLabel jLabel6;
    private JLabel jLabel4;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private PzPanel pnlPretraga;
    private PzPanelHeader header;
    private PzPanel mainPanel;
    private Radnajedinica rj;
    private PzDoubleField txtPdv;
    private JLabel jLabel9;
    private PzTextField txtDokument;
    private Kalkulacija kalkulacija;
    private Komitent komitent;
    private EntityManager em;
    private Kalkulacija zapisnik;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogKojeOtpremniceNaNaknadnoj inst = new PzDialogKojeOtpremniceNaNaknadnoj(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogKojeOtpremniceNaNaknadnoj(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogKojeOtpremniceNaNaknadnoj(PzDialog dialog) {
        super(dialog);
    }

    private void initGUI() {
        try {
            this.setTitle("Koje su otpremnice na zapisniku?");
            AnchorLayout ancLy = new AnchorLayout();
            this.getContentPane().setLayout(ancLy);
            this.jScrollPane1 = new JScrollPane();
            this.getContentPane().add((Component)this.jScrollPane1, new AnchorConstraint(247, 994, 6, 6, 2, 1, 2, 2));
            this.jScrollPane1.setPreferredSize(new Dimension(873, 309));
            this.jScrollPane1.setBorder(BorderFactory.createEtchedBorder(1));
            this.table = new PzTable();
            this.jScrollPane1.setViewportView((Component)this.table);
            this.header = new PzPanelHeader();
            this.getContentPane().add((Component)this.header, new AnchorConstraint(0, 1000, 123, 0, 2, 1, 0, 2));
            this.header.setPreferredSize(new Dimension(884, 69));
            this.header.setTitle("Pregled otpremnica za zapisnik");
            this.setSize(900, 600);
            this.mainPanel = new PzPanel();
            AnchorLayout mainPanelLayout = new AnchorLayout();
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.getContentPane().add((Component)this.mainPanel, new AnchorConstraint(74, 1000, 370, 0, 2, 1, 0, 2));
            this.mainPanel.setPreferredSize(new Dimension(884, 173));
            this.mainPanel.setBorder((Border)BorderFactory.createTitledBorder("Pretraga"));
            this.pnlPretraga = new PzPanel();
            GridBagLayout pnlPretragaLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlPretraga, (Object)new AnchorConstraint(21, 991, 971, 4, 2, 1, 0, 2));
            this.pnlPretraga.setPreferredSize(new Dimension(872, 149));
            pnlPretragaLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1};
            pnlPretragaLayout.rowHeights = new int[]{7, 7, 7, 7, 7, 7};
            pnlPretragaLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlPretragaLayout.columnWidths = new int[]{141, 153, 29, 191, 139, 190, 7};
            this.pnlPretraga.setLayout((LayoutManager)pnlPretragaLayout);
            this.jLabel1 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel1.setText("\u0160ifra dobavlja\u010da:");
            this.jLabel2 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel2, (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel2.setText("Oznaka dokumenta:");
            this.jLabel3 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel3, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel3.setText("Iznos zapisnika:");
            this.jLabel4 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel4, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel4.setText("Uplate:");
            this.jLabel5 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel5, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel5.setText("Datum:");
            this.jLabel6 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel6, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel6.setText("Stornirano:");
            this.jLabel7 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel7, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel7.setText("DUG:");
            this.jLabel8 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel8, (Object)new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel8.setText("NZK:");
            this.txtSfrDobavljaca = new PzTextField();
            this.pnlPretraga.add((Component)this.txtSfrDobavljaca, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.txtSfrDobavljaca.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.txtNazivDobavljaca = new PzTextField();
            this.pnlPretraga.add((Component)this.txtNazivDobavljaca, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.txtNazivDobavljaca.setEditable(false);
            this.txtNazivDobavljaca.setFocusable(false);
            this.indDobavljac = new PzFieldIndikator();
            this.pnlPretraga.add((Component)this.indDobavljac, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.txtIznosZapisnika = new PzDoubleField();
            this.pnlPretraga.add((Component)this.txtIznosZapisnika, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtIznosZapisnika.setEditable(false);
            this.txtIznosZapisnika.setFocusable(false);
            this.txtUplate = new PzDoubleField();
            this.pnlPretraga.add((Component)this.txtUplate, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtUplate.setEditable(false);
            this.txtUplate.setFocusable(false);
            this.txtDatum = new PzDateField();
            this.pnlPretraga.add((Component)this.txtDatum, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtDatum.setEditable(false);
            this.txtDatum.setFocusable(false);
            this.txtStornoIznos = new PzDoubleField();
            this.pnlPretraga.add((Component)this.txtStornoIznos, (Object)new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtStornoIznos.setEditable(false);
            this.txtStornoIznos.setFocusable(false);
            this.txtDug = new PzDoubleField();
            this.pnlPretraga.add((Component)this.txtDug, (Object)new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtDug.setEditable(false);
            this.txtDug.setFocusable(false);
            this.txtNZK = new PzTextField();
            this.pnlPretraga.add((Component)this.txtNZK, (Object)new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtNZK.setEditable(false);
            this.txtNZK.setFocusable(false);
            this.pnlButton = new PzPanel();
            this.pnlPretraga.add((Component)this.pnlButton, (Object)new GridBagConstraints(5, 2, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnTrazi = new PzButton();
            this.pnlButton.add((Component)this.btnTrazi);
            this.btnTrazi.setText("Tra\u017ei");
            this.btnTrazi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/find.png")));
            this.btnTrazi.setPreferredSize(new Dimension(137, 31));
            this.btnTrazi.setActionCommand("trazi");
            this.btnTrazi.addActionListener((ActionListener)((Object)this));
            this.indOznakaDokumenta = new PzFieldIndikator();
            this.pnlPretraga.add((Component)this.indOznakaDokumenta, (Object)new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.txtDokument = new PzTextField(){

                public boolean entityExists() {
                    String q = "SELECT z FROM Kalkulacija z WHERE z.arhiviran = 1 AND z.storno=0 AND z.komitent.sfrKomitent=:sfrKomit AND z.oznDokumenta=:brdok AND z.tip=:tipDok";
                    EntityManager em = PzEntityManager.getEm();
                    Query query = em.createQuery(q).setParameter("brdok", (Object)PzDialogKojeOtpremniceNaNaknadnoj.this.txtDokument.getVal()).setParameter("tipDok", (Object)TipDokumentConfig.get().ZAPISNIK_OTPREMNICE).setParameter("sfrKomit", (Object)PzDialogKojeOtpremniceNaNaknadnoj.this.txtSfrDobavljaca.getVal());
                    return query.getResultList().size() > 0;
                }
            };
            this.pnlPretraga.add((Component)this.txtDokument, (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtDokument.setFKField(Kalkulacija.class, PzDialogUzmiDokument.class, true, null);
            this.jLabel9 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel9, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel9.setText("PDV:");
            this.txtPdv = new PzDoubleField();
            this.pnlPretraga.add((Component)this.txtPdv, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtPdv.setEditable(false);
            this.txtPdv.setFocusable(false);
            this.txtDokument.setStateIndikator(this.indOznakaDokumenta);
            this.txtDokument.setSize(174, 27);
            this.txtSfrDobavljaca.setStateIndikator(this.indDobavljac);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        EntityManager em = PzEntityManager.getEm();
        String query = "SELECT k FROM Kalkulacija k JOIN k.kalkulacijazapisniks1 kz JOIN kz.zapisnik z WHERE k.arhiviran=1 AND k.storno=0 AND z.oznDokumenta = :zap AND z.storno=0 AND z.tip=:ktip AND k.komitent=:komitent";
        Query q = em.createQuery(query).setParameter("zap", (Object)this.txtDokument.getVal()).setParameter("ktip", (Object)TipDokumentConfig.get().ZAPISNIK_OTPREMNICE).setParameter("komitent", (Object)this.komitent);
        Vector kalkulacija = (Vector)q.getResultList();
        this.table.setData((List)kalkulacija, Kalkulacija.class);
        this.table.getTableHeader().setFocusable(false);
        this.table.requestFocusInWindow();
        if (this.table.getDataSize() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.komitent = (Komitent)entity;
            this.txtSfrDobavljaca.setVal((Object)this.komitent.getSfrKomitent());
            ((PzTextField)component).setVal((Object)((Komitent)entity).getSfrKomitent());
            this.txtNazivDobavljaca.setVal((Object)((Komitent)entity).getNaziv());
            this.getSession().putParameter("sfrKomitent", (Object)this.komitent.getSfrKomitent());
        } else if (entity instanceof Kalkulacija) {
            this.zapisnik = (Kalkulacija)entity;
            ((PzTextField)component).setVal((Object)((Kalkulacija)entity).getOznDokumenta());
            this.txtDokument.setVal((Object)this.zapisnik.getOznDokumenta());
            this.txtIznosZapisnika.setVal((Object)this.zapisnik.getIznos());
            this.txtStornoIznos.setVal((Object)this.zapisnik.getStornoIznos());
            this.txtDatum.setVal((Object)this.zapisnik.getDatum());
            this.txtDug.setVal((Object)this.zapisnik.getIznos().subtract(this.zapisnik.getStornoIznos()).subtract(this.zapisnik.getUplata()));
            this.txtPdv.setVal((Object)this.getPdvIznos(this.zapisnik));
            this.txtNZK.setVal(this.getNZK(this.zapisnik) == null ? "0" : this.getNZK(this.zapisnik));
        } else {
            String q = "SELECT z FROM Kalkulacija z WHERE z.arhiviran = 1 AND z.storno=0 AND z.komitent.sfrKomitent=:sfrKomit AND z.oznDokumenta=:brdok AND z.tip=:tipDok";
            EntityManager em = PzEntityManager.getEm();
            Query query = em.createQuery(q).setParameter("sfrKomit", (Object)this.txtSfrDobavljaca.getVal()).setParameter("brdok", (Object)this.txtDokument.getVal()).setParameter("tipDok", (Object)TipDokumentConfig.get().ZAPISNIK_OTPREMNICE);
            if (query.getResultList().size() == 0) {
                return;
            }
            this.zapisnik = (Kalkulacija)query.getSingleResult();
            this.txtDokument.setVal((Object)this.zapisnik.getOznDokumenta());
            this.txtIznosZapisnika.setVal((Object)this.zapisnik.getIznos());
            this.txtStornoIznos.setVal((Object)this.zapisnik.getStornoIznos());
            this.txtDatum.setVal((Object)this.zapisnik.getDatum());
            this.txtDug.setVal((Object)this.zapisnik.getIznos().subtract(this.zapisnik.getStornoIznos()).subtract(this.zapisnik.getUplata()));
            this.txtPdv.setVal((Object)this.getPdvIznos(this.zapisnik));
            this.txtNZK.setVal(this.getNZK(this.zapisnik) == null ? "0" : this.getNZK(this.zapisnik));
        }
    }

    private BigDecimal getPdvIznos(Kalkulacija k) {
        BigDecimal pdv = new BigDecimal(0);
        int i = 0;
        while (i < k.getTaksakalkulacijas().size()) {
            pdv = pdv.add(((Taksakalkulacija)k.getTaksakalkulacijas().get(i)).getIznos());
            ++i;
        }
        return pdv;
    }

    private Integer getNZK(Kalkulacija k) {
        EntityManager emNZK = PzEntityManager.getEm();
        String query = "SELECT nzk.idNalog FROM Nzk AS nzk, IN(nzk.stavkanzks) stavka WHERE stavka.dokument.idDok=:brDok";
        try {
            Query q = emNZK.createQuery(query).setParameter("brDok", (Object)k.getIdDok());
            return (Integer)q.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogKojeOtpremniceNaNaknadnoj(Boolean.FALSE);
    }

    public PzDialogKojeOtpremniceNaNaknadnoj(Boolean initGUI) {
    }
}

