/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.dataimport.importers;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import jxl.Cell;
import jxl.CellType;
import jxl.Sheet;
import jxl.Workbook;
import org.apache.commons.beanutils.BeanUtils;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikalkalkulacija;
import rs.pezar.db.entity.ArtikalkalkulacijaPK;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.nabavka.dataimport.DataImporter;
import rs.pezar.nabavka.dataimport.DataImporterOptionsPanel;
import rs.pezar.nabavka.dataimport.importers.panels.XlsPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class XlsDataImporter
extends DataImporter {
    private Map<Object, Object> hm;
    private XlsPanel panel;
    private Object[][] niz;

    @Override
    public DataImporterOptionsPanel getOptionsPanel() {
        this.panel = new XlsPanel();
        return this.panel;
    }

    @Override
    public String getFileExtension() {
        return "xls";
    }

    @Override
    public String getImporterName() {
        return "Microsoft Office Excel [97-2003]";
    }

    @Override
    public boolean isValidFileFormat(File f, Map<Object, Object> userOptions) {
        return true;
    }

    @Override
    public Kalkulacija getKalkulacija(File f, Map<Object, Object> userOptions) {
        return null;
    }

    @Override
    public List<Artikalkalkulacija> getArtikalKalkulacijas(File f, Map<Object, Object> userOptions) {
        this.hm = this.panel.getOptions();
        this.niz = (Object[][])this.hm.get("niz");
        int redOd = (Integer)this.hm.get("red_od");
        int redDo = (Integer)this.hm.get("red_do");
        int str = (Integer)this.hm.get("stranica");
        Workbook workBook = (Workbook)this.hm.get("workbook");
        ArrayList<Artikalkalkulacija> lista = new ArrayList<Artikalkalkulacija>();
        EntityManager em = PzEntityManager.getEm();
        try {
            em.getTransaction().begin();
            Sheet sheet = workBook.getSheet(str);
            if (sheet.getRows() != 0) {
                if (redDo == -1) {
                    redDo = sheet.getRows();
                }
                System.out.println("Parametar do je:" + redDo);
                int j = redOd;
                while (j <= redDo) {
                    if (j != sheet.getRows()) {
                        Artikalkalkulacija al;
                        Cell[] row = sheet.getRow(j);
                        if (row.length != 0) {
                            al = new Artikalkalkulacija();
                            al.setId(new ArtikalkalkulacijaPK());
                            int i = 1;
                            while (i < this.niz.length) {
                                if (this.getCriteriaOpstiInt(2)[i] != -1) {
                                    if (this.getCriteriaOpstiInt(2)[i] > row.length) {
                                        throw new PzInfoException("Gre\u0161ka! Kolona za polje " + this.getCriteriaOpsti(0)[i] + " nije dobro definisana! ");
                                    }
                                    int red = row[this.getCriteriaOpstiInt(2)[i]].getRow() + 1;
                                    if (row[this.getCriteriaOpstiInt(2)[i]].getType() == CellType.EMPTY) {
                                        throw new PzInfoException("Gre\u0161ka! Kolona za polje " + this.getCriteriaOpsti(0)[i] + " je prazna. Red " + red + ".");
                                    }
                                    if (this.getCriteriaOpsti(3)[i].equals("STRING")) {
                                        if (row[this.getCriteriaOpstiInt(2)[i]].getContents().trim().length() > this.getCriteriaOpstiInt(4)[i]) {
                                            throw new PzInfoException("Gre\u0161ka! Vrednost kolone za polje " + this.getCriteriaOpsti(0)[i] + " u " + red + ". redu je preduga\u010dka. Polje " + this.getCriteriaOpsti(0)[i] + " ima " + this.getCriteriaOpstiInt(4)[i] + " karaktera");
                                        }
                                        BeanUtils.setProperty((Object)al, (String)this.getCriteriaOpsti(1)[i].trim(), (Object)row[this.getCriteriaOpstiInt(2)[i]].getContents());
                                    } else if (this.getCriteriaOpsti(3)[i].equals("DOUBLE") || this.getCriteriaOpsti(3)[i].equals("BIG_DECIMAL")) {
                                        String input = row[this.getCriteriaOpstiInt(2)[i]].getContents();
                                        double broj = this.getDouble(input);
                                        if (broj == -1.0) {
                                            throw new PzInfoException("Gre\u0161ka! Vrednost kolone za polje " + this.getCriteriaOpsti(0)[i] + " u " + red + ". redu nije broj. ");
                                        }
                                        BeanUtils.setProperty((Object)al, (String)this.getCriteriaOpsti(1)[i], (Object)broj);
                                    }
                                }
                                ++i;
                            }
                        } else {
                            int red = j + 1;
                            throw new PzInfoException("Informacija! Red " + red + " je prazan");
                        }
                        lista.add(al);
                        ++j;
                        continue;
                    }
                    break;
                }
            } else {
                throw new PzInfoException("Informacija! List je prazan!");
            }
            ArrayList<Artikalkalkulacija> arrayList = lista;
            return arrayList;
        }
        catch (PzInfoException e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
            return null;
        }
        finally {
            em.close();
        }
    }

    public double getDouble(String input) {
        try {
            double broj = new DecimalFormat("###,###.##").parse(input).doubleValue();
            return broj;
        }
        catch (Exception exception) {
            return -1.0;
        }
    }

    public String[] getCriteriaOpsti(int x) {
        int len = this.niz.length;
        Object[][] array = this.niz;
        String[] criterias = new String[len];
        int i = 0;
        while (i < len) {
            criterias[i] = (String)array[i][x];
            ++i;
        }
        return criterias;
    }

    public int[] getCriteriaOpstiInt(int x) {
        int len = this.niz.length;
        Object[][] array = this.niz;
        int[] criterias = new int[len];
        int i = 0;
        while (i < len) {
            criterias[i] = (Integer)array[i][x];
            ++i;
        }
        return criterias;
    }

    @Override
    public void validateDokument(Kalkulacija k) throws Exception {
        if (k.getId() == 0) {
            throw new PzInfoException("Da biste mogli da uvezete podatke, zaglavlje kalkulacije mora prethodno biti snimljeno.");
        }
    }

    public static class Type {
        public static final String T_DOUBLE = "DOUBLE";
        public static final String T_BIG_DECIMAL = "BIG_DECIMAL";
        public static final String T_STRING = "STRING";
        public static final String T_DATE = "DATE";
        public static final String T_INTEGER = "INTEGER";
        public static final String T_BOOLEAN = "BOOLEAN";
    }
}

