/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.dataimport.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.jdesktop.swingx.VerticalLayout;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.nabavka.dataimport.DataImporter;
import rs.pezar.nabavka.dataimport.DataImporterOptionsPanel;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzFileUtility;
import rs.pezar.swing.util.PzSwingUtility;

public class PzPanelGeneralOptions
extends DataImporterOptionsPanel {
    private static final long serialVersionUID = 20383409414671415L;
    private PzPanel pnlFile;
    private PzTextField txtFile;
    private PzButton btnPronadji;
    private PzRadioGroup<PzChoice> rgr;
    private PzDoubleField dblProcMarze;
    private PzPanel pnlMarza;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add((Component)((Object)new PzPanelGeneralOptions()));
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public PzPanelGeneralOptions() {
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout((LayoutManager)new VerticalLayout());
        try {
            this.pnlFile = new PzPanel();
            this.pnlFile.setLayout((LayoutManager)new FlowLayout(3, 10, 10));
            this.add((Component)this.pnlFile);
            this.pnlFile.add((Component)new JLabel("Putanja:"));
            this.txtFile = new PzTextField();
            this.pnlFile.add((Component)this.txtFile);
            this.txtFile.setName("txtFile");
            this.txtFile.setColumns(35);
            this.btnPronadji = new PzButton();
            this.btnPronadji.setText("Pronadji");
            this.btnPronadji.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/folder.png")));
            this.pnlFile.add((Component)this.btnPronadji);
            this.btnPronadji.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PzPanelGeneralOptions.this.btnPronadjiActionPerformed(evt);
                }
            });
            Object[] choices = new PzChoice[]{new PzChoice("Pitaj me za svaku stavku", (Object)"INDIVIDUAL"), new PzChoice("Generalni procenat mar\u017ee", (Object)"GENERAL"), new PzChoice("Zadr\u017ei postoje\u0107u cenu", (Object)"CURRENT_PRICE")};
            this.rgr = PzRadioGroup.create((Object[])choices);
            this.rgr.setSelectedIndex(0);
            this.rgr.setBorder((Border)new TitledBorder("Na\u010din odre\u0111ivanja prodajne cene"));
            this.add((Component)this.rgr);
            this.rgr.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getStateChange() == 1) {
                        if (((PzChoice)evt.getValue()).getValue().equals("GENERAL")) {
                            PzPanelGeneralOptions.this.dblProcMarze.setEnabled(true);
                        } else {
                            PzPanelGeneralOptions.this.dblProcMarze.setEnabled(false);
                        }
                    }
                }
            });
            this.pnlMarza = new PzPanel();
            this.pnlMarza.setLayout((LayoutManager)new FlowLayout(3, 10, 10));
            this.add((Component)this.pnlMarza);
            this.pnlMarza.add((Component)new JLabel("Procenat mar\u017ee:"));
            this.dblProcMarze = new PzDoubleField();
            this.dblProcMarze.setEnabled(false);
            this.dblProcMarze.setColumns(5);
            this.pnlMarza.add((Component)this.dblProcMarze);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<Object, Object> getOptions() {
        HashMap<Object, Object> opt = new HashMap<Object, Object>();
        opt.put("FILE", new File(this.txtFile.getVal()));
        opt.put("MARGIN", ((PzChoice)this.rgr.getSelectedValue()).getValue());
        opt.put("MARGIN_RATE", this.dblProcMarze.getVal());
        return opt;
    }

    @Override
    public String getDescription() {
        return "Izaberite fajl iz koga se uvoze podaci";
    }

    @Override
    public void validateInputs() throws Exception {
        File f = new File(this.txtFile.getVal());
        if (!f.exists()) {
            throw new PzInfoException("Izabrani fajl ne postoji!");
        }
        if (!this.txtFile.getVal().endsWith(this.getDataImporter().getFileExtension())) {
            throw new PzInfoException("Format izabranog fajla nije odgovaraju\u0107i!");
        }
        this.setSessionParameter("FILE", f);
    }

    private void btnPronadjiActionPerformed(ActionEvent evt) {
        DataImporter di = this.getDataImporter();
        File f = PzFileUtility.selectFile((String[])new String[]{di.getFileExtension()}, (String)"Izaberite fajl koji se uvozi", (PzDialog)this.getParentDialog(), (int)0);
        if (f == null) {
            return;
        }
        if (!f.exists()) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Izabrani fajl ne postoji!");
        } else {
            this.txtFile.setVal((Object)f.getPath());
        }
    }

    @Override
    public void panelExposed() {
    }

    private DataImporter getDataImporter() {
        return (DataImporter)this.getSessionParameter("IMPORTER");
    }
}

