/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka;

import java.math.BigDecimal;
import java.util.ArrayList;
import javax.persistence.EntityManager;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.entity.Artikalcarinadokument;
import rs.pezar.db.entity.Artikalkalkulacija;
import rs.pezar.db.entity.CarinaDokument;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.util.PzDateUtility;
import rs.pezar.util.PzMathUtility;

public class PzNabavkaUtil {
    @Deprecated
    public static BigDecimal getZavTros(Artikalkalkulacija ak, BigDecimal iznosSaDok, BigDecimal trosakSaDokumenta, BigDecimal trosakDodatni, BigDecimal pdv, String tipRj) {
        BigDecimal netoIznosRobe = tipRj.equals("V") ? iznosSaDok.subtract(pdv).subtract(trosakSaDokumenta) : iznosSaDok.subtract(trosakSaDokumenta);
        BigDecimal fakturnaCena = PzMathUtility.roundIznos((double)ak.getFakturnaCena());
        BigDecimal kolicina = PzMathUtility.roundKolicina((double)ak.getKolicina());
        BigDecimal fakturnaVrednost = fakturnaCena.multiply(kolicina);
        BigDecimal procRabata = PzMathUtility.divide100((BigDecimal)PzMathUtility.roundRabat((double)ak.getProcRabata()));
        BigDecimal rabat = PzMathUtility.roundIznos((BigDecimal)fakturnaVrednost.multiply(procRabata));
        BigDecimal nabavnaVrednost = fakturnaVrednost.subtract(rabat);
        double udeoUTroskovima = nabavnaVrednost.multiply(new BigDecimal("100")).doubleValue() / netoIznosRobe.doubleValue() / 100.0;
        double zTros1 = (trosakSaDokumenta.doubleValue() + trosakDodatni.doubleValue()) * udeoUTroskovima;
        BigDecimal zTros = PzMathUtility.roundIznos((double)zTros1);
        return zTros;
    }

    @Deprecated
    public static BigDecimal getNabCena(Artikalkalkulacija ak, BigDecimal iznosSaDok, BigDecimal trosakSaDokumenta, BigDecimal trosakDodatni, BigDecimal pdv, String tipRj) {
        BigDecimal iznFak = tipRj.equals("V") ? iznosSaDok.subtract(pdv).subtract(trosakSaDokumenta) : iznosSaDok.subtract(trosakSaDokumenta);
        double nabCena1 = ak.getFakturnaCena() - ak.getFakturnaCena() * ak.getProcRabata() / 100.0;
        if (iznFak.compareTo(new BigDecimal(0)) != 0) {
            double pomProc = 0.0;
            if (trosakDodatni.compareTo(new BigDecimal(0)) != 0) {
                pomProc = nabCena1 * ak.getKolicina() * 100.0 / iznFak.subtract(pdv).subtract(trosakSaDokumenta).doubleValue();
            }
            nabCena1 += trosakDodatni.doubleValue() * pomProc / 100.0 / ak.getKolicina();
        }
        return PzMathUtility.roundToBigDecimal((double)nabCena1, (int)4);
    }

    @Deprecated
    public static BigDecimal getProdCena(Artikalkalkulacija ak, BigDecimal procMarze, BigDecimal iznosSaDok, BigDecimal trosakSaDokumenta, BigDecimal trosakDodatni, BigDecimal pdv, String tipRj) {
        ak.setProcMarze(procMarze.doubleValue());
        PzMathUtility.roundKolicina((double)ak.getKolicina());
        BigDecimal fakturnaCena = PzMathUtility.roundIznos((double)ak.getFakturnaCena());
        BigDecimal procRabata = PzMathUtility.divide100((BigDecimal)PzMathUtility.roundRabat((double)ak.getProcRabata()));
        BigDecimal nabCena = fakturnaCena.multiply(new BigDecimal("1").subtract(procRabata));
        return PzMathUtility.roundIznos((BigDecimal)nabCena.multiply(new BigDecimal("1").add(PzMathUtility.divide100((BigDecimal)procMarze))));
    }

    public static BigDecimal getRazlikaUCeni(Kalkulacija k) {
        BigDecimal ukRazlika = new BigDecimal("0.00");
        BigDecimal razlUCeni = null;
        if (k.getArtikalkalkulacijas() == null || k.getArtikalkalkulacijas().size() == 0) {
            return ukRazlika;
        }
        for (Artikalkalkulacija ak : k.getArtikalkalkulacijas()) {
            BigDecimal kolicina = BDConverter.getKolicina((double)ak.getKolicina());
            BigDecimal stopa = BDConverter.getStopaPDV((double)ak.getTaksa("PDV").getStopa());
            BigDecimal nabVrednost = ak.calculateNabVrednost();
            if (k.getArtikalkalkulacijas().indexOf(ak) == k.getArtikalkalkulacijas().size() - 1) {
                BigDecimal razl = k.calculateRazlikaTroskova();
                nabVrednost = nabVrednost.add(razl);
            }
            BigDecimal prodVrednost = BDConverter.getIznos((BigDecimal)ak.getProdCena().multiply(kolicina));
            BigDecimal prodVrednostBezPDV = new BigDecimal(0);
            prodVrednostBezPDV = k.getRadnajedinica().getgTip().equals("V") ? prodVrednost : BDConverter.getIznos((double)(prodVrednost.multiply(new BigDecimal("100")).doubleValue() / new BigDecimal("100").add(stopa).doubleValue()));
            razlUCeni = BDConverter.getIznos((BigDecimal)prodVrednostBezPDV.subtract(nabVrednost));
            ukRazlika = ukRazlika.add(razlUCeni);
        }
        return ukRazlika;
    }

    public static BigDecimal getNabavnaVrednost(Kalkulacija k) {
        BigDecimal res = new BigDecimal(0);
        if (k.getArtikalkalkulacijas() != null && k.getArtikalkalkulacijas().size() > 0) {
            for (Artikalkalkulacija ak : k.getArtikalkalkulacijas()) {
                BigDecimal nabVrednost = BDConverter.getIznos((BigDecimal)ak.calculateNabCena().multiply(BDConverter.getKolicina((double)ak.getKolicina())));
                res = res.add(nabVrednost);
            }
        }
        return res;
    }

    public static void main(String[] args) {
        BigDecimal iznos = new BigDecimal("74038.11");
        BigDecimal trosSaDok = new BigDecimal("15197.97");
        BigDecimal trosDodatni = new BigDecimal("600");
        BigDecimal procMarze = new BigDecimal("10");
        BigDecimal pdv = new BigDecimal("11293.95");
        Artikalkalkulacija ak1 = new Artikalkalkulacija();
        ak1.setFakturnaCena(713.9);
        ak1.setKolicina(11.13);
        ak1.setProcRabata(17.97);
        System.out.println(PzNabavkaUtil.getZavTros(ak1, iznos, trosSaDok, trosDodatni, pdv, "V"));
        System.out.println(PzNabavkaUtil.getProdCena(ak1, procMarze, iznos, trosSaDok, trosDodatni, pdv, "V"));
        System.out.println();
        Artikalkalkulacija ak2 = new Artikalkalkulacija();
        ak2.setFakturnaCena(653.08);
        ak2.setKolicina(17.25);
        ak2.setProcRabata(17.97);
        System.out.println(PzNabavkaUtil.getZavTros(ak2, iznos, trosSaDok, trosDodatni, pdv, "V"));
        System.out.println(PzNabavkaUtil.getProdCena(ak2, procMarze, iznos, trosSaDok, trosDodatni, pdv, "V"));
        System.out.println();
        Artikalkalkulacija ak3 = new Artikalkalkulacija();
        ak3.setFakturnaCena(685.73);
        ak3.setKolicina(56.51);
        ak3.setProcRabata(17.97);
        System.out.println(PzNabavkaUtil.getZavTros(ak3, iznos, trosSaDok, trosDodatni, pdv, "V"));
        System.out.println(PzNabavkaUtil.getProdCena(ak3, procMarze, iznos, trosSaDok, trosDodatni, pdv, "V"));
        System.out.println();
    }

    public static Kalkulacija convertCarinaToKalkulacija(CarinaDokument car, Radnajedinica rj, EntityManager em) {
        Kalkulacija k = new Kalkulacija();
        k.setTip(TipDokumentConfig.get().KALKULACIJA);
        k.setPodTip(TipDokumentConfig.get().PODTIP_KALKULACIJA_FAKTURA);
        k.setDatDPO(car.getDatPrometa());
        k.setDatFakture(car.getDatum());
        k.setDatum(car.getDatum());
        k.setDatValute(PzDateUtility.getCurrentDate());
        k.setPdv("BEZ_PDV");
        k.setPoruka("");
        k.setRadnajedinica(rj);
        k.setOznDokumenta(car.getOznDokumenta());
        k.setKomitent(car.getKomitent());
        k.setUserPoc(car.getUserKraj());
        k.setUserKraj(car.getUserKraj());
        k.setKurs(car.getKurs());
        k.setIznos(BDConverter.getIznos((double)car.getVrednostD()));
        k.setArtikalkalkulacijas(new ArrayList());
        if (car.getArtikalcarinadokuments() != null) {
            for (Artikalcarinadokument ac : car.getArtikalcarinadokuments()) {
                Artikalkalkulacija ak = new Artikalkalkulacija();
                ak.init(ac.getArtikal(), (PzDokument)k);
                ak.setFakturnaCena(ac.getCenaD());
                ak.setNabCena(ac.getCenaD());
                ak.setKolicina(ac.getKolicina());
                Stanje s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(ak.getId().getSfrProizvod(), rj));
                if (s != null) {
                    ak.setCena(s.getProdCena());
                } else {
                    ak.setProdCena(BDConverter.getProdCena((double)ac.getCenaD()));
                }
                ak.setProcMarze(BDConverter.getProcMarze((double)(ak.getProdCena().doubleValue() / ak.getNabCena())).doubleValue() * 100.0);
                k.getArtikalkalkulacijas().add(ak);
            }
        }
        return k;
    }
}

