/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui.util;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.util.Base64;

public class VerificationURLDecoder {
    public static InvoiceInfo decode(String url) throws UnsupportedEncodingException {
        String value = url.substring(url.lastIndexOf("=") + 1);
        String urlDecoded = URLDecoder.decode(value, StandardCharsets.US_ASCII.toString());
        byte[] bytes = Base64.getDecoder().decode(urlDecoded);
        ByteBuffer buff = ByteBuffer.wrap(bytes);
        buff.position(1);
        byte[] tempBytes = new byte[8];
        buff.get(tempBytes);
        String requestedBy = new String(tempBytes, StandardCharsets.US_ASCII);
        buff.get(tempBytes);
        String signedBy = new String(tempBytes, StandardCharsets.US_ASCII);
        tempBytes = new byte[4];
        buff.get(tempBytes);
        ByteBuffer tempBuff = ByteBuffer.wrap(tempBytes);
        tempBuff.order(ByteOrder.LITTLE_ENDIAN);
        tempBuff.position(0);
        int totalCounter = tempBuff.getInt();
        tempBytes = new byte[4];
        buff.get(tempBytes);
        tempBuff = ByteBuffer.wrap(tempBytes);
        tempBuff.order(ByteOrder.LITTLE_ENDIAN);
        tempBuff.position(0);
        int transactionTypeCounter = tempBuff.getInt();
        tempBytes = new byte[8];
        buff.get(tempBytes);
        tempBuff = ByteBuffer.wrap(tempBytes);
        tempBuff.order(ByteOrder.LITTLE_ENDIAN);
        tempBuff.position(0);
        long totalAmountLong = tempBuff.getLong();
        BigDecimal totalAmount = new BigDecimal(totalAmountLong).divide(new BigDecimal("10000"), 2, RoundingMode.HALF_UP);
        long timestamp = buff.getLong();
        Date date = new Date(timestamp);
        byte invoiceType = buff.get();
        byte transactionType = buff.get();
        byte buyerIdLength = buff.get();
        tempBytes = new byte[buyerIdLength];
        buff.get(tempBytes);
        String buyerId = tempBytes.length > 0 ? new String(tempBytes, StandardCharsets.US_ASCII) : null;
        return new InvoiceInfo(requestedBy, signedBy, totalCounter, transactionTypeCounter, totalAmount, date, invoiceType, transactionType, buyerId);
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        System.out.println(VerificationURLDecoder.decode("https://sandbox.suf.purs.gov.rs/v/?vl=A0tIWEZDWTY1S0hYRkNZNjUWAAAAEwAAANDdBgAAAAAAAAABkk3DOggAAABfcqLp7rC%2BslzvUIO7lfDb4gqQe9UNy7v8MbXzwewVDyOZcJp1asWK9S7N3JwK75KsqA1wdiyXjae5dVSYlHLt2u79EY4%2B0hOifP0CStpFRqcHSeA4zxQl7yMKISE5ezme1Lf7FsZDOyoDNUG1DBUNc6784W8qI45h1afYuD7ZB%2FU%2BKZ64hVx0u64pwqnVfZ6hQB%2BoHl7vzr25zJFwwMvX4uyh9AQ1u0rYf1RAo3jWMxdQsaUv9hCIKw5zmsnshJpBSdkCymOAuYJi%2BSdojpbaOY7ivf1%2BHC9zK6oTlkT4oSNEt6ZN9TAKGBJQ1rUdSM0AqjcpxnO2Nq%2FZt74xRaqIfVzIfmBLGJBo%2FAOW9cPgzx3ZbKzRT6XplLvMOVDeOeIKXfwhZykqKiKi3VkPQ0aXCF0sLTAP5avwkvGore94tNsx1ftGsPBVUPD%2FQJ1ulLFOVLSQksDeev6YQsEw%2FB9Fj%2Flg3bCH2zKGIXLz7TttA67GI8iHIiZtj7%2B1DoTficMdK8JEr6XZ5SBPh%2FOH3DaR2cvSPulMJSHWu%2F4Shw6492mxHdRIQfIrVQtc8JKRee%2B%2BHpncumLVHyVVOprprQb%2Bz9xLTgUOe0NTm7IlwOB5odE9fEQ6TPVNRMPPptyTeSg3t0E77D%2FGQQOZOdX%2F3HK1xmx8xEI5lxHXxMjjByyJO3KMe79vgWQSYOTNqVbRcI0%3D"));
    }

    public static class InvoiceInfo {
        private String requestedBy;
        private String signedBy;
        private int totalCounter;
        private int transactionTypeCounter;
        private BigDecimal totalAmount;
        private Date date;
        private int invoiceType;
        private int transactionType;
        private String buyerId;

        public InvoiceInfo(String requestedBy, String signedBy, int totalCounter, int transactionTypeCounter, BigDecimal totalAmount, Date date, int invoiceType, int transactionType, String buyerId) {
            this.requestedBy = requestedBy;
            this.signedBy = signedBy;
            this.totalCounter = totalCounter;
            this.transactionTypeCounter = transactionTypeCounter;
            this.totalAmount = totalAmount;
            this.date = date;
            this.invoiceType = invoiceType;
            this.transactionType = transactionType;
            this.buyerId = buyerId;
        }

        public String getRequestedBy() {
            return this.requestedBy;
        }

        public String getSignedBy() {
            return this.signedBy;
        }

        public int getTotalCounter() {
            return this.totalCounter;
        }

        public int getTransactionTypeCounter() {
            return this.transactionTypeCounter;
        }

        public BigDecimal getTotalAmount() {
            return this.totalAmount;
        }

        public Date getDate() {
            return this.date;
        }

        public int getInvoiceType() {
            return this.invoiceType;
        }

        public int getTransactionType() {
            return this.transactionType;
        }

        public String getBuyerId() {
            return this.buyerId;
        }

        public String getSdcNumber() {
            return String.valueOf(this.getRequestedBy()) + "-" + this.getSignedBy() + "-" + this.getTotalCounter();
        }

        public String getBuyerTin() {
            if (this.buyerId == null || !this.buyerId.contains(":")) {
                return null;
            }
            return this.buyerId.split(":")[1];
        }

        public String toString() {
            return "InvoiceInfo [requestedBy=" + this.requestedBy + ", signedBy=" + this.signedBy + ", totalCounter=" + this.totalCounter + ", transactionTypeCounter=" + this.transactionTypeCounter + ", totalAmount=" + this.totalAmount + ", date=" + this.date + ", invoiceType=" + this.invoiceType + ", transactionType=" + this.transactionType + ", buyerId=" + this.buyerId + "]";
        }
    }
}

