/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui.util;

import java.awt.Component;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.apache.commons.jxpath.JXPathContext;
import org.eclipse.persistence.queries.FetchGroup;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import rs.pezar.core.PzApplication;
import rs.pezar.core.log.PzLogger;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.commons.PzIdGen;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Konto;
import rs.pezar.db.entity.KontoPK;
import rs.pezar.db.entity.Nzk;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Shema;
import rs.pezar.db.entity.Stavkanzk;
import rs.pezar.finansije.engine.DokumentCompilerException;
import rs.pezar.finansije.engine.DokumentCompilerFactory;
import rs.pezar.finansije.engine.DokumentCompilerObserver;
import rs.pezar.finansije.engine.MultiDokumentCompiler;
import rs.pezar.finansije.engine.internal.ExpressionParser;
import rs.pezar.finansije.gui.PzDialogIzRobnogUFinansijsko;
import rs.pezar.finansije.gui.util.reportCustomizers.ReportCustomizer;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportViewer;
import rs.pezar.reports.engine.standard.PzBeanDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;

public class Tools {
    private static XMLConfiguration reportConf;
    public static String ID_HEADER_SUBREPORT;
    public static String ID_HEADER_DATA;
    public static String ID_DOKUMENT_SUBREPORT;
    public static String ID_DOKUMENT_DATA;
    public static String ID_NZK_SUBREPORT;
    public static String ID_NZK_DATA;
    public static String ID_DOKUMENT_PARAMETERS;
    private static Map<String, String> props;

    static {
        ID_HEADER_SUBREPORT = "headerSubreport";
        ID_HEADER_DATA = "headerData";
        ID_DOKUMENT_SUBREPORT = "dokumentSubreport";
        ID_DOKUMENT_DATA = "dokumentData";
        ID_NZK_SUBREPORT = "nzkSubreport";
        ID_NZK_DATA = "nzkData";
        ID_DOKUMENT_PARAMETERS = "dokumentParameters";
        EntityManager em1 = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                String cfr_ignored_0 = (String)em1.createNativeQuery("SELECT column_name FROM information_schema.columns WHERE table_name='nzk' and column_name='opis'").getSingleResult();
            }
            catch (NoResultException noResultException) {
                em1.getTransaction().begin();
                em1.createNativeQuery("ALTER TABLE nzk ADD COLUMN opis character varying(255)").executeUpdate();
                em1.getTransaction().commit();
                em1.close();
            }
        }
        finally {
            em1.close();
        }
    }

    public static void generishiNaloge(final List<PzDokument> dokumenti, final Date datum, final PzDialogIzRobnogUFinansijsko dlg, final boolean mosha, final Map<String, String> properties) {
        dlg.getToolbar().setEnabled(false);
        SwingWorker<List<Nzk>, Integer> worker = new SwingWorker<List<Nzk>, Integer>(){

            @Override
            protected List<Nzk> doInBackground() throws Exception {
                PzWorkerDialog.getDialogInstance().setProgresSize(0, dokumenti.size());
                MultiDokumentCompiler compiler = DokumentCompilerFactory.getInstance().createMultiDokumentCompiler();
                compiler.addObserver(new DokumentCompilerObserver(){

                    @Override
                    public void compilationStarted(PzDokument dok) {
                    }

                    @Override
                    public void compilationDone(PzDokument dokument) {
                        this.publish(new Integer[]{1});
                    }
                });
                props = properties;
                List<Nzk> nalozi = compiler.compile(dokumenti, properties);
                return nalozi;
            }

            @Override
            protected void process(List<Integer> arg0) {
                for (Integer i : arg0) {
                    PzWorkerDialog.getDialogInstance().incProgress(i.intValue());
                }
            }

            @Override
            protected void done() {
                List nalozi = null;
                try {
                    nalozi = (List)this.get();
                    PzWorkerDialog.getDialogInstance().setProgresSize(0, nalozi.size());
                    if (mosha) {
                        Tools.prikaziIzvestaje(nalozi, dlg, false);
                    } else {
                        PzWorkerDialog.getDialogInstance().setMessage("Snimanje naloga je u toku. Molim, sa\u010dekajte");
                        Tools.arhivirajNaloge(nalozi, datum, dokumenti, dlg);
                    }
                }
                catch (DokumentCompilerException e) {
                    PzSwingUtility.showErrorMessage((Component)((Object)dlg), (String)e.getMessage());
                    if (mosha && nalozi != null) {
                        try {
                            Tools.prikaziIzvestaje(nalozi, dlg, false);
                            dlg.getToolbar().setEnabled(true);
                        }
                        catch (Exception e1) {
                            PzLogger.getInstance().logException((Throwable)e1);
                        }
                    }
                    PzWorkerDialog.hideStatus();
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle((Component)((Object)dlg), (Throwable)e);
                }
            }
        };
        worker.execute();
    }

    public static void arhivirajNaloge(final List<Nzk> nalozi, final Date datum, final List<PzDokument> dokumenti, final PzDialogIzRobnogUFinansijsko dlg) {
        SwingWorker<Object, Integer> worker = new SwingWorker<Object, Integer>(){

            @Override
            protected Object doInBackground() throws Exception {
                EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                try {
                    try {
                        em.getTransaction().begin();
                        for (Nzk nalog : nalozi) {
                            nalog.setIdNalog(Integer.valueOf(PzIdGen.getNextId((String)"NZK_ID", (int)1, (EntityManager)em).getIdVal()));
                            nalog.setDatum(datum);
                            nalog.setPzuser((Pzuser)em.find(Pzuser.class, (Object)PzApplication.getApplication().getSession().getLoggedUser().getPzusername()));
                            List stavke = nalog.getStavkanzks();
                            nalog.setStavkanzks(null);
                            em.persist((Object)nalog);
                            BigDecimal duguje = new BigDecimal(0);
                            BigDecimal potrazuje = new BigDecimal(0);
                            for (Stavkanzk stavka : stavke) {
                                stavka.getId().setIdNalog(nalog.getIdNalog());
                                duguje = duguje.add(stavka.getDuguje());
                                potrazuje = potrazuje.add(stavka.getPotrazuje());
                                Tools.updateKonto(em, stavka);
                            }
                            nalog.setStavkanzks(stavke);
                            nalog.setDuguje(duguje);
                            nalog.setPotrazuje(potrazuje);
                            Shema s = DokumentCompilerFactory.getInstance().getShemaProvider().getShema(nalog);
                            String rj = nalog.getRadnajedinica() != null ? " RJ: " + nalog.getRadnajedinica().getId().getOznRj() : "";
                            nalog.setOpis(String.valueOf(TipDokumentConfig.getNameByValue((String)s.getId().getTipDok(), null)) + rj + " (automatsko knji\u017eenje) ");
                            if (nalog.getArhiviran() == 1 && nalog.getDuguje().compareTo(nalog.getPotrazuje()) != 0) {
                                throw new DokumentCompilerException("Nalog " + nalog.getIdNalog() + " nije u ravnote\u017ei. Proces knji\u017eenja je obustavljen. Ni jedan dokument nije proknji\u017een.");
                            }
                            em.flush();
                            this.publish(1);
                        }
                        String strdok = "";
                        int i = 0;
                        while (i < dokumenti.size()) {
                            strdok = String.valueOf(strdok) + (i == 0 ? "" : ",") + ((PzDokument)dokumenti.get(i)).getIdDok();
                            ++i;
                        }
                        Query q = em.createQuery("UPDATE Dokument d SET d.proknjizen=1 WHERE d.idDok IN (" + strdok + ")");
                        q.executeUpdate();
                        q = em.createNativeQuery("UPDATE Dokument  SET proknjizen=1 WHERE idDok IN (SELECT idDok FROM Kalkulacija WHERE idKalkulacija in (" + strdok + "))");
                        q.executeUpdate();
                        em.getTransaction().commit();
                    }
                    catch (Exception e) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        if (e instanceof DokumentCompilerException) {
                            PzSwingUtility.showErrorMessage((Component)((Object)dlg), (String)(String.valueOf(e.getMessage()) + " \nSlike naloga \u0107e biti prikazane radi informacije i nisu predvi\u0111ene za \u0161tampanje."));
                        } else {
                            PzMysqlExceptionHandler.handle((Component)((Object)dlg), (Throwable)e);
                        }
                        em.close();
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    em.close();
                    PzWorkerDialog.hideStatus();
                }
                return nalozi;
            }

            @Override
            protected void process(List<Integer> arg0) {
                for (Integer i : arg0) {
                    if (PzWorkerDialog.getDialogInstance() == null) continue;
                    PzWorkerDialog.getDialogInstance().incProgress(i.intValue());
                }
            }

            @Override
            protected void done() {
                PzWorkerDialog.hideStatus();
                try {
                    List nalozi2 = (List)this.get();
                    Vector<Nzk> naloziZaPrikaz = new Vector<Nzk>();
                    String naloziUPripremi = "";
                    int i = 0;
                    while (i < nalozi2.size()) {
                        Nzk nalog = (Nzk)nalozi2.get(i);
                        if (nalog.getArhiviran() == 1) {
                            naloziZaPrikaz.add(nalog);
                        } else {
                            naloziUPripremi = String.valueOf(naloziUPripremi) + (i == 0 ? "" : ", ") + nalog.getIdNalog();
                        }
                        ++i;
                    }
                    dlg.instantiateTable();
                    if (naloziZaPrikaz.size() > 0) {
                        Tools.prikaziIzvestaje(naloziZaPrikaz, dlg, false);
                    }
                    if (naloziUPripremi.length() != 0) {
                        JOptionPane.showMessageDialog((Component)((Object)dlg), "Slede\u0107i nalozi su ostavljeni u pripremi i moraju biti ru\u010dno doknji\u017eeni: \n" + naloziUPripremi);
                    }
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle((Component)((Object)dlg), (Throwable)e);
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        worker.execute();
    }

    public static void updateKonto(EntityManager em, Stavkanzk stavka) {
        Konto konto = (Konto)em.find(Konto.class, (Object)new KontoPK(stavka.getId().getOznKonto(), stavka.getId().getAnalitika()));
        konto.setDug(konto.getDug().add(stavka.getDuguje()));
        konto.setPot(konto.getPot().add(stavka.getPotrazuje()));
        konto.setZdug(stavka.getDuguje());
        konto.setZpot(stavka.getPotrazuje());
    }

    public static void printajNaloge(List<Nzk> nalozi) {
        for (Nzk n : nalozi) {
            System.out.println("NALOG");
            for (Stavkanzk stavka : n.getStavkanzks()) {
                System.out.println("-----------STAVKA-------------");
                System.out.println("  Konto: " + stavka.getId().getOznKonto() + "   " + stavka.getId().getAnalitika());
                System.out.println("  Duguje: " + stavka.getDuguje());
                System.out.println("  Potrazuje: " + stavka.getPotrazuje());
            }
            System.out.println();
        }
    }

    public static void prikaziIzvestaje(List<Nzk> nalozi, PzDialog parent, boolean detaljni) throws Exception {
        Vector<JasperPrint> izvestaji = new Vector<JasperPrint>();
        for (Nzk nalog : nalozi) {
            HashMap<String, Object> dokumentSubreport = Tools.sastaviDokumentSubreport(nalog);
            if (!detaljni) {
                Tools.sumirajStavke(nalog);
            }
            izvestaji.add(Tools.sastaviIzvestaj(Tools.sastaviHeaderSubreport(), Tools.sastaviNzkSubreport(nalog, detaljni), dokumentSubreport, Tools.napraviDatasource(nalog)));
        }
        if (props != null && props.get("NZK_ERROR_DOKUMENT_ID") != null) {
            PzSwingUtility.showInformationMessage((Component)parent, (String)("Dokument ID: " + props.get("NZK_ERROR_DOKUMENT_ID") + " je prouzrokovao neslaganje dugovne i potrazne strane"));
        }
        PzReportViewer.viewReport((PzDialog)parent, (JasperPrint)Tools.spojiIzvestaje(izvestaji), (String)"Nalozi_za_knjizenje");
        PzWorkerDialog.hideStatus();
    }

    public static void prikaziIzvestaj(Nzk nalog, PzDialog parent, boolean detaljni) throws JRException, Exception {
        if (!detaljni) {
            Tools.sumirajStavke(nalog);
        }
        JasperPrint izvestaj = Tools.sastaviIzvestaj(Tools.sastaviHeaderSubreport(), Tools.sastaviNzkSubreport(nalog, detaljni), new HashMap<String, Object>(), Tools.napraviDatasource(nalog));
        PzReportViewer.viewReport((PzDialog)parent, (JasperPrint)izvestaj, (String)("Nalog_za_knjizenja_" + nalog.getIdNalog()));
    }

    private static PzDataSourceExtended napraviDatasource(Nzk nalog) {
        Vector<Nzk> staticContent = new Vector<Nzk>();
        staticContent.add(nalog);
        PzDataSourceExtended ds = new PzDataSourceExtended(staticContent, staticContent);
        ds.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
        return ds;
    }

    private static void sumirajStavke(Nzk nalog) {
        List stavke = nalog.getStavkanzks();
        nalog.setStavkanzks(new Vector());
        for (Stavkanzk stavka : stavke) {
            Tools.dodajStavku(nalog, stavka);
        }
    }

    private static void dodajStavku(Nzk nalog, Stavkanzk stavka) {
        Iterator i = nalog.getStavkanzks().iterator();
        Stavkanzk nStavka = null;
        boolean found = false;
        while (i.hasNext() && !found) {
            nStavka = (Stavkanzk)i.next();
            if (!nStavka.getId().getOznKonto().equals(stavka.getId().getOznKonto()) || !nStavka.getId().getAnalitika().equals(stavka.getId().getAnalitika())) continue;
            nStavka.setDuguje(nStavka.getDuguje().add(stavka.getDuguje()));
            nStavka.setPotrazuje(nStavka.getPotrazuje().add(stavka.getPotrazuje()));
            found = true;
        }
        if (!found) {
            nalog.getStavkanzks().add(stavka);
        }
    }

    private static JasperPrint spojiIzvestaje(List<JasperPrint> izvestaji) {
        JasperPrint jp = null;
        boolean first = true;
        for (JasperPrint izvestaj : izvestaji) {
            if (first) {
                jp = izvestaj;
                first = false;
                continue;
            }
            List pages = izvestaj.getPages();
            for (JRPrintPage page : pages) {
                jp.addPage(page);
            }
        }
        return jp;
    }

    private static JasperPrint sastaviIzvestaj(HashMap<String, Object> header, HashMap<String, Object> nzk, HashMap<String, Object> dokument, PzDataSourceExtended ds) throws JRException {
        JasperReport report = (JasperReport)JRLoader.loadObject((URL)Tools.class.getClassLoader().getResource("rs/pezar/finansije/resource/reports/compiled/nzk_container.jasper"));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.putAll(nzk);
        params.putAll(header);
        if (dokument != null) {
            params.putAll(dokument);
        }
        return JasperFillManager.fillReport((JasperReport)report, params, (JRDataSource)ds);
    }

    private static HashMap<String, Object> sastaviNzkSubreport(Nzk nalog, boolean detaljni) throws JRException {
        if (!detaljni) {
            Collections.sort(nalog.getStavkanzks(), new Comparator<Stavkanzk>(){

                @Override
                public int compare(Stavkanzk o1, Stavkanzk o2) {
                    if (o1.getId().getOznKonto().equals(o2.getId().getOznKonto())) {
                        return o1.getId().getAnalitika().compareTo(o2.getId().getAnalitika());
                    }
                    return o1.getId().getOznKonto().compareTo(o2.getId().getOznKonto());
                }
            });
        } else {
            Collections.sort(nalog.getStavkanzks(), new Comparator<Stavkanzk>(){

                @Override
                public int compare(Stavkanzk o1, Stavkanzk o2) {
                    if (o1.getId().getrBroj() > o2.getId().getrBroj()) {
                        return 1;
                    }
                    if (o1.getId().getrBroj() < o2.getId().getrBroj()) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        String filename = detaljni ? "nzk_detaljno.jasper" : "nzk.jasper";
        JasperReport nzkReport = (JasperReport)JRLoader.loadObject((URL)Tools.class.getClassLoader().getResource("rs/pezar/finansije/resource/reports/compiled/" + filename));
        Vector<Nzk> staticContent = new Vector<Nzk>();
        staticContent.add(nalog);
        PzDataSourceExtended ds = new PzDataSourceExtended(staticContent, nalog.getStavkanzks());
        ds.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
        res.put(ID_NZK_SUBREPORT, nzkReport);
        res.put(ID_NZK_DATA, ds);
        return res;
    }

    private static HashMap<String, Object> sastaviHeaderSubreport() throws Exception {
        HashMap<String, Object> res = new HashMap<String, Object>();
        JasperReport headerSubreport = (JasperReport)JRLoader.loadObject((URL)Tools.class.getClassLoader().getResource("rs/pezar/finansije/resource/reports/compiled/header.standard.jasper"));
        Vector<Firma> staticContent = new Vector<Firma>();
        staticContent.add(PzFirma.getFirma());
        PzDataSourceExtended ds = new PzDataSourceExtended(staticContent, staticContent);
        ds.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
        res.put(ID_HEADER_SUBREPORT, headerSubreport);
        res.put(ID_HEADER_DATA, ds);
        return res;
    }

    private static HashMap<String, Object> sastaviDokumentSubreport(Nzk nalog) throws JRException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        Shema s = DokumentCompilerFactory.getInstance().getShemaProvider().getShema(nalog);
        JasperReport dokumentSubreport = null;
        JasperReport defaultReport = (JasperReport)JRLoader.loadObject((URL)Tools.class.getClassLoader().getResource("rs/pezar/finansije/resource/reports/compiled/dokumenti.jasper"));
        ReportCustomizer customizer = null;
        if (s == null) {
            dokumentSubreport = (JasperReport)JRLoader.loadObject((URL)Tools.class.getClassLoader().getResource("rs/pezar/finansije/resource/reports/compiled/dokumenti.jasper"));
        } else {
            String fname = "";
            try {
                fname = Tools.findReport(s.getId().getTipDok(), s.getId().getTipRj(), s.getCena());
                dokumentSubreport = fname != null ? (JasperReport)JRLoader.loadObject((URL)Tools.class.getClassLoader().getResource(fname)) : defaultReport;
            }
            catch (Exception e) {
                throw new JRException("Navedeni izve\u0161taj ne postoji: " + fname, (Throwable)e);
            }
            try {
                customizer = Tools.getReportCustomizer(s.getId().getTipDok(), s.getId().getTipRj());
            }
            catch (Exception e) {
                throw new JRException("Navedeni customizer ne postoji. Tip dokumenta : " + s.getId().getTipDok() + ", tip rj: " + s.getId().getTipDok(), (Throwable)e);
            }
        }
        Vector<Nzk> staticContent = new Vector<Nzk>();
        staticContent.add(nalog);
        Vector<PzDokument> dynamicContent = new Vector<PzDokument>();
        for (Stavkanzk stavka : nalog.getStavkanzks()) {
            if (dynamicContent.contains(stavka.getDokument())) continue;
            dynamicContent.add((PzDokument)stavka.getDokument());
        }
        PzDataSourceExtended ds = new PzDataSourceExtended(staticContent, dynamicContent);
        ds.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter(){

            public Object getDynamicValue(String fieldName, Object obj) throws JRException {
                Object res = null;
                if (fieldName.startsWith("xpath@")) {
                    String name = fieldName.replace("xpath@", "").replace('.', '/');
                    try {
                        res = JXPathContext.newContext((Object)obj).getValue(name);
                    }
                    catch (Exception exception) {
                        res = new BigDecimal("0");
                    }
                } else if (fieldName.startsWith("sum@")) {
                    String name = "sum(LIST{" + fieldName.replace("sum@", "").replace('.', '/') + "})";
                    try {
                        res = ExpressionParser.parseDoubleExpression(name, (PzDokument)obj);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                } else {
                    Object ret;
                    res = ret = super.getDynamicValue("dokument." + fieldName, obj);
                }
                if (obj instanceof PzDokument && ((PzDokument)obj).getStorno() == 1 && res != null) {
                    if (res instanceof BigDecimal) {
                        res = ((BigDecimal)res).multiply(new BigDecimal(-1));
                    } else if (res instanceof Double) {
                        res = -1.0 * (Double)res;
                    }
                }
                return res;
            }
        });
        res.put(ID_DOKUMENT_SUBREPORT, dokumentSubreport);
        res.put(ID_DOKUMENT_DATA, ds);
        res.put("nazivSheme", TipDokumentConfig.getNameByValue((String)s.getId().getTipDok(), null));
        if (customizer != null) {
            customizer.customizeDokumentSubreport(res, dynamicContent);
        }
        return res;
    }

    private static String findReport(String tipDok, String tipRj, String tipCene) throws Exception {
        if (reportConf == null) {
            reportConf = new XMLConfiguration(Tools.class.getClassLoader().getResource("rs/pezar/finansije/resource/reports.conf.xml"));
        }
        reportConf.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        String cTipDok = tipDok != null ? "[@tipDok='" + tipDok + "']" : "";
        String cTipRj = tipRj != null ? "[@tipRj='" + tipRj + "']" : "";
        String cTipCene = tipCene != null ? "[@tipCene='" + tipCene + "']" : "";
        return (String)reportConf.getProperty("report" + cTipDok + cTipRj + cTipCene);
    }

    private static ReportCustomizer getReportCustomizer(String tipDok, String tipRj) throws Exception {
        if (reportConf == null) {
            reportConf = new XMLConfiguration(Tools.class.getClassLoader().getResource("rs/pezar/finansije/resource/reports.conf.xml"));
        }
        NodeList nl = reportConf.getDocument().getDocumentElement().getElementsByTagName("report");
        String res = null;
        int i = 0;
        while (i < nl.getLength()) {
            if (((Element)nl.item(i)).getAttribute("tipDok").equals(tipDok) && ((Element)nl.item(i)).getAttribute("tipRj").equals(tipRj)) {
                res = ((Element)nl.item(i)).getAttribute("customizer");
                break;
            }
            ++i;
        }
        if (res != null && !res.equals("")) {
            return (ReportCustomizer)Class.forName(res).newInstance();
        }
        return null;
    }

    public static List<Nzk> getNalozi(EntityManager em) {
        Query q = em.createQuery("SELECT nzk FROM Nzk nzk join fetch nzk.pzuser WHERE nzk.idNalog > 0 ORDER BY nzk.arhiviran, nzk.idNalog");
        FetchGroup grp = new FetchGroup();
        grp.addAttribute("idNalog");
        grp.addAttribute("datum");
        grp.addAttribute("arhiviran");
        grp.addAttribute("pzuser.pzusername");
        q.setHint("eclipselink.fetch-group", (Object)grp);
        List res = q.getResultList();
        return res;
    }
}

