/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui.shemeKnjizenja;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.RadnajedinicaPK;
import rs.pezar.db.entity.Shema;
import rs.pezar.db.entity.ShemaPK;
import rs.pezar.db.entity.Stavkasheme;
import rs.pezar.db.entity.StavkashemePK;
import rs.pezar.globals.TipDokumentStructure;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzGenericTableDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.event.PzEntityChecker;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogNovaShema
extends PzDialogInsert {
    private static final long serialVersionUID = -3362895422040638148L;
    private PzPanel panel;
    private PzPanel pnlVelikoprodaja;
    private PzTextField naziv;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JRadioButton vTipReklamacije;
    private JRadioButton vTipObicna;
    private JLabel jLabel5;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JTextField jLabelNaziv;
    private PzTextField radnaJedinicaField;
    private PzButton btnOK;
    private JPanel pnlButtons;
    private PzPanelHeader header;
    private JComboBox tipDokumenta;
    private JComboBox podtipDokumenta;
    private JComboBox tipRJCB;
    private JComboBox podtipRJCB;
    private JComboBox podpodtipRJCB;
    private JCheckBox chkZatvaraNalog;
    private Radnajedinica radnajedinica;
    private boolean update;
    private ButtonGroup btnGroupVTip;
    private JLabel lblNasledjuje;
    private JList lstNasledjuje;
    private JScrollPane scp;
    private PzButton btnDodaj;
    private PzButton btnBrisi;
    private JLabel lblOpisNaStavovima;
    private PzTextField txtOpis;
    private JCheckBox chckbxAbstraktnaShema;
    private JLabel lblTipCene;
    private JComboBox cbTipCene;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogNovaShema inst = new PzDialogNovaShema(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogNovaShema() {
        this.initGUI();
    }

    public PzDialogNovaShema(JFrame frame) {
        super(frame);
        this.initGUI();
        this.update = (Boolean)this.getSession().getParameter("update");
        if (!this.update) {
            this.popuniTipoveDokumenata();
        }
    }

    public PzDialogNovaShema(PzDialog dialog) {
        super(dialog);
        this.update = (Boolean)this.getSession().getParameter("update");
        if (!this.update) {
            this.popuniTipoveDokumenata();
        }
    }

    protected void initGUI() {
        try {
            this.setPreferredSize(new Dimension(520, 493));
            this.header = new PzPanelHeader();
            this.getContentPane().add((Component)this.header, "North");
            this.header.setIcon(this.getHeaderIcon());
            this.header.setTitle(this.getHeaderTitle());
            this.pnlButtons = new JPanel();
            this.getContentPane().add((Component)this.pnlButtons, "South");
            this.pnlButtons.setPreferredSize(new Dimension(714, 64));
            this.pnlButtons.setLayout(null);
            this.btnOK = new PzButton();
            this.pnlButtons.add((Component)this.btnOK);
            this.btnOK.setText("Potvrdi");
            this.btnOK.setBounds(193, 12, 140, 31);
            this.btnOK.setFont(new Font("Tahoma", 1, 12));
            this.btnOK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/check.png")));
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.panel = new PzPanel();
            this.panel.setBorder((Border)new EmptyBorder(10, 10, 10, 10));
            this.getContentPane().add((Component)this.panel, "Center");
            this.panel.setTransferFocusOnEnter(true);
            GridBagLayout panelLayout = new GridBagLayout();
            panelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            int[] nArray = new int[10];
            nArray[1] = 43;
            nArray[2] = 44;
            nArray[3] = 28;
            nArray[4] = 28;
            nArray[5] = 206;
            nArray[6] = 30;
            nArray[7] = 25;
            nArray[9] = 13;
            panelLayout.rowHeights = nArray;
            panelLayout.columnWeights = new double[]{0.0, 1.0, 0.0};
            panelLayout.columnWidths = new int[]{114, 254, 79};
            this.panel.setLayout((LayoutManager)panelLayout);
            this.chckbxAbstraktnaShema = new JCheckBox("Abstraktna shema");
            GridBagConstraints gbc_chckbxAbstraktnaShema = new GridBagConstraints();
            gbc_chckbxAbstraktnaShema.anchor = 17;
            gbc_chckbxAbstraktnaShema.insets = new Insets(0, 0, 5, 5);
            gbc_chckbxAbstraktnaShema.gridx = 1;
            gbc_chckbxAbstraktnaShema.gridy = 0;
            this.panel.add((Component)this.chckbxAbstraktnaShema, (Object)gbc_chckbxAbstraktnaShema);
            this.lblNasledjuje = new JLabel("Nasledjuje:");
            GridBagConstraints gbc_lblNasledjuje = new GridBagConstraints();
            gbc_lblNasledjuje.anchor = 13;
            gbc_lblNasledjuje.gridheight = 2;
            gbc_lblNasledjuje.insets = new Insets(0, 0, 5, 5);
            gbc_lblNasledjuje.gridx = 0;
            gbc_lblNasledjuje.gridy = 1;
            this.panel.add((Component)this.lblNasledjuje, (Object)gbc_lblNasledjuje);
            this.scp = new JScrollPane();
            GridBagConstraints gbc_scp = new GridBagConstraints();
            gbc_scp.gridheight = 2;
            gbc_scp.fill = 1;
            gbc_scp.insets = new Insets(0, 0, 5, 5);
            gbc_scp.gridx = 1;
            gbc_scp.gridy = 1;
            this.panel.add((Component)this.scp, (Object)gbc_scp);
            this.lstNasledjuje = new JList();
            this.lstNasledjuje.setModel(new DefaultListModel());
            this.scp.setViewportView(this.lstNasledjuje);
            this.btnDodaj = new PzButton();
            this.btnDodaj.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzDialogNovaShema.this.btnDodajactionPerformed(arg0);
                }
            });
            this.btnDodaj.setIcon((Icon)new ImageIcon(PzDialogNovaShema.class.getResource("/rs/pezar/finansije/resource/img/add.png")));
            this.btnDodaj.setText("Dodaj");
            GridBagConstraints gbc_btnDodaj = new GridBagConstraints();
            gbc_btnDodaj.fill = 2;
            gbc_btnDodaj.anchor = 15;
            gbc_btnDodaj.insets = new Insets(0, 0, 5, 60);
            gbc_btnDodaj.gridx = 2;
            gbc_btnDodaj.gridy = 1;
            this.panel.add((Component)this.btnDodaj, (Object)gbc_btnDodaj);
            this.btnBrisi = new PzButton();
            this.btnBrisi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzDialogNovaShema.this.btnBrisiactionPerformed(arg0);
                }
            });
            this.btnBrisi.setIcon((Icon)new ImageIcon(PzDialogNovaShema.class.getResource("/rs/pezar/finansije/resource/img/delete.png")));
            this.btnBrisi.setText("Brisi");
            GridBagConstraints gbc_btnBrisi = new GridBagConstraints();
            gbc_btnBrisi.fill = 2;
            gbc_btnBrisi.anchor = 11;
            gbc_btnBrisi.insets = new Insets(0, 0, 5, 60);
            gbc_btnBrisi.gridx = 2;
            gbc_btnBrisi.gridy = 2;
            this.panel.add((Component)this.btnBrisi, (Object)gbc_btnBrisi);
            this.jLabel5 = new JLabel();
            this.panel.add((Component)this.jLabel5, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 5, 5), 0, 0));
            this.jLabel5.setText("Tip dokumenta");
            this.tipDokumenta = new JComboBox();
            this.panel.add((Component)this.tipDokumenta, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
            this.tipDokumenta.setFont(new Font("Tahoma", 0, 14));
            this.tipDokumenta.setBounds(766, 26, 102, 25);
            this.tipDokumenta.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    if (evt.getStateChange() != 1) {
                        return;
                    }
                    PzDialogNovaShema.this.podtipDokumenta.removeAllItems();
                    PzDialogNovaShema.this.podtipDokumenta.addItem("");
                    List podtipovi = ((TipDokumentStructure.Tip)PzDialogNovaShema.this.tipDokumenta.getSelectedItem()).getPodTipovi();
                    for (TipDokumentStructure.PodTip podtip : podtipovi) {
                        PzDialogNovaShema.this.podtipDokumenta.addItem(podtip);
                    }
                    PzDialogNovaShema.this.predloziNazivSheme();
                }
            });
            this.jLabel1 = new JLabel();
            this.panel.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.jLabel1.setText("Podtip dokumenta");
            this.lblTipCene = new JLabel("Tip cene:");
            GridBagConstraints gbc_lblTipCene = new GridBagConstraints();
            gbc_lblTipCene.anchor = 13;
            gbc_lblTipCene.insets = new Insets(0, 0, 5, 5);
            gbc_lblTipCene.gridx = 0;
            gbc_lblTipCene.gridy = 6;
            this.panel.add((Component)this.lblTipCene, (Object)gbc_lblTipCene);
            this.cbTipCene = new JComboBox();
            this.cbTipCene.addItem(new PzChoice("Nije bitno", null));
            this.cbTipCene.addItem(new PzChoice("Prodajna", (Object)"PROD"));
            this.cbTipCene.addItem(new PzChoice("Prose\u010dna nabavna", (Object)"PRNC"));
            this.cbTipCene.setSelectedIndex(0);
            this.cbTipCene.setFont(new Font("SansSerif", 0, 14));
            GridBagConstraints gbc_cbTipCene = new GridBagConstraints();
            gbc_cbTipCene.anchor = 17;
            gbc_cbTipCene.insets = new Insets(0, 0, 5, 5);
            gbc_cbTipCene.fill = 3;
            gbc_cbTipCene.gridx = 1;
            gbc_cbTipCene.gridy = 6;
            this.panel.add((Component)this.cbTipCene, (Object)gbc_cbTipCene);
            this.jLabel2 = new JLabel();
            this.panel.add((Component)this.jLabel2, (Object)new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.jLabel2.setText("Naziv sheme");
            this.podtipDokumenta = new JComboBox();
            this.panel.add((Component)this.podtipDokumenta, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
            this.podtipDokumenta.setFont(new Font("Tahoma", 0, 14));
            this.podtipDokumenta.setBounds(766, 26, 102, 25);
            this.podtipDokumenta.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    if (evt.getStateChange() != 1) {
                        return;
                    }
                    PzDialogNovaShema.this.predloziNazivSheme();
                }
            });
            this.naziv = new PzTextField();
            this.panel.add((Component)this.naziv, (Object)new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.naziv.setFont(new Font("Tahoma", 0, 14));
            this.naziv.setMaxLength(100);
            this.naziv.setSize(80, 24);
            this.naziv.setVerifyInput(true);
            this.pnlVelikoprodaja = new PzPanel();
            this.panel.add((Component)this.pnlVelikoprodaja, (Object)new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.pnlVelikoprodaja.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Izbor radne jedinice", 4, 0));
            GridBagLayout panelLayout1 = new GridBagLayout();
            panelLayout1.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0};
            int[] nArray2 = new int[7];
            nArray2[0] = 27;
            nArray2[1] = 30;
            nArray2[2] = -1;
            nArray2[3] = 30;
            nArray2[4] = 30;
            nArray2[5] = 30;
            panelLayout1.rowHeights = nArray2;
            panelLayout1.columnWeights = new double[]{0.0, 0.0, 1.0};
            panelLayout1.columnWidths = new int[]{23, 67, 233};
            this.pnlVelikoprodaja.setLayout((LayoutManager)panelLayout1);
            this.btnGroupVTip = new ButtonGroup();
            this.vTipObicna = new JRadioButton();
            this.pnlVelikoprodaja.add((Component)this.vTipObicna, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.vTipObicna.setText("Konkretna radna jedinica");
            this.vTipObicna.setBounds(18, 20, 203, 18);
            this.vTipObicna.setActionCommand("konkrentnaRJ");
            this.btnGroupVTip.add(this.vTipObicna);
            this.vTipObicna.setSelected(true);
            this.vTipObicna.addActionListener((ActionListener)((Object)this));
            this.vTipReklamacije = new JRadioButton();
            this.pnlVelikoprodaja.add((Component)this.vTipReklamacije, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.vTipReklamacije.setText("Tip radne jedinice");
            this.vTipReklamacije.setBounds(18, 85, 124, 18);
            this.vTipReklamacije.setActionCommand("pojedinacnaRJ");
            this.vTipReklamacije.addActionListener((ActionListener)((Object)this));
            this.btnGroupVTip.add(this.vTipReklamacije);
            this.jLabel4 = new JLabel();
            this.pnlVelikoprodaja.add((Component)this.jLabel4, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.jLabel4.setText("Radna jedinica");
            this.jLabelNaziv = new JTextField();
            this.jLabelNaziv.setFocusable(false);
            this.jLabelNaziv.setEditable(false);
            this.pnlVelikoprodaja.add((Component)this.jLabelNaziv, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.jLabelNaziv.setText(" ");
            this.jLabel6 = new JLabel();
            this.pnlVelikoprodaja.add((Component)this.jLabel6, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.jLabel6.setText("Tip RJ");
            this.jLabel7 = new JLabel();
            this.pnlVelikoprodaja.add((Component)this.jLabel7, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.jLabel7.setText("Podtip RJ");
            this.tipRJCB = new JComboBox();
            this.pnlVelikoprodaja.add((Component)this.tipRJCB, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
            this.tipRJCB.setBounds(766, 26, 102, 25);
            this.tipRJCB.setEnabled(false);
            this.tipRJCB.addItem("");
            this.tipRJCB.addItem("V");
            this.tipRJCB.addItem("E");
            this.tipRJCB.addItem("T");
            this.tipRJCB.addItem("K");
            this.tipRJCB.addItem("S");
            this.tipRJCB.addItem("P");
            this.tipRJCB.addItem("G");
            this.tipRJCB.addItem("N");
            this.tipRJCB.addItem("C");
            this.tipRJCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    if (evt.getStateChange() != 1) {
                        return;
                    }
                    if (PzDialogNovaShema.this.tipRJCB.getSelectedItem().toString().equals("C")) {
                        PzDialogNovaShema.this.podtipRJCB.removeAllItems();
                        PzDialogNovaShema.this.podpodtipRJCB.removeAllItems();
                    }
                    if (PzDialogNovaShema.this.tipRJCB.getSelectedItem().toString().equals("V")) {
                        PzDialogNovaShema.this.podtipRJCB.removeAllItems();
                        PzDialogNovaShema.this.podpodtipRJCB.removeAllItems();
                        PzDialogNovaShema.this.podtipRJCB.addItem("");
                        PzDialogNovaShema.this.podtipRJCB.addItem("R");
                        PzDialogNovaShema.this.podtipRJCB.addItem("S");
                    }
                    if (PzDialogNovaShema.this.tipRJCB.getSelectedItem().toString().equals("E")) {
                        PzDialogNovaShema.this.podtipRJCB.removeAllItems();
                        PzDialogNovaShema.this.podpodtipRJCB.removeAllItems();
                        PzDialogNovaShema.this.podpodtipRJCB.addItem("");
                        PzDialogNovaShema.this.podtipRJCB.addItem("");
                        PzDialogNovaShema.this.podtipRJCB.addItem("L");
                        PzDialogNovaShema.this.podtipRJCB.addItem("V");
                        PzDialogNovaShema.this.podtipRJCB.addItem("T");
                        PzDialogNovaShema.this.podtipRJCB.addItem("P");
                        PzDialogNovaShema.this.podtipRJCB.addItem("W");
                    }
                    if (PzDialogNovaShema.this.tipRJCB.getSelectedItem().toString().equals("T")) {
                        PzDialogNovaShema.this.podtipRJCB.removeAllItems();
                        PzDialogNovaShema.this.podpodtipRJCB.removeAllItems();
                    }
                    if (PzDialogNovaShema.this.tipRJCB.getSelectedItem().toString().equals("K")) {
                        PzDialogNovaShema.this.podtipRJCB.removeAllItems();
                        PzDialogNovaShema.this.podpodtipRJCB.removeAllItems();
                    }
                    if (PzDialogNovaShema.this.tipRJCB.getSelectedItem().toString().equals("S")) {
                        PzDialogNovaShema.this.podtipRJCB.removeAllItems();
                        PzDialogNovaShema.this.podpodtipRJCB.removeAllItems();
                        PzDialogNovaShema.this.podtipRJCB.addItem("");
                        PzDialogNovaShema.this.podtipRJCB.addItem("R");
                    }
                    if (PzDialogNovaShema.this.tipRJCB.getSelectedItem().toString().equals("P")) {
                        PzDialogNovaShema.this.podtipRJCB.removeAllItems();
                        PzDialogNovaShema.this.podpodtipRJCB.removeAllItems();
                    }
                    if (PzDialogNovaShema.this.tipRJCB.getSelectedItem().toString().equals("N")) {
                        PzDialogNovaShema.this.podtipRJCB.removeAllItems();
                        PzDialogNovaShema.this.podpodtipRJCB.removeAllItems();
                    }
                    if (PzDialogNovaShema.this.tipRJCB.getSelectedItem().toString().equals("")) {
                        PzDialogNovaShema.this.podtipRJCB.removeAllItems();
                        PzDialogNovaShema.this.podpodtipRJCB.removeAllItems();
                    }
                    PzDialogNovaShema.this.predloziNazivSheme();
                }
            });
            this.podtipRJCB = new JComboBox();
            this.pnlVelikoprodaja.add((Component)this.podtipRJCB, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
            this.podtipRJCB.setBounds(766, 26, 102, 25);
            this.podtipRJCB.setEnabled(false);
            this.podtipRJCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    if (evt.getStateChange() != 1) {
                        return;
                    }
                    if (PzDialogNovaShema.this.tipRJCB.getSelectedItem().toString().equals("E") && PzDialogNovaShema.this.podtipRJCB.getSelectedItem() != null && PzDialogNovaShema.this.podtipRJCB.getSelectedItem().toString().equals("L")) {
                        PzDialogNovaShema.this.podpodtipRJCB.removeAllItems();
                        PzDialogNovaShema.this.podpodtipRJCB.addItem("");
                        PzDialogNovaShema.this.podpodtipRJCB.addItem("K");
                        PzDialogNovaShema.this.podpodtipRJCB.addItem("R");
                    }
                    PzDialogNovaShema.this.predloziNazivSheme();
                }
            });
            this.radnaJedinicaField = new PzTextField();
            this.pnlVelikoprodaja.add((Component)this.radnaJedinicaField, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
            this.radnaJedinicaField.setMaxLength(10);
            this.radnaJedinicaField.setSize(80, 24);
            this.radnaJedinicaField.setFKField(Radnajedinica.class, PzDialogRJ.class, true, null);
            this.radnaJedinicaField.setEntityChecker(new PzEntityChecker(){

                public PzEntity getEntity() {
                    try {
                        PzDialogNovaShema.this.radnajedinica = (Radnajedinica)PzEntityManager.find(Radnajedinica.class, (Object)new RadnajedinicaPK("1", PzDialogNovaShema.this.radnaJedinicaField.getVal()));
                        PzDialogNovaShema.this.predloziNazivSheme();
                        return PzDialogNovaShema.this.radnajedinica;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        PzMysqlExceptionHandler.handle((Component)((Object)PzDialogNovaShema.this), (Throwable)e);
                        return null;
                    }
                }
            });
            this.radnaJedinicaField.setVerifyInput(true);
            this.jLabel8 = new JLabel();
            this.pnlVelikoprodaja.add((Component)this.jLabel8, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.jLabel8.setText("Pod podtip RJ");
            this.podpodtipRJCB = new JComboBox();
            this.pnlVelikoprodaja.add((Component)this.podpodtipRJCB, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
            this.podpodtipRJCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    if (evt.getStateChange() != 1) {
                        return;
                    }
                    PzDialogNovaShema.this.predloziNazivSheme();
                }
            });
            this.podpodtipRJCB.setEnabled(false);
            this.lblOpisNaStavovima = new JLabel("Opis na stavovima");
            GridBagConstraints gbc_lblOpisNaStavovima = new GridBagConstraints();
            gbc_lblOpisNaStavovima.anchor = 13;
            gbc_lblOpisNaStavovima.insets = new Insets(0, 0, 5, 5);
            gbc_lblOpisNaStavovima.gridx = 0;
            gbc_lblOpisNaStavovima.gridy = 8;
            this.panel.add((Component)this.lblOpisNaStavovima, (Object)gbc_lblOpisNaStavovima);
            this.txtOpis = new PzTextField();
            GridBagConstraints gbc_txtOpis = new GridBagConstraints();
            gbc_txtOpis.gridwidth = 2;
            gbc_txtOpis.insets = new Insets(0, 0, 5, 0);
            gbc_txtOpis.fill = 2;
            gbc_txtOpis.gridx = 1;
            gbc_txtOpis.gridy = 8;
            this.panel.add((Component)this.txtOpis, (Object)gbc_txtOpis);
            this.chkZatvaraNalog = new JCheckBox();
            this.panel.add((Component)this.chkZatvaraNalog, (Object)new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
            this.chkZatvaraNalog.setText("Zatvara nalog");
            this.chkZatvaraNalog.setBounds(17, 22, 233, 18);
            this.pack();
            this.setSize(520, 493);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent e) {
        EntityManager em = PzEntityManager.getEm();
        String actionCommand = e.getActionCommand();
        if (actionCommand.equalsIgnoreCase("odustajanje")) {
            this.dispose();
        }
        if (actionCommand.equalsIgnoreCase("konkrentnaRJ")) {
            this.tipRJCB.setEnabled(false);
            this.podtipRJCB.setEnabled(false);
            this.podpodtipRJCB.setEnabled(false);
            this.radnaJedinicaField.setEnabled(true);
            this.predloziNazivSheme();
        }
        if (actionCommand.equalsIgnoreCase("pojedinacnaRJ")) {
            this.tipRJCB.setEnabled(true);
            this.podtipRJCB.setEnabled(true);
            this.podpodtipRJCB.setEnabled(true);
            this.radnaJedinicaField.setEnabled(false);
            this.predloziNazivSheme();
        }
        if (actionCommand.equals("insert") || Boolean.TRUE.equals(this.getSession().getParameter("copy"))) {
            try {
                if (this.naziv.getVal().equals("")) {
                    PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot((Component)((Object)this)), (String)"Morate uneti naziv sheme.");
                    this.naziv.requestFocus();
                    return;
                }
                if (this.vTipObicna.isSelected() && this.radnaJedinicaField.getVal().equals("")) {
                    PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot((Component)((Object)this)), (String)"Morate uneti radnu jedinicu.");
                    this.vTipObicna.requestFocus();
                    return;
                }
                Shema shema = new Shema();
                TipDokumentStructure.Tip tipDok = (TipDokumentStructure.Tip)this.tipDokumenta.getSelectedItem();
                TipDokumentStructure.PodTip podtipDok = null;
                if (this.podtipDokumenta.getSelectedItem() != null) {
                    podtipDok = this.podtipDokumenta.getSelectedItem().equals("") ? null : (TipDokumentStructure.PodTip)this.podtipDokumenta.getSelectedItem();
                }
                ShemaPK shemaPK = new ShemaPK();
                shemaPK.setTipDok(tipDok.getTip());
                if (podtipDok == null) {
                    shemaPK.setPodTipDok("");
                } else {
                    shemaPK.setPodTipDok(podtipDok.getPodTip());
                }
                shema.setAbstrakt((short)(this.chckbxAbstraktnaShema.isSelected() ? 1 : 0));
                shema.setOpis(this.naziv.getVal());
                shema.setCena((String)((PzChoice)this.cbTipCene.getSelectedItem()).getValue());
                shema.setOpisKnjizenja(this.txtOpis.getVal());
                if (this.vTipObicna.isSelected()) {
                    shemaPK.setOznOgranak("1");
                    shemaPK.setOznRj(this.radnajedinica.getId().getOznRj());
                    shemaPK.setTipRj(this.radnajedinica.getgTip());
                    shemaPK.setpTipRj(this.radnajedinica.getpTip());
                    shemaPK.setPpTipRj(this.radnajedinica.getPpTip());
                } else if (this.vTipReklamacije.isSelected()) {
                    shemaPK.setOznOgranak("");
                    shemaPK.setOznRj("");
                    shemaPK.setTipRj(this.tipRJCB.getSelectedItem().toString());
                    if (this.podtipRJCB.getSelectedItem() != null) {
                        shemaPK.setpTipRj(this.podtipRJCB.getSelectedItem().toString());
                    } else {
                        shemaPK.setpTipRj("");
                    }
                    if (this.podpodtipRJCB.getSelectedItem() != null) {
                        shemaPK.setPpTipRj(this.podpodtipRJCB.getSelectedItem().toString());
                    } else {
                        shemaPK.setPpTipRj("");
                    }
                }
                Shema pomocna = (Shema)PzEntityManager.find(Shema.class, (Object)shemaPK);
                if (pomocna != null) {
                    PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot((Component)((Object)this)), (String)"Shema ve\u0107 postoji!");
                    return;
                }
                try {
                    Integer n;
                    shema.setId(shemaPK);
                    shema.setNadSheme(this.getNadSheme());
                    if (this.chkZatvaraNalog.isSelected()) {
                        shema.setZatvori(Integer.valueOf(1));
                    } else {
                        shema.setZatvori(Integer.valueOf(0));
                    }
                    try {
                        n = (Integer)em.createQuery("SELECT MAX(s.rBroj) FROM Shema s").getResultList().get(0);
                        if (n == null) {
                            n = new Integer(0);
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        n = new Integer(0);
                    }
                    n = n + 1;
                    if (Boolean.TRUE.equals(this.getSession().getParameter("copy"))) {
                        Shema pomocnashema = (Shema)((PzTable)this.getSession().getParameter("table")).getSelectedEntity();
                        shema.setStavkashemes(pomocnashema.getStavkashemes());
                        for (Stavkasheme stavka : shema.getStavkashemes()) {
                            StavkashemePK id = new StavkashemePK(shema.getId(), stavka.getId().getrBroj().intValue());
                            stavka.setId(id);
                        }
                    }
                    shema.setrBroj(n);
                    em.getTransaction().begin();
                    ((PzTable)this.getSession().getParameter("table")).insert((PzEntity)shema, em);
                    em.getTransaction().commit();
                    ((PzTable)this.getSession().getParameter("table")).commitInsert();
                    this.dispose();
                    return;
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                        em.close();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                }
                return;
            }
            finally {
                em.close();
            }
        }
        if (!actionCommand.equals("update")) return;
        try {
            if (this.naziv.getVal().equals("")) {
                PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot((Component)((Object)this)), (String)"Morate uneti naziv sheme.");
                this.naziv.requestFocus();
                return;
            }
            try {
                if (this.vTipObicna.isSelected() && this.radnaJedinicaField.getVal().equals("")) {
                    PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot((Component)((Object)this)), (String)"Morate uneti radnu jedinicu.");
                    this.vTipObicna.requestFocus();
                    return;
                }
                Shema pomocnashema = (Shema)((PzTable)this.getSession().getParameter("table")).getSelectedEntity();
                Shema shema = new Shema();
                TipDokumentStructure.Tip tipDok = (TipDokumentStructure.Tip)this.tipDokumenta.getSelectedItem();
                TipDokumentStructure.PodTip podtipDok = null;
                if (this.podtipDokumenta.getSelectedItem() != null) {
                    podtipDok = this.podtipDokumenta.getSelectedItem().equals("") ? null : (TipDokumentStructure.PodTip)this.podtipDokumenta.getSelectedItem();
                }
                ShemaPK shemaPK = new ShemaPK();
                shemaPK.setTipDok(tipDok.getTip());
                if (podtipDok == null) {
                    shemaPK.setPodTipDok("");
                } else {
                    shemaPK.setPodTipDok(podtipDok.getPodTip());
                }
                shema.setAbstrakt((short)(this.chckbxAbstraktnaShema.isSelected() ? 1 : 0));
                shema.setOpis(this.naziv.getVal());
                shema.setCena((String)((PzChoice)this.cbTipCene.getSelectedItem()).getValue());
                shema.setOpisKnjizenja(this.txtOpis.getVal());
                if (this.vTipObicna.isSelected()) {
                    shemaPK.setOznOgranak("1");
                    shemaPK.setOznRj(this.radnajedinica.getId().getOznRj());
                    shemaPK.setTipRj(this.radnajedinica.getgTip());
                    shemaPK.setpTipRj(this.radnajedinica.getpTip());
                    shemaPK.setPpTipRj(this.radnajedinica.getPpTip());
                } else if (this.vTipReklamacije.isSelected()) {
                    shemaPK.setOznOgranak("");
                    shemaPK.setOznRj("");
                    shemaPK.setTipRj(this.tipRJCB.getSelectedItem().toString());
                    if (this.podtipRJCB.getSelectedItem() != null) {
                        shemaPK.setpTipRj(this.podtipRJCB.getSelectedItem().toString());
                    } else {
                        shemaPK.setpTipRj("");
                    }
                    if (this.podpodtipRJCB.getSelectedItem() != null) {
                        shemaPK.setPpTipRj(this.podpodtipRJCB.getSelectedItem().toString());
                    } else {
                        shemaPK.setPpTipRj("");
                    }
                }
                shema.setId(shemaPK);
                shema.setNadSheme(this.getNadSheme());
                if (this.chkZatvaraNalog.isSelected()) {
                    shema.setZatvori(Integer.valueOf(1));
                } else {
                    shema.setZatvori(Integer.valueOf(0));
                }
                shema.setStavkashemes(pomocnashema.getStavkashemes());
                shema.setrBroj(pomocnashema.getrBroj());
                for (Stavkasheme stavka : shema.getStavkashemes()) {
                    StavkashemePK id = new StavkashemePK(shema.getId(), stavka.getId().getrBroj().intValue());
                    stavka.setId(id);
                }
                em.getTransaction().begin();
                em.remove(em.find(Shema.class, (Object)pomocnashema.getId()));
                em.flush();
                em.persist((Object)shema);
                em.getTransaction().commit();
                ((PzTable)this.getSession().getParameter("table")).updateSelectedEntity((PzEntity)shema, false);
                this.dispose();
                return;
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                    em.close();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
            return;
        }
        finally {
            em.close();
        }
    }

    private List<Shema> getNadSheme() {
        Vector<Shema> nadsheme = new Vector<Shema>();
        int i = 0;
        while (i < ((DefaultListModel)this.lstNasledjuje.getModel()).getSize()) {
            nadsheme.add((Shema)((DefaultListModel)this.lstNasledjuje.getModel()).get(i));
            ++i;
        }
        return nadsheme;
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogNovaShema(Boolean.FALSE);
    }

    public PzDialogNovaShema(Boolean initGUI) {
    }

    protected void onInsert() {
        this.btnOK.setActionCommand("insert");
    }

    protected void onUpdate() {
        this.btnOK.setActionCommand("update");
        Shema sh = (Shema)this.getSession().getParameter("shema");
        String tip = sh.getId().getTipDok();
        String podtip = sh.getId().getPodTipDok();
        this.popuniTipoveDokumenata();
        int i = 0;
        while (i < this.tipDokumenta.getItemCount()) {
            if (((TipDokumentStructure.Tip)this.tipDokumenta.getItemAt(i)).getTip().equals(tip)) {
                this.tipDokumenta.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        if (podtip.equals("")) {
            this.podtipDokumenta.setSelectedIndex(0);
        } else {
            i = 1;
            while (i < this.podtipDokumenta.getItemCount()) {
                if (((TipDokumentStructure.PodTip)this.podtipDokumenta.getItemAt(i)).getPodTip().equals(podtip)) {
                    this.podtipDokumenta.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
        if (sh.getZatvori() == 1) {
            this.chkZatvaraNalog.setSelected(true);
        }
        this.naziv.setVal((Object)sh.getOpis());
        this.txtOpis.setVal((Object)sh.getOpisKnjizenja());
        this.chckbxAbstraktnaShema.setSelected(sh.getAbstrakt() == 1);
        if (sh.getCena() != null) {
            if (sh.getCena().equals("PROD")) {
                this.cbTipCene.setSelectedIndex(1);
            } else if (sh.getCena().equals("PRNC")) {
                this.cbTipCene.setSelectedIndex(2);
            } else {
                this.cbTipCene.setSelectedIndex(0);
            }
        }
        if (sh.getId().getOznOgranak().equals("") && sh.getId().getOznRj().equals("")) {
            this.vTipReklamacije.setSelected(true);
            this.tipRJCB.setEnabled(true);
            this.podtipRJCB.setEnabled(true);
            this.podpodtipRJCB.setEnabled(true);
            this.radnaJedinicaField.setEnabled(false);
            String glTip = sh.getId().getTipRj();
            String podTip = sh.getId().getpTipRj();
            String podpodTip = sh.getId().getPpTipRj();
            int i2 = 0;
            while (i2 < this.tipRJCB.getItemCount()) {
                if (this.tipRJCB.getItemAt(i2).toString().equals(glTip)) {
                    this.tipRJCB.setSelectedIndex(i2);
                    break;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.podtipRJCB.getItemCount()) {
                if (this.podtipRJCB.getItemAt(i2).toString().equals(podTip)) {
                    this.podtipRJCB.setSelectedIndex(i2);
                    break;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.podpodtipRJCB.getItemCount()) {
                if (this.podpodtipRJCB.getItemAt(i2).toString().equals(podpodTip)) {
                    this.podpodtipRJCB.setSelectedIndex(i2);
                    break;
                }
                ++i2;
            }
        } else {
            this.vTipObicna.setSelected(true);
            RadnajedinicaPK rjPK = new RadnajedinicaPK(sh.getId().getOznOgranak(), sh.getId().getOznRj());
            try {
                Radnajedinica rj = (Radnajedinica)PzEntityManager.find(Radnajedinica.class, (Object)rjPK);
                this.jLabelNaziv.setText(rj.getNaziv().trim());
                this.radnajedinica = rj;
                this.radnaJedinicaField.setVal((Object)rj.getId().getOznRj());
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
        for (Shema ss : sh.getNadSheme()) {
            ((DefaultListModel)this.lstNasledjuje.getModel()).addElement(ss);
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity == null) {
            return;
        }
        this.jLabelNaziv.setText(((Radnajedinica)entity).getNaziv().trim());
        this.radnajedinica = (Radnajedinica)entity;
        this.radnaJedinicaField.setVal((Object)((Radnajedinica)entity).getId().getOznRj());
    }

    protected void setHeaderOnInsert() {
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/product_add.png")));
        this.setHeaderTitle("Nova shema knji\u017eenja");
    }

    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Izmena sheme knji\u017eenja");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/product_edit.png")));
    }

    private void popuniTipoveDokumenata() {
        List tipovi = TipDokumentStructure.loadStructure();
        for (TipDokumentStructure.Tip tip : tipovi) {
            this.tipDokumenta.addItem(tip);
        }
    }

    private void predloziNazivSheme() {
        String tipdok = "";
        String podtipdok = "";
        String tipRJ = "";
        String podtipRJ = "";
        String podpodtipRJ = "";
        String oznRJ = "";
        String ukupnoTipRJ = "";
        tipdok = this.tipDokumenta.getSelectedItem().toString();
        podtipdok = this.podtipDokumenta.getSelectedItem().toString();
        if (this.vTipReklamacije.isSelected()) {
            tipRJ = this.tipRJCB.getSelectedItem().toString();
            podtipRJ = this.podtipRJCB.getSelectedItem() == null ? "" : this.podtipRJCB.getSelectedItem().toString();
            podpodtipRJ = this.podpodtipRJCB.getSelectedItem() == null ? "" : this.podpodtipRJCB.getSelectedItem().toString();
            if (!tipRJ.equals("")) {
                ukupnoTipRJ = "{" + tipRJ + podtipRJ + podpodtipRJ + "} ";
            }
            if (!podtipdok.equals("")) {
                podtipdok = " (" + podtipdok + ") ";
            }
        } else if (this.vTipObicna.isSelected()) {
            if (this.radnajedinica != null) {
                tipRJ = this.radnajedinica.getgTip();
                podtipRJ = this.radnajedinica.getpTip();
                podpodtipRJ = this.radnajedinica.getPpTip();
            } else {
                tipRJ = "";
                podtipRJ = "";
                podpodtipRJ = "";
            }
            if (!tipRJ.equals("")) {
                ukupnoTipRJ = "{" + tipRJ + podtipRJ + podpodtipRJ + "} ";
            }
            if (!podtipdok.equals("")) {
                podtipdok = " (" + podtipdok + ") ";
            }
        }
        if (!this.radnaJedinicaField.getVal().equals("")) {
            oznRJ = PzEntityUtil.strZero((String)this.radnaJedinicaField.getVal(), (int)3);
            oznRJ = "[" + oznRJ + "]";
        }
        if (this.vTipReklamacije.isSelected()) {
            oznRJ = "";
        }
        this.naziv.setVal((Object)(String.valueOf(tipdok) + podtipdok + ukupnoTipRJ + oznRJ));
    }

    protected void btnDodajactionPerformed(ActionEvent arg0) {
        try {
            PzEntityFilter filter = new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Shema s = (Shema)entity;
                    return new Object[]{s.getrBroj(), s.getOpis()};
                }

                public String[] getColumnNames() {
                    return new String[]{"Br. sheme", "Opis"};
                }
            };
            List nadsheme = PzGenericTableDialog.showDialog((PzDialog)this, Shema.class, (List)PzEntityManager.getList((String)"SELECT s FROM Shema s"), (String)"Izbor sheme za knji\u017eenej", (String)"Izaberite sheme \u010dije \u0107e se stavke naslediti", (int)0, (PzEntityFilter)filter);
            if (nadsheme == null || nadsheme.size() == 0) {
                return;
            }
            for (PzEntity e : nadsheme) {
                ((DefaultListModel)this.lstNasledjuje.getModel()).addElement(e);
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected void btnBrisiactionPerformed(ActionEvent arg0) {
        if (this.lstNasledjuje.getSelectedIndex() == -1) {
            return;
        }
        ((DefaultListModel)this.lstNasledjuje.getModel()).remove(this.lstNasledjuje.getSelectedIndex());
    }
}

