/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui.nalogZaKnjizenje.akcije;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Komitent;
import rs.pezar.finansije.engine.sifreKnjizenja.manager.StornoRacunaKupcaManager;
import rs.pezar.finansije.engine.sifreKnjizenja.manager.UplataManager;
import rs.pezar.finansije.gui.nalogZaKnjizenje.akcije.FaktureKupca;
import rs.pezar.finansije.gui.nalogZaKnjizenje.akcije.PzComponentFactory;
import rs.pezar.finansije.gui.nalogZaKnjizenje.akcije.PzDialogAkcija;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.custom.PzTablePorez;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class StornoRacunaKupca
extends PzDialogAkcija {
    private static final String SA_POREZOM = "Sa porezom";
    private static final String BEZ_POREZA = "Bez poreza";
    private static final String SA_PRAVOM = "Sa pravom na odbitak";
    private static final String BEZ_PRAVA = "Bez prava na odbitak";
    private static final String KEPU_R_Z = "KEPU: zadu\u017eenje i razdu\u017eenje";
    private static final String KEPU_R = "KEPU: razdu\u017eenje";
    private PzPanel mainPanel;
    private PzPanelHeader pnlHeader;
    private PzPanel contentPanel;
    private PzDateField dfDatumKnjizenja;
    private PzTextField tfBrojFakture;
    private JLabel lblBrojFakture;
    private PzTextField tfNazivKupca;
    private PzFieldIndikator indKupac;
    private PzNumericOnlyTextField tfSifraKupca;
    private JLabel lblSifraKupca;
    private PzDoubleField dfDug;
    private JLabel lblDug;
    private JLabel lblUplate;
    private PzDoubleField dfStornirano;
    private JLabel lblStornirano;
    private PzDoubleField dfIznos;
    private JLabel lblIznos;
    private JLabel lblIznosFakture;
    private JButton btnPotvrdi;
    private JLabel lblDatumValute;
    private JLabel lblDatumDPO;
    private PzDoubleField dfObracunatIznos;
    private JLabel lblObracunatIznos;
    private JScrollPane scrollPane;
    private PzRadioGroup<String> panelRbs1;
    private PzDoubleField dfStornoIznos;
    private JLabel lblStornoIznos;
    private JLabel lblDatumKnjizenja;
    private PzTablePorez tblPorez;
    private PzRadioGroup<String> panelRbs3;
    private PzRadioGroup<String> panelRbs2;
    private PzDoubleField dfUplata;
    private PzDokument faktura;
    private Komitent komitent;

    public static void main(String[] args) {
        try {
            StornoRacunaKupca dialog = new StornoRacunaKupca();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public StornoRacunaKupca() {
        this.initGUI();
    }

    public StornoRacunaKupca(PzDialog parent) {
        super(parent);
        this.initGUI();
    }

    @Override
    public Date getDatKnjizenja() {
        return this.dfDatumKnjizenja.getVal();
    }

    @Override
    public PzDokument getNewDokument() throws Exception {
        Faktura f = new Faktura();
        f.setDatPrometa(this.dfDatumKnjizenja.getVal());
        f.setDatum(this.dfDatumKnjizenja.getVal());
        f.setIznos(this.dfStornoIznos.getBigDecimal());
        f.setIznosBezPoreza(new BigDecimal(0));
        f.setKomitent(this.faktura.getKomitent());
        f.setNabavnaUkupno(new BigDecimal(0));
        f.setrBroj(f.getrBroj());
        f.setOznDokumenta(this.faktura.getOznDokumenta());
        f.setPodTip(TipDokumentConfig.get().PODTIP_FAKTURA_SA_NALOGA);
        f.setTip(TipDokumentConfig.get().FAKTURA);
        f.setSaPorezom(((String)this.panelRbs1.getSelectedValue()).equals(SA_POREZOM) ? 1 : 0);
        f.setSaPravomNaOdbitak(((String)this.panelRbs2.getSelectedValue()).equals(SA_PRAVOM) ? 1 : 0);
        f.setTaksafakturas(this.tblPorez.getPorezi());
        f.setRadnajedinica(this.faktura.getRadnajedinica());
        f.setStorno(1);
        f.setOriginal(this.faktura);
        f.setVrsta(((String)this.panelRbs3.getSelectedValue()).equals(KEPU_R) ? "R" : "Z");
        return f;
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.mainPanel = new PzPanel();
            BorderLayout mainPanelLayout = new BorderLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setPreferredSize(new Dimension(612, 350));
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.pnlHeader = new PzPanelHeader();
            this.pnlHeader.setOpaque(false);
            this.pnlHeader.setTitle("Knji\u017eenje storno fakture kupca");
            this.mainPanel.add((Component)this.pnlHeader, (Object)"North");
            this.contentPanel = new PzPanel();
            GridBagLayout contentPanelLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.contentPanel, (Object)"Center");
            contentPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            contentPanelLayout.rowHeights = new int[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
            contentPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            contentPanelLayout.columnWidths = new int[]{100, 120, 220, 220, 7};
            this.contentPanel.setLayout((LayoutManager)contentPanelLayout);
            this.lblDatumKnjizenja = new JLabel();
            this.contentPanel.add((Component)this.lblDatumKnjizenja, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 3, 0), 0, 0));
            this.lblDatumKnjizenja.setText("Datum knji\u017eenja");
            this.dfDatumKnjizenja = new PzDateField();
            this.contentPanel.add((Component)this.dfDatumKnjizenja, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.dfDatumKnjizenja.setName("dfDatumKnjizenja");
            this.lblSifraKupca = new JLabel();
            this.contentPanel.add((Component)this.lblSifraKupca, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 3, 0), 0, 0));
            this.lblSifraKupca.setText("\u0160ifra kupca");
            this.tfSifraKupca = PzComponentFactory.createKomitentField();
            this.contentPanel.add((Component)this.tfSifraKupca, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.indKupac = new PzFieldIndikator();
            this.contentPanel.add((Component)this.indKupac, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.tfNazivKupca = new PzTextField();
            this.contentPanel.add((Component)this.tfNazivKupca, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 25, 3, 0), 0, 0));
            this.tfNazivKupca.setFocusable(false);
            this.tfNazivKupca.setEnabled(false);
            this.lblBrojFakture = new JLabel();
            this.contentPanel.add((Component)this.lblBrojFakture, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 3, 0), 0, 0));
            this.lblBrojFakture.setText("Broj fakture");
            this.tfBrojFakture = PzComponentFactory.createOznDokumentaField(this.tfSifraKupca, 1, TipDokumentConfig.get().FAKTURA, null, this, null, null);
            this.tfBrojFakture.setName("brfak");
            this.contentPanel.add((Component)this.tfBrojFakture, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.lblStornoIznos = new JLabel();
            this.contentPanel.add((Component)this.lblStornoIznos, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 15, 3, 0), 0, 0));
            this.lblStornoIznos.setName("lblStornoIznos");
            this.dfStornoIznos = new PzDoubleField();
            this.contentPanel.add((Component)this.dfStornoIznos, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.lblIznos = new JLabel();
            this.contentPanel.add((Component)this.lblIznos, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 3, 0), 0, 0));
            this.lblIznos.setText("Iznos fakture");
            this.dfDug = new PzDoubleField();
            this.contentPanel.add((Component)this.dfDug, (Object)new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 90, 3, 0), 0, 0));
            this.dfDug.setFocusable(false);
            this.lblDug = new JLabel();
            this.contentPanel.add((Component)this.lblDug, (Object)new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.lblDug.setText("Dug");
            this.dfUplata = new PzDoubleField();
            this.contentPanel.add((Component)this.dfUplata, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 90, 0, 0), 0, 0));
            this.dfUplata.setFocusable(false);
            this.lblUplate = new JLabel();
            this.contentPanel.add((Component)this.lblUplate, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 3, 0), 0, 0));
            this.lblUplate.setText("Uplate");
            this.dfStornirano = new PzDoubleField();
            this.contentPanel.add((Component)this.dfStornirano, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 90, 3, 0), 0, 0));
            this.dfStornirano.setFocusable(false);
            this.lblStornirano = new JLabel();
            this.contentPanel.add((Component)this.lblStornirano, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 3, 0), 0, 0));
            this.lblStornirano.setText("Stornirano za");
            this.dfIznos = new PzDoubleField();
            this.contentPanel.add((Component)this.dfIznos, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 90, 3, 0), 0, 0));
            this.dfIznos.setFocusable(false);
            this.panelRbs1 = new PzRadioGroup((Object[])new String[]{SA_POREZOM, BEZ_POREZA});
            BoxLayout panelRBs2Layout = new BoxLayout((Container)this.panelRbs1, 1);
            this.panelRbs1.setLayout((LayoutManager)panelRBs2Layout);
            this.contentPanel.add(this.panelRbs1, (Object)new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.panelRbs1.setBorder((Border)BorderFactory.createTitledBorder(""));
            this.panelRbs1.setSelectedValue((Object)SA_POREZOM);
            this.panelRbs1.setOpaque(false);
            this.panelRbs1.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getStateChange() == 1) {
                        if (evt.getValue().equals(StornoRacunaKupca.SA_POREZOM)) {
                            StornoRacunaKupca.this.panelRbs2.setEnabled(false);
                            StornoRacunaKupca.this.tblPorez.setEnabled(true);
                        } else if (evt.getValue().equals(StornoRacunaKupca.BEZ_POREZA)) {
                            StornoRacunaKupca.this.panelRbs2.setEnabled(true);
                            StornoRacunaKupca.this.tblPorez.setEnabled(false);
                        }
                    }
                }
            });
            this.panelRbs2 = new PzRadioGroup((Object[])new String[]{SA_PRAVOM, BEZ_PRAVA});
            panelRBs2Layout = new BoxLayout((Container)this.panelRbs2, 1);
            this.panelRbs2.setLayout((LayoutManager)panelRBs2Layout);
            this.contentPanel.add(this.panelRbs2, (Object)new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.panelRbs2.setBorder((Border)BorderFactory.createTitledBorder(""));
            this.panelRbs2.setSelectedValue((Object)SA_PRAVOM);
            this.panelRbs2.setOpaque(false);
            this.panelRbs2.setEnabled(false);
            this.panelRbs3 = new PzRadioGroup((Object[])new String[]{KEPU_R_Z, KEPU_R});
            panelRBs2Layout = new BoxLayout((Container)this.panelRbs3, 1);
            this.panelRbs3.setLayout((LayoutManager)panelRBs2Layout);
            this.contentPanel.add(this.panelRbs3, (Object)new GridBagConstraints(0, 7, 2, 2, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.panelRbs3.setBorder((Border)BorderFactory.createTitledBorder(""));
            this.panelRbs3.setSelectedValue((Object)KEPU_R_Z);
            this.panelRbs3.setOpaque(false);
            this.scrollPane = new JScrollPane();
            this.contentPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(2, 5, 2, 2, 0.0, 0.0, 10, 1, new Insets(0, 5, 3, 0), 0, 0));
            this.tblPorez = this.createTablePorez();
            this.scrollPane.setViewportView((Component)this.tblPorez);
            this.lblObracunatIznos = new JLabel();
            this.contentPanel.add((Component)this.lblObracunatIznos, (Object)new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.lblObracunatIznos.setText("Obra\u010dunat iznos");
            this.dfObracunatIznos = this.tblPorez.createExpresionField("$2$+$3$");
            this.dfObracunatIznos.setFocusable(false);
            this.contentPanel.add((Component)this.dfObracunatIznos, (Object)new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 110, 0, 0), 0, 0));
            this.lblDatumDPO = new JLabel();
            this.contentPanel.add((Component)this.lblDatumDPO, (Object)new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 25, 0, 0), 0, 0));
            this.lblDatumDPO.setName("lblDatumDPO");
            this.lblDatumValute = new JLabel();
            this.contentPanel.add((Component)this.lblDatumValute, (Object)new GridBagConstraints(3, 8, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.lblDatumValute.setName("lblDatumValute");
            this.btnPotvrdi = new JButton();
            this.contentPanel.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(2, 9, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    StornoRacunaKupca.this.actionPerformedokButton(arg0);
                }
            });
            this.btnPotvrdi.setIcon(new ImageIcon(FaktureKupca.class.getResource("/rs/pezar/finansije/resource/img/check.png")));
            this.btnPotvrdi.setActionCommand("OK");
            this.tfSifraKupca.setStateIndikator(this.indKupac);
            this.pack();
            this.setSize(905, 429);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PzTablePorez createTablePorez() {
        return PzComponentFactory.createPzTablePorezFakturaKupca();
    }

    protected void actionPerformedokButton(ActionEvent arg0) {
        if (!this.contentPanel.validateForm(true)) {
            return;
        }
        this.commit();
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.komitent = (Komitent)entity;
            this.tfSifraKupca.setVal((Object)((Komitent)entity).getSfrKomitent());
            this.tfNazivKupca.setVal((Object)((Komitent)entity).getNaziv());
        } else if (entity instanceof PzDokument) {
            this.faktura = (PzDokument)entity;
            if (entity instanceof Faktura) {
                Faktura f = (Faktura)entity;
                this.dfIznos.setVal((Object)f.getIznos());
                this.dfStornirano.setVal((Object)f.getStornoIznos());
                this.dfUplata.setVal((Object)f.getUplata());
                this.dfDug.setVal((Object)f.getIznos().subtract(f.getStornoIznos()).subtract(f.getUplata()));
                this.dfStornoIznos.setVal((Object)this.dfDug.getVal());
                this.panelRbs1.setSelectedValue((Object)(f.getSaPorezom() == 1 ? SA_POREZOM : BEZ_POREZA));
                this.panelRbs2.setSelectedValue((Object)(f.getSaPravomNaOdbitak() == 1 ? SA_PRAVOM : BEZ_PRAVA));
            }
        }
    }

    @Override
    public void commit() {
        if (((String)this.panelRbs1.getSelectedValue()).equals(SA_POREZOM)) {
            if (!this.dfObracunatIznos.getVal().equals(this.dfStornoIznos.getVal())) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Unet iznos se ne poklapa sa zbirom unete osnovice i PDV-a. Ne mo\u017eete nastaviti dalje.");
            } else {
                super.commit();
            }
        } else {
            this.tblPorez.resetPorezi();
            super.commit();
        }
    }

    @Override
    public UplataManager getUplataManager() {
        return new StornoRacunaKupcaManager(this.faktura, null).addValue("STORNO_IZNOS", this.dfStornoIznos.getBigDecimal());
    }
}

