/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui.nalogZaKnjizenje.akcije;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.jdesktop.application.Application;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Komitentparameter;
import rs.pezar.db.entity.KomitentparameterPK;
import rs.pezar.db.entity.Konto;
import rs.pezar.db.entity.KontoPK;
import rs.pezar.db.entity.Kurs;
import rs.pezar.db.entity.KursPK;
import rs.pezar.db.entity.RacunDobavljaca;
import rs.pezar.db.entity.Stavkanzk;
import rs.pezar.db.entity.StavkanzkPK;
import rs.pezar.finansije.gui.nalogZaKnjizenje.akcije.PzComponentFactory;
import rs.pezar.finansije.gui.nalogZaKnjizenje.akcije.PzDialogAkcija;
import rs.pezar.finansije.gui.nalogZaKnjizenje.akcije.PzDialogVerificationURL;
import rs.pezar.finansije.gui.util.VerificationURLDecoder;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.custom.PzDialogPorezFiskal;
import rs.pezar.swing.custom.PzDialogPorezIznos;
import rs.pezar.swing.custom.PzTablePorez;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;
import rs.pezar.util.PzUlazniRacunKategorijaUtil;
import rs.pezar.util.beanConverters.BBBigDecimalConverter;
import rs.pezar.util.beanConverters.BBDateConverter;

public class FakturaDobavljaca
extends PzDialogAkcija {
    private static final long serialVersionUID = 6791724554481693146L;
    private final PzPanel contentPanel = new PzPanel();
    private PzPanelHeader pnlHeader;
    private PzPanel pnlForm;
    private JLabel lblifraDobavljaa;
    private PzNumericOnlyTextField numSifraDobavljaca;
    private JLabel lblOznakaFakture;
    private PzTextField txtOznDokumenta;
    private JLabel lblIznosFakture;
    private JButton btnQr;
    private PzRadioGroup<PzUlazniRacunKategorijaUtil.UlazniRacunKategorija> rgrKategorija;
    private PzDoubleField dblIznos;
    private JScrollPane scp;
    private PzDoubleField dfIznosUValuti;
    private JLabel lblIznosUValuti;
    private PzTextField txtNazivKonta;
    private PzTablePorez tblPorez;
    private JLabel lblObraunatIznos;
    private PzDoubleField dblObracunatIznos;
    private JLabel lblDatumKnjienja;
    private JLabel lblDatumFakture;
    private JLabel lblDatumValute;
    private PzDateField datKnjizenja;
    private PzDateField datFakture;
    private PzDateField datValute;
    private JLabel lblKontoZaTroak;
    private PzNumericOnlyTextField numKonto;
    private PzRadioGroup<PzChoice> rgrPdv;
    private PzTextField txtNazivDobavljaca;
    private RacunDobavljaca faktura;
    private Komitent komitent;
    private PzTextField txtAnalitika;
    private String nazivKonta;
    protected Kurs kurs;
    private final String stranaValuta;
    private EntityManager em;

    public static void main(String[] args) {
        try {
            FakturaDobavljaca dialog = new FakturaDobavljaca();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FakturaDobavljaca() {
        this.initGUI();
        this.stranaValuta = PzParameter.getParameterValue((String)"DEF_VALUTA", (String)"EUR");
        this.lblIznosUValuti.setText("Iznos u valuti-" + this.stranaValuta);
    }

    public FakturaDobavljaca(PzDialog parent) {
        super(parent);
        this.initGUI();
        this.datKnjizenja.setVal((Object)this.getDatKnjizenjaTemp());
        this.stranaValuta = PzParameter.getParameterValue((String)"DEF_VALUTA", (String)"EUR");
        this.lblIznosUValuti.setText("Iznos u valuti-" + this.stranaValuta);
    }

    @Override
    public void setDokument(PzDokument dokument) {
        super.setDokument(dokument);
        this.faktura = (RacunDobavljaca)dokument;
    }

    private void initGUI() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new BorderLayout());
        this.contentPanel.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
        this.contentPanel.setPaintGradient(true);
        this.contentPanel.setGradient(Color.WHITE, PzComponentFactory.COLOR_BLUE_LIGHT, PzPanel.GRADIENT_WEST_EAST);
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        buttonPane.setLayout(new FlowLayout(1));
        this.contentPanel.add((Component)buttonPane, (Object)"South");
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FakturaDobavljaca.this.actionPerformedokButton(arg0);
            }
        });
        okButton.setIcon(new ImageIcon(FakturaDobavljaca.class.getResource("/rs/pezar/finansije/resource/img/check.png")));
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.pnlHeader = new PzPanelHeader();
        this.pnlHeader.setOpaque(false);
        this.pnlHeader.setTitle("Knji\u017eenje fakture dobavlja\u010da");
        this.contentPanel.add((Component)this.pnlHeader, (Object)"North");
        this.pnlForm = new PzPanel();
        GridBagLayout gbl_pnlForm = new GridBagLayout();
        this.pnlForm.setOpaque(false);
        this.contentPanel.add((Component)this.pnlForm, (Object)"Center");
        int[] nArray = new int[8];
        nArray[0] = 113;
        nArray[1] = 111;
        nArray[2] = 48;
        nArray[3] = 72;
        nArray[4] = 116;
        nArray[5] = 110;
        nArray[6] = 182;
        gbl_pnlForm.columnWidths = nArray;
        int[] nArray2 = new int[10];
        nArray2[0] = 20;
        nArray2[3] = 20;
        nArray2[4] = 24;
        nArray2[5] = 93;
        nArray2[7] = 33;
        nArray2[8] = 20;
        gbl_pnlForm.rowHeights = nArray2;
        gbl_pnlForm.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        gbl_pnlForm.rowWeights = new double[]{0.1, 0.0, 0.0, 0.1, 0.0, 1.0, 0.0, 0.0, 0.1, Double.MIN_VALUE};
        this.pnlForm.setLayout((LayoutManager)gbl_pnlForm);
        this.lblifraDobavljaa = new JLabel("\u0160ifra dobavlja\u010da:");
        GridBagConstraints gbc_lblifraDobavljaa = new GridBagConstraints();
        gbc_lblifraDobavljaa.insets = new Insets(0, 0, 5, 5);
        gbc_lblifraDobavljaa.anchor = 13;
        gbc_lblifraDobavljaa.gridx = 0;
        gbc_lblifraDobavljaa.gridy = 0;
        this.pnlForm.add((Component)this.lblifraDobavljaa, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.numSifraDobavljaca = PzComponentFactory.createKomitentField();
        GridBagConstraints gbc_numSifraKomitenta = new GridBagConstraints();
        gbc_numSifraKomitenta.insets = new Insets(0, 0, 5, 5);
        gbc_numSifraKomitenta.fill = 2;
        gbc_numSifraKomitenta.gridx = 1;
        gbc_numSifraKomitenta.gridy = 0;
        this.pnlForm.add((Component)this.numSifraDobavljaca, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.numSifraDobavljaca.setInputVerifier(this.getInputVerifier());
        this.txtNazivDobavljaca = new PzTextField();
        this.txtNazivDobavljaca.setFocusable(false);
        this.txtNazivDobavljaca.setEditable(false);
        GridBagConstraints gbc_txtNazivDobavljaca = new GridBagConstraints();
        gbc_txtNazivDobavljaca.gridwidth = 4;
        gbc_txtNazivDobavljaca.insets = new Insets(0, 0, 5, 5);
        gbc_txtNazivDobavljaca.fill = 2;
        gbc_txtNazivDobavljaca.gridx = 2;
        gbc_txtNazivDobavljaca.gridy = 0;
        this.pnlForm.add((Component)this.txtNazivDobavljaca, (Object)new GridBagConstraints(2, 1, 4, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.lblOznakaFakture = new JLabel("Oznaka fakture:");
        GridBagConstraints gbc_lblOznakaFakture = new GridBagConstraints();
        gbc_lblOznakaFakture.anchor = 13;
        gbc_lblOznakaFakture.insets = new Insets(0, 0, 5, 5);
        gbc_lblOznakaFakture.gridx = 0;
        gbc_lblOznakaFakture.gridy = 1;
        this.pnlForm.add((Component)this.lblOznakaFakture, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.txtOznDokumenta = new PzTextField();
        this.txtOznDokumenta.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (FakturaDobavljaca.this.komitent != null && ((PzUlazniRacunKategorijaUtil.UlazniRacunKategorija)FakturaDobavljaca.this.rgrKategorija.getSelectedValue()).equals(PzUlazniRacunKategorijaUtil.FISKAL)) {
                    FakturaDobavljaca.this.btnQr.setEnabled(true);
                }
            }
        });
        this.txtOznDokumenta.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                if (FakturaDobavljaca.this.txtOznDokumenta.getVal().startsWith("https://")) {
                    try {
                        VerificationURLDecoder.InvoiceInfo invoice = VerificationURLDecoder.decode(FakturaDobavljaca.this.txtOznDokumenta.getVal());
                        FakturaDobavljaca.this.fillInvoiceData(invoice);
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Throwable)e);
                    }
                    return false;
                }
                if (FakturaDobavljaca.this.getEm().createQuery("SELECT r FROM Kalkulacija r WHERE r.arhiviran <> -1 AND r.oznDokumenta='" + FakturaDobavljaca.this.txtOznDokumenta.getVal() + "' AND r.komitent.sfrKomitent=" + FakturaDobavljaca.this.numSifraDobavljaca.getVal()).getResultList().size() > 0) {
                    PzSwingUtility.showErrorMessage((Component)((Object)FakturaDobavljaca.this), (String)("Ra\u010dun " + FakturaDobavljaca.this.txtOznDokumenta.getVal() + " od dobavlja\u010da [" + FakturaDobavljaca.this.komitent.getSfrKomitent() + "] " + FakturaDobavljaca.this.komitent.getNaziv() + " ve\u0107 postoji. Ne mo\u017eete nastaviti dalje."));
                    return false;
                }
                return !FakturaDobavljaca.this.txtOznDokumenta.getText().equals("");
            }
        });
        GridBagConstraints gbc_txtOznDokumenta = new GridBagConstraints();
        gbc_txtOznDokumenta.gridwidth = 2;
        gbc_txtOznDokumenta.insets = new Insets(0, 0, 5, 5);
        gbc_txtOznDokumenta.fill = 2;
        gbc_txtOznDokumenta.gridx = 1;
        gbc_txtOznDokumenta.gridy = 1;
        this.pnlForm.add((Component)this.txtOznDokumenta, (Object)new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.lblIznosFakture = new JLabel("Iznos fakture:");
        GridBagConstraints gbc_lblIznosFakture = new GridBagConstraints();
        gbc_lblIznosFakture.anchor = 13;
        gbc_lblIznosFakture.insets = new Insets(0, 0, 5, 5);
        gbc_lblIznosFakture.gridx = 3;
        gbc_lblIznosFakture.gridy = 1;
        this.pnlForm.add((Component)this.lblIznosFakture, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.dblIznos = new PzDoubleField();
        this.dblIznos.setVerifyInput(true);
        GridBagConstraints gbc_dblIznos = new GridBagConstraints();
        gbc_dblIznos.insets = new Insets(0, 0, 5, 5);
        gbc_dblIznos.fill = 2;
        gbc_dblIznos.gridx = 4;
        gbc_dblIznos.gridy = 1;
        this.pnlForm.add((Component)this.dblIznos, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.scp = new JScrollPane();
        GridBagConstraints gbc_scp = new GridBagConstraints();
        gbc_scp.gridheight = 2;
        gbc_scp.gridwidth = 4;
        gbc_scp.insets = new Insets(0, 0, 5, 5);
        gbc_scp.fill = 1;
        gbc_scp.gridx = 2;
        gbc_scp.gridy = 2;
        this.pnlForm.add((Component)this.scp, (Object)new GridBagConstraints(2, 4, 4, 2, 0.0, 0.0, 10, 1, new Insets(6, 0, 5, 5), 0, 0));
        this.tblPorez = this.createTablePorez();
        this.scp.setViewportView((Component)this.tblPorez);
        this.lblObraunatIznos = new JLabel("Obra\u010dunat iznos:");
        GridBagConstraints gbc_lblObraunatIznos = new GridBagConstraints();
        gbc_lblObraunatIznos.anchor = 16;
        gbc_lblObraunatIznos.insets = new Insets(0, 0, 5, 0);
        gbc_lblObraunatIznos.gridx = 6;
        gbc_lblObraunatIznos.gridy = 2;
        this.pnlForm.add((Component)this.lblObraunatIznos, (Object)new GridBagConstraints(6, 4, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.rgrPdv = PzComponentFactory.createRadioGroupFakturaDobavljaca();
        this.rgrPdv.addRadioGroupListener(new PzRadioGroupListener(){

            public void selectionChanged(PzRadioGroupEvent evt) {
                FakturaDobavljaca.this.selectionChangedrgrPdv(evt);
            }
        });
        this.rgrPdv.setBorder((Border)new TitledBorder(null, "PDV", 4, 2, null, null));
        GridBagConstraints gbc_rgrPdv = new GridBagConstraints();
        gbc_rgrPdv.gridheight = 2;
        gbc_rgrPdv.gridwidth = 2;
        gbc_rgrPdv.insets = new Insets(0, 0, 5, 5);
        gbc_rgrPdv.fill = 1;
        gbc_rgrPdv.gridx = 0;
        gbc_rgrPdv.gridy = 2;
        this.pnlForm.add(this.rgrPdv, (Object)new GridBagConstraints(0, 4, 2, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.lblIznosUValuti = new JLabel();
        this.pnlForm.add((Component)this.lblIznosUValuti, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.lblIznosUValuti.setName("lblIznosUValuti");
        this.lblIznosUValuti.setVisible(false);
        this.dfIznosUValuti = new PzDoubleField();
        this.pnlForm.add((Component)this.dfIznosUValuti, (Object)new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.dfIznosUValuti.setVisible(false);
        this.dfIznosUValuti.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent arg0) {
                if (FakturaDobavljaca.this.dfIznosUValuti.getVal() != 0.0 && FakturaDobavljaca.this.kurs != null) {
                    FakturaDobavljaca.this.dblIznos.setVal((Object)(FakturaDobavljaca.this.dfIznosUValuti.getVal() * FakturaDobavljaca.this.kurs.getSrednji().doubleValue()));
                }
                return true;
            }
        });
        this.dblObracunatIznos = this.tblPorez.createExpresionField("$2$+$3$");
        this.dblObracunatIznos.setBackground(new Color(176, 224, 230));
        this.dblObracunatIznos.setEditable(false);
        this.dblObracunatIznos.setFocusable(false);
        this.dblObracunatIznos.setColumns(8);
        GridBagConstraints gbc_dblObracunatIznos = new GridBagConstraints();
        gbc_dblObracunatIznos.anchor = 11;
        gbc_dblObracunatIznos.insets = new Insets(0, 0, 5, 0);
        gbc_dblObracunatIznos.fill = 2;
        gbc_dblObracunatIznos.gridx = 6;
        gbc_dblObracunatIznos.gridy = 3;
        this.pnlForm.add((Component)this.tblPorez.createExpresionField("$2$+$3$"), (Object)new GridBagConstraints(6, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.lblDatumKnjienja = new JLabel("Datum knji\u017eenja:");
        GridBagConstraints gbc_lblDatumKnjienja = new GridBagConstraints();
        gbc_lblDatumKnjienja.insets = new Insets(0, 0, 5, 5);
        gbc_lblDatumKnjienja.gridx = 0;
        gbc_lblDatumKnjienja.gridy = 5;
        this.pnlForm.add((Component)this.lblDatumKnjienja, (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.lblDatumFakture = new JLabel("Datum fakture:");
        GridBagConstraints gbc_lblDatumFakture = new GridBagConstraints();
        gbc_lblDatumFakture.insets = new Insets(0, 0, 5, 5);
        gbc_lblDatumFakture.gridx = 1;
        gbc_lblDatumFakture.gridy = 5;
        this.pnlForm.add((Component)this.lblDatumFakture, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.lblDatumValute = new JLabel("Datum valute:");
        GridBagConstraints gbc_lblDatumValute = new GridBagConstraints();
        gbc_lblDatumValute.gridwidth = 2;
        gbc_lblDatumValute.insets = new Insets(0, 0, 5, 5);
        gbc_lblDatumValute.gridx = 2;
        gbc_lblDatumValute.gridy = 5;
        this.pnlForm.add((Component)this.lblDatumValute, (Object)new GridBagConstraints(2, 6, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.lblKontoZaTroak = new JLabel("Konto za tro\u0161ak:");
        this.pnlForm.add((Component)this.lblKontoZaTroak, (Object)new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 5, 5), 0, 0));
        this.datKnjizenja = new PzDateField();
        GridBagConstraints gbc_datKnjizenja = new GridBagConstraints();
        gbc_datKnjizenja.insets = new Insets(0, 0, 0, 5);
        gbc_datKnjizenja.fill = 2;
        gbc_datKnjizenja.gridx = 0;
        gbc_datKnjizenja.gridy = 6;
        this.pnlForm.add((Component)this.datKnjizenja, (Object)new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.datFakture = new PzDateField();
        GridBagConstraints gbc_datFakture = new GridBagConstraints();
        gbc_datFakture.insets = new Insets(0, 0, 0, 5);
        gbc_datFakture.fill = 2;
        gbc_datFakture.gridx = 1;
        gbc_datFakture.gridy = 6;
        this.pnlForm.add((Component)this.datFakture, (Object)new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.datValute = new PzDateField();
        GridBagConstraints gbc_datValute = new GridBagConstraints();
        gbc_datValute.gridwidth = 2;
        gbc_datValute.insets = new Insets(0, 0, 0, 5);
        gbc_datValute.fill = 2;
        gbc_datValute.gridx = 2;
        gbc_datValute.gridy = 6;
        this.pnlForm.add((Component)this.datValute, (Object)new GridBagConstraints(2, 7, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.numKonto = new PzNumericOnlyTextField();
        this.pnlForm.add((Component)this.numKonto, (Object)new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.txtNazivKonta = new PzTextField();
        this.txtNazivKonta.setEditable(false);
        this.txtNazivKonta.setFocusable(false);
        this.pnlForm.add((Component)this.txtNazivKonta, (Object)new GridBagConstraints(3, 8, 4, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.txtAnalitika = new PzTextField();
        this.txtAnalitika.setFocusable(false);
        this.txtAnalitika.setEditable(false);
        this.pnlForm.add((Component)this.txtAnalitika, (Object)new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.txtAnalitika.setColumns(3);
        this.rgrKategorija = PzUlazniRacunKategorijaUtil.getKategorijeTrosak();
        this.rgrKategorija.setFocusable(false);
        this.rgrKategorija.setLayoutAxis(0);
        this.pnlForm.add(this.rgrKategorija, (Object)new GridBagConstraints(0, 0, 7, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.btnQr = new JButton("Skeniraj QR kod");
        this.btnQr.setFocusable(false);
        this.btnQr.setEnabled(false);
        this.btnQr.addActionListener((ActionListener)((Object)this));
        this.pnlForm.add((Component)this.btnQr, (Object)new GridBagConstraints(3, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.initDataBindings();
        this.pack();
        this.setSize(716, 543);
        PzComponentFactory.installOznKontoField(this.numKonto, this.txtAnalitika, this, false);
        this.rgrKategorija.addRadioGroupListener(new PzRadioGroupListener(){

            public void selectionChanged(PzRadioGroupEvent evt) {
                if (evt.getStateChange() == 1) {
                    PzUlazniRacunKategorijaUtil.UlazniRacunKategorija val = (PzUlazniRacunKategorijaUtil.UlazniRacunKategorija)evt.getValue();
                    if (val.equals(PzUlazniRacunKategorijaUtil.FISKAL)) {
                        FakturaDobavljaca.this.tblPorez.setDialogClass(PzDialogPorezFiskal.class);
                    } else {
                        FakturaDobavljaca.this.tblPorez.setDialogClass(PzDialogPorezIznos.class);
                    }
                }
            }
        });
        this.rgrKategorija.setSelectedValue((Object)PzUlazniRacunKategorijaUtil.FISKAL);
        Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
    }

    private PzTablePorez createTablePorez() {
        return PzComponentFactory.createPzTablePorezFakturaDobavljaca();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.komitent == null) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Morate izabrati dobavljaca");
            return;
        }
        VerificationURLDecoder.InvoiceInfo invoice = PzDialogVerificationURL.getInvoice(this);
        if (invoice == null) {
            return;
        }
        this.fillInvoiceData(invoice);
    }

    private void fillInvoiceData(VerificationURLDecoder.InvoiceInfo invoice) {
        if ((invoice.getInvoiceType() != 0 || invoice.getTransactionType() != 0) && PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"VAZNO! Vrsta skeniranog racuna nije PROMET - PRODAJA. \r\nDa li nastavljate dalje?", (String)"Pogresan tip racuna?", null, (boolean)true) == 1) {
            return;
        }
        try {
            if (!PzFirma.getFirma().getPib().equals(invoice.getBuyerTin()) && PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"VAZNO! Id kupca na racunu ne odgovara podacima vase firme. \r\nDa li nastavljate dalje?", (String)"Pogresna firma?", null, (boolean)true) == 1) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.txtOznDokumenta.setVal((Object)invoice.getSdcNumber());
        this.txtOznDokumenta.transferFocus();
        this.dblIznos.setVal((Object)invoice.getTotalAmount());
        this.datFakture.setVal((Object)invoice.getDate());
        this.datKnjizenja.setVal((Object)invoice.getDate());
        this.datValute.setVal((Object)invoice.getDate());
    }

    protected void selectionChangedrgrPdv(PzRadioGroupEvent evt) {
        if (evt.getStateChange() == 1) {
            if (((PzChoice)evt.getValue()).getValue().equals("OSLOBODJENO")) {
                this.tblPorez.setVisible(false);
                this.dblObracunatIznos.setVal((Object)this.dblIznos.getVal());
            } else {
                this.tblPorez.setVisible(true);
                this.dblObracunatIznos.setVal((Object)this.tblPorez.sumAll("$2$+$3$"));
            }
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            Komitentparameter p;
            this.komitent = (Komitent)entity;
            if (this.komitent.getDomaciKomitent() == 1 && this.komitent.getObveznikPDV() == 0) {
                this.tblPorez.setVisible(false);
                this.tblPorez.resetPorezi();
                this.rgrPdv.setVisible(false);
            } else {
                this.tblPorez.setVisible(true);
                this.rgrPdv.setVisible(true);
            }
            this.numSifraDobavljaca.setVal((Object)((Komitent)entity).getSfrKomitent());
            this.txtNazivDobavljaca.setVal((Object)((Komitent)entity).getNaziv());
            if (this.numKonto.isEmpty() && (p = (Komitentparameter)PzEntityManager.getEm().find(Komitentparameter.class, (Object)new KomitentparameterPK(this.komitent.getSfrKomitent(), "KONTO_TROSKA"))) != null && !"".equals(p.getValue())) {
                String[] val = p.getValue().split(":");
                String ozn = val[0];
                String anl = val.length > 1 ? val[1] : "";
                Konto k = (Konto)PzEntityManager.getEm().find(Konto.class, (Object)new KontoPK(ozn, anl));
                if (k != null) {
                    this.numKonto.setVal((Object)k.getId().getOznKonto());
                    this.txtAnalitika.setText(k.getId().getAnalitika());
                    this.txtNazivKonta.setVal((Object)k.getNaziv());
                    this.nazivKonta = k.getNaziv();
                }
            }
        } else if (entity instanceof Konto) {
            ((PzFieldImpl)component).setVal((Object)((Konto)entity).getId().getOznKonto());
            this.nazivKonta = ((Konto)entity).getNaziv();
            this.txtAnalitika.setVal((Object)((Konto)entity).getId().getAnalitika());
            this.txtNazivKonta.setVal((Object)((Konto)entity).getNaziv());
        }
    }

    protected void actionPerformedokButton(ActionEvent arg0) {
        if (!this.pnlForm.validateForm(true)) {
            return;
        }
        if (!this.txtOznDokumenta.getInputVerifier().verify((JComponent)this.txtOznDokumenta)) {
            return;
        }
        this.commit();
    }

    @Override
    public void initData(EntityManager em) {
        this.em = em;
        if (this.faktura == null) {
            this.faktura = new RacunDobavljaca();
        }
        this.initDataBindings();
        this.datFakture.setVal((Object)PzDateUtility.getCurrentDate());
        this.datKnjizenja.setVal((Object)PzDateUtility.getCurrentDate());
        this.datValute.setVal((Object)PzDateUtility.getCurrentDate());
    }

    protected void initDataBindings() {
        BeanProperty fakturaDobavljacaBeanProperty = BeanProperty.create((String)"komitent.sfrKomitent");
        BeanProperty pzNumericOnlyTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.faktura, (Property)fakturaDobavljacaBeanProperty, (Object)this.numSifraDobavljaca, (Property)pzNumericOnlyTextFieldBeanProperty);
        autoBinding.bind();
        BeanProperty fakturaDobavljacaBeanProperty_1 = BeanProperty.create((String)"komitent.naziv");
        BeanProperty pzTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.faktura, (Property)fakturaDobavljacaBeanProperty_1, (Object)this.txtNazivDobavljaca, (Property)pzTextFieldBeanProperty);
        autoBinding_1.bind();
        BeanProperty fakturaDobavljacaBeanProperty_2 = BeanProperty.create((String)"oznDokumenta");
        BeanProperty pzTextFieldBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.faktura, (Property)fakturaDobavljacaBeanProperty_2, (Object)this.txtOznDokumenta, (Property)pzTextFieldBeanProperty_1);
        autoBinding_2.bind();
        BeanProperty fakturaDobavljacaBeanProperty_3 = BeanProperty.create((String)"iznos");
        BeanProperty pzDoubleFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.faktura, (Property)fakturaDobavljacaBeanProperty_3, (Object)this.dblIznos, (Property)pzDoubleFieldBeanProperty);
        autoBinding_3.setConverter((Converter)new BBBigDecimalConverter());
        autoBinding_3.bind();
        BeanProperty fakturaDobavljacaBeanProperty_4 = BeanProperty.create((String)"datKnjizenja");
        BeanProperty pzDateFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.faktura, (Property)fakturaDobavljacaBeanProperty_4, (Object)this.datKnjizenja, (Property)pzDateFieldBeanProperty);
        autoBinding_4.setConverter((Converter)new BBDateConverter());
        autoBinding_4.bind();
        BeanProperty fakturaDobavljacaBeanProperty_5 = BeanProperty.create((String)"datum");
        BeanProperty pzDateFieldBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.faktura, (Property)fakturaDobavljacaBeanProperty_5, (Object)this.datFakture, (Property)pzDateFieldBeanProperty_1);
        autoBinding_5.setConverter((Converter)new BBDateConverter());
        autoBinding_5.bind();
        BeanProperty fakturaDobavljacaBeanProperty_6 = BeanProperty.create((String)"datValute");
        BeanProperty pzDateFieldBeanProperty_2 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.faktura, (Property)fakturaDobavljacaBeanProperty_6, (Object)this.datValute, (Property)pzDateFieldBeanProperty_2);
        autoBinding_6.setConverter((Converter)new BBDateConverter());
        autoBinding_6.bind();
        BeanProperty fakturaDobavljacaBeanProperty_7 = BeanProperty.create((String)"kontoTrosak");
        BeanProperty pzNumericOnlyTextFieldBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.faktura, (Property)fakturaDobavljacaBeanProperty_7, (Object)this.numKonto, (Property)pzNumericOnlyTextFieldBeanProperty_1);
        autoBinding_7.bind();
        BeanProperty fakturaDobavljacaBeanProperty_8 = BeanProperty.create((String)"analitika");
        BeanProperty pzTextFieldBeanProperty_2 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.faktura, (Property)fakturaDobavljacaBeanProperty_8, (Object)this.txtAnalitika, (Property)pzTextFieldBeanProperty_2);
        autoBinding_8.bind();
    }

    @Override
    public Date getDatKnjizenja() {
        return this.datKnjizenja.getVal();
    }

    @Override
    public PzDokument getNewDokument() {
        this.faktura.setKomitent(this.komitent);
        this.faktura.setDatFakture(this.datFakture.getVal());
        this.faktura.setDatum(this.datKnjizenja.getVal());
        this.faktura.setDatDPO(this.datKnjizenja.getVal());
        this.faktura.setDatFakture(this.datFakture.getVal());
        this.faktura.setPoruka("");
        if (this.komitent.getDomaciKomitent() == 0) {
            this.faktura.setPorez("INO");
        } else if (this.komitent.getObveznikPDV() == 0) {
            this.faktura.setPorez("NIJE_OBVEZNIK");
        } else {
            this.faktura.setPorez((String)((PzChoice)this.rgrPdv.getSelectedValue()).getValue());
            this.faktura.setTaksakalkulacijas(this.tblPorez.getPorezi());
        }
        this.faktura.setKategorija(((PzUlazniRacunKategorijaUtil.UlazniRacunKategorija)this.rgrKategorija.getSelectedValue()).getId());
        return this.faktura;
    }

    @Override
    public List<Stavkanzk> getStavke() {
        if (!this.numKonto.getText().equals("")) {
            Vector<Stavkanzk> stavke = new Vector<Stavkanzk>();
            Stavkanzk stavkaTrosak = new Stavkanzk();
            stavkaTrosak.setId(new StavkanzkPK(this.numKonto.getText(), this.txtAnalitika.getText(), Integer.valueOf(0), Integer.valueOf(0)));
            if ((this.komitent.getDomaciKomitent() == 0 || this.komitent.getDomaciKomitent() == 1 && this.komitent.getObveznikPDV() == 1) && ((PzChoice)this.rgrPdv.getSelectedValue()).getValue().equals("SA_PRAVOM")) {
                stavkaTrosak.setDuguje(BDConverter.getIznos((double)this.tblPorez.sumAll("$2$")));
            } else {
                stavkaTrosak.setDuguje(BDConverter.getIznos((BigDecimal)this.dblIznos.getBigDecimal()));
            }
            stavkaTrosak.setOpis("Racun " + this.faktura.getOznDokumenta() + " od komitenta " + this.numSifraDobavljaca.getVal());
            stavkaTrosak.setNazivKonta(this.nazivKonta);
            stavke.add(stavkaTrosak);
            return stavke;
        }
        return null;
    }

    @Override
    public void commit() {
        this.setDatKnjizenjaTemp(this.datKnjizenja.getVal());
        String obveznikPDV = (String)((PzChoice)this.rgrPdv.getSelectedValue()).getValue();
        if ((this.komitent.getDomaciKomitent() == 0 || this.komitent.getDomaciKomitent() == 1 && this.komitent.getObveznikPDV() == 1) && !obveznikPDV.equals("OSLOBODJENO")) {
            if (!obveznikPDV.equals("OBRACUNAT_SA_PRAVOM")) {
                if (this.dblObracunatIznos.getVal().compareTo(this.dblIznos.getVal()) != 0) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Unet iznos se ne poklapa sa zbirom unete osnovice i PDV-a. Ne mo\u017eete nastaviti dalje.");
                } else {
                    super.commit();
                }
            } else {
                super.commit();
            }
        } else {
            this.tblPorez.resetPorezi();
            super.commit();
        }
        if (!this.numKonto.isEmpty()) {
            Komitentparameter p = new Komitentparameter();
            KomitentparameterPK pk = new KomitentparameterPK(this.komitent.getSfrKomitent(), "KONTO_TROSKA");
            p.setId(pk);
            p.setValue(String.valueOf(this.numKonto.getText()) + ":" + this.txtAnalitika.getText());
            EntityManager em = PzEntityManager.getEm();
            em.getTransaction().begin();
            em.merge((Object)p);
            em.getTransaction().commit();
        } else {
            KomitentparameterPK pk = new KomitentparameterPK(this.komitent.getSfrKomitent(), "KONTO_TROSKA");
            Komitentparameter p = new Komitentparameter();
            p.setId(pk);
            p.setValue("");
            EntityManager em = PzEntityManager.getEm();
            em.getTransaction().begin();
            em.merge((Object)p);
            em.getTransaction().commit();
        }
    }

    private InputVerifier getInputVerifier() {
        return new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                if (FakturaDobavljaca.this.komitent.getDomaciKomitent() != 1) {
                    FakturaDobavljaca.this.kurs = (Kurs)FakturaDobavljaca.this.em.find(Kurs.class, (Object)new KursPK(PzParameter.getParameterValue((String)"DEF_VALUTA", (String)"EUR", (EntityManager)FakturaDobavljaca.this.em), FakturaDobavljaca.this.datKnjizenja.getVal()));
                    if (FakturaDobavljaca.this.kurs == null) {
                        PzSwingUtility.showErrorMessage((Component)((Object)FakturaDobavljaca.this), (String)("Na datum knjizenja ne postoji kurs valute! Preuzmite kurs za valutu - " + FakturaDobavljaca.this.stranaValuta + " na datum prometa kroz opciju: \u0160ifarnici->Kursna lista"));
                        return false;
                    }
                    FakturaDobavljaca.this.lblIznosUValuti.setVisible(true);
                    FakturaDobavljaca.this.dfIznosUValuti.setVisible(true);
                } else {
                    FakturaDobavljaca.this.lblIznosUValuti.setVisible(false);
                    FakturaDobavljaca.this.dfIznosUValuti.setVisible(false);
                }
                return true;
            }
        };
    }
}

