/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.engine.sifreKnjizenja.manager;

import javax.persistence.EntityManager;
import rs.pezar.db.PzDokument;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturausluga;
import rs.pezar.db.entity.Stavkanzk;
import rs.pezar.db.entity.Uplata;
import rs.pezar.finansije.engine.sifreKnjizenja.manager.UplataManager;
import rs.pezar.globals.TipDokumentConfig;

public class UplataPazaraManager
extends UplataManager {
    public static final String TIP = "TIP";

    public UplataPazaraManager(PzDokument dokument, Uplata uplata) {
        super(dokument, uplata);
    }

    @Override
    public void doInTransaction(EntityManager em) {
        if (this.getValue(TIP).equals(TipDokumentConfig.get().PODTIP_UPLATA_PAZARA_VIRMAN)) {
            Faktura f = (Faktura)em.find(Faktura.class, (Object)this.getDokument().getIdDok());
            if (f != null) {
                f.setUplata(f.getUplata().add(this.getUplata().getIznos()));
            } else {
                Fakturausluga fu = (Fakturausluga)em.find(Fakturausluga.class, (Object)this.getDokument().getIdDok());
                fu.setUplata(fu.getUplata().add(this.getUplata().getIznos()));
            }
        }
    }

    @Override
    public void reverse(EntityManager em, Stavkanzk stavka) {
        Uplata uplata = (Uplata)em.find(Uplata.class, (Object)stavka.getDokument().getIdDok());
        if (uplata != null && uplata.getPodTip().equals(TipDokumentConfig.get().PODTIP_UPLATA_PAZARA_VIRMAN)) {
            Faktura f = (Faktura)em.find(Faktura.class, (Object)uplata.getPoDokumentu());
            if (f != null) {
                f.setUplata(f.getUplata().subtract(uplata.getIznos()));
            } else {
                Fakturausluga fu = (Fakturausluga)em.find(Fakturausluga.class, (Object)uplata.getPoDokumentu());
                fu.setUplata(fu.getUplata().subtract(uplata.getIznos()));
            }
        }
    }
}

