/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.engine.izvod;

import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.SwingWorker;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.PzRacun;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Konto;
import rs.pezar.db.entity.KontoPK;
import rs.pezar.db.entity.Nzk;
import rs.pezar.db.entity.Slobodnaanalitika;
import rs.pezar.db.entity.Stavkanzk;
import rs.pezar.db.entity.StavkanzkPK;
import rs.pezar.db.entity.Uplata;
import rs.pezar.finansije.engine.DokumentCompilerFactory;
import rs.pezar.finansije.engine.SingleDokumentCompiler;
import rs.pezar.finansije.engine.izvod.IzvodBanke;
import rs.pezar.finansije.engine.izvod.IzvodLoaderException;
import rs.pezar.finansije.engine.izvod.TransakcijaIzvodaBanke;
import rs.pezar.finansije.engine.izvod.uplataLoader.UplataLoader;
import rs.pezar.finansije.engine.sifreKnjizenja.ManagerLoader;
import rs.pezar.finansije.gui.izvod.PzDialogIzvodImport;
import rs.pezar.finansije.gui.izvod.PzPanelIzvodInfo;
import rs.pezar.finansije.gui.izvod.PzPanelTransakcija;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.util.PzDateUtility;

public class IzvodManager {
    private IzvodBanke izvod;
    private List<PzPanelTransakcija> listPnlTransakcija = new ArrayList<PzPanelTransakcija>();
    private PzPanelIzvodInfo pnlIzvodInfo;
    private Nzk nzk;
    private PzDialogIzvodImport dlg;
    private EntityManager emTemp;

    public IzvodManager(IzvodBanke izvod) {
        this.setIzvod(izvod);
    }

    public IzvodBanke getIzvod() {
        return this.izvod;
    }

    public void setIzvod(IzvodBanke izvod) {
        this.izvod = izvod;
    }

    public List<PzPanelTransakcija> getListPnlTransakcija() {
        return this.listPnlTransakcija;
    }

    public PzPanelIzvodInfo getPnlIzvodInfo() {
        return this.pnlIzvodInfo;
    }

    public void setPnlIzvodInfo(PzPanelIzvodInfo pnlIzvodInfo) {
        this.pnlIzvodInfo = pnlIzvodInfo;
    }

    public void srediUplate(Komitent k, String strana, List<Uplata> uplate, BigDecimal iznos, UplataLoader df, PzPanelTransakcija pt) {
        if (this.listPnlTransakcija == null) {
            return;
        }
        for (PzPanelTransakcija pnlTransakcija : this.listPnlTransakcija) {
            if (pt == pnlTransakcija || !strana.equals(pnlTransakcija.getTransakcijaIzvodaBanke().getStrana()) || pnlTransakcija.getKomitent() == null || !pnlTransakcija.getKomitent().getSfrKomitent().equals(k.getSfrKomitent()) || !strana.equals(pnlTransakcija.getTransakcijaIzvodaBanke().getStrana())) continue;
            for (Uplata upl1 : uplate) {
                for (Uplata upl2 : pnlTransakcija.getUplateAll()) {
                    if (upl1.getPoDokumentu() != upl2.getPoDokumentu()) continue;
                    upl1.setDokumentUpl(upl2.getDokumentUpl());
                }
            }
        }
        df.rebuildUplate(uplate, strana, iznos);
    }

    public Komitent getKomitentByBrRacuna(String brRacuna) {
        Komitent k = null;
        if (this.listPnlTransakcija == null) {
            return k;
        }
        Iterator<PzPanelTransakcija> iterator = this.listPnlTransakcija.iterator();
        while (iterator.hasNext() && k == null) {
            PzPanelTransakcija type = iterator.next();
            if (!type.getTransakcijaIzvodaBanke().getBrojRacuna().equals(brRacuna)) continue;
            k = type.getKomitent();
        }
        return k;
    }

    public boolean racunExists(TransakcijaIzvodaBanke t) {
        boolean exists = false;
        if (this.listPnlTransakcija == null) {
            return exists;
        }
        Iterator<PzPanelTransakcija> iterator = this.listPnlTransakcija.iterator();
        while (iterator.hasNext() && !exists) {
            PzPanelTransakcija pt = iterator.next();
            if (pt.getTransakcijaIzvodaBanke() == t || !pt.getTransakcijaIzvodaBanke().getBrojRacuna().equals(t.getBrojRacuna())) continue;
            exists = true;
        }
        return exists;
    }

    public void setKomitentByBrRacuna(TransakcijaIzvodaBanke t, Komitent k, EntityManager em1) {
        if (this.listPnlTransakcija == null) {
            return;
        }
        EntityManager em = em1 != null ? em1 : PzEntityManagerFactory.getInstance().createEm();
        for (PzPanelTransakcija pt : this.listPnlTransakcija) {
            if (pt.getTransakcijaIzvodaBanke() == t || !pt.getTransakcijaIzvodaBanke().getBrojRacuna().equals(t.getBrojRacuna())) continue;
            pt.setKomitent(k);
            pt.setUplate(em, false, true);
        }
        if (em1 == null) {
            em.close();
        }
    }

    public void ponistiUplateByBrRacuna(TransakcijaIzvodaBanke t) {
        if (this.listPnlTransakcija == null) {
            return;
        }
        for (PzPanelTransakcija pt : this.listPnlTransakcija) {
            if (pt.getTransakcijaIzvodaBanke() == t || !pt.getTransakcijaIzvodaBanke().getBrojRacuna().equals(t.getBrojRacuna())) continue;
            pt.ponishtiUplate(true, true);
        }
    }

    public void refreshUplateByKomitent(Komitent k) {
        if (this.listPnlTransakcija == null) {
            return;
        }
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        for (PzPanelTransakcija pt : this.listPnlTransakcija) {
            if (pt.getKomitent() == null || !pt.getKomitent().getSfrKomitent().equals(k.getSfrKomitent())) continue;
            pt.ponishtiUplate(false, false);
            pt.setUplataLocked();
        }
        em.close();
    }

    public boolean komitentExists(Komitent k, TransakcijaIzvodaBanke t) {
        boolean exists = false;
        if (this.listPnlTransakcija == null) {
            return exists;
        }
        Iterator<PzPanelTransakcija> iterator = this.listPnlTransakcija.iterator();
        while (iterator.hasNext() && !exists) {
            PzPanelTransakcija pt = iterator.next();
            if (pt.getTransakcijaIzvodaBanke() == t || pt.getKomitent() == null || !pt.getKomitent().getSfrKomitent().equals(k.getSfrKomitent())) continue;
            exists = true;
        }
        return exists;
    }

    public boolean komitentExistsByStrana(Komitent k, TransakcijaIzvodaBanke t) {
        boolean exists = false;
        if (this.listPnlTransakcija == null) {
            return exists;
        }
        Iterator<PzPanelTransakcija> iterator = this.listPnlTransakcija.iterator();
        while (iterator.hasNext() && !exists) {
            PzPanelTransakcija pt = iterator.next();
            if (!pt.getTransakcijaIzvodaBanke().getStrana().equals(t.getStrana()) || pt.getTransakcijaIzvodaBanke() == t || pt.getKomitent() == null || !pt.getKomitent().getSfrKomitent().equals(k.getSfrKomitent())) continue;
            exists = true;
        }
        return exists;
    }

    public boolean validateTransakcije() {
        boolean ok = true;
        Iterator<PzPanelTransakcija> iterator = this.listPnlTransakcija.iterator();
        while (iterator.hasNext() && ok) {
            PzPanelTransakcija pt = iterator.next();
            ok = pt.validateUplate();
        }
        return ok;
    }

    public void knjiziIzvod(Nzk n) {
        this.nzk = n;
        PzWorkerDialog.showStatus((String)"Knji\u017eenje u toku. Molim sa\u010dekajte!", (PzDialog)this.dlg);
        PzWorkerDialog.getDialogInstance().getProgressBar().setIndeterminate(false);
        this.emTemp = PzEntityManagerFactory.getInstance().createEm();
        SwingWorker<Object, Integer> worker = new SwingWorker<Object, Integer>(){

            @Override
            protected Object doInBackground() throws Exception {
                ArrayList<Stavkanzk> stavke = new ArrayList<Stavkanzk>();
                SingleDokumentCompiler compiler = DokumentCompilerFactory.getInstance().createSingleDokumentCompiler();
                this.publish(-1);
                this.publish(IzvodManager.this.listPnlTransakcija.size() - 1);
                IzvodManager.this.emTemp.getTransaction().begin();
                stavke.add(IzvodManager.this.getStavkaTekuciRacun(IzvodManager.this.emTemp));
                for (PzPanelTransakcija pt : IzvodManager.this.listPnlTransakcija) {
                    List<Uplata> uplateTemp = pt.getUplateNonZero();
                    for (Uplata uplata : uplateTemp) {
                        PzRacun r = (PzRacun)uplata.getDokumentUpl();
                        if (r != null) {
                            IzvodManager.this.emTemp.merge((Object)r);
                        }
                        uplata.setArhiviran((short)1);
                        uplata.setProknjizen((short)1);
                        PzDokumentManager.getInstance().arhivirajDokument((PzDokument)uplata, false, null, IzvodManager.this.emTemp);
                        List ls = compiler.compileDokument((PzDokument)uplata).getStavkanzks();
                        uplata.getDokument().setStavkanzks(null);
                        for (Stavkanzk snzk : ls) {
                            String sfrs = ManagerLoader.getSfrByTip(uplata.getTip());
                            if (sfrs == null) continue;
                            snzk.setSfrKnjizenja(Integer.valueOf(Integer.parseInt(sfrs)));
                        }
                        stavke.addAll(ls);
                        this.publish(0);
                    }
                }
                this.publish(-1);
                this.publish(stavke.size() - 1);
                Integer brojac = IzvodManager.this.getSledeciBrojStavke(IzvodManager.this.emTemp);
                for (Stavkanzk s : stavke) {
                    brojac = brojac + 1;
                    s.getId().setIdNalog(IzvodManager.this.nzk.getIdNalog());
                    s.getId().setrBroj(brojac);
                    s.setDatKnjizenja(PzDateUtility.getCurrentDate());
                    s.setSfrKnjizenja(Integer.valueOf(-1));
                    IzvodManager.this.emTemp.persist((Object)s);
                    this.publish(0);
                }
                IzvodManager.this.emTemp.getTransaction().commit();
                IzvodManager.this.nzk.getStavkanzks().addAll(stavke);
                return null;
            }

            @Override
            protected void process(List<Integer> chunks) {
                for (Integer integer : chunks) {
                    if (integer < 0) {
                        PzWorkerDialog.getDialogInstance().getProgressBar().setValue(0);
                        continue;
                    }
                    if (integer == 0) {
                        PzWorkerDialog.getDialogInstance().incProgress(1);
                        continue;
                    }
                    if (integer <= 0) continue;
                    PzWorkerDialog.getDialogInstance().getProgressBar().setMaximum(integer);
                }
            }

            @Override
            protected void done() {
                try {
                    try {
                        this.get();
                        IzvodManager.this.dlg.dalje();
                    }
                    catch (Exception e) {
                        if (IzvodManager.this.emTemp.getTransaction().isActive()) {
                            IzvodManager.this.emTemp.getTransaction().rollback();
                        }
                        PzMysqlExceptionHandler.handle((Component)((Object)IzvodManager.this.dlg), (Throwable)e);
                        IzvodManager.this.emTemp.close();
                        IzvodManager.this.emTemp = null;
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    IzvodManager.this.emTemp.close();
                    IzvodManager.this.emTemp = null;
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        worker.execute();
    }

    private Integer getSledeciBrojStavke(EntityManager em) {
        Integer brojac = (Integer)this.emTemp.createQuery("SELECT MAX(s.id.rBroj) FROM Stavkanzk s WHERE s.id.idNalog=" + this.nzk.getIdNalog()).getSingleResult();
        if (brojac == null) {
            brojac = 0;
        }
        return brojac;
    }

    private Stavkanzk getStavkaTekuciRacun(EntityManager em) throws IzvodLoaderException {
        String oznKonto;
        Slobodnaanalitika sa = (Slobodnaanalitika)em.find(Slobodnaanalitika.class, (Object)this.izvod.getKodBanke());
        if (sa == null) {
            sa = new Slobodnaanalitika();
            sa.setOznAnalitika(this.izvod.getKodBanke());
            sa.setNaziv(this.izvod.getBrojRacuna());
            em.persist((Object)sa);
        }
        if ((oznKonto = PzParameter.getParameterValue((String)"KONTO_TEKUCI_RACUN", (EntityManager)em)) == null) {
            throw new IzvodLoaderException("Nije pode\u0161en parametar sistema koji predstavlja oznaku konta teku\u0107eg ra\u010duna. Nastavak rada nemogu\u0107!");
        }
        Konto k = (Konto)em.find(Konto.class, (Object)new KontoPK(oznKonto, sa.getOznAnalitika()));
        if (k == null) {
            Konto ktr = (Konto)em.find(Konto.class, (Object)new KontoPK(oznKonto, ""));
            if (ktr == null) {
                throw new IzvodLoaderException("Konto " + oznKonto + ", koji je ozna\u010den kao konto teku\u0107eg ra\u010duna, ne postoji u \u0161ifarniku (kontnom okviru). Nastavak rada nemogu\u0107!");
            }
            k = new Konto(oznKonto, sa.getOznAnalitika(), "S", ktr.getNaziv());
            em.persist((Object)k);
        }
        Stavkanzk s = new Stavkanzk();
        s.setId(new StavkanzkPK(k.getId().getOznKonto(), k.getId().getAnalitika(), this.nzk.getIdNalog(), this.getSledeciBrojStavke(em)));
        s.setNazivKonta(k.getNaziv());
        s.setNazivAnalitike(sa.getNaziv());
        s.setDatKnjizenja(PzDateUtility.getCurrentDate());
        s.setDuguje(this.getOdobrenjeUkupno());
        s.setOpis("IZVOD broj " + this.izvod.getrBroj());
        s.setPotrazuje(this.getZaduzenjeUkupno());
        s.setSfrKnjizenja(Integer.valueOf(1));
        return s;
    }

    public BigDecimal getOdobrenjeUkupno() {
        BigDecimal odobrenje = new BigDecimal("0.00");
        for (TransakcijaIzvodaBanke t : this.izvod.getTransakcije()) {
            if (!t.getStrana().equals("ODOBRENJE")) continue;
            odobrenje = odobrenje.add(t.getIznos());
        }
        return odobrenje;
    }

    public BigDecimal getZaduzenjeUkupno() {
        BigDecimal zaduzenje = new BigDecimal("0.00");
        for (TransakcijaIzvodaBanke t : this.izvod.getTransakcije()) {
            if (!t.getStrana().equals("ZADUZENJE")) continue;
            zaduzenje = zaduzenje.add(t.getIznos());
        }
        return zaduzenje;
    }

    public PzDialogIzvodImport getDlg() {
        return this.dlg;
    }

    public void setDlg(PzDialogIzvodImport dlg) {
        this.dlg = dlg;
    }
}

