/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.gui.util;

import java.awt.Component;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.text.JTextComponent;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.pezar.core.format.BDConverter;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.core.log.PzLogger;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDefaultDokumentCustomizer;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.PzProizvodDokument;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturaservisa;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Fiskalniracun;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Proizvodfiskalniracun;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Taksafaktura;
import rs.pezar.db.entity.Taksafiskalniracun;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.Uslugafaktura;
import rs.pezar.db.management.PzPorukeManager;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.msg.device.cashregister.CashRegisterHandler;
import rs.pezar.msg.device.cashregister.data.Article;
import rs.pezar.msg.device.cashregister.data.CashRegisterBill;
import rs.pezar.msg.device.cashregister.data.CashRegisterControl;
import rs.pezar.msg.device.cashregister.exceptions.CRException;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzSingleListDataSource;
import rs.pezar.reports.engine.standard.PzBeanDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;
import rs.pezar.util.PzFileUtility;
import rs.pezar.util.PzMathUtility;

public class PzKasaUtil {
    private static JTextComponent txtComponent;
    private static boolean first;
    private static HashMap<String, Character> stope;
    private static HashMap<String, String> slova;

    static {
        stope = new HashMap();
        try {
            if (PzFirma.getFirma().getPdvObveznik() == 0) {
                stope.put("T0", Character.valueOf('A'));
                stope.put("U0", Character.valueOf('A'));
            } else {
                stope.put("T0", Character.valueOf('G'));
                stope.put("U0", Character.valueOf('G'));
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
            e.printStackTrace();
        }
        stope.put("T1", Character.valueOf('d'));
        stope.put("U1", Character.valueOf('d'));
        stope.put("T11", Character.valueOf('d'));
        stope.put("U11", Character.valueOf('d'));
        stope.put("T2", Character.valueOf('E'));
        stope.put("U2", Character.valueOf('E'));
        slova = new HashMap();
        slova.put("\u0161", "s");
        slova.put("\u0111", "dj");
        slova.put("\u010d", "c");
        slova.put("\u0107", "c");
        slova.put("\u017e", "z");
        slova.put("\u0160", "S");
        slova.put("\u0110", "Dj");
        slova.put("\u010c", "C");
        slova.put("\u0106", "C");
        slova.put("\u017d", "z");
    }

    @Deprecated
    public static void arhivirajRacunOld(Fiskalniracun racun, EntityManager em) throws Exception {
        Timestamp datum = PzDateUtility.getServerTime((EntityManager)em);
        racun.setVreme(datum);
        PzKasaUtil.pripremiZaStampu(racun, em, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean proveriStanje(Fiskalniracun racun, EntityManager em) {
        if (racun.getRadnajedinica().getMinusKolicine().equals("DOZVOLJEN")) {
            return true;
        }
        try {
            ArrayList<String> sifre = new ArrayList<String>();
            for (Proizvodfiskalniracun pf : racun.getProizvodfiskalniracuns()) {
                sifre.add(pf.getId().getSfrProizvod());
            }
            List list = em.createQuery("SELECT s.id.sfrProizvod, s.kolicina - s.alocKolicina FROM Stanje s WHERE s.radnajedinica = :rj AND s.id.sfrProizvod in :sfrProizvod").setParameter("rj", (Object)racun.getRadnajedinica()).setParameter("sfrProizvod", sifre).getResultList();
            for (Proizvodfiskalniracun pf : racun.getProizvodfiskalniracuns()) {
                if (pf.getId().getSfrProizvod().startsWith("U")) continue;
                Double kol = null;
                for (Object object : list) {
                    Object[] l1 = (Object[])object;
                    if (!pf.getId().getSfrProizvod().equals(l1[0])) continue;
                    kol = (Double)l1[1];
                }
                if (kol == null) {
                    PzSwingUtility.showErrorMessage(null, (String)("Proizvod " + pf.getId().getSfrProizvod() + " nema definisanu cenu! Unos nije mogu\u0107!"));
                    return false;
                }
                if (!(kol < 0.0)) continue;
                PzSwingUtility.showErrorMessage(null, (String)("Nema dovoljno raspolo\u017eive koli\u010dine artikla " + pf.getId().getSfrProizvod() + "! Unos nije mogu\u0107!"));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
            return false;
        }
    }

    public static void updateStanje(Fiskalniracun racun, EntityManager em) {
        boolean kolicineUVredProd = PzParameter.getBoolean((String)"KOLICINE_U_VRED_PROD", (boolean)false, (EntityManager)em);
        if (racun.getRadnajedinica().getpTip().equals("V") && !kolicineUVredProd) {
            return;
        }
        for (Proizvodfiskalniracun pf : racun.getProizvodfiskalniracuns()) {
            if (pf.getTaksa("PDV").getOznTarGr().startsWith("U")) continue;
            StanjePK spk = new StanjePK(pf.getId().getSfrProizvod(), racun.getRadnajedinica().getId().getOznOgranak(), racun.getRadnajedinica().getId().getOznRj());
            Stanje s = (Stanje)em.find(Stanje.class, (Object)spk);
            s.setDatZadIzlaza(new Date(racun.getDatum().getTime()));
            if (racun.getPodTip().startsWith("Normal")) {
                if (racun.getPodTip().endsWith("Sale")) {
                    s.setKolicina(s.getKolicina() - pf.getKolicina());
                    s.setKumIzlaza(s.getKumIzlaza() + pf.getKolicina());
                } else {
                    s.setKolicina(s.getKolicina() + pf.getKolicina());
                    s.setKumIzlaza(s.getKumIzlaza() - pf.getKolicina());
                }
            }
            s.setAlocKolicina(s.getAlocKolicina() - pf.getKolicina());
        }
    }

    public static void addTaksas(Fiskalniracun racun) {
        if (racun.getTaksafiskalniracuns() == null) {
            racun.setTaksafiskalniracuns(new Vector());
        }
        PzKasaUtil.addTaksaRacun(racun);
    }

    public static void addTaksaRacun(Fiskalniracun racun) {
        if (racun.getProizvodfiskalniracuns() != null && racun.getProizvodfiskalniracuns().size() > 0) {
            for (Proizvodfiskalniracun proizvod : racun.getProizvodfiskalniracuns()) {
                PzKasaUtil.addTaksa(proizvod, racun, racun.getRadnajedinica());
            }
        }
    }

    private static void addTaksa(Proizvodfiskalniracun proizvod, Fiskalniracun racun, Radnajedinica rj) {
        try {
            if (racun.getTaksafiskalniracuns() == null) {
                return;
            }
            boolean found = false;
            Tarifnagrupa tg = null;
            tg = (Tarifnagrupa)PzEntityManager.find(Tarifnagrupa.class, (Object)proizvod.getTaksa("PDV").getId().getOznTarGr());
            for (Taksafiskalniracun td : racun.getTaksafiskalniracuns()) {
                if (!td.getTarifnagrupa().getOznTarGr().equals(tg.getOznTarGr())) continue;
                td.setIznos(PzMathUtility.round((BigDecimal)td.getIznos().add(proizvod.calculateTaksa("PDV"))));
                td.setVrsta(PzTaksaDokument.TIP_UKALKULISANI);
                td.setOsnovica(PzMathUtility.round((BigDecimal)td.getOsnovica().add(proizvod.calculateOsnovica("PDV"))));
                found = true;
            }
            if (!found) {
                Taksafiskalniracun td;
                System.out.println("Tarifna grupa je " + tg.getOznTarGr());
                td = racun.createEmptytakTaksafiskalniracun(tg.getOznTarGr(), null);
                td.getId().setTip("PDV");
                td.setTarifnagrupa(tg);
                td.setIznos(PzMathUtility.round((BigDecimal)proizvod.calculateTaksa("PDV")));
                td.setOsnovica(proizvod.calculateOsnovica("PDV"));
                td.setVrsta(PzTaksaDokument.TIP_UKALKULISANI);
                racun.getTaksafiskalniracuns().add(td);
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }

    public static void showReports(PzDialog parent, Fiskalniracun racun, String fname) throws Exception {
        String title = "";
        Vector<Object> data = new Vector<Object>();
        data.add(PzFirma.getFirma());
        data.add(racun);
        PzDataSourceExtended ds = new PzDataSourceExtended(data, racun.getProizvodfiskalniracuns());
        ds.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (fname.equals("rs/pezar/kasa/resource/reports/compiled/gotovinski.racun.jasper")) {
            title = "Gotovinski ra\u010dun br." + racun.getOznDokumenta();
            params.put("porezSubreport", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/subreport.porez.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
            params.put("porezDS", new PzSingleListDataSource(racun.getTaksafiskalniracuns()));
        } else {
            title = racun.getStorno() == 0 ? "Ra\u010dun br." + racun.getOznDokumenta() : "Storno Ra\u010dun br." + racun.getOznDokumenta();
        }
        params.put("nazivArtikla", PzParameter.getParameterValue((String)"NAZIV_ARTIKLA", (String)"jedan_red"));
        params.put("title", title);
        params.put("reklama", "");
        PzReportManager.createAndShowReport((PzDialog)parent, (JRDataSource)ds, (URL)parent.getClass().getClassLoader().getResource(fname), params, (String)title, (int)PzReportManager.REPORT_TYPE_JASPER);
    }

    public static boolean stampajRacun(PzDokument dokument, Boolean predracun, BigDecimal[] iznosi) throws Exception {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        em.getTransaction().begin();
        boolean ok = PzKasaUtil.stampajRacun(dokument, predracun, iznosi, em);
        em.getTransaction().commit();
        return ok;
    }

    public static boolean stampajRacun(PzDokument dokument, Boolean predracun, BigDecimal[] iznosi, EntityManager em) throws Exception {
        boolean ok = false;
        try {
            ok = PzKasaUtil.bill(dokument, predracun, iznosi);
        }
        catch (CRException crx) {
            PzInfoException e = new PzInfoException("Gre\u0161ka prilikom \u0161tampanja na fiskalnom \u0161tampa\u010du.", (Throwable)crx);
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
        if (ok) {
            try {
                if (predracun.booleanValue()) {
                    PzDokumentManager.getInstance().log(dokument, 51, "Izdat nefiskalni izvestaj");
                } else {
                    PzDokumentManager.getInstance().log(dokument, 50, "Izdat fiskalni racun");
                }
            }
            catch (Exception e) {
                PzLogger.getInstance().logException((Throwable)e);
            }
        }
        return ok;
    }

    public static boolean bill(PzDokument dokument, Boolean predracun, BigDecimal[] iznosi) throws Exception {
        HashMap results = null;
        try {
            results = CashRegisterHandler.sendToDefaultCashRegister((Object)PzKasaUtil.createBill(dokument, predracun, iznosi));
        }
        catch (Exception e) {
            PzKasaUtil.showErorMessage("Greska: " + e.getMessage());
            System.out.println("Greska: " + e.getMessage());
            throw e;
        }
        if (results != null && results.containsKey("CODE") && ((String)results.get("CODE")).equals("SUCCESS")) {
            PzKasaUtil.showMessage(results);
            System.out.println("Rezultat operacije: " + (String)results.get("MESSAGE"));
            System.out.println("Info uredjaja: " + (String)results.get("INFOS"));
        }
        return results != null;
    }

    private static CashRegisterBill createBill(PzDokument dokument, Boolean predracun, BigDecimal[] iznosi) {
        CashRegisterBill bill;
        block18: {
            Article article;
            block17: {
                bill = new CashRegisterBill();
                bill.setOperaterCode("1");
                bill.setOperaterPassword("0000");
                bill.setCashRegisterCode("1");
                bill.setBillIdString(dokument.getOznDokumenta());
                bill.setBillAdditionalText(PzKasaUtil.getMessage(dokument));
                if (dokument instanceof Fiskalniracun) {
                    Fiskalniracun fr = (Fiskalniracun)dokument;
                    bill.setPaidAmountCash(fr.getPrimljeno() == null || fr.getPrimljeno().equals(new BigDecimal(0)) ? fr.getIznos() : fr.getPrimljeno());
                    bill.setPaidAmountCard(fr.getKartice());
                    bill.setPaidAmountCheck(fr.getCekovi());
                    if (((Fiskalniracun)dokument).getPrimljeno() == null) {
                        bill.setPaidAmountCustomer(((Fiskalniracun)dokument).getGotovina());
                    } else {
                        bill.setPaidAmountCustomer(((Fiskalniracun)dokument).getPrimljeno());
                    }
                    if (predracun.booleanValue()) {
                        StringBuilder s = new StringBuilder();
                        if (fr.getNazivKupca() != null && !"".equals(fr.getNazivKupca())) {
                            try {
                                Firma f = PzFirma.getFirma();
                                s.append("-----------------------------#crlf");
                                s.append("PRODAVAC:");
                                s.append(" #crlf");
                                s.append(f.getNaziv());
                                s.append(" #crlf");
                                s.append(f.getAdresa().replaceAll("(?<=\\G.{25})", "#crlf"));
                                s.append(" #crlf");
                                s.append(f.getGrad());
                                s.append(" #crlf");
                                s.append("MBR: ");
                                s.append(f.getMatBroj());
                                s.append(" #crlf");
                                s.append("PIB: ");
                                s.append(f.getPib());
                                s.append(" #crlf");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            s.append("-----------------------------#crlf");
                            s.append("GOTOVINSKI RACUN BROJ:");
                            s.append(" #crlf");
                            s.append(dokument.getOznDokumenta());
                            s.append(" #crlf");
                            s.append("-----------------------------#crlf");
                            s.append("KUPAC:");
                            s.append(" #crlf");
                            s.append(fr.getNazivKupca().replaceAll("(?<=\\G.{25})", "#crlf"));
                            if (fr.getAdresa() != null && !"".equals(fr.getAdresa())) {
                                s.append(" #crlf");
                                s.append("ADRESA:");
                                s.append(" #crlf");
                                s.append(fr.getAdresa());
                            }
                            if (fr.getGrad() != null && !"".equals(fr.getGrad())) {
                                s.append(" #crlf");
                                s.append("GRAD:");
                                s.append(" #crlf");
                                s.append(fr.getGrad());
                            }
                            if (fr.getPib() != null && !"".equals(fr.getPib())) {
                                s.append(" #crlf");
                                s.append("PIB: " + fr.getPib());
                            }
                            s.append(" #crlf");
                            s.append("-----------------------------#crlf");
                            s.append("Mesto izdavanja racuna: ");
                            s.append(" #crlf");
                            s.append(dokument.getRadnajedinica().getMesto());
                            s.append(" #crlf");
                            s.append("Datum izdavanja racuna:");
                            s.append(" #crlf");
                            s.append(PzFormatFactory.getDateFormat().format(dokument.getDatum()));
                            s.append(" #crlf");
                            s.append("Datum prometa:");
                            s.append(" #crlf");
                            s.append(PzFormatFactory.getDateFormat().format(dokument.getDatPrometa()));
                            bill.setBillHeaderText(PzKasaUtil.translateMessage(s.toString().replace("\\p{Cntrl}", "")));
                            s = new StringBuilder();
                            if (fr.getTaksafiskalniracuns() != null) {
                                Iterator iterator = fr.getTaksafiskalniracuns().iterator();
                                while (iterator.hasNext()) {
                                    Taksafiskalniracun p = (Taksafiskalniracun)iterator.next();
                                    s.append("PDV ");
                                    s.append(String.valueOf(p.getTarifnagrupa().getStopa()) + "%");
                                    s.append("#crlf");
                                    s.append("Osnovica: " + PzFormatFactory.getIznosFormat().format(p.getOsnovica()));
                                    s.append("#crlf");
                                    s.append("Iznos poreza: " + PzFormatFactory.getIznosFormat().format(p.getIznos()));
                                    if (!iterator.hasNext()) continue;
                                    s.append("#crlf");
                                }
                            }
                            s.append(" #crlf ");
                            s.append("#crlf");
                            s.append("Broj fiskalnog isecka: " + fr.getBrFiskalnogIsecka());
                            s.append("#crlf ");
                            s.append("#crlf ");
                            s.append("#crlf ");
                            s.append("________________________ M.P.");
                            s.append("#crlf");
                            s.append("      Racun izdao");
                            s.append("#crlf ");
                            s.append("#crlf ");
                            s.append("#crlf ");
                            bill.setBillAdditionalText(PzKasaUtil.translateMessage(s.toString().replace("\\p{Cntrl}", "")));
                        }
                    }
                } else {
                    bill.setPaidAmountCard(iznosi[0]);
                    bill.setPaidAmountCheck(iznosi[1]);
                    bill.setPaidAmountCash(iznosi[2]);
                    bill.setPaidAmountCustomer(iznosi[2]);
                }
                bill.setPreBill(predracun.booleanValue());
                if (!(dokument instanceof Fiskalniracun)) break block17;
                for (Proizvodfiskalniracun proizvod : ((Fiskalniracun)dokument).getProizvodfiskalniracuns()) {
                    article = new Article();
                    article.setPLU(null);
                    article.setSifra(proizvod.getId().getSfrProizvod());
                    article.setName(proizvod.getNaziv());
                    article.setUnit(proizvod.getJm());
                    article.setQuantity(BDConverter.getKolicina((double)proizvod.getKolicina()));
                    article.setPrice(BDConverter.getProdCena((double)proizvod.getCena()));
                    article.setTaxRate(PzKasaUtil.convertStopa((PzADTaksa)proizvod.getTaksa("PDV")));
                    bill.addArticle(article);
                }
                break block18;
            }
            for (PzArtikalDokument af : dokument.getArtikalDocuments()) {
                article = new Article();
                article.setPLU(null);
                article.setSifra(af.getId().getSfrProizvod());
                article.setName(af.getNaziv());
                article.setUnit(af.getJm());
                article.setQuantity(BDConverter.getKolicina((double)af.getKolicina()));
                article.setPrice(BDConverter.getProdCena((double)af.getCena()));
                article.setTaxRate(PzKasaUtil.convertStopa(af.getTaksa("PDV")));
                bill.addArticle(article);
            }
            if (!(dokument instanceof Fakturaservisa)) break block18;
            for (Uslugafaktura uf : ((Fakturaservisa)dokument).getUslugafakturas()) {
                if (uf.getUsluga() == null) {
                    throw new IllegalArgumentException("Postoji usluga koja nema sifru, zato je dalji rad onemogucen!");
                }
                article = new Article();
                article.setPLU(null);
                article.setSifra(uf.getUsluga().getSfrProizvod());
                article.setName(uf.getNaziv());
                article.setUnit("");
                article.setQuantity(BDConverter.getKolicina((double)uf.getKolicina()));
                article.setPrice(BDConverter.getProdCena((double)uf.getCena()));
                article.setTaxRate(PzKasaUtil.convertStopa(uf.getTaksa("PDV")));
                bill.addArticle(article);
            }
        }
        return bill;
    }

    public static void control(final PzDialog dialog, final String kontrola) {
        PzWorkerDialog.showStatus((String)"Komunikacija sa uredjajem u toku. Molim, sacekajte.", (PzDialog)dialog);
        SwingWorker<HashMap<String, String>, Object> sw = new SwingWorker<HashMap<String, String>, Object>(){

            @Override
            protected HashMap<String, String> doInBackground() throws Exception {
                HashMap results = null;
                CashRegisterControl cntrl = new CashRegisterControl();
                cntrl.setControlCode(kontrola);
                results = CashRegisterHandler.sendToDefaultCashRegister((Object)cntrl);
                return results;
            }

            @Override
            protected void done() {
                HashMap results = null;
                try {
                    results = (HashMap)this.get();
                }
                catch (Exception e) {
                    if (e.getCause() instanceof CRException) {
                        System.out.println("Greska: " + ((CRException)e.getCause()).getMessages());
                        PzSwingUtility.showErrorMessage((Component)dialog, (String)("Greska: " + ((CRException)e.getCause()).getMessages()));
                    }
                    if (e instanceof CRException) {
                        System.out.println("Greska: " + ((CRException)e).getMessages());
                        PzSwingUtility.showErrorMessage((Component)dialog, (String)("Greska: " + ((CRException)e).getMessages()));
                    }
                    PzMysqlExceptionHandler.handle((Component)dialog, (Throwable)e);
                }
                if (results != null && results.containsKey("CODE") && ((String)results.get("CODE")).equals("SUCCESS")) {
                    PzWorkerDialog.hideStatus();
                    System.out.println("Rezultat operacije: " + (String)results.get("MESSAGE"));
                    System.out.println("Info uredjaja: " + (String)results.get("INFOS"));
                    PzSwingUtility.showInformationMessage((Component)dialog, (String)"Operacija uspe\u0161na");
                }
                PzWorkerDialog.hideStatus();
            }
        };
        sw.execute();
    }

    public static void control(final PzDialog dialog, final String kontrola, final HashMap<String, String> parameters) {
        PzWorkerDialog.showStatus((String)"Komunikacija sa uredjajem u toku. Molim, sacekajte.", (PzDialog)dialog);
        SwingWorker<HashMap<String, String>, Object> sw = new SwingWorker<HashMap<String, String>, Object>(){

            @Override
            protected HashMap<String, String> doInBackground() throws Exception {
                HashMap results = null;
                CashRegisterControl cntrl = new CashRegisterControl();
                cntrl.setControlCode(kontrola);
                cntrl.setParameters(parameters);
                results = CashRegisterHandler.sendToDefaultCashRegister((Object)cntrl);
                return results;
            }

            @Override
            protected void done() {
                HashMap results = null;
                try {
                    results = (HashMap)this.get();
                }
                catch (Exception e) {
                    if (e.getCause() instanceof CRException) {
                        System.out.println("Greska: " + ((CRException)e.getCause()).getMessages());
                        PzSwingUtility.showErrorMessage((Component)dialog, (String)("Greska: " + ((CRException)e.getCause()).getMessages()));
                    }
                    if (e instanceof CRException) {
                        System.out.println("Greska: " + ((CRException)e).getMessages());
                        PzSwingUtility.showErrorMessage((Component)dialog, (String)("Greska: " + ((CRException)e).getMessages()));
                    }
                    PzMysqlExceptionHandler.handle((Component)dialog, (Throwable)e);
                }
                if (results != null && results.containsKey("CODE") && ((String)results.get("CODE")).equals("SUCCESS")) {
                    PzWorkerDialog.hideStatus();
                    System.out.println("Rezultat operacije: " + (String)results.get("MESSAGE"));
                    System.out.println("Info uredjaja: " + (String)results.get("INFOS"));
                    PzSwingUtility.showInformationMessage((Component)dialog, (String)"Operacija uspe\u0161na");
                }
                PzWorkerDialog.hideStatus();
            }
        };
        sw.execute();
    }

    public static void showMessage(HashMap<String, String> results) {
        String infoUredjaja = results.get("INFOS");
        System.out.println("info uredjaja je " + infoUredjaja);
        String[] poruke = infoUredjaja.split(";");
        int i = 0;
        while (i < poruke.length) {
            System.out.println(poruke[i]);
            System.out.println(poruke[i].substring(0, 1));
            if (poruke[i].substring(0, 1).equals("H")) {
                PzKasaUtil.setInfoUredjaj(poruke[i].substring(2, poruke[i].length()), "H");
            } else if (poruke[i].substring(0, 1).equals("M")) {
                PzKasaUtil.setInfoUredjaj(poruke[i].substring(2, poruke[i].length()), "M");
            }
            ++i;
        }
    }

    public static String getMessage(PzDokument dok) {
        if (dok instanceof Fiskalniracun) {
            Fiskalniracun racun = (Fiskalniracun)dok;
            if (racun.getPopust().compareTo(new BigDecimal(0)) == 0) {
                return "";
            }
            String poruka = "";
            String artikal = "";
            int i = 0;
            for (Proizvodfiskalniracun p : racun.getProizvodfiskalniracuns()) {
                artikal = "[" + p.getSifra() + "] " + p.getNaziv() + ", popust: " + p.getProcRabata() + "%, iznos popusta: " + p.getPopust();
                poruka = String.valueOf(poruka) + (i == 0 ? "" : "#crlf") + artikal;
                ++i;
            }
            return PzPorukeManager.getStandardnaPoruka((PzDokument)dok).replace("%list%", poruka).replace("%ukupno%", racun.getPopust().toString());
        }
        return "";
    }

    public static void showErorMessage(String message) {
        PzKasaUtil.setInfoUredjaj(message, "E");
    }

    public static char convertStopa(PzADTaksa d) {
        return stope.get(d.getOznTarGr()).charValue();
    }

    public static void setInfoUredjaj(final String message, final String boja) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String color = "#000000";
                String text = "";
                if (boja.equals("H")) {
                    color = "#FF0000";
                } else if (boja.equals("M")) {
                    color = "#0000FF";
                } else if (boja.equals("L")) {
                    color = "#00FF00";
                }
                if (txtComponent != null) {
                    if (!first) {
                        txtComponent.setText("<html><font color=" + color + ">" + message + "</font></html>");
                        first = true;
                    } else {
                        text = txtComponent.getText().replace("</body>", "<br><font color=" + color + ">" + message + "</font></body>");
                        txtComponent.setText(text);
                    }
                }
            }
        });
    }

    public static JTextComponent getTxtComponent() {
        return txtComponent;
    }

    public static void setTxtComponent(JTextComponent txtComponent) {
        PzKasaUtil.txtComponent = txtComponent;
        first = false;
    }

    public static synchronized void display(Proizvodfiskalniracun article, BigDecimal sum) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String price = "";
        String name = "                    ";
        String quantity = "";
        String suma = "                    ";
        final CashRegisterControl cntrl = new CashRegisterControl();
        cntrl.setControlCode("CODE_TO_DISPLAY");
        if (article != null) {
            name = "                    " + article.getNaziv();
            if (article.getKolicina() > 1.0) {
                quantity = "*" + article.getKolicina();
            }
            price = String.valueOf(quantity) + " " + article.getCena();
            name = String.valueOf((String.valueOf(article.getNaziv()) + "                    ").substring(0, 20 - price.length())) + price;
            suma = "SUMA                ";
            suma = String.valueOf(suma.toString().substring(0, 20 - sum.toString().length())) + sum.toPlainString();
        }
        parameters.put("UP", name);
        parameters.put("DOWN", suma);
        cntrl.setParameters(parameters);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CashRegisterHandler.sendToDefaultCashRegister((Object)cntrl);
                }
                catch (Exception e) {
                    System.out.println("Greska(Ok, ako kasa nije povezana): " + e.getMessage());
                }
            }
        });
        t.start();
    }

    public static synchronized void prevedi(Fiskalniracun racun) {
        if (racun.getProizvodfiskalniracuns() != null && racun.getProizvodfiskalniracuns().size() > 0) {
            for (Proizvodfiskalniracun p : racun.getProizvodfiskalniracuns()) {
                if (p.getNaziv() == null) continue;
                for (Map.Entry<String, String> e : slova.entrySet()) {
                    p.setNaziv(p.getNaziv().replaceAll(e.getKey(), e.getValue()));
                }
            }
        }
    }

    public static synchronized void prevediDok(PzDokument racun) {
        if (racun.getArtikalDocuments() != null && racun.getArtikalDocuments().size() > 0) {
            for (PzArtikalDokument p : racun.getArtikalDocuments()) {
                if (p.getNaziv() == null) continue;
                for (Map.Entry<String, String> e : slova.entrySet()) {
                    p.setNaziv(p.getNaziv().replaceAll(e.getKey(), e.getValue()));
                }
            }
        }
    }

    public static synchronized void pripremiZaStampu(Fiskalniracun dokumentK, EntityManager em, boolean arhiviraj) throws Exception {
        PzDefaultDokumentCustomizer dcust = new PzDefaultDokumentCustomizer();
        dokumentK.setCvProdajna((short)1);
        dokumentK.izracunajVrednostRobe();
        if (dokumentK.getrBroj() == 0) {
            dokumentK.setrBroj(dcust.getRBroj((PzDokument)dokumentK, em));
        }
        if (dokumentK.getRbrDok() == 0) {
            dokumentK.setRbrDok(dcust.getRbrDok((PzDokument)dokumentK, em));
        }
        if (arhiviraj) {
            dokumentK.setArhiviran((short)1);
        }
        em.flush();
        dcust.addTaksas((PzDokument)dokumentK, em);
        dcust.adjust((PzDokument)dokumentK, em);
        PzKasaUtil.setIznosRacuna(dokumentK);
        dcust.sort(dokumentK.getArtikalDocuments());
        dcust.sort(dokumentK.getUslugaDocuments());
        Collections.sort(dokumentK.getProizvodfiskalniracuns(), new Comparator<PzProizvodDokument>(){

            @Override
            public int compare(PzProizvodDokument o1, PzProizvodDokument o2) {
                if (o1.getSort() < o2.getSort()) {
                    return -1;
                }
                if (o1.getSort() > o2.getSort()) {
                    return 1;
                }
                return 0;
            }
        });
        dcust.updateDokumentInstance((PzDokument)dokumentK, true, em);
        PzKasaUtil.osveziPRNC(dokumentK, em);
        if (!arhiviraj) {
            dokumentK.createLog(21, "Spreman za stampanje na kasi", dokumentK.getUserKraj(), em);
        }
        dokumentK.formirajOznaku();
        dokumentK.getDokument().setOznDokumenta(dokumentK.getOznDokumenta());
        dokumentK.getDokument().setOpis(dokumentK.getOpis());
        if (dokumentK.getPodTip() == null) {
            dokumentK.setPodTip("");
            if (dokumentK.getDokument() != null && dokumentK.getDokument().getPodTip() == null) {
                dokumentK.getDokument().setPodTip("");
            }
        }
    }

    public static void setIznosRacuna(Fiskalniracun f) {
        BigDecimal iznos = BigDecimal.ZERO;
        if (f.getProizvodfiskalniracuns() != null && f.getProizvodfiskalniracuns().size() > 0) {
            for (Proizvodfiskalniracun p : f.getProizvodfiskalniracuns()) {
                iznos = iznos.add(BDConverter.getIznos((double)(p.getCena() * p.getKolicina())));
            }
        }
        f.setIznos(iznos);
    }

    public static synchronized void pripremiZaStampu(Fiskalniracun dokument) throws Exception {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                em.getTransaction().begin();
                PzKasaUtil.pripremiZaStampu(dokument, em, false);
                em.getTransaction().commit();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                throw e;
            }
        }
        finally {
            if (em.isOpen()) {
                em.close();
            }
        }
    }

    public static synchronized void arhivirajRacun(Fiskalniracun racun, boolean updateKolicine, boolean bezKase) throws Exception {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                em.getTransaction().begin();
                PzKasaUtil.arhivirajRacun(racun, em, updateKolicine, bezKase);
                em.getTransaction().commit();
                racun.setArhiviran((short)1);
                racun.getDokument().setArhiviran((short)1);
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                throw e;
            }
        }
        finally {
            em.close();
        }
    }

    public static synchronized void arhivirajRacun(Fiskalniracun racun, EntityManager em, boolean updateKolicine, boolean bezKase) {
        em.createQuery("UPDATE Fiskalniracun f SET f.arhiviran = 1, f.lpfrBroj = '" + racun.getLpfrBroj() + "', f.lpfrVreme = '" + racun.getLpfrVreme() + "' WHERE f.idDok=" + racun.getIdDok()).executeUpdate();
        em.createQuery("UPDATE Dokument f SET f.arhiviran = 1 WHERE f.idDok=" + racun.getIdDok()).executeUpdate();
        if (bezKase) {
            em.createQuery("UPDATE Fiskalniracun f SET f.poruka='Racun arhiviran bez kase zbog greske u programu' WHERE f.idDok=" + racun.getIdDok()).executeUpdate();
        }
        if (updateKolicine) {
            PzKasaUtil.updateStanje(racun, em);
        }
    }

    public static void napraviFakturu(Fiskalniracun racun, Komitent kupac, Date datValute) throws Exception {
        EntityManager em = PzEntityManager.getEm();
        em.getTransaction().begin();
        Faktura f = new Faktura();
        f.setTip("FAKTURA");
        f.setPodTip("FISKALNI_RACUN");
        f.setDatum(PzDateUtility.getServerDate((EntityManager)em));
        f.setDatPrometa(f.getDatum());
        f.setDatValute(datValute);
        f.setRadnajedinica(racun.getRadnajedinica());
        f.setOznDokumenta(racun.getStorno() == 0 ? racun.getLpfrBroj() : racun.getRefBroj());
        f.setStorno(racun.getStorno());
        f.setIznos(racun.getIznos());
        f.setVrednostRobe(racun.getVrednostRobe());
        f.setVrednostUsluga(racun.getVrednostUsluga());
        f.setKomitent(kupac);
        f.setSaPorezom(1);
        f.setTaksafakturas(new ArrayList());
        for (Taksafiskalniracun tfr : racun.getTaksafiskalniracuns()) {
            Taksafaktura tf = new Taksafaktura(f.getIdDok(), tfr.getId().getTip(), tfr.getId().getOznTarGr());
            tf.setTarifnagrupa(tfr.getTarifnagrupa());
            tf.setVrsta(tfr.getVrsta());
            tf.setIznos(tfr.getIznos());
            tf.setOsnovica(tfr.getOsnovica());
            tf.setFaktura(f);
            f.getTaksafakturas().add(tf);
        }
        try {
            List list = em.createQuery("SELECT f FROM Faktura f where f.storno = 0 and f.oznDokumenta = :oznDokumenta").setParameter("oznDokumenta", (Object)f.getOznDokumenta()).getResultList();
            if (list.size() > 0) {
                Faktura f1 = (Faktura)list.get(0);
                f1.setStornoIznos(f1.getStornoIznos().add(f.getIznos()));
                f.setDatValute(f1.getDatValute());
            }
            PzDokumentManager.getInstance().arhivirajDokument((PzDokument)f, true, null, em);
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
    }

    public static void napraviAvansnuFakturu(Fiskalniracun racun) throws Exception {
        EntityManager em = PzEntityManager.getEm();
        em.getTransaction().begin();
        Faktura f = new Faktura();
        f.setTip("AVANSNI_RACUN");
        f.setPodTip("AVANSNI_RACUN_IZNOS");
        f.setDatum(PzDateUtility.getServerDate((EntityManager)em));
        f.setDatValute(PzDateUtility.getServerDate((EntityManager)em));
        f.setRadnajedinica(racun.getRadnajedinica());
        f.setOznDokumenta(racun.getStorno() == 0 ? racun.getLpfrBroj() : racun.getRefBroj());
        f.setStorno(racun.getStorno());
        f.setIznos(racun.getIznos());
        f.setKomitent(racun.getKomitent());
        f.setSaPorezom(1);
        f.setTaksafakturas(new ArrayList());
        for (Taksafiskalniracun tfr : racun.getTaksafiskalniracuns()) {
            Taksafaktura tf = new Taksafaktura(f.getIdDok(), tfr.getId().getTip(), tfr.getId().getOznTarGr());
            tf.setTarifnagrupa(tfr.getTarifnagrupa());
            tf.setVrsta(tfr.getVrsta());
            tf.setIznos(tfr.getIznos());
            tf.setOsnovica(tfr.getOsnovica());
            tf.setFaktura(f);
            f.getTaksafakturas().add(tf);
        }
        try {
            List list = em.createQuery("SELECT f FROM Faktura f where f.storno = 0 and f.oznDokumenta = :oznDokumenta").setParameter("oznDokumenta", (Object)f.getOznDokumenta()).getResultList();
            if (list.size() > 0) {
                Faktura f1 = (Faktura)list.get(0);
                f1.setStornoIznos(f1.getStornoIznos().add(f.getIznos()));
                f.setDatValute(f1.getDatValute());
            }
            PzDokumentManager.getInstance().arhivirajDokument((PzDokument)f, true, null, em);
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
    }

    private static void osveziPRNC(Fiskalniracun dokument, EntityManager em) {
        if (dokument.getArtikalDocuments() != null && dokument.getArtikalDocuments().size() > 0) {
            String sifre = "";
            int i = 0;
            while (i < dokument.getArtikalDocuments().size()) {
                sifre = String.valueOf(sifre) + (i == 0 ? "" : ",") + "'" + ((PzArtikalDokument)dokument.getArtikalDocuments().get(i)).getId().getSfrProizvod() + "'";
                ++i;
            }
            sifre = "(" + sifre + ")";
            Query q = em.createQuery("SELECT s.id.sfrProizvod, s.prosNabCena FROM Stanje s WHERE s.id.sfrProizvod IN " + sifre + " AND s.radnajedinica=:rj");
            q.setParameter("rj", (Object)dokument.getRadnajedinica());
            List res = q.getResultList();
            for (PzArtikalDokument a : dokument.getArtikalDocuments()) {
                for (Object[] row : res) {
                    if (!a.getId().getSfrProizvod().equals(row[0])) continue;
                    a.setProsNabCena((BigDecimal)row[1]);
                }
            }
            for (PzArtikalDokument a : dokument.getDokument().getArtikalDocuments()) {
                for (Object[] row : res) {
                    if (!a.getId().getSfrProizvod().equals(row[0])) continue;
                    a.setProsNabCena((BigDecimal)row[1]);
                    a.setNabCena(((BigDecimal)row[1]).doubleValue());
                }
            }
        }
    }

    public static void appendInfoLine(String text) {
        if (txtComponent != null) {
            int from;
            String[] lines = txtComponent.getText().split("<br>");
            String content = "";
            int i = from = lines.length > 10 ? lines.length - 11 : 0;
            while (i < lines.length) {
                content = String.valueOf(content) + lines[i] + "<br>";
                ++i;
            }
            content = String.valueOf(content) + text;
            txtComponent.setText(text);
        }
    }

    public static String translateMessage(String message) {
        HashMap<String, String> l = new HashMap<String, String>();
        l.put("\u0160", "S");
        l.put("\u0161", "s");
        l.put("\u0110", "Dj");
        l.put("\u0111", "dj");
        l.put("\u010c", "C");
        l.put("\u010d", "c");
        l.put("\u0106", "C");
        l.put("\u0107", "c");
        l.put("\u017d", "Z");
        l.put("\u017e", "z");
        String ret = "";
        String chr = null;
        int i = 0;
        while (i < message.length()) {
            chr = (String)l.get(String.valueOf(message.charAt(i)));
            chr = chr == null ? String.valueOf(message.charAt(i)) : chr;
            ret = String.valueOf(ret) + chr;
            ++i;
        }
        return ret.replaceAll("[^\\x00-\\x7F]", "");
    }

    public static String getSN() {
        byte[] hardwareAddress = null;
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements() && hardwareAddress == null) {
                NetworkInterface networkInterface = interfaces.nextElement();
                try {
                    if (networkInterface.getHardwareAddress() == null) continue;
                    hardwareAddress = networkInterface.getHardwareAddress();
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (SocketException e1) {
            e1.printStackTrace();
        }
        if (hardwareAddress != null) {
            return PzKasaUtil.byteArrToString(hardwareAddress, "");
        }
        return String.valueOf(new java.util.Date().getTime());
    }

    private static String byteArrToString(byte[] iBytes, String iSeparator) {
        StringBuffer sb = new StringBuffer();
        byte[] byArray = iBytes;
        int n = iBytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(PzKasaUtil.byteToHex(b));
            sb.append(iSeparator);
            ++n2;
        }
        if (iSeparator.length() > 0 && sb.length() >= iSeparator.length()) {
            sb.deleteCharAt(sb.length() - iSeparator.length());
        }
        return sb.toString();
    }

    private static String byteToHex(int iVal) {
        String hx = Integer.toHexString(iVal & 0xFF).toUpperCase();
        if (hx.length() == 2) {
            return hx;
        }
        return "0" + hx;
    }
}

