/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.gui.administracija;

import com.fazecast.jSerialComm.SerialPort;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rs.pezar.kasa.display.DisplayProperties;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.fields.PzIntegerField;

public class EksterniDisplej
extends PzDialog {
    private static final long serialVersionUID = 1L;
    private PzIntegerField txtColumns;
    private PzIntegerField txtRows;
    private JComboBox<String> cbBaud;
    private JButton btnOK;
    private JComboBox<String> cbPort;
    private JLabel lblColumns;
    private JLabel lblRows;
    private JLabel lblBaud;
    private JLabel lblPort;
    private JPanel jPanel1;
    private JPanel pnlContent;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                EksterniDisplej inst = new EksterniDisplej(frame);
                inst.setVisible(true);
            }
        });
    }

    public EksterniDisplej(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public EksterniDisplej(PzDialog parent) {
        super(parent);
        this.initGUI();
        this.populateUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Parametri eksternog displeja");
            this.jPanel1 = new JPanel();
            this.getContentPane().add((Component)this.jPanel1, "Center");
            BorderLayout jPanel1Layout = new BorderLayout();
            this.jPanel1.setLayout(jPanel1Layout);
            this.jPanel1.setPreferredSize(new Dimension(384, 159));
            this.jPanel1.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.pnlContent = new JPanel();
            this.jPanel1.add((Component)this.pnlContent, "Center");
            GridBagLayout pnlContentLayout = new GridBagLayout();
            pnlContentLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
            pnlContentLayout.rowHeights = new int[]{7, 7, 7, 7, 20};
            pnlContentLayout.columnWeights = new double[]{0.1, 0.1};
            pnlContentLayout.columnWidths = new int[]{7, 7};
            this.pnlContent.setLayout(pnlContentLayout);
            this.lblPort = new JLabel("COM port:");
            this.pnlContent.add((Component)this.lblPort, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.lblPort.setName("lblPort");
            this.lblBaud = new JLabel("Baud:");
            this.pnlContent.add((Component)this.lblBaud, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.lblBaud.setName("lblBaud");
            this.lblRows = new JLabel("Broj redova:");
            this.pnlContent.add((Component)this.lblRows, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.lblRows.setName("lblRows");
            this.lblColumns = new JLabel("Broj kolona:");
            this.pnlContent.add((Component)this.lblColumns, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.lblColumns.setName("lblColumns");
            this.cbPort = new JComboBox();
            this.pnlContent.add(this.cbPort, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.btnOK = new JButton("Potvrdi");
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.pnlContent.add((Component)this.btnOK, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOK.setName("btnOK");
            this.cbBaud = new JComboBox();
            this.pnlContent.add(this.cbBaud, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.txtRows = new PzIntegerField();
            this.pnlContent.add((Component)this.txtRows, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.txtRows.setName("txtRows");
            this.txtColumns = new PzIntegerField();
            this.pnlContent.add((Component)this.txtColumns, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.txtColumns.setName("txtColumns");
            this.setSize(298, 217);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void populateUI() {
        DisplayProperties props = DisplayProperties.load();
        String[] ports = new String[SerialPort.getCommPorts().length + 1];
        ports[0] = "";
        int i = 0;
        while (i < SerialPort.getCommPorts().length) {
            SerialPort tmp = SerialPort.getCommPorts()[i];
            ports[i + 1] = tmp.getSystemPortName();
            ++i;
        }
        this.cbPort.setModel(new DefaultComboBoxModel<String>(ports));
        this.cbPort.setSelectedItem(props.getPort());
        String[] bauds = new String[]{"9600", "14400", "19200", "38400", "57600", "115200"};
        this.cbBaud.setModel(new DefaultComboBoxModel<String>(bauds));
        this.cbBaud.setSelectedItem(String.valueOf(props.getBaud()));
        this.txtRows.setVal((Object)props.getRows());
        this.txtColumns.setVal((Object)props.getColumns());
    }

    public void actionPerformed(ActionEvent e) {
        DisplayProperties.save(new DisplayProperties((String)this.cbPort.getSelectedItem(), Integer.parseInt((String)this.cbBaud.getSelectedItem()), this.txtRows.getVal(), this.txtColumns.getVal()));
        this.dispose();
    }
}

