/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.gui;

import com.swtdesigner.FocusTraversalOnArray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.OptimisticLockException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.persistence.indirection.IndirectList;
import org.jdesktop.application.Application;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.core.log.PzLogger;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Aftaksa;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fiskalniracun;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Proizvodfiskalniracun;
import rs.pezar.kasa.display.Display;
import rs.pezar.kasa.gui.IzborKomitenta;
import rs.pezar.kasa.gui.PzDialogB2B;
import rs.pezar.kasa.gui.PzDialogIzradaMaloprodajnogRacunaNew;
import rs.pezar.kasa.gui.PzDialogPIN;
import rs.pezar.kasa.gui.PzDialogPorukaZaKupca;
import rs.pezar.kasa.gui.util.PzKasaUtil;
import rs.pezar.kasa.lpfr.LPFRException;
import rs.pezar.kasa.lpfr.model.Buyer;
import rs.pezar.kasa.lpfr.model.BuyerCostCenter;
import rs.pezar.kasa.lpfr.model.BuyerIdentification;
import rs.pezar.kasa.lpfr.model.InvoiceResponse;
import rs.pezar.kasa.lpfr.model.InvoiceTransaction;
import rs.pezar.kasa.lpfr.model.RequestParams;
import rs.pezar.kasa.lpfr.rest.LPFRClient;
import rs.pezar.kasa.utility.DateTimePicker;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class ArhiviranjeNew
extends PzDialog {
    private static final String FISKALNI_PREKO_FAKTURE = "fiskalniPrekoFakture";
    private static final String STORNO_RACUNA = "storno";
    private static final String IZRADA_RACUNA = "izradaRacuna";
    private static final long serialVersionUID = 4634561238599267310L;
    private PzPanel pnlDesno;
    private PzPanel pnlFields;
    private PzDoubleField dfGotovina;
    private JLabel lbGotovina;
    private PzDoubleField dfCek;
    private JLabel lbCek;
    private PzDoubleField dfPlatnaKartica;
    private JLabel lbPlatnaKartica;
    private PzDoubleField dfIznosRacuna;
    private PzDoubleField dfKusur;
    private JLabel lbKusur;
    private PzDoubleField dfPrimljeno;
    private JLabel lbPrimljeno;
    private JLabel lbIznosRacuna;
    private PzButton btnPotvrdi;
    private Fiskalniracun racun;
    private Faktura f;
    private final boolean showReport = false;
    public Double gotovina = 0.0;
    public Double cekovi = 0.0;
    private PzDateField dfDatum;
    private JLabel lblDatum;
    private JCheckBox cbPoruka;
    private JLabel lblAvansPore;
    private JLabel lblAvans;
    private PzDoubleField dfAvansPorez;
    private PzDoubleField dfAvans;
    private JCheckBox cbAvans;
    private DateTimePicker txtRokPlacanja;
    private JLabel lblRokPlacanja;
    private PzTextField txtIdentifikator1;
    private JLabel lblIdentifikator1;
    private JComboBox cbOpcionoPolje;
    private JLabel lblOpcionoPolje;
    private PzTextField txtIdentifikator;
    private JLabel lblIdentifikator;
    private JLabel lblIdKupca;
    private JComboBox cbIdentifikacija;
    private DateTimePicker txtEsirVreme;
    private JLabel lblEsirVreme;
    private DateTimePicker txtRefVreme;
    private JLabel lblRefVreme;
    private PzTextField txtRefNumber;
    private JLabel lblRefNumber;
    private JComboBox cbTip;
    private JLabel lblTip;
    private JPanel pnlLevo;
    private PzPanel pnlGlavni;
    private PzDoubleField dfOstalo;
    private PzDoubleField dfVirman;
    private PzDoubleField dfInstant;
    private PzDoubleField dfVaucer;
    private JLabel lblOstalo;
    private JLabel lblInstant;
    private JLabel lblVaucer;
    private JLabel lblVirman;
    private PzDoubleField dfPopust;
    private JLabel lblPopust;
    private JCheckBox cbSaNivelacijom;
    private JPanel jPanel1;
    private JCheckBox cbGotovinski;
    private PzPanelHeader header;
    public Double kartice = 0.0;
    private final boolean arhiviraj = true;
    private final String parameter;
    private HashMap<String, Object> stateMap;
    private JXLayer<Component> layer;
    private PzBusyPainterUI layerUI;
    private boolean updateKolicine;
    private ArrayList<Component> fieldList = new ArrayList();
    private Komitent kupacAvans;
    private Boolean kasaPopustPoruka;

    public ArhiviranjeNew(PzDialog dialog) {
        super(dialog);
        Boolean bezKase;
        this.parameter = (String)this.getSession().getParameter("parameter");
        this.initGUI();
        this.addFieldShortcuts(this.fieldList);
        if (this.parameter.equals(FISKALNI_PREKO_FAKTURE)) {
            this.f = (Faktura)this.getSession().getParameter("racun");
            this.dfIznosRacuna.setVal((Object)this.f.getIznos());
            this.dfGotovina.setVal((Object)this.f.getIznos().subtract(this.f.getStornoIznos()));
            this.dfPrimljeno.setVal((Object)this.f.getIznos().subtract(this.f.getStornoIznos()));
            this.cbGotovinski.setEnabled(false);
        } else if (this.parameter.equals(STORNO_RACUNA)) {
            this.racun = (Fiskalniracun)this.getSession().getParameter("racun");
            this.dfIznosRacuna.setVal((Object)this.racun.getIznosRacuna());
            this.dfGotovina.setVal((Object)this.racun.getIznosRacuna());
            this.dfPrimljeno.setVal((Object)this.racun.getIznosRacuna());
            this.cbGotovinski.setEnabled(false);
        } else {
            this.racun = (Fiskalniracun)this.getSession().getParameter("racun");
            this.dfIznosRacuna.setVal((Object)this.racun.getIznosRacuna());
            this.dfGotovina.setVal((Object)this.racun.getIznosRacuna());
            this.dfPrimljeno.setVal((Object)this.racun.getIznosRacuna());
        }
        Boolean bl = bezKase = this.getSession().getParameter("bez_kase") != null ? (Boolean)this.getSession().getParameter("bez_kase") : Boolean.FALSE;
        if (bezKase.booleanValue()) {
            this.dfDatum.setEnabled(true);
        } else {
            this.dfDatum.setEnabled(false);
        }
        this.kasaPopustPoruka = PzParameter.getBoolean((String)"KASA_POPUST_PORUKA", (boolean)true);
        this.paintPanel();
        this.restState();
        this.setFocusTraversal();
        this.updateKolicine = (Boolean)this.getSession().getParameter("updateKolicine");
        if (!"generalni".equals(PzParameter.getParameterValue((String)"KASA_POPUST", (String)"")) || PzApplication.getApplication().getSession().getLoggedUser().getDozvola("POSEBNA DOZVOLA", "FAKTURA_PROMENA_RABATA") == null) {
            this.dfPopust.setEnabled(false);
        }
    }

    private void setFocusTraversal() {
        try {
            this.pnlDesno.setFocusTraversalPolicyProvider(true);
            String focus = PzParameter.getParameterValue((String)"KASA_ARHIVA_FOCUS");
            if (focus != null) {
                String[] focArr = focus.split("\\s+");
                Vector fields = this.pnlFields.getAllFields();
                ArrayList<Component> fieldsFiltered = new ArrayList<Component>();
                int i = 0;
                while (i < focArr.length) {
                    for (PzField field : fields) {
                        if (!(field instanceof PzDoubleField) || !((Component)field).getName().equals(focArr[i])) continue;
                        fieldsFiltered.add((Component)field);
                    }
                    ++i;
                }
                if (fieldsFiltered.size() > 0) {
                    fieldsFiltered.add((Component)this.btnPotvrdi);
                    Object[] cObj = fieldsFiltered.toArray();
                    Component[] components = new Component[cObj.length];
                    int i2 = 0;
                    while (i2 < components.length) {
                        components[i2] = (Component)cObj[i2];
                        ++i2;
                    }
                    this.pnlDesno.setFocusTraversalPolicy((FocusTraversalPolicy)new FocusTraversalOnArray(components));
                } else {
                    this.pnlDesno.setFocusTraversalPolicy((FocusTraversalPolicy)new FocusTraversalOnArray(new Component[]{this.dfPrimljeno, this.btnPotvrdi}));
                }
            } else {
                this.pnlDesno.setFocusTraversalPolicy((FocusTraversalPolicy)new FocusTraversalOnArray(new Component[]{this.dfPrimljeno, this.btnPotvrdi}));
            }
        }
        catch (Exception exception) {
            this.pnlDesno.setFocusTraversalPolicy((FocusTraversalPolicy)new FocusTraversalOnArray(new Component[]{this.dfPrimljeno, this.btnPotvrdi}));
        }
    }

    private void paintPanel() {
        this.pnlGlavni.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.pnlGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.pnlGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("ARHIVIRANJE");
            this.setSize(744, 643);
            this.setRestorable(false);
            this.setPreferredSize(new Dimension(744, 643));
            this.pnlGlavni = new PzPanel();
            GridBagLayout pnlGlavniLayout1 = new GridBagLayout();
            pnlGlavniLayout1.rowWeights = new double[]{0.0, 0.1};
            pnlGlavniLayout1.rowHeights = new int[]{7, 7};
            pnlGlavniLayout1.columnWeights = new double[]{0.1};
            pnlGlavniLayout1.columnWidths = new int[]{7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout1);
            this.header = new PzPanelHeader();
            this.pnlGlavni.add((Component)this.header, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 1, 1));
            this.header.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/cashier1.png")));
            this.header.setTitle("Izdavanje ra\u010duna maloprodaje");
            this.header.setName("header");
            this.pnlDesno = new PzPanel();
            this.pnlGlavni.add((Component)this.pnlDesno, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.layerUI = new PzBusyPainterUI();
            this.layer = new JXLayer((Component)this.pnlGlavni, (LayerUI)this.layerUI);
            this.getContentPane().add((Component)this.layer, "Center");
            GridBagLayout pnlDesnoLayout = new GridBagLayout();
            pnlDesnoLayout.rowWeights = new double[]{0.1, 0.1};
            pnlDesnoLayout.rowHeights = new int[]{80, 7};
            pnlDesnoLayout.columnWeights = new double[]{0.0, 0.1};
            pnlDesnoLayout.columnWidths = new int[]{382, 32};
            this.pnlDesno.setLayout((LayoutManager)pnlDesnoLayout);
            this.pnlDesno.setPreferredSize(new Dimension(390, 284));
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout1 = new GridBagLayout();
            pnlFieldsLayout1.columnWeights = new double[]{0.0, 0.1, 0.0};
            int[] nArray = new int[3];
            nArray[0] = 145;
            nArray[1] = 7;
            pnlFieldsLayout1.columnWidths = nArray;
            pnlFieldsLayout1.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout1.rowHeights = new int[]{20, 7, 20, 20, 20, 20, 7, 7, 7, 7, 7, 20, 20, 20};
            this.pnlDesno.add((Component)this.pnlFields, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout1);
            this.pnlFields.setOpaque(false);
            this.pnlFields.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 20));
            this.lbIznosRacuna = new JLabel();
            this.pnlFields.add((Component)this.lbIznosRacuna, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lbIznosRacuna.setText("Iznos racuna");
            this.lbIznosRacuna.setName("lbIznosRacuna");
            this.dfIznosRacuna = new PzDoubleField();
            this.dfIznosRacuna.setFont(new Font("SansSerif", 0, 18));
            this.pnlFields.add((Component)this.dfIznosRacuna, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 5), 0, 0));
            this.dfIznosRacuna.setLimit(7, 2);
            this.dfIznosRacuna.setFocusable(false);
            this.dfIznosRacuna.setName("dfIznosRacuna");
            this.lbPlatnaKartica = new JLabel();
            this.pnlFields.add((Component)this.lbPlatnaKartica, (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lbPlatnaKartica.setText("Platne kartice");
            this.lbPlatnaKartica.setName("lbPlatnaKartica");
            this.dfPlatnaKartica = new PzDoubleField();
            this.dfPlatnaKartica.setFont(new Font("SansSerif", 0, 18));
            this.pnlFields.add((Component)this.dfPlatnaKartica, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 5), 0, 0));
            this.dfPlatnaKartica.setLimit(7, 2);
            this.dfPlatnaKartica.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    ArhiviranjeNew.this.calculateGotovinaPrimljeno();
                }
            });
            this.dfPlatnaKartica.setName("dfPlatneKartice");
            this.lbCek = new JLabel();
            this.pnlFields.add((Component)this.lbCek, (Object)new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lbCek.setText("Cekovi");
            this.lbCek.setName("lbCek");
            this.dfCek = new PzDoubleField();
            this.dfCek.setFont(new Font("SansSerif", 0, 18));
            this.pnlFields.add((Component)this.dfCek, (Object)new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 5), 0, 0));
            this.dfCek.setDecimalFormat(PzFormatFactory.getIznosFormat());
            this.dfCek.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    ArhiviranjeNew.this.calculateGotovinaPrimljeno();
                }
            });
            this.dfCek.setName("dfCekovi");
            this.lbGotovina = new JLabel();
            this.pnlFields.add((Component)this.lbGotovina, (Object)new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lbGotovina.setText("Gotovina");
            this.lbGotovina.setName("lbGotovina");
            this.dfGotovina = new PzDoubleField();
            this.dfGotovina.setFont(new Font("SansSerif", 0, 18));
            this.pnlFields.add((Component)this.dfGotovina, (Object)new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 5), 0, 0));
            this.dfGotovina.setDecimalFormat(PzFormatFactory.getIznosFormat());
            this.dfGotovina.setFocusable(false);
            this.dfGotovina.setName("dfGotovina");
            this.lbPrimljeno = new JLabel();
            this.pnlFields.add((Component)this.lbPrimljeno, (Object)new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lbPrimljeno.setText("Primljeno");
            this.lbPrimljeno.setName("lbPrimljeno");
            this.dfPrimljeno = new PzDoubleField();
            this.dfPrimljeno.setFont(new Font("SansSerif", 0, 18));
            this.pnlFields.add((Component)this.dfPrimljeno, (Object)new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.dfPrimljeno.setDecimalFormat(PzFormatFactory.getIznosFormat());
            this.dfPrimljeno.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    ArhiviranjeNew.this.calculatePovracaj();
                }
            });
            this.dfPrimljeno.setName("dfPrimljeno");
            this.lbKusur = new JLabel();
            this.pnlFields.add((Component)this.lbKusur, (Object)new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lbKusur.setText("Povra\u0107aj");
            this.lbKusur.setName("lbKusur");
            this.dfKusur = new PzDoubleField();
            this.dfKusur.setFont(new Font("SansSerif", 0, 18));
            this.pnlFields.add((Component)this.dfKusur, (Object)new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 5), 0, 0));
            this.dfKusur.setDecimalFormat(PzFormatFactory.getIznosFormat());
            this.dfKusur.setFocusable(false);
            this.dfKusur.setName("dfKusur");
            this.cbSaNivelacijom = new JCheckBox("Sa nivelacijom");
            this.cbSaNivelacijom.setFont(new Font("SansSerif", 0, 18));
            this.cbSaNivelacijom.setOpaque(false);
            this.cbSaNivelacijom.setFocusable(false);
            this.pnlFields.add((Component)this.cbSaNivelacijom, (Object)new GridBagConstraints(1, 11, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.lblPopust = new JLabel("Popust ( % )");
            this.pnlFields.add((Component)this.lblPopust, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lblPopust.setName("lblPopust");
            this.dfPopust = new PzDoubleField();
            this.dfPopust.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    ArhiviranjeNew.this.dfPopustKeyPressed();
                }
            });
            this.dfPopust.setFont(new Font("SansSerif", 0, 18));
            this.pnlFields.add((Component)this.dfPopust, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 5), 0, 0));
            this.lblVirman = new JLabel();
            this.pnlFields.add((Component)this.lblVirman, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
            this.lblVirman.setName("lblVirman");
            this.lblVaucer = new JLabel();
            this.pnlFields.add((Component)this.lblVaucer, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
            this.lblVaucer.setName("lblVaucer");
            this.lblInstant = new JLabel();
            this.pnlFields.add((Component)this.lblInstant, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
            this.lblInstant.setName("lblInstant");
            this.lblOstalo = new JLabel();
            this.pnlFields.add((Component)this.lblOstalo, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
            this.lblOstalo.setName("lblOstalo");
            this.dfVaucer = new PzDoubleField();
            this.dfVaucer.setFont(new Font("SansSerif", 0, 18));
            this.pnlFields.add((Component)this.dfVaucer, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 5), 0, 0));
            this.dfVaucer.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    ArhiviranjeNew.this.calculateGotovinaPrimljeno();
                }
            });
            this.dfInstant = new PzDoubleField();
            this.dfInstant.setFont(new Font("SansSerif", 0, 18));
            this.pnlFields.add((Component)this.dfInstant, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 5), 0, 0));
            this.dfInstant.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    ArhiviranjeNew.this.calculateGotovinaPrimljeno();
                }
            });
            this.dfVirman = new PzDoubleField();
            this.dfVirman.setFont(new Font("SansSerif", 0, 18));
            this.pnlFields.add((Component)this.dfVirman, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 5), 0, 0));
            this.dfVirman.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    ArhiviranjeNew.this.calculateGotovinaPrimljeno();
                }
            });
            this.dfOstalo = new PzDoubleField();
            this.dfOstalo.setFont(new Font("SansSerif", 0, 18));
            this.pnlFields.add((Component)this.dfOstalo, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 5), 0, 0));
            this.dfOstalo.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    ArhiviranjeNew.this.calculateGotovinaPrimljeno();
                }
            });
            this.cbPoruka = new JCheckBox("Poruka za kupca");
            this.cbPoruka.setFont(new Font("SansSerif", 0, 18));
            this.cbPoruka.setOpaque(false);
            this.pnlFields.add((Component)this.cbPoruka, (Object)new GridBagConstraints(1, 12, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel1 = new JPanel();
            this.jPanel1.setOpaque(false);
            this.pnlDesno.add((Component)this.jPanel1, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 15, 0), 0, 0));
            this.btnPotvrdi = new PzButton();
            this.btnPotvrdi.setFont(new Font("SansSerif", 0, 18));
            this.jPanel1.add((Component)this.btnPotvrdi);
            this.btnPotvrdi.setText("Izdaj ra\u010dun (Ctrl+W)");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/check.png")));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setShortcut("Ctrl+W");
            this.btnPotvrdi.setPreferredSize(new Dimension(256, 36));
            this.pnlLevo = new JPanel();
            GridBagLayout pnlLevoLayout = new GridBagLayout();
            this.pnlDesno.add((Component)this.pnlLevo, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlLevo.setName("pnlLevo");
            pnlLevoLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlLevoLayout.rowHeights = new int[]{7, 7, 20, 20, 20, 20, 20, 20, 20, 20, 7, 20, 20, 20};
            pnlLevoLayout.columnWeights = new double[]{0.0, 0.1};
            pnlLevoLayout.columnWidths = new int[]{121, 7};
            this.pnlLevo.setLayout(pnlLevoLayout);
            this.pnlLevo.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            this.lblDatum = new JLabel("Datum");
            this.pnlLevo.add((Component)this.lblDatum, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblDatum.setName("lblDatum");
            this.dfDatum = new PzDateField();
            this.pnlLevo.add((Component)this.dfDatum, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.dfDatum.setFont(new Font("SansSerif", 0, 18));
            this.lblTip = new JLabel();
            this.pnlLevo.add((Component)this.lblTip, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblTip.setName("lblTip");
            this.cbTip = new JComboBox();
            this.cbTip.setFont(new Font("SansSerif", 0, 18));
            this.pnlLevo.add((Component)this.cbTip, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.cbTip.setModel(new DefaultComboBoxModel<InvoiceTransaction>(InvoiceTransaction.getAll()));
            this.cbTip.setName("cbTip");
            this.cbTip.setMinimumSize(new Dimension(200, 30));
            this.cbTip.setSelectedItem(null);
            this.lblRefNumber = new JLabel();
            this.pnlLevo.add((Component)this.lblRefNumber, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblRefNumber.setName("lblRefNumber");
            this.txtRefNumber = new PzTextField();
            this.txtRefNumber.setToUpperCase(true);
            this.txtRefNumber.setFont(new Font("SansSerif", 0, 18));
            this.pnlLevo.add((Component)this.txtRefNumber, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.lblRefVreme = new JLabel();
            this.pnlLevo.add((Component)this.lblRefVreme, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblRefVreme.setName("lblRefVreme");
            this.txtRefVreme = new DateTimePicker();
            this.txtRefVreme.setFormats(new DateFormat[]{new SimpleDateFormat("dd.MM.yyyy HH:mm:ss")});
            this.txtRefVreme.setTimeFormat(new SimpleDateFormat("HH:mm:ss"));
            this.txtRefVreme.setFont(new Font("SansSerif", 0, 18));
            this.pnlLevo.add((Component)((Object)this.txtRefVreme), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.lblEsirVreme = new JLabel();
            this.pnlLevo.add((Component)this.lblEsirVreme, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblEsirVreme.setName("lblEsirVreme");
            this.txtEsirVreme = new DateTimePicker();
            this.txtEsirVreme.setFormats(new DateFormat[]{new SimpleDateFormat("dd.MM.yyyy HH:mm:ss")});
            this.txtEsirVreme.setTimeFormat(new SimpleDateFormat("HH:mm:ss"));
            this.txtEsirVreme.setFont(new Font("SansSerif", 0, 18));
            this.pnlLevo.add((Component)((Object)this.txtEsirVreme), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.cbIdentifikacija = new JComboBox();
            this.cbIdentifikacija.setMinimumSize(new Dimension(200, 30));
            this.cbIdentifikacija.setFont(new Font("SansSerif", 0, 18));
            this.pnlLevo.add((Component)this.cbIdentifikacija, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.cbIdentifikacija.setModel(new DefaultComboBoxModel<BuyerIdentification>(BuyerIdentification.getAll()));
            this.cbIdentifikacija.setSelectedItem(null);
            this.lblIdKupca = new JLabel();
            this.pnlLevo.add((Component)this.lblIdKupca, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblIdKupca.setName("lblIdKupca");
            this.lblIdentifikator = new JLabel();
            this.pnlLevo.add((Component)this.lblIdentifikator, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblIdentifikator.setName("lblIdentifikator");
            this.txtIdentifikator = new PzTextField();
            this.txtIdentifikator.setToUpperCase(true);
            this.txtIdentifikator.setFont(new Font("SansSerif", 0, 18));
            this.pnlLevo.add((Component)this.txtIdentifikator, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.lblOpcionoPolje = new JLabel();
            this.pnlLevo.add((Component)this.lblOpcionoPolje, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblOpcionoPolje.setName("lblOpcionoPolje");
            this.cbOpcionoPolje = new JComboBox<BuyerCostCenter>(new DefaultComboBoxModel<BuyerCostCenter>(BuyerCostCenter.getAll()));
            this.pnlLevo.add((Component)this.cbOpcionoPolje, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.cbOpcionoPolje.setFont(new Font("SansSerif", 0, 18));
            this.cbOpcionoPolje.setMinimumSize(new Dimension(200, 30));
            this.cbOpcionoPolje.setName("cbOpcionoPolje");
            this.cbOpcionoPolje.setSelectedItem(null);
            this.lblIdentifikator1 = new JLabel();
            this.pnlLevo.add((Component)this.lblIdentifikator1, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblIdentifikator1.setName("lblIdentifikator1");
            this.txtIdentifikator1 = new PzTextField();
            this.txtIdentifikator1.setToUpperCase(true);
            this.txtIdentifikator1.setFont(new Font("SansSerif", 0, 18));
            this.pnlLevo.add((Component)this.txtIdentifikator1, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.cbGotovinski = new JCheckBox("Gotovinski ra\u010dun");
            this.pnlLevo.add((Component)this.cbGotovinski, new GridBagConstraints(1, 13, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.cbGotovinski.setFont(new Font("SansSerif", 0, 18));
            this.cbGotovinski.setOpaque(false);
            this.cbGotovinski.setSelected(true);
            this.lblRokPlacanja = new JLabel();
            this.pnlLevo.add((Component)this.lblRokPlacanja, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.lblRokPlacanja.setName("lblRokPlacanja");
            this.txtRokPlacanja = new DateTimePicker();
            this.txtRokPlacanja.setFormats(new DateFormat[]{new SimpleDateFormat("dd.MM.yyyy")});
            this.txtRokPlacanja.setFont(new Font("SansSerif", 0, 18));
            this.pnlLevo.add((Component)((Object)this.txtRokPlacanja), new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.cbAvans = new JCheckBox();
            this.cbAvans.setOpaque(false);
            this.pnlLevo.add((Component)this.cbAvans, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 3, 0), 0, 0));
            this.cbAvans.setName("cbAvans");
            this.dfAvans = new PzDoubleField();
            this.dfAvans.setEnabled(false);
            this.dfAvans.setFont(new Font("SansSerif", 0, 18));
            this.pnlLevo.add((Component)this.dfAvans, new GridBagConstraints(1, 11, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.dfAvans.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    ArhiviranjeNew.this.calculateGotovinaPrimljeno();
                }
            });
            this.dfAvansPorez = new PzDoubleField();
            this.dfAvansPorez.setEnabled(false);
            this.dfAvansPorez.setFont(new Font("SansSerif", 0, 18));
            this.pnlLevo.add((Component)this.dfAvansPorez, new GridBagConstraints(1, 12, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.lblAvans = new JLabel();
            this.pnlLevo.add((Component)this.lblAvans, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.lblAvans.setName("lblAvans");
            this.lblAvansPore = new JLabel();
            this.pnlLevo.add((Component)this.lblAvansPore, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.lblAvansPore.setName("lblAvansPore");
            this.cbIdentifikacija.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    BuyerIdentification id = (BuyerIdentification)e.getItem();
                    ArhiviranjeNew.this.txtIdentifikator.setEnabled(id.getId() != null);
                    ArhiviranjeNew.this.cbOpcionoPolje.setEnabled(id.getId() != null);
                    BuyerCostCenter bc = (BuyerCostCenter)ArhiviranjeNew.this.cbOpcionoPolje.getSelectedItem();
                    ArhiviranjeNew.this.txtIdentifikator1.setEnabled(id.getId() != null && bc.getValue() != null);
                    ArhiviranjeNew.this.cbGotovinski.setEnabled(BuyerIdentification.PIB_KUPCA.getId().equals(id.getId()));
                    ArhiviranjeNew.this.cbGotovinski.setSelected(BuyerIdentification.PIB_KUPCA.getId().equals(id.getId()));
                }
            });
            this.cbIdentifikacija.setSelectedIndex(0);
            this.cbOpcionoPolje.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    BuyerCostCenter bc = (BuyerCostCenter)e.getItem();
                    ArhiviranjeNew.this.txtIdentifikator1.setEnabled(bc.getValue() != null);
                }
            });
            this.cbOpcionoPolje.setSelectedIndex(0);
            this.cbTip.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    InvoiceTransaction it = (InvoiceTransaction)e.getItem();
                    if (InvoiceTransaction.isReferenceOption(it)) {
                        ArhiviranjeNew.this.txtRefNumber.setEnabled(true);
                        ArhiviranjeNew.this.txtRefVreme.setEnabled(true);
                    } else {
                        ArhiviranjeNew.this.txtRefNumber.setEnabled(false);
                        ArhiviranjeNew.this.txtRefNumber.setText("");
                        ArhiviranjeNew.this.txtRefVreme.setEnabled(false);
                        ArhiviranjeNew.this.txtRefVreme.setDate(null);
                    }
                    ArhiviranjeNew.this.txtEsirVreme.setEnabled(it.getInvoiceType().equals(InvoiceTransaction.ADVANCE_SALE.getInvoiceType()));
                    ArhiviranjeNew.this.txtRokPlacanja.setEnabled(it.equals(InvoiceTransaction.PROFORMA_SALE));
                    if (it.equals(InvoiceTransaction.NORMAL_SALE)) {
                        ArhiviranjeNew.this.cbAvans.setEnabled(true);
                    } else {
                        ArhiviranjeNew.this.cbAvans.setEnabled(false);
                        ArhiviranjeNew.this.cbAvans.setSelected(false);
                    }
                }
            });
            this.cbTip.setSelectedIndex(0);
            this.cbAvans.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ArhiviranjeNew.this.dfAvans.setEnabled(ArhiviranjeNew.this.cbAvans.isSelected());
                    ArhiviranjeNew.this.dfAvansPorez.setEnabled(ArhiviranjeNew.this.cbAvans.isSelected());
                    if (!ArhiviranjeNew.this.cbAvans.isSelected()) {
                        ArhiviranjeNew.this.dfAvans.setVal((Object)new Double(0.0));
                        ArhiviranjeNew.this.dfAvansPorez.setVal((Object)new Double(0.0));
                    }
                }
            });
            this.fieldList.add((Component)this.dfPlatnaKartica);
            this.fieldList.add((Component)this.dfCek);
            this.fieldList.add((Component)this.dfPrimljeno);
            this.fieldList.add((Component)this.btnPotvrdi);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void addFieldShortcuts(final ArrayList<Component> list) {
        for (final Component field : list) {
            field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    int i = list.indexOf(field);
                    if (e.getKeyCode() == 38) {
                        if (i != 0) {
                            ((Component)list.get(i - 1)).requestFocusInWindow();
                            if (list.get(i - 1) instanceof PzDoubleField && list.get(i) instanceof PzDoubleField) {
                                PzDoubleField s = (PzDoubleField)list.get(i - 1);
                                PzDoubleField t = (PzDoubleField)list.get(i);
                                if (t.getVal().equals(ArhiviranjeNew.this.dfIznosRacuna.getVal())) {
                                    t.setVal((Object)new Double(0.0));
                                    s.setVal((Object)ArhiviranjeNew.this.dfIznosRacuna.getVal());
                                    ArhiviranjeNew.this.calculateGotovinaPrimljeno();
                                }
                            }
                        }
                    } else if (e.getKeyCode() == 40) {
                        if (i != list.size() - 1) {
                            ((Component)list.get(i + 1)).requestFocusInWindow();
                            if (list.get(i + 1) instanceof PzDoubleField && list.get(i) instanceof PzDoubleField) {
                                PzDoubleField s = (PzDoubleField)list.get(i + 1);
                                PzDoubleField t = (PzDoubleField)list.get(i);
                                if (t.getVal().equals(ArhiviranjeNew.this.dfIznosRacuna.getVal())) {
                                    t.setVal((Object)new Double(0.0));
                                    s.setVal((Object)ArhiviranjeNew.this.dfIznosRacuna.getVal());
                                    ArhiviranjeNew.this.calculateGotovinaPrimljeno();
                                }
                            }
                        }
                    } else if (e.getKeyCode() == 113) {
                        ArhiviranjeNew.this.dfPopust.requestFocusInWindow();
                    }
                }
            });
        }
    }

    private void calculateGotovinaPrimljeno() {
        double i = this.dfIznosRacuna.getVal();
        double c = this.dfCek.getVal();
        double k = this.dfPlatnaKartica.getVal();
        double va = this.dfVaucer.getVal();
        double vi = this.dfVirman.getVal();
        double ips = this.dfInstant.getVal();
        double o = this.dfOstalo.getVal();
        double a = this.dfAvans.getVal();
        double raz = i - c - k - va - vi - ips - o - a;
        this.dfGotovina.setVal((Object)raz);
        this.dfPrimljeno.setVal((Object)(raz > 0.0 ? raz : 0.0));
        this.calculatePovracaj();
    }

    private void calculatePovracaj() {
        this.dfKusur.setVal((Object)(this.dfPrimljeno.getVal() + this.dfCek.getVal() + this.dfPlatnaKartica.getVal() + this.dfVirman.getVal() + this.dfVaucer.getVal() + this.dfInstant.getVal() + this.dfOstalo.getVal() + this.dfAvans.getVal() - this.dfIznosRacuna.getVal()));
    }

    private void dfPopustKeyPressed() {
        Double iznos = new Double(this.racun.getIznosRacuna().doubleValue() - this.racun.getIznosRacuna().doubleValue() * (this.dfPopust.getVal() / 100.0));
        this.dfIznosRacuna.setVal((Object)iznos);
        this.dfGotovina.setVal((Object)iznos);
        this.dfPrimljeno.setVal((Object)iznos);
        this.dfPlatnaKartica.setVal((Object)new Double(0.0));
        this.dfCek.setVal((Object)new Double(0.0));
        this.dfInstant.setVal((Object)new Double(0.0));
        this.dfVaucer.setVal((Object)new Double(0.0));
        this.dfVirman.setVal((Object)new Double(0.0));
        this.dfOstalo.setVal((Object)new Double(0.0));
        this.dfAvans.setVal((Object)new Double(0.0));
        this.dfAvansPorez.setVal((Object)new Double(0.0));
    }

    public void actionPerformed(ActionEvent e) {
        try {
            PzButton button = (PzButton)e.getSource();
            String actionCommand = button.getActionCommand();
            if (actionCommand.equals("potvrdi") && this.parameter.equals(IZRADA_RACUNA)) {
                this.izdavanjeRacuna();
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    private void izdavanjeRacuna() {
        InvoiceTransaction it;
        int rez;
        if (this.dfKusur.getBigDecimal().compareTo(new BigDecimal("1000000")) > 0 && (rez = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Nelogican iznos povracaja. Nastavljate dalje?", (String)"Potencijalni problem", null, (boolean)true)) == 1) {
            return;
        }
        if (this.cbPoruka.isSelected()) {
            this.showDialog(PzDialogPorukaZaKupca.class);
            if (this.getSession().getParameter("poruka_za_kupca") == null) {
                return;
            }
        }
        if (InvoiceTransaction.isAdvance(it = (InvoiceTransaction)this.cbTip.getSelectedItem())) {
            this.kupacAvans = IzborKomitenta.getKomitent(this);
            if (this.kupacAvans == null) {
                return;
            }
            this.racun.setKomitent(this.kupacAvans);
            if (this.kupacAvans.getTip() == 0) {
                this.cbIdentifikacija.setSelectedItem(BuyerIdentification.PIB_KUPCA);
                this.txtIdentifikator.setText(this.kupacAvans.getPib());
                this.cbGotovinski.setSelected(false);
            } else if (this.kupacAvans.getTip() == 2 && this.kupacAvans.getPib().length() == 13) {
                this.cbIdentifikacija.setSelectedItem(BuyerIdentification.JMBG);
                this.txtIdentifikator.setText(this.kupacAvans.getPib());
            }
            if (it.equals(InvoiceTransaction.ADVANCE_SALE)) {
                this.handleAdvance();
            }
        }
        this.calculatePovracaj();
        if (this.layerUI.isLocked()) {
            return;
        }
        try {
            if (!this.proveriPodatke()) {
                return;
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Throwable)e1);
            return;
        }
        Buyer buyer = null;
        if (this.cbGotovinski.isEnabled() && this.cbGotovinski.isSelected() && !InvoiceTransaction.isAdvance(it)) {
            this.showDialog(PzDialogB2B.class);
            if (this.getSession().getParameter("KUPAC") != null) {
                buyer = (Buyer)this.getSession().popParameter("KUPAC");
                this.txtIdentifikator.setText(buyer.getPib());
            } else {
                return;
            }
        }
        final Buyer kupac = buyer;
        if (this.layerUI.isLocked()) {
            return;
        }
        try {
            PzDialogPIN.verifyPIN(this);
        }
        catch (LPFRException e1) {
            JOptionPane.showMessageDialog((Component)((Object)this), e1.getFullMessage(), "L-PFR greska", 0);
            return;
        }
        this.layerUI.setLocked(true);
        SwingWorker<InvoiceResponse, Object> worker = new SwingWorker<InvoiceResponse, Object>(){

            @Override
            protected InvoiceResponse doInBackground() throws Exception {
                LPFRClient client = new LPFRClient();
                ArhiviranjeNew.this.ocisti();
                Boolean bezKase = (Boolean)ArhiviranjeNew.this.getSession().getParameter("bez_kase");
                if (bezKase == null) {
                    bezKase = Boolean.FALSE;
                }
                if (!bezKase.booleanValue()) {
                    BuyerCostCenter bc;
                    BuyerIdentification bi;
                    if (!ArhiviranjeNew.this.pripremiRacunZaStampu(false, ArhiviranjeNew.this.cbSaNivelacijom.isSelected(), kupac)) {
                        return null;
                    }
                    RequestParams.Builder builder = RequestParams.getBuilder().withInvoiceType(it.getInvoiceType()).withTransactionType(it.getTransactionType()).withPayment("Cash", ArhiviranjeNew.this.dfPrimljeno.getBigDecimal()).withPayment("Card", ArhiviranjeNew.this.dfPlatnaKartica.getBigDecimal()).withPayment("Check", ArhiviranjeNew.this.dfCek.getBigDecimal()).withPayment("Voucher", ArhiviranjeNew.this.dfVaucer.getBigDecimal()).withPayment("WireTransfer", ArhiviranjeNew.this.dfVirman.getBigDecimal()).withPayment("MobileMoney", ArhiviranjeNew.this.dfInstant.getBigDecimal()).withPayment("Other", ArhiviranjeNew.this.dfOstalo.getBigDecimal()).withMessage((String)ArhiviranjeNew.this.getSession().popParameter("poruka_za_kupca"));
                    if (ArhiviranjeNew.this.racun.getPopust().compareTo(BigDecimal.ZERO) > 0 && ArhiviranjeNew.this.kasaPopustPoruka.booleanValue()) {
                        builder.withMessage("\r\nKUPOVINOM U NA\u0160OJ PRODAVNICI OSTVARILI STE POPUST OD " + PzFormatFactory.getIznosFormat().format(ArhiviranjeNew.this.racun.getPopust()) + " DINARA \r\n\r\n\r\n");
                    }
                    if (ArhiviranjeNew.this.cbAvans.isSelected()) {
                        builder.withAdvance(ArhiviranjeNew.this.dfAvans.getBigDecimal()).withAdvanceTax(ArhiviranjeNew.this.dfAvansPorez.getBigDecimal());
                    }
                    if (ArhiviranjeNew.this.txtRokPlacanja.getDate() != null) {
                        builder.withValidTo(ArhiviranjeNew.this.txtRokPlacanja.getDate());
                    }
                    if (ArhiviranjeNew.this.txtRefNumber.isEnabled() && !ArhiviranjeNew.this.txtRefNumber.getText().equals("")) {
                        builder.withReferentDocumentNumber(ArhiviranjeNew.this.txtRefNumber.getText());
                    }
                    if (ArhiviranjeNew.this.txtRefVreme.isEnabled() && ArhiviranjeNew.this.txtRefVreme.getDate() != null) {
                        builder.withReferentDocumentDT(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(ArhiviranjeNew.this.txtRefVreme.getDate()));
                    }
                    if (ArhiviranjeNew.this.txtEsirVreme.isEnabled() && ArhiviranjeNew.this.txtEsirVreme.getDate() != null) {
                        builder.withDateAndTimeOfIssue(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(ArhiviranjeNew.this.txtEsirVreme.getDate()));
                    }
                    if (ArhiviranjeNew.this.cbIdentifikacija.getSelectedIndex() != -1 && (bi = (BuyerIdentification)ArhiviranjeNew.this.cbIdentifikacija.getSelectedItem()).getId() != null) {
                        builder.withBuyerId(bi.value(ArhiviranjeNew.this.txtIdentifikator.getText()));
                    }
                    if (ArhiviranjeNew.this.cbOpcionoPolje.getSelectedIndex() != -1 && (bc = (BuyerCostCenter)ArhiviranjeNew.this.cbOpcionoPolje.getSelectedItem()).getValue() != null) {
                        builder.withBuyerCostCenterId(bc.value(ArhiviranjeNew.this.txtIdentifikator1.getText()));
                    }
                    client.setTaxMap(PzEntityManager.getList((String)"SELECT t FROM TaxMap t"));
                    return client.createInvoice(ArhiviranjeNew.this.racun, builder.build());
                }
                ArhiviranjeNew.this.racun.setPoruka("Ra\u010dun registrovan bez \u0161tampanja na fiskalnom \u0161tampa\u010du");
                ArhiviranjeNew.this.pripremiRacunZaStampu(true, ArhiviranjeNew.this.cbSaNivelacijom.isSelected(), kupac);
                return null;
            }

            @Override
            protected void done() {
                block11: {
                    Boolean bezKase = ArhiviranjeNew.this.getSession() != null && ArhiviranjeNew.this.getSession().getParameter("bez_kase") != null ? (Boolean)ArhiviranjeNew.this.getSession().getParameter("bez_kase") : Boolean.FALSE;
                    try {
                        InvoiceResponse odstampan = (InvoiceResponse)this.get();
                        if (odstampan == null && !bezKase.booleanValue()) {
                            return;
                        }
                        try {
                            if (!bezKase.booleanValue()) {
                                ArhiviranjeNew.this.racun.setLpfrBroj(odstampan.getInvoiceNumber());
                                ArhiviranjeNew.this.racun.setLpfrVreme(odstampan.getSdcDateTime());
                            }
                            ArhiviranjeNew.this.arhivirajRacun(bezKase);
                            ArhiviranjeNew.this.napraviPrazanRacun();
                            ArhiviranjeNew.this.saveState();
                            ArhiviranjeNew.this.dispose();
                            Display.instance().displayText("     Hvala Vam", "     na poseti");
                        }
                        catch (Exception e) {
                            if (e.getCause() instanceof LPFRException) {
                                JOptionPane.showMessageDialog((Component)((Object)ArhiviranjeNew.this), ((LPFRException)e.getCause()).getFullMessage(), "L-PFR greska", 0);
                                if (e.getCause() != null) {
                                    PzLogger.getInstance().logException((Throwable)e);
                                }
                                break block11;
                            }
                            if (!(e instanceof OptimisticLockException) && !(e instanceof OptimisticLockException)) {
                                PzMysqlExceptionHandler.handle((Throwable)e);
                                break block11;
                            }
                            PzMysqlExceptionHandler.handle((Throwable)e);
                        }
                    }
                    finally {
                        ArhiviranjeNew.this.layerUI.setLocked(false);
                    }
                }
            }
        };
        worker.execute();
    }

    private void handleAdvance() {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        List idlist = em.createQuery("SELECT MAX(f.idDok) FROM Fiskalniracun f WHERE f.podTip='Advance-Sale' and f.arhiviran = 1 AND f.komitent.sfrKomitent = '" + this.kupacAvans.getSfrKomitent() + "' AND f.iznos - f.stornoIznos > 0").getResultList();
        if (idlist.size() > 0 && idlist.get(0) != null) {
            Fiskalniracun f = (Fiskalniracun)em.find(Fiskalniracun.class, idlist.get(0));
            this.txtRefNumber.setVal((Object)f.getLpfrBroj());
            try {
                this.txtRefVreme.setDate(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(f.getLpfrVreme().replaceAll("\\+.+", "")));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean proveriPodatke() throws Exception {
        if (this.dfPrimljeno.getVal() < 0.0) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Primljeni iznos ne mo\u017ee biti negativan");
            return false;
        }
        Double d = new Double(0.0);
        if (this.dfKusur.getVal() < d) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Gre\u0161ka! Povra\u0107aj ne mo\u017ee biti negativan. Proverite unete podatke.");
            return false;
        }
        BigDecimal suma = this.dfCek.getBigDecimal().add(this.dfPlatnaKartica.getBigDecimal()).add(this.dfGotovina.getBigDecimal()).add(this.dfVirman.getBigDecimal()).add(this.dfInstant.getBigDecimal()).add(this.dfVaucer.getBigDecimal()).add(this.dfOstalo.getBigDecimal()).add(this.dfAvans.getBigDecimal());
        if (suma.compareTo(this.dfIznosRacuna.getBigDecimal()) != 0) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Iznos racuna se ne slaze sa zbirom pojedinacnih uplata");
            return false;
        }
        InvoiceTransaction it = (InvoiceTransaction)this.cbTip.getSelectedItem();
        if (InvoiceTransaction.isReferenceRequired(it) && (this.txtRefNumber.getText().equals("") || this.txtRefVreme.getDate() == null)) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)("Za izabrani tip ra\u010duna '" + it.getDescription() + "' morate uneti referentni broj i referentno vreme"));
            return false;
        }
        BuyerIdentification bi = (BuyerIdentification)this.cbIdentifikacija.getSelectedItem();
        if (bi.getId() != null && !this.cbGotovinski.isSelected() && this.txtIdentifikator.getText().equals("")) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Morate popuniti identifikator kupca");
            return false;
        }
        BuyerCostCenter bc = (BuyerCostCenter)this.cbOpcionoPolje.getSelectedItem();
        if (bc.getValue() != null && this.txtIdentifikator1.getText().equals("")) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Morate popuniti identifikator za opciono polje kupca");
            return false;
        }
        if (!this.txtRefNumber.getText().equals("")) {
            if (!this.txtRefNumber.getText().matches("[A-Z0-9]{8}\\-[A-Z0-9]{8}\\-\\d+")) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Neispravan format referentnog broja");
                return false;
            }
            if (this.txtRefVreme.getDate() == null) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Morate popuniti polje 'Referentno vreme'");
                return false;
            }
        }
        if (this.cbAvans.isSelected()) {
            if (BigDecimal.ZERO.compareTo(this.dfAvans.getBigDecimal()) >= 0) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Iznos avansne uplate nije validan");
                return false;
            }
            if (PzFirma.getFirma().getPdvObveznik() == 1 && BigDecimal.ZERO.compareTo(this.dfAvansPorez.getBigDecimal()) >= 0) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Iznos poreza na avans nije validan");
                return false;
            }
            if (this.txtRefNumber.getText().equals("") || this.txtRefVreme.getDate() == null) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Kod pokrivanja avansom morate popuniti polja 'Referentni broj' i 'Referentno vreme'");
                return false;
            }
        }
        return true;
    }

    private void ocisti() {
        block2: {
            EntityManager em = PzEntityManagerFactory.getInstance().createEm();
            try {
                em.getTransaction().begin();
                em.createQuery("DELETE FROM Taksafiskalniracun t WHERE t.id.idDok=" + this.racun.getIdDok()).executeUpdate();
                em.createQuery("DELETE FROM Dtaksa t WHERE t.id.idDok=" + this.racun.getIdDok()).executeUpdate();
                em.getTransaction().commit();
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Throwable)e);
                if (!em.getTransaction().isActive()) break block2;
                em.getTransaction().commit();
            }
        }
    }

    private void saveState() throws IOException {
        HashMap<String, Boolean> m = new HashMap<String, Boolean>();
        m.put("cbSaNivelacijom", this.cbSaNivelacijom.isSelected());
        PzApplication.getApplication().getPropManager().saveObject(m, "arh_fisk.sav");
    }

    private void restState() {
        try {
            this.stateMap = (HashMap)PzApplication.getApplication().getPropManager().loadObject("arh_fisk.sav");
        }
        catch (Exception exception) {}
        if (this.stateMap == null) {
            this.stateMap = new HashMap();
            if (this.racun.getRadnajedinica().getpTip().equals("V")) {
                this.stateMap.put("cbSaNivelacijom", false);
            } else {
                this.stateMap.put("cbSaNivelacijom", true);
            }
        }
        this.cbSaNivelacijom.setSelected((Boolean)this.stateMap.get("cbSaNivelacijom"));
    }

    private boolean pripremiRacunZaStampu(boolean arhiviraj, boolean saNivelacijom, Buyer kupac) throws Exception {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        boolean nivSuccess = !saNivelacijom;
        try {
            Boolean bezKase;
            BuyerCostCenter bc;
            BuyerIdentification bi;
            em.getTransaction().begin();
            InvoiceTransaction it = (InvoiceTransaction)this.cbTip.getSelectedItem();
            if (it.equals(InvoiceTransaction.NORMAL_SALE) && !PzKasaUtil.proveriStanje(this.racun, em)) {
                return false;
            }
            this.racun = (Fiskalniracun)em.createQuery("SELECT f FROM Fiskalniracun F JOIN FETCH f.proizvodfiskalniracuns JOIN FETCH f.dokument WHERE f.idDok=" + this.racun.getIdDok()).getSingleResult();
            if (this.dfPopust.getVal().compareTo(new Double(0.0)) > 0 && this.racun.getProizvodfiskalniracuns() != null && this.racun.getProizvodfiskalniracuns().size() > 0) {
                for (Proizvodfiskalniracun p : this.racun.getProizvodfiskalniracuns()) {
                    p.setProcRabata(p.getProcRabata() + this.dfPopust.getVal());
                }
                this.racun.primeniPopustNaCene();
            }
            this.racun.setTip(it.getInvoiceType().equals("Normal") ? "FISKALNI_RACUN" : "ISECAK");
            this.racun.setPodTip(it.getValue());
            this.racun.setStorno(it.getTransactionType().equals("Refund") ? 1 : 0);
            this.racun.sumirajPopust();
            this.racun.setGotovina(this.dfGotovina.getBigDecimal());
            this.racun.setCekovi(this.dfCek.getBigDecimal());
            this.racun.setKartice(this.dfPlatnaKartica.getBigDecimal());
            this.racun.setVirman(this.dfVirman.getBigDecimal());
            this.racun.setVaucer(this.dfVaucer.getBigDecimal());
            this.racun.setIps(this.dfInstant.getBigDecimal());
            this.racun.setOstalo(this.dfOstalo.getBigDecimal());
            this.racun.setPrimljeno(this.dfPrimljeno.getBigDecimal());
            if (!this.txtRefNumber.getText().equals("")) {
                this.racun.setRefBroj(this.txtRefNumber.getText());
            }
            if (this.txtRefVreme.isEnabled() && this.txtRefVreme.getDate() != null) {
                this.racun.setRefVreme(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.txtRefVreme.getDate()));
            }
            if (this.cbIdentifikacija.getSelectedIndex() != -1 && (bi = (BuyerIdentification)this.cbIdentifikacija.getSelectedItem()).getId() != null) {
                this.racun.setIdKupca(bi.value(this.txtIdentifikator.getText()));
            }
            if (InvoiceTransaction.isAdvance(it) || this.kupacAvans != null) {
                this.racun.setKomitent((Komitent)em.find(Komitent.class, (Object)this.kupacAvans.getSfrKomitent()));
            }
            if (this.cbOpcionoPolje.getSelectedIndex() != -1 && (bc = (BuyerCostCenter)this.cbOpcionoPolje.getSelectedItem()).getValue() != null) {
                this.racun.setOpcionoPolje(bc.value(this.txtIdentifikator1.getText()));
            }
            Timestamp datum = PzDateUtility.getServerTime((EntityManager)em);
            Boolean bl = bezKase = this.getSession().getParameter("bez_kase") != null ? (Boolean)this.getSession().getParameter("bez_kase") : Boolean.FALSE;
            if (bezKase.booleanValue()) {
                this.racun.setVreme(new Timestamp(this.dfDatum.getVal().getTime()));
            } else {
                this.racun.setVreme(datum);
            }
            Nivelacija nivelacija = null;
            if (saNivelacijom && Arrays.asList(InvoiceTransaction.NORMAL_SALE, InvoiceTransaction.NORMAL_REFUND).contains(it)) {
                Faktura f = this.getFaktura(this.racun, em);
                nivelacija = PzEntityUtil.createNivelacija((PzDokument)f, (boolean)false, (boolean)true, (EntityManager)em);
                this.arhiviraj(nivelacija, em);
                nivSuccess = true;
            }
            if (kupac != null) {
                this.racun.setPib(kupac.getPib());
                this.racun.setMbr(kupac.getMbr());
                this.racun.setNazivKupca(kupac.getNaziv());
                this.racun.setAdresa(kupac.getAdresa());
                this.racun.setGrad(kupac.getGrad());
            }
            PzKasaUtil.pripremiZaStampu(this.racun, em, arhiviraj);
            em.getTransaction().commit();
            if (nivelacija != null) {
                this.header.setText("Registrovana je promena cene tako da \u0107e biti izra\u0111ena nivelacija.");
            }
            return true;
        }
        catch (Exception e) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            if (e instanceof OptimisticLockException || e instanceof OptimisticLockException) {
                boolean bl = this.pripremiRacunZaStampu(arhiviraj, !nivSuccess, kupac);
                return bl;
            }
            throw e;
        }
        finally {
            em.close();
        }
    }

    private void arhivirajRacun(boolean bezKase) throws Exception {
        try {
            PzKasaUtil.arhivirajRacun(this.racun, this.updateKolicine, bezKase);
            if (this.racun.getPodTip().equals("Advance-Sale")) {
                PzKasaUtil.napraviAvansnuFakturu(this.racun);
            }
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (e instanceof OptimisticLockException || cause != null && cause instanceof OptimisticLockException) {
                e.printStackTrace();
                this.arhivirajRacun(bezKase);
            }
            throw e;
        }
    }

    public Faktura getFaktura(Fiskalniracun racun, EntityManager em) {
        Faktura f = null;
        f = new Faktura();
        f.setTip("FAKTURA");
        f.setArtikalfakturas((List)new IndirectList());
        f.setRadnajedinica(racun.getRadnajedinica());
        f.setDatum(PzDateUtility.getServerDate((EntityManager)em));
        for (Proizvodfiskalniracun proizvod : racun.getProizvodfiskalniracuns()) {
            if (proizvod.getId().getSfrProizvod().endsWith("U")) continue;
            Artikalfaktura af = new Artikalfaktura();
            Artikal a = (Artikal)em.find(Artikal.class, (Object)proizvod.getId().getSfrProizvod());
            af.setArtikal(a);
            af.setId(1, proizvod.getId().getSfrProizvod(), 1);
            af.setKolicina(proizvod.getKolicina());
            af.setCena(proizvod.getCena());
            af.setNaziv(proizvod.getNaziv());
            af.setJm(proizvod.getJm());
            af.setAftaksas(new Vector());
            if (proizvod.getTaksas() != null || proizvod.getTaksas().size() != 0) {
                for (PzADTaksa t : proizvod.getTaksas()) {
                    af.getAftaksas().add(new Aftaksa(f.getIdDok(), proizvod.getId().getSfrProizvod(), t.getOznTarGr(), 0, t.getStopa(), t.getOznVrstaTG(), ""));
                }
            }
            f.getArtikalfakturas().add(af);
        }
        return f;
    }

    private void arhiviraj(Nivelacija nivel, EntityManager em) throws Exception {
        if (nivel == null) {
            return;
        }
        PzDokumentManager.getInstance().arhivirajDokument((PzDokument)nivel, true, null, em);
    }

    private void napraviPrazanRacun() {
        if (this.getSession().getParameter("izArhiveObrisanih") != null) {
            return;
        }
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                em.getTransaction().begin();
                if (!((PzDialogIzradaMaloprodajnogRacunaNew)((Object)this.getParent())).getFiskalniRacun().booleanValue()) {
                    ((PzDialogIzradaMaloprodajnogRacunaNew)((Object)this.getParent())).createFiskalniRacun(em);
                }
                ((PzDialogIzradaMaloprodajnogRacunaNew)((Object)this.getParent())).refreshDataTable();
                ((PzDialogIzradaMaloprodajnogRacunaNew)((Object)this.getParent())).refreshIznos();
                ((PzDialogIzradaMaloprodajnogRacunaNew)((Object)this.getParent())).resetDialogData();
                em.getTransaction().commit();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                if (e instanceof OptimisticLockException || e.getCause() instanceof OptimisticLockException) {
                    this.napraviPrazanRacun();
                } else {
                    PzMysqlExceptionHandler.handle((Throwable)e);
                }
                em.close();
            }
        }
        finally {
            em.close();
        }
    }
}

