/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.display;

import com.fazecast.jSerialComm.SerialPort;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import rs.pezar.core.log.PzLogger;

public class SerialStream
extends PipedOutputStream {
    private final PipedInputStream pipedInputStream = new PipedInputStream();
    private final Thread threadPrint;

    public SerialStream(final String portDescriptor, final int baud) throws IOException {
        super.connect(this.pipedInputStream);
        Thread.UncaughtExceptionHandler uncaughtException = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                e.printStackTrace();
                PzLogger.getInstance().logException(e);
            }
        };
        Runnable runnablePrint = new Runnable(){

            @Override
            public void run() {
                try {
                    SerialPort comPort = SerialPort.getCommPort((String)portDescriptor);
                    comPort.setBaudRate(baud);
                    if (!comPort.openPort()) {
                        throw new IOException("Error on comPort.openPort call");
                    }
                    OutputStream outputStream = comPort.getOutputStream();
                    try {
                        int n;
                        byte[] buf = new byte[1024];
                        while ((n = SerialStream.this.pipedInputStream.read(buf)) >= 0) {
                            outputStream.write(buf, 0, n);
                        }
                    }
                    finally {
                        outputStream.close();
                        comPort.closePort();
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        this.threadPrint = new Thread(runnablePrint);
        this.threadPrint.setUncaughtExceptionHandler(uncaughtException);
        this.threadPrint.start();
    }

    public void setUncaughtException(Thread.UncaughtExceptionHandler uncaughtException) {
        this.threadPrint.setUncaughtExceptionHandler(uncaughtException);
    }
}

