/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.display;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import rs.pezar.core.PzApplication;
import rs.pezar.core.log.PzLogger;

public class DisplayProperties {
    public static final int DEF_BAUD = 9600;
    public static final int DEF_ROWS = 2;
    public static final int DEF_COLS = 20;
    private String port;
    private int baud = 9600;
    private int rows = 2;
    private int columns = 20;

    public DisplayProperties(String port, int baud, int rows, int columns) {
        this.port = port;
        this.baud = baud;
        this.rows = rows;
        this.columns = columns;
    }

    public String getPort() {
        return this.port;
    }

    public int getBaud() {
        return this.baud;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    private static DisplayProperties create(Properties props) {
        String port = props.getProperty("port");
        try {
            int baud = Integer.parseInt(props.getProperty("baud", String.valueOf(9600)));
            int rows = Integer.parseInt(props.getProperty("rows", String.valueOf(2)));
            int columns = Integer.parseInt(props.getProperty("columns", String.valueOf(20)));
            return new DisplayProperties(port, baud, rows, columns);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            PzLogger.getInstance().logException((Throwable)e);
            return new DisplayProperties(port, 9600, 2, 20);
        }
    }

    public static DisplayProperties load() {
        Properties props = new Properties();
        File propsFile = DisplayProperties.getPropsFile();
        if (!propsFile.exists()) {
            return DisplayProperties.create(props);
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(propsFile);
            props.load(is);
            DisplayProperties displayProperties = DisplayProperties.create(props);
            return displayProperties;
        }
        catch (Exception e) {
            PzLogger.getInstance().logException((Throwable)e);
            e.printStackTrace();
            DisplayProperties displayProperties = DisplayProperties.create(props);
            return displayProperties;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e1) {
                    PzLogger.getInstance().logException((Throwable)e1);
                    e1.printStackTrace();
                }
            }
        }
    }

    public static void save(DisplayProperties dp) {
        block12: {
            Properties props = new Properties();
            props.put("port", dp.getPort());
            props.put("baud", String.valueOf(dp.getBaud()));
            props.put("rows", String.valueOf(dp.getRows()));
            props.put("columns", String.valueOf(dp.getColumns()));
            FileOutputStream os = null;
            try {
                try {
                    os = new FileOutputStream(DisplayProperties.getPropsFile());
                    props.store(os, "External display proerties");
                }
                catch (Exception e) {
                    PzLogger.getInstance().logException((Throwable)e);
                    e.printStackTrace();
                    if (os == null) break block12;
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        PzLogger.getInstance().logException((Throwable)e2);
                    }
                }
            }
            finally {
                if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        PzLogger.getInstance().logException((Throwable)e);
                    }
                }
            }
        }
    }

    private static File getPropsFile() {
        String propertiesLocation = String.valueOf(PzApplication.getApplication().getConfigFolder().getAbsolutePath()) + File.separator + "display.properties";
        return new File(propertiesLocation);
    }
}

