/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.indexes;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import org.xBaseJ.DBF;
import org.xBaseJ.Util;
import org.xBaseJ.fields.Field;
import org.xBaseJ.indexes.BinaryTree;
import org.xBaseJ.indexes.Index;
import org.xBaseJ.indexes.Node;
import org.xBaseJ.indexes.NodeKey;
import org.xBaseJ.xBaseJException;

public class NDX
extends Index {
    public NDX() {
    }

    public NDX(String filename, DBF indatabase, char readonly) throws IOException, xBaseJException {
        int Index_record;
        Node lNode = null;
        Field Field2 = null;
        this.dosname = filename;
        this.database = indatabase;
        this.file = new File(filename);
        if (!this.file.exists() || !this.file.isFile()) {
            throw new xBaseJException("Unknown Index file");
        }
        this.nfile = readonly == 'r' ? new RandomAccessFile(filename, "r") : new RandomAccessFile(filename, "rw");
        this.anchor_read();
        int reading = Index_record = this.top_Node;
        int i = 0;
        while (i < 488) {
            if (this.key_definition[i] <= 32) break;
            ++i;
        }
        try {
            this.stringKey = new String(this.key_definition, 0, i, DBF.encodedType);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.stringKey = new String(this.key_definition, 0, i);
        }
        StringTokenizer strtok = new StringTokenizer(this.stringKey, "+ ");
        while (strtok.hasMoreElements()) {
            String wb = (String)strtok.nextElement();
            wb = wb.trim();
            Field2 = this.database.getField(wb);
            this.keyControl.addElement(Field2);
        }
        while (reading > 0) {
            if (this.topNode == null) {
                lNode = new Node(this.nfile, this.key_per_Node, this.key_length, this.keyType, Index_record, false);
            } else {
                Node llNode = new Node(this.nfile, this.key_per_Node, this.key_length, this.keyType, Index_record, false);
                lNode.set_prev(llNode);
                lNode = llNode;
            }
            this.workNode = lNode;
            lNode.set_pos(0);
            lNode.read();
            if (reading > 0 && (Index_record = lNode.get_lower_level()) == 0) {
                Index_record = lNode.get_key_record_number();
                reading = 0;
                lNode.set_pos(0);
            }
            if (this.topNode != null) continue;
            this.topNode = (Node)lNode.clone();
        }
        if (this.topNode == null) {
            this.workNode = this.topNode = new Node(this.nfile, this.key_per_Node, this.key_length, this.keyType, Index_record, false);
        }
    }

    public NDX(String name, String NDXString, DBF indatabase, boolean destroy, boolean unique) throws xBaseJException, IOException {
        int key_type = 32;
        StringTokenizer strtok = new StringTokenizer(NDXString.toUpperCase(), "+");
        this.file = new File(name);
        this.dosname = name;
        this.database = indatabase;
        if (!destroy && this.file.exists()) {
            throw new xBaseJException("NDX file already exists");
        }
        if (destroy && this.file.exists() && !this.file.delete()) {
            throw new xBaseJException("Can't delete old NDX file");
        }
        this.key_length = 0;
        this.stringKey = new String(NDXString);
        this.set_key_definition(NDXString);
        this.unique_key = (byte)(unique ? 64 : 0);
        while (strtok.hasMoreElements()) {
            String tempch1 = (String)strtok.nextElement();
            Field Field2 = this.database.getField(tempch1);
            int type = Field2.getType();
            if (type == 77) {
                throw new xBaseJException("Can't make memo field part of a key");
            }
            if (type == 76) {
                throw new xBaseJException("Can't make logical ield part of a key");
            }
            if (type == 70) {
                throw new xBaseJException("Can't make float field part of a key");
            }
            if (key_type == 32) {
                key_type = type;
            } else if (key_type == 68 && type == 78) {
                key_type = 78;
            } else if (key_type == 78 && type == 68) {
                key_type = 78;
            } else if (key_type != type) {
                key_type = 67;
            }
            this.key_length = (short)(this.key_length + Field2.getLength());
            this.keyControl.addElement(Field2);
        }
        if (key_type == 68 || key_type == 78) {
            this.keyType = (char)78;
            this.key_length = (short)8;
        } else {
            this.keyType = (char)67;
        }
        int len = ((this.key_length - 1) / 4 + 1) * 4;
        if (len < 1) {
            throw new xBaseJException("key length too short");
        }
        if (len > 100) {
            throw new xBaseJException("key length too int");
        }
        this.next_available = 1;
        this.key_entry_size = (short)(len += 8);
        this.key_per_Node = (short)(509 / len);
        this.nfile = new RandomAccessFile(name, "rw");
        this.anchor_write();
        if (this.database.getRecordCount() > 0) {
            this.bIndex();
        } else {
            this.workNode = this.topNode = new Node(this.nfile, this.key_per_Node, this.key_length, this.keyType, this.next_available, false);
            this.topNode.set_pos(0);
            this.top_Node = this.next_available++;
            this.anchor_write();
            this.topNode.set_lower_level(0);
            this.topNode.set_key_record_number(0);
            this.topNode.set_keys_in_this_Node(0);
            this.topNode.write();
        }
    }

    public void close() throws IOException {
        this.nfile.close();
    }

    @Override
    public int find_entry(NodeKey findKey) throws xBaseJException, IOException {
        return this.find_entry(findKey, -2);
    }

    @Override
    public int find_entry(NodeKey findKey, int rec) throws xBaseJException, IOException {
        if (this.topNode == null) {
            throw new xBaseJException("No keys built");
        }
        this.topNode.set_pos(0);
        this.record = this.find_entry(findKey, this.topNode, rec);
        return this.record;
    }

    public int find_entry(NodeKey findKey, Node aNode, int findrec) throws xBaseJException, IOException {
        this.foundExact = false;
        int stat = 1;
        this.workNode = aNode;
        if (aNode == null) {
            throw new xBaseJException("No keys built");
        }
        int leaf = aNode.get_lower_level();
        int until = leaf != 0 ? aNode.get_keys_in_this_Node() + 1 : aNode.get_keys_in_this_Node();
        aNode.set_pos(0);
        while (aNode.get_pos() < until && stat > 0) {
            leaf = aNode.get_lower_level();
            int rec = aNode.get_key_record_number();
            if (aNode.get_pos() >= aNode.get_keys_in_this_Node() || (stat = findKey.compareKey(aNode.get_key_value())) <= 0) {
                if (leaf > 0) {
                    Node Node_2;
                    if (aNode.get_next() == null) {
                        Node_2 = new Node(this.nfile, this.key_per_Node, this.key_length, this.keyType, leaf, true);
                        aNode.set_next(Node_2);
                        Node_2.set_prev(aNode);
                    } else {
                        Node_2 = aNode.get_next();
                    }
                    Node_2.set_record_number(leaf);
                    Node_2.read();
                    Node_2.set_pos(0);
                    this.workNode = Node_2;
                    rec = this.find_entry(findKey, Node_2, findrec);
                    return rec;
                }
                if (stat < 0) {
                    if (findrec > 0) {
                        return -3;
                    }
                    if (findrec == -1) {
                        return -3;
                    }
                    return rec;
                }
                this.foundExact = true;
                if (findrec > 0 && rec == findrec) {
                    return rec;
                }
                if (findrec == -1) {
                    return rec;
                }
                if (findrec == -2) {
                    return rec;
                }
            }
            aNode.pos_up();
        }
        return -4;
    }

    public void bIndex() throws xBaseJException, IOException {
        int reccount = this.database.getRecordCount();
        BinaryTree topTree = null;
        if (this.database.getRecordCount() > 0) {
            this.database.gotoRecord(1);
            this.top_Node = 0;
            this.next_available = 1;
            int i = 1;
            while (i <= reccount) {
                NodeKey lastkey = this.build_key();
                if (topTree == null) {
                    topTree = new BinaryTree(lastkey, i, topTree);
                } else {
                    new BinaryTree(lastkey, i, topTree);
                }
                if (i < reccount) {
                    this.database.read();
                }
                ++i;
            }
            this.topNode = null;
            this.reIndexWork(topTree.getLeast(), 0);
            this.anchor_write();
        }
    }

    @Override
    public void reIndex() throws xBaseJException, IOException {
        int reccount = this.database.getRecordCount();
        BinaryTree topTree = null;
        this.top_Node = 0;
        this.next_available = 1;
        int i = 1;
        while (i <= reccount) {
            this.database.gotoRecord(i);
            NodeKey lastkey = this.build_key();
            if (topTree == null) {
                topTree = new BinaryTree(lastkey, i, topTree);
            } else {
                new BinaryTree(lastkey, i, topTree);
            }
            ++i;
        }
        this.topNode = null;
        this.nfile.close();
        this.file.delete();
        this.nfile = new RandomAccessFile(this.file, "rw");
        this.anchor_write();
        if (this.database.getRecordCount() > 0) {
            this.reIndexWork(topTree.getLeast(), 0);
        }
        this.anchor_write();
    }

    private int reIndexWork(BinaryTree bt, int level) throws IOException, xBaseJException {
        BinaryTree tree2 = null;
        int pos = 0;
        this.top_Node = this.next_available;
        this.workNode = new Node(this.nfile, this.key_per_Node, this.key_length, this.keyType, this.top_Node, level > 0);
        ++this.next_available;
        this.workNode.set_pos(0);
        NodeKey lastKey = null;
        while (true) {
            if (pos == this.key_per_Node || bt == null) {
                int i;
                if (tree2 == null && pos == 1 && level > 0 || pos == 0) {
                    --this.top_Node;
                    --this.next_available;
                    this.topNode = this.workNode;
                    i = pos;
                    while (i < this.key_per_Node) {
                        this.workNode.set_pos(i);
                        this.workNode.set_key_value(lastKey);
                        ++i;
                    }
                    this.workNode.write();
                    break;
                }
                if (bt != null || tree2 != null) {
                    if (tree2 == null) {
                        this.topNode = this.workNode;
                        tree2 = new BinaryTree(lastKey, this.workNode.get_record_number(), tree2);
                    } else {
                        new BinaryTree(lastKey, this.workNode.get_record_number(), tree2);
                    }
                }
                if (level == 0) {
                    this.workNode.set_keys_in_this_Node(pos);
                } else {
                    this.workNode.set_keys_in_this_Node(pos - 1);
                }
                i = pos;
                while (i < this.key_per_Node) {
                    this.workNode.set_pos(i);
                    this.workNode.set_key_value(lastKey);
                    ++i;
                }
                this.workNode.write();
                if (bt == null) {
                    this.topNode = this.workNode;
                    break;
                }
                this.top_Node = this.next_available;
                this.workNode = new Node(this.nfile, this.key_per_Node, this.key_length, this.keyType, this.top_Node, level > 0);
                ++this.next_available;
                pos = 0;
                this.workNode.set_pos(0);
            }
            ++pos;
            lastKey = bt.getKey();
            this.workNode.set_key_value(lastKey);
            if (level == 0) {
                this.workNode.set_key_record_number(bt.getWhere());
            } else {
                this.workNode.set_lower_level(bt.getWhere());
            }
            this.workNode.pos_up();
            bt = bt.getNext();
        }
        if (tree2 == null) {
            return 0;
        }
        return this.reIndexWork(tree2.getLeast(), ++level);
    }

    @Override
    public int add_entry(NodeKey NDXkey, int recno) throws xBaseJException, IOException {
        if (this.topNode != null) {
            this.find_entry(NDXkey, -2);
        }
        this.set_active_key(NDXkey);
        return this.update_entry(this.workNode, NDXkey, 0, 0, recno);
    }

    private int update_entry(Node aNode, NodeKey NDXkey, int leftleaf, int rightleaf, int recno) throws IOException, xBaseJException {
        if (this.topNode == null) {
            this.workNode = this.topNode = new Node(this.nfile, this.key_per_Node, this.key_length, this.keyType, this.next_available, false);
            this.topNode.set_pos(0);
            this.top_Node = this.next_available++;
            this.anchor_write();
            this.topNode.set_lower_level(0);
            this.topNode.set_key_record_number(recno);
            this.topNode.set_key_value(NDXkey);
            this.topNode.set_keys_in_this_Node(1);
            this.topNode.write();
            return 0;
        }
        if (leftleaf > 0 && recno > 0) {
            Node bNode = new Node(this.nfile, this.key_per_Node, this.key_length, this.keyType, this.next_available, true);
            aNode.set_prev(bNode);
            bNode.set_next(aNode);
            bNode.set_pos(0);
            bNode.set_lower_level(leftleaf);
            bNode.set_key_record_number(0);
            bNode.set_key_value(NDXkey);
            bNode.pos_up();
            bNode.set_lower_level(recno);
            bNode.set_key_record_number(0);
            this.topNode = bNode;
            bNode.set_keys_in_this_Node(1);
            this.top_Node = this.next_available++;
            bNode.set_record_number(this.top_Node);
            this.anchor_write();
            bNode.write();
            return 0;
        }
        int savepos = aNode.get_pos();
        if (savepos < aNode.get_keys_in_this_Node()) {
            int i = aNode.get_keys_in_this_Node();
            aNode.set_pos(i);
            int ptr = aNode.get_lower_level();
            aNode.pos_up();
            aNode.set_lower_level(ptr);
            aNode.set_pos(i);
            while (i > -1 && i >= savepos) {
                ptr = aNode.get_lower_level();
                int recn = aNode.get_key_record_number();
                NodeKey buf = aNode.get_key_value();
                aNode.pos_up();
                aNode.set_lower_level(ptr);
                aNode.set_key_record_number(recn);
                aNode.set_key_value(buf);
                aNode.set_pos(i - 1);
                --i;
            }
            aNode.set_pos(savepos);
            aNode.set_lower_level(leftleaf);
            aNode.set_key_record_number(recno);
            aNode.set_key_value(NDXkey);
            if (rightleaf > 0) {
                aNode.pos_up();
                aNode.set_lower_level(rightleaf);
                aNode.pos_down();
            }
        } else {
            aNode.set_pos(aNode.get_keys_in_this_Node());
            aNode.set_lower_level(leftleaf);
            aNode.set_key_record_number(recno);
            aNode.set_key_value(NDXkey);
            if (rightleaf > 0) {
                aNode.pos_up();
                aNode.set_lower_level(rightleaf);
                aNode.pos_down();
            }
        }
        aNode.set_keys_in_this_Node(aNode.get_keys_in_this_Node() + 1);
        aNode.write();
        if (aNode.get_keys_in_this_Node() >= this.key_per_Node) {
            this.splitNode(aNode, savepos);
        }
        return 0;
    }

    private void splitNode(Node aNode, int savepos) throws xBaseJException, IOException {
        Node bNode = new Node(this.nfile, this.key_per_Node, this.key_length, this.keyType, 0, aNode.isBranch());
        bNode.set_pos(0);
        aNode.set_pos(0);
        int k = 0;
        while (k < aNode.get_keys_in_this_Node()) {
            bNode.set_lower_level(aNode.get_lower_level());
            bNode.set_key_record_number(aNode.get_key_record_number());
            bNode.set_key_value(aNode.get_key_value());
            bNode.pos_up();
            aNode.pos_up();
            ++k;
        }
        bNode.set_lower_level(aNode.get_lower_level());
        bNode.set_key_record_number(0);
        bNode.set_key_value("");
        int i = aNode.get_keys_in_this_Node() / 2;
        int j = aNode.get_keys_in_this_Node() - i;
        if (savepos > i) {
            bNode.set_keys_in_this_Node(i);
            if (aNode.get_next() != null) {
                aNode.set_keys_in_this_Node(i - 1);
            } else {
                aNode.set_keys_in_this_Node(i);
            }
            int left = aNode.get_record_number();
            aNode.write();
            int right = this.next_available++;
            this.anchor_write();
            if (aNode.get_prev() != null) {
                bNode.set_pos(i - 1);
                this.update_entry(aNode.get_prev(), bNode.get_key_value(), aNode.get_record_number(), right, 0);
            }
            aNode.set_pos(0);
            bNode.set_pos(i);
            k = 0;
            while (k <= j) {
                aNode.set_lower_level(bNode.get_lower_level());
                aNode.set_key_record_number(bNode.get_key_record_number());
                aNode.set_key_value(bNode.get_key_value());
                aNode.pos_up();
                bNode.pos_up();
                ++k;
            }
            aNode.set_keys_in_this_Node(j);
            aNode.set_pos(savepos - i);
            aNode.set_record_number(right);
            aNode.write();
            if (aNode.get_prev() == null) {
                bNode.set_pos(i - 1);
                this.update_entry(bNode, bNode.get_key_value(), left, 0, right);
            }
        } else {
            int right = aNode.get_record_number();
            aNode.set_pos(0);
            bNode.set_pos(j);
            k = 0;
            while (k <= i) {
                aNode.set_lower_level(bNode.get_lower_level());
                aNode.set_key_record_number(bNode.get_key_record_number());
                aNode.set_key_value(bNode.get_key_value());
                aNode.pos_up();
                bNode.pos_up();
                ++k;
            }
            aNode.set_keys_in_this_Node(i);
            aNode.write();
            bNode.set_keys_in_this_Node(i);
            aNode.set_pos(0);
            bNode.set_pos(0);
            k = 0;
            while (k < this.key_per_Node) {
                aNode.set_lower_level(bNode.get_lower_level());
                aNode.set_key_record_number(bNode.get_key_record_number());
                aNode.set_key_value(bNode.get_key_value());
                aNode.pos_up();
                bNode.pos_up();
                ++k;
            }
            aNode.set_record_number(this.next_available);
            ++this.next_available;
            this.anchor_write();
            if (aNode.get_next() != null) {
                aNode.set_keys_in_this_Node(j - 1);
            } else {
                aNode.set_keys_in_this_Node(j);
            }
            aNode.set_pos(j - 1);
            aNode.write();
            int left = aNode.get_record_number();
            if (aNode.get_prev() != null) {
                this.update_entry(aNode.get_prev(), aNode.get_key_value(), left, right, 0);
            } else {
                bNode.set_pos(j - 1);
                this.update_entry(bNode, bNode.get_key_value(), left, 0, right);
            }
        }
        bNode = null;
    }

    @Override
    public void del_entry(Node inNode) throws IOException, xBaseJException {
        int pos;
        Node aNode = inNode;
        int k = pos = aNode.get_pos();
        aNode.set_keys_in_this_Node(aNode.get_keys_in_this_Node() - 1);
        if (aNode.get_lower_level() != 0 && pos <= aNode.get_keys_in_this_Node()) {
            k = pos - 1;
            while (k < aNode.get_keys_in_this_Node()) {
                aNode.pos_up();
                int level = aNode.get_lower_level();
                int rec = aNode.get_key_record_number();
                NodeKey key = aNode.get_key_value();
                aNode.pos_down();
                aNode.set_lower_level(level);
                aNode.set_key_record_number(rec);
                aNode.set_key_value(key);
                aNode.pos_up();
                ++k;
            }
        } else if (pos < aNode.get_keys_in_this_Node()) {
            k = pos;
            while (k < aNode.get_keys_in_this_Node()) {
                aNode.pos_up();
                int level = aNode.get_lower_level();
                int rec = aNode.get_key_record_number();
                NodeKey key = aNode.get_key_value();
                aNode.pos_down();
                aNode.set_lower_level(level);
                aNode.set_key_record_number(rec);
                aNode.set_key_value(key);
                aNode.pos_up();
                ++k;
            }
        }
        if (aNode.get_prev() != null) {
            if (aNode.get_keys_in_this_Node() == 0) {
                if (aNode.get_lower_level() == 0) {
                    this.del_entry(aNode.get_prev());
                }
            } else if (aNode.get_keys_in_this_Node() == -1) {
                this.del_entry(aNode.get_prev());
            }
        }
        aNode.set_pos(pos);
        aNode.write();
    }

    @Override
    public int get_next_key() throws xBaseJException, IOException {
        return this.get_next_key(this.workNode);
    }

    private int get_next_key(Node aNode) throws xBaseJException, IOException {
        if (aNode == null) {
            return -1;
        }
        aNode.pos_up();
        int leaf = aNode.get_lower_level();
        int until = leaf > 0 ? aNode.get_keys_in_this_Node() + 1 : aNode.get_keys_in_this_Node();
        if (aNode.get_pos() >= until) {
            Node rNode = aNode.get_prev();
            int rec = this.get_next_key(rNode);
            if (rec == -1) {
                aNode.set_pos(until);
                return -1;
            }
            this.workNode = aNode;
            aNode.set_record_number(rec);
            aNode.read();
            aNode.set_pos(0);
        }
        leaf = aNode.get_lower_level();
        this.workNode = aNode;
        if (leaf > 0) {
            return leaf;
        }
        return aNode.get_key_record_number();
    }

    @Override
    public int get_prev_key() throws xBaseJException, IOException {
        return this.get_prev_key(this.workNode);
    }

    private int get_prev_key(Node aNode) throws xBaseJException, IOException {
        if (aNode == null) {
            return -1;
        }
        if (aNode.get_pos() < 0) {
            return -1;
        }
        int leaf = aNode.get_lower_level();
        int until = leaf > 0 ? 1 : 0;
        if (aNode.get_pos() > -1) {
            aNode.pos_down();
        }
        if (aNode.get_pos() < 0) {
            int rec = this.get_prev_key(aNode.get_prev());
            if (rec == -1) {
                return -1;
            }
            aNode.set_record_number(rec);
            aNode.read();
            aNode.set_pos(aNode.get_keys_in_this_Node() + until);
            aNode.pos_down();
        }
        leaf = aNode.get_lower_level();
        this.workNode = aNode;
        if (leaf > 0) {
            return leaf;
        }
        return aNode.get_key_record_number();
    }

    public void anchor_read() throws IOException {
        this.nfile.seek(0L);
        this.top_Node = this.nfile.readInt();
        this.next_available = this.nfile.readInt();
        this.reserved_02 = this.nfile.readInt();
        this.key_length = this.nfile.readShort();
        this.key_per_Node = this.nfile.readShort();
        this.keyType = (char)(this.nfile.readShort() != 0 ? 78 : 67);
        this.key_entry_size = this.nfile.readShort();
        this.reserved_01 = this.nfile.readByte();
        this.reserved_03 = this.nfile.readByte();
        this.reserved_04 = this.nfile.readByte();
        this.unique_key = this.nfile.readByte();
        this.nfile.readFully(this.key_definition, 0, 488);
        this.redo_numbers();
    }

    public void anchor_write() throws IOException {
        this.nfile.seek(0L);
        this.redo_numbers();
        this.nfile.writeInt(this.top_Node);
        this.nfile.writeInt(this.next_available);
        this.nfile.writeInt(this.reserved_02);
        this.nfile.writeShort(this.key_length);
        this.nfile.writeShort(this.key_per_Node);
        this.nfile.writeShort(this.keyType == 'N' ? 1 : 0);
        this.nfile.writeShort(this.key_entry_size);
        this.nfile.writeByte(this.reserved_01);
        this.nfile.writeByte(this.reserved_03);
        this.nfile.writeByte(this.reserved_04);
        this.nfile.writeByte(this.unique_key);
        this.nfile.write(this.key_definition, 0, 488);
        this.redo_numbers();
    }

    public void redo_numbers() {
        this.top_Node = Util.x86(this.top_Node);
        this.next_available = Util.x86(this.next_available);
        this.key_length = Util.x86(this.key_length);
        this.key_per_Node = Util.x86(this.key_per_Node);
        this.key_entry_size = Util.x86(this.key_entry_size);
    }
}

