/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.indexes;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Vector;
import org.xBaseJ.DBF;
import org.xBaseJ.Util;
import org.xBaseJ.fields.Field;
import org.xBaseJ.indexes.Node;
import org.xBaseJ.indexes.NodeFloat;
import org.xBaseJ.indexes.NodeKey;
import org.xBaseJ.xBaseJException;

public abstract class Index {
    public int top_Node;
    public int next_available;
    public int reserved_02;
    public short key_length;
    public short key_per_Node;
    public char keyType;
    public short key_entry_size;
    public byte reserved_01;
    public byte reserved_03;
    public byte reserved_04;
    public byte unique_key;
    public byte[] key_definition = new byte[488];
    public Vector keyControl = new Vector();
    public NodeKey activeKey = null;
    public int record;
    public Node topNode = null;
    public Node workNode;
    public File file;
    public RandomAccessFile nfile;
    public FileChannel channel;
    public ByteBuffer bytebuffer;
    public String dosname = new String("");
    public DBF database;
    public String stringKey;
    public static final int findFirstMatchingKey = -1;
    public static final int findAnyKey = -2;
    public static final int keyNotFound = -3;
    public static final int foundMatchingKeyButNotRecord = -4;
    public boolean foundExact = false;

    public boolean compareKey(String keyToCompare) throws xBaseJException, IOException {
        NodeKey tempKey;
        if (this.keyType == 'F') {
            tempKey = new NodeKey(new NodeFloat(Double.valueOf(keyToCompare)));
        } else if (this.keyType == 'N') {
            Double d = new Double(keyToCompare);
            tempKey = new NodeKey(d);
        } else {
            tempKey = new NodeKey(keyToCompare);
        }
        return this.activeKey.compareKey(tempKey) == 0;
    }

    public abstract int add_entry(NodeKey var1, int var2) throws xBaseJException, IOException;

    public int add_entry(int recno) throws xBaseJException, IOException {
        NodeKey newkey = this.build_key();
        return this.add_entry(newkey, recno);
    }

    public abstract int find_entry(NodeKey var1) throws xBaseJException, IOException;

    public abstract int find_entry(NodeKey var1, int var2) throws xBaseJException, IOException;

    public int find_entry(String key) throws xBaseJException, IOException {
        if (this.keyType == 'F') {
            return this.find_entry(new NodeKey(new NodeFloat(Double.valueOf(key))));
        }
        if (this.keyType == 'N') {
            double d = 0.0;
            Field f = (Field)this.keyControl.elementAt(0);
            d = f.getType() == 'D' ? Util.doubleDate(key) : Double.valueOf(key);
            return this.find_entry(new NodeKey(new Double(d)));
        }
        return this.find_entry(new NodeKey(key));
    }

    public int find_entry(String key, int recno) throws xBaseJException, IOException {
        this.record = this.keyType == 'F' ? this.find_entry(new NodeKey(new NodeFloat(Double.valueOf(key))), recno) : (this.keyType == 'N' ? this.find_entry(new NodeKey(new Double(key)), recno) : this.find_entry(new NodeKey(key), recno));
        return this.record;
    }

    public abstract int get_next_key() throws xBaseJException, IOException;

    public abstract int get_prev_key() throws xBaseJException, IOException;

    public abstract void del_entry(Node var1) throws IOException, xBaseJException;

    public abstract void reIndex() throws xBaseJException, IOException;

    public void check_for_duplicates(int count) throws xBaseJException, IOException {
        if (this.topNode == null) {
            return;
        }
        int ret = this.find_entry(this.build_key(), -1);
        if (this.unique_key == 0) {
            return;
        }
        if (ret == -3) {
            return;
        }
        if (count == -1 && ret == count) {
            return;
        }
        if (count > 0 && ret == count) {
            return;
        }
        if (ret > 0) {
            throw new xBaseJException("Duplicate key error");
        }
    }

    public String getName() {
        return this.dosname.trim();
    }

    public String getKeyFields() {
        return this.stringKey;
    }

    public String buildKey() throws xBaseJException {
        return this.build_key().toString();
    }

    public NodeKey build_key() throws xBaseJException {
        NodeKey dataptr;
        double doubleer = 0.0;
        switch (this.keyType) {
            case 'F': {
                int i = 0;
                while (i < this.keyControl.size()) {
                    Field f = (Field)this.keyControl.elementAt(i);
                    if (f.get() != null && f.get().length() != 0) {
                        doubleer = f.getType() == 'D' ? (doubleer += Util.doubleDate(f.get())) : (doubleer += Double.valueOf(f.get()).doubleValue());
                    }
                    ++i;
                }
                dataptr = new NodeKey(new NodeFloat(doubleer));
                break;
            }
            case 'N': {
                int i = 0;
                while (i < this.keyControl.size()) {
                    Field f = (Field)this.keyControl.elementAt(i);
                    if (f.get() != null && f.get().length() != 0) {
                        doubleer = f.getType() == 'D' ? (doubleer += Util.doubleDate(f.get())) : (doubleer += Double.valueOf(f.get()).doubleValue());
                    }
                    ++i;
                }
                dataptr = new NodeKey(new Double(doubleer));
                break;
            }
            default: {
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < this.keyControl.size()) {
                    Field f = (Field)this.keyControl.elementAt(i);
                    sb.append(f.get());
                    ++i;
                }
                dataptr = new NodeKey(new String(sb));
            }
        }
        return dataptr;
    }

    public boolean is_unique_key() {
        return this.unique_key != 0;
    }

    public void set_active_key(NodeKey key) {
        this.activeKey = key;
    }

    public NodeKey get_active_key() {
        return this.activeKey;
    }

    public void set_key_definition(String definition) {
        byte[] kd;
        try {
            kd = definition.getBytes(DBF.encodedType);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            kd = definition.getBytes();
        }
        int x = 0;
        while (x < kd.length) {
            this.key_definition[x] = kd[x];
            ++x;
        }
    }

    public void update(int recno) throws xBaseJException, IOException {
        NodeKey bkey = this.build_key();
        this.record = this.find_entry(this.activeKey, recno);
        if (this.record == recno) {
            if (bkey.compareKey(this.activeKey) != 0) {
                this.del_entry(this.workNode);
                this.add_entry(recno);
            }
        } else {
            this.add_entry(recno);
        }
    }

    public void position_at_first() throws xBaseJException, IOException {
        String startKey = this.keyType == 'N' ? new NodeKey(new Double(-1.78E308)).toString() : (this.keyType == 'F' ? new NodeKey(new NodeFloat(-1.78E308)).toString() : new NodeKey(new String("\u0000")).toString());
        this.find_entry(startKey, -1);
        this.workNode.set_pos(-1);
    }

    public void position_at_last() throws xBaseJException, IOException {
        String startKey = this.keyType == 'N' ? new NodeKey(new Double(1.78E308)).toString() : (this.keyType == 'F' ? new NodeKey(new NodeFloat(1.78E308)).toString() : new NodeKey(new String("\uffff")).toString());
        this.find_entry(startKey, -1);
    }

    public boolean didFindFindExact() {
        return this.foundExact;
    }
}

