/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.fields;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.xBaseJ.fields.Field;
import org.xBaseJ.xBaseJException;

public class NumField
extends Field {
    private static final long serialVersionUID = 1L;
    private byte decPosition = 0;
    static DecimalFormatSymbols dfs = new DecimalFormatSymbols();
    static char decimalSeparator = dfs.getDecimalSeparator();

    public NumField() {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        NumField tField = (NumField)super.clone();
        tField.Name = new String(this.Name);
        tField.Length = this.Length;
        tField.decPosition = this.decPosition;
        return tField;
    }

    public NumField(String iName, int iLength, int idecPosition, ByteBuffer inBuffer) throws xBaseJException {
        super.setField(iName, iLength, inBuffer);
        this.decPosition = (byte)idecPosition;
        this.put("");
    }

    public NumField(String iName, int iLength, int inDecPosition) throws xBaseJException, IOException {
        super.setField(iName, iLength, null);
        this.decPosition = (byte)inDecPosition;
    }

    @Override
    public char getType() {
        return 'N';
    }

    @Override
    public int getDecimalPositionCount() {
        return this.decPosition;
    }

    @Override
    public String get() {
        String value = super.get();
        if (value.trim().length() == 0) {
            return "";
        }
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c != ' ') {
                return value;
            }
            ++i;
        }
        StringBuffer format = new StringBuffer();
        int decoffset = this.Length - this.decPosition - 1;
        i = 0;
        while (i < decoffset - 1) {
            format.append(' ');
            ++i;
        }
        if (decoffset > 0) {
            format.append('0');
        }
        if (this.decPosition > 0) {
            format.append(decimalSeparator);
            i = 0;
            while (i < this.decPosition) {
                format.append('0');
                ++i;
            }
        }
        return format.toString();
    }

    @Override
    public void put(String inValue) throws xBaseJException {
        try {
            Double.valueOf(inValue);
        }
        catch (NumberFormatException numberFormatException) {
            super.put("");
            return;
        }
        int worklen = this.Length > inValue.length() ? this.Length : inValue.length();
        char[] charArray = new char[this.Length];
        int i1 = 0;
        while (i1 < this.Length) {
            charArray[i1] = 32;
            ++i1;
        }
        i1 = 0;
        while (i1 < inValue.length()) {
            if (inValue.charAt(i1) == '-' || inValue.charAt(i1) == decimalSeparator || inValue.charAt(i1) >= '0' && inValue.charAt(i1) <= '9') break;
            ++i1;
        }
        boolean neg = false;
        if (inValue.charAt(i1) == '-') {
            neg = true;
            ++i1;
        }
        char[] intForm = new char[worklen];
        int breaklen = this.decPosition == 0 ? worklen : worklen - 1;
        int i2 = 0;
        while (i2 < breaklen) {
            if (i1 >= inValue.length() || inValue.charAt(i1) < '0' || inValue.charAt(i1) > '9') break;
            intForm[i2] = inValue.charAt(i1);
            ++i1;
            ++i2;
        }
        if (i1 < inValue.length() && inValue.charAt(i1) == decimalSeparator) {
            ++i1;
        }
        char[] decForm = new char[worklen];
        int i3 = 0;
        while (i3 < breaklen) {
            decForm[i3] = 48;
            ++i3;
        }
        i3 = 0;
        while (i3 < breaklen) {
            if (i1 >= inValue.length() || inValue.charAt(i1) < '0' || inValue.charAt(i1) > '9') break;
            decForm[i3] = inValue.charAt(i1);
            ++i1;
            ++i3;
        }
        int startpos = this.Length - this.decPosition - 1;
        if (this.decPosition > 0) {
            charArray[startpos] = decimalSeparator;
            --startpos;
        }
        int i4 = startpos;
        while (i4 > -1) {
            if (--i2 < 0) break;
            charArray[i4] = intForm[i2];
            --i4;
        }
        if (neg) {
            if (i4 < 0) {
                charArray[0] = 45;
            } else {
                charArray[i4] = 45;
            }
        }
        if (this.decPosition > 0) {
            startpos += 2;
            i4 = 1;
            while (i4 <= this.decPosition) {
                charArray[startpos] = decForm[i4 - 1];
                ++startpos;
                ++i4;
            }
        }
        super.put(new String(charArray).replace(decimalSeparator, '.'));
    }

    public void put(long inValue) throws xBaseJException {
        this.put(String.valueOf(inValue));
    }

    public void put(int inValue) throws xBaseJException {
        this.put(String.valueOf(inValue));
    }

    public void put(float inValue) throws xBaseJException {
        StringBuffer sb = new StringBuffer(this.getLength() + 1);
        sb.append("#");
        int i = 0;
        while (i < this.getLength()) {
            sb.append("#");
            ++i;
        }
        DecimalFormat df = new DecimalFormat(sb.toString());
        String s = df.format(inValue).trim();
        this.put(s);
    }

    public void put(double inValue) throws xBaseJException {
        StringBuffer sb = new StringBuffer(this.getLength() + 1);
        sb.append("#");
        int i = 0;
        while (i < this.getLength()) {
            sb.append("#");
            ++i;
        }
        if (this.decPosition > 0) {
            int pos = this.getLength() - this.getDecimalPositionCount();
            sb.setCharAt(pos, decimalSeparator);
            ++pos;
            while (pos < this.getLength() + 1) {
                sb.setCharAt(pos, '0');
                ++pos;
            }
        }
        DecimalFormat df = new DecimalFormat(sb.toString());
        String s = df.format(inValue).trim();
        this.put(s);
    }
}

