/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.transformation;

import java.sql.Date;
import java.util.HashMap;
import javax.persistence.EntityManager;
import rs.pezar.core.transformation.DefaultDokumentTransformer;
import rs.pezar.core.transformation.DokumentTransformer;
import rs.pezar.db.PzDokument;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.prodaja.gui.PzDialogFaktureArhiva;
import rs.pezar.prodaja.gui.PzDialogInterniRacun;
import rs.pezar.prodaja.util.PzProdajaUtil;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.util.PzDateUtility;

public class InterniRacunTransformer
extends DokumentTransformer {
    public static final String PARAMETER_RJ = "RJ";
    public static final String PARAMETER_TIP = "TIP_DOKUMENTA";
    public static final String TRANSFORMER = "FAKTURA_TRANSFORMER";
    public static final String PARAMETER_KOMITENT = "KOMITENT";
    public static final String PARAMETER_DATUM_IZRADE = "DATUM_IZRADE";
    public static final String PARAMETER_DATUM_PROMETA = "DATUM_PROMETA";
    public static final String PARAMETER_DATUM_VALUTE = "DATUM_VALUTE";
    public static final String PARAMETER_KURS = "KURS";
    public boolean priprema = false;

    public HashMap<String, Object> getDokumentParameters(PzDialog parent, Lista l) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(PARAMETER_TIP, "FAKTURA_INTERNI_RACUN");
        Radnajedinica rj = PzDialogRJ.getRJ((PzDialog)parent, (Character[])new Character[]{Character.valueOf("V".charAt(0)), Character.valueOf("E".charAt(0)), Character.valueOf("T".charAt(0))});
        parameters.put(PARAMETER_RJ, rj);
        return parameters;
    }

    public PzDokument getDokumentToTransform(PzDialog parent) {
        PzChoice[] choices = new PzChoice[]{new PzChoice("Interni ra\u010dun iz arhive", (Object)"ARHIVA"), new PzChoice("Interni ra\u010dun u pripremi", (Object)"U_PRIPREMI")};
        String choice = (String)PzDialogChoice.showPzDialogChoice((PzDialog)parent, (PzChoice[])choices, (String)"Izabor internog ra\u010duna");
        if (choice == null) {
            return null;
        }
        if (choice.equals("ARHIVA")) {
            return PzDialogFaktureArhiva.getFakturaIzArhive(parent, "kupiZaSebe");
        }
        this.priprema = true;
        return PzDialogInterniRacun.getInterniRacunUPripermi(parent, "kupiZaSebe");
    }

    public PzDokument toDokument(Lista l, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        Faktura rez = null;
        Faktura f = (Faktura)PzProdajaUtil.toFaktura(l, parameters, em);
        if (f != null) {
            rez = f;
        }
        return rez;
    }

    public Lista toLista(PzDokument dokument, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        Lista l = new DefaultDokumentTransformer(Faktura.class, Artikalfaktura.class).toLista(dokument, parameters, em);
        if (this.priprema) {
            l.setNaslov("Interni ra\u010dun od " + PzDateUtility.formatDate((Date)dokument.getDatum()));
        } else {
            l.setNaslov("Interni ra\u010dun od " + PzDateUtility.formatDate((Date)dokument.getDatum()) + " broj " + dokument.getrBroj());
        }
        return l;
    }

    public String getName() {
        return "Transformator internog ra\u010duna";
    }

    public String getDescription() {
        return null;
    }
}

