/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.transformation;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Date;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.prodaja.gui.PzDialogUnosFakture;
import rs.pezar.prodaja.util.PzProdajaUtil;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.util.PzDateUtility;

public class FakturaTransformerParametri
extends PzDialog {
    public static final String PARAMETER_RJ = "RJ";
    public static final String PARAMETER_TIP = "TIP_DOKUMENTA";
    public static final String TRANSFORMER = "FAKTURA_TRANSFORMER";
    public static final String PARAMETER_KOMITENT = "KOMITENT";
    public static final String PARAMETER_DATUM_IZRADE = "DATUM_IZRADE";
    public static final String PARAMETER_DATUM_PROMETA = "DATUM_PROMETA";
    public static final String PARAMETER_DATUM_VALUTE = "DATUM_VALUTE";
    public static final String PARAMETER_KURS = "KURS";
    private JLabel lblSifraKupca;
    private PzFieldIndikator indKursEvra;
    private PzFieldIndikator indKupac;
    private PzTextField tekstKupca;
    private PzDoubleField kursEvra;
    private JLabel jlKursEvra;
    private PzDateField dfDatumValute;
    private PzNumericOnlyTextField nfBrDanaValute;
    private PzDateField dfDatumPrometa;
    private PzDateField dfDatumIzrade;
    private PzTextField nfSifraKupca;
    private PzButton btnPotvrdi;
    private JLabel lblDatumValute;
    private JLabel lblBrojDanaValute;
    private JLabel lblDatumDPO;
    private JLabel lblDatumIzrade;
    private PzPanel plGlavni;
    private Radnajedinica rj;
    private PzPanelHeader header;
    private boolean izmena;
    private String tipF;
    private Faktura f;
    private PzTable table;
    private Komitent komitent;

    public static void main(String[] args) {
        try {
            FakturaTransformerParametri dialog = new FakturaTransformerParametri();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FakturaTransformerParametri() {
        this.tipF = (String)this.getSession().getParameter(PARAMETER_TIP);
        this.initGUI();
    }

    public FakturaTransformerParametri(PzDialog parent) {
        super(parent);
        this.tipF = (String)this.getSession().getParameter(PARAMETER_TIP);
        this.initGUI();
    }

    protected void initGUI() {
        try {
            this.plGlavni = new PzPanel();
            GridBagLayout plGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.plGlavni, "Center");
            plGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            plGlavniLayout.rowHeights = new int[]{10, 25, 25, 25, 25, 25, 25, 7};
            plGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            plGlavniLayout.columnWidths = new int[]{130, 85, 100, 20};
            this.plGlavni.setLayout((LayoutManager)plGlavniLayout);
            this.plGlavni.setPreferredSize(new Dimension(446, 219));
            this.lblSifraKupca = new JLabel();
            this.plGlavni.add((Component)this.lblSifraKupca, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.lblSifraKupca.setText("\u0160ifra kupca");
            this.lblDatumIzrade = new JLabel();
            this.plGlavni.add((Component)this.lblDatumIzrade, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblDatumIzrade.setText("Datum izrade");
            this.lblDatumDPO = new JLabel();
            this.plGlavni.add((Component)this.lblDatumDPO, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblDatumDPO.setText("Datum prometa");
            this.lblBrojDanaValute = new JLabel();
            this.plGlavni.add((Component)this.lblBrojDanaValute, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblBrojDanaValute.setText("Broj dana valute");
            this.lblDatumValute = new JLabel();
            this.plGlavni.add((Component)this.lblDatumValute, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblDatumValute.setText("Datum valute");
            this.btnPotvrdi = new PzButton();
            this.plGlavni.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 25, 0, 25), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.nfSifraKupca = new PzTextField();
            this.plGlavni.add((Component)this.nfSifraKupca, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.nfSifraKupca.setFont(new Font("Tahoma", 0, 14));
            this.nfSifraKupca.setPreferredSize(new Dimension(75, 24));
            this.nfSifraKupca.setEnabled(true);
            this.nfSifraKupca.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.nfSifraKupca.setCustomInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    if (FakturaTransformerParametri.this.komitent == null) {
                        return false;
                    }
                    if (FakturaTransformerParametri.this.komitent.getTip() == 2 && !PzProdajaUtil.mozeFizickoLice(FakturaTransformerParametri.this.rj, FakturaTransformerParametri.this.tipF)) {
                        FakturaTransformerParametri.this.nfSifraKupca.setVal((Object)"");
                        FakturaTransformerParametri.this.tekstKupca.setVal((Object)"");
                        JOptionPane.showMessageDialog((Component)FakturaTransformerParametri.this.indKupac, "Za odabrani tip dokumenta i radne jedinice nije mogu\u0107e izdati fakturu fizi\u010dkom licu!", "Informacija", 1);
                        FakturaTransformerParametri.this.nfSifraKupca.setState(PzFieldIndikator.STATE_INVALID);
                        return false;
                    }
                    if (FakturaTransformerParametri.this.komitent.getDomaciKomitent() != 1) {
                        FakturaTransformerParametri.this.enableKurs(true);
                    } else {
                        FakturaTransformerParametri.this.enableKurs(false);
                    }
                    if (FakturaTransformerParametri.this.komitent.getTip() == 2) {
                        JOptionPane.showMessageDialog((Component)FakturaTransformerParametri.this.indKupac, "Odabrani komitent je fizi\u010dko lice!", "Informacija", 1);
                    }
                    return true;
                }
            });
            this.dfDatumIzrade = new PzDateField();
            this.plGlavni.add((Component)this.dfDatumIzrade, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.dfDatumIzrade.setFont(new Font("Tahoma", 0, 14));
            this.dfDatumIzrade.setPreferredSize(new Dimension(60, 24));
            this.dfDatumIzrade.setDefaultDate(PzDateUtility.getCurrentDate());
            this.dfDatumPrometa = new PzDateField();
            this.plGlavni.add((Component)this.dfDatumPrometa, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.dfDatumPrometa.setFont(new Font("Tahoma", 0, 14));
            this.dfDatumPrometa.setPreferredSize(new Dimension(60, 24));
            this.dfDatumPrometa.setDefaultDate(PzDateUtility.getCurrentDate());
            this.dfDatumPrometa.setCustomInputVerifier(this.getInputVerifier());
            this.nfBrDanaValute = new PzNumericOnlyTextField();
            this.plGlavni.add((Component)this.nfBrDanaValute, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.nfBrDanaValute.setFont(new Font("Tahoma", 0, 14));
            this.nfBrDanaValute.setPreferredSize(new Dimension(75, 24));
            this.nfBrDanaValute.setMaxLength(3);
            this.nfBrDanaValute.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    FakturaTransformerParametri.this.keyRel(evt);
                }
            });
            this.dfDatumValute = new PzDateField();
            this.plGlavni.add((Component)this.dfDatumValute, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.dfDatumValute.setFont(new Font("Tahoma", 0, 14));
            this.dfDatumValute.setPreferredSize(new Dimension(60, 24));
            this.dfDatumValute.setDefaultDate(PzDateUtility.getCurrentDate());
            this.dfDatumValute.setCustomInputVerifier(this.getInputVerifier());
            this.jlKursEvra = new JLabel();
            this.plGlavni.add((Component)this.jlKursEvra, (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jlKursEvra.setText("Kurs evra");
            this.getTekstKupca();
            this.kursEvra = new PzDoubleField();
            this.plGlavni.add((Component)this.kursEvra, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.plGlavni.add((Component)this.getTekstKupca(), (Object)new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 20, 0, 5), 0, 0));
            this.indKupac = new PzFieldIndikator();
            this.plGlavni.add((Component)this.indKupac, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
            this.indKursEvra = new PzFieldIndikator();
            this.plGlavni.add((Component)this.indKursEvra, (Object)new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
            this.kursEvra.setFont(new Font("Tahoma", 0, 14));
            this.kursEvra.setPreferredSize(new Dimension(75, 24));
            this.kursEvra.setLimit(5, 4);
            this.kursEvra.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    PzField field = (PzField)arg0;
                    if (FakturaTransformerParametri.this.kursEvra.getVal() <= 0.0) {
                        field.setState(PzFieldIndikator.STATE_INVALID);
                        return false;
                    }
                    field.setState(PzFieldIndikator.STATE_VALID);
                    return true;
                }
            });
            this.header = new PzPanelHeader();
            this.header.setIcon(new ImageIcon(FakturaTransformerParametri.class.getResource("/rs/pezar/prodaja/resource/img/document.png")));
            this.header.setTitle("Parametri dokumenta");
            this.getContentPane().add((Component)this.header, "North");
            this.nfSifraKupca.setStateIndikator(this.indKupac);
            this.kursEvra.setStateIndikator(this.indKursEvra);
            this.pack();
            this.setSize(600, 330);
            this.setMinimumSize(new Dimension(600, 330));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.plGlavni.validateForm(true)) {
            return;
        }
        try {
            String actionCommand = ((PzButton)e.getSource()).getActionCommand();
            if (actionCommand.equals("potvrdi")) {
                HashMap map = (HashMap)this.getSession().getParameter(TRANSFORMER);
                map.put(PARAMETER_RJ, this.rj);
                map.put(PARAMETER_TIP, this.tipF);
                map.put(PARAMETER_KOMITENT, this.komitent);
                map.put(PARAMETER_DATUM_IZRADE, this.dfDatumIzrade.getVal());
                map.put(PARAMETER_DATUM_PROMETA, this.dfDatumPrometa.getVal());
                map.put(PARAMETER_DATUM_VALUTE, this.dfDatumValute.getVal());
                map.put(PARAMETER_KURS, this.kursEvra.getVal());
                System.out.println("Datum izrade u dijalogu parametri je " + map.get(PARAMETER_DATUM_IZRADE));
            }
            this.dispose();
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    private void keyRel(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            Date datPrometa = this.dfDatumPrometa.getVal();
            if (evt.getComponent() instanceof PzNumericOnlyTextField) {
                int val = this.nfBrDanaValute.getIntVal();
                this.dfDatumValute.setVal((Object)PzDateUtility.add((Date)datPrometa, (int)val));
            }
        }
    }

    private void enableKurs(boolean enable) {
        this.jlKursEvra.setEnabled(enable);
        this.kursEvra.setEnabled(enable);
        this.indKursEvra.setEnabled(enable);
        if (!enable) {
            this.kursEvra.setVal((Object)0);
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.komitent = (Komitent)entity;
            this.nfSifraKupca.setVal((Object)this.komitent.getSfrKomitent());
            this.tekstKupca.setVal((Object)this.komitent.getNaziv());
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogUnosFakture(Boolean.FALSE);
    }

    public FakturaTransformerParametri(Boolean initGUI) {
    }

    public boolean shouldBeShown() {
        boolean result = true;
        this.rj = this.tipF.equals("FAKTURA") ? PzDialogRJ.getRJ((PzDialog)this, (Character[])new Character[]{Character.valueOf("V".charAt(0)), Character.valueOf("E".charAt(0)), Character.valueOf("T".charAt(0))}) : (this.tipF.equals("FAKTURA_ZA_OTPREMNICE") ? (Radnajedinica)this.getSession().getParameter("radnaJedinica") : (this.tipF.equals("OTPREMNICA") ? PzDialogRJ.getRJ((PzDialog)this, (Character[])new Character[]{Character.valueOf("V".charAt(0)), Character.valueOf("T".charAt(0))}) : (this.tipF.equals("PRENOSNICA_SA_KONSIGNACIJE") ? PzDialogRJ.getRJ((PzDialog)this, (String[])new String[]{"T", "ET"}) : (this.tipF.equals("PROFAKTURA") || this.tipF.equals("AVANSNI_RACUN") || this.tipF.equals("FAKTURA_TRANZITA") ? PzDialogRJ.getRJ((PzDialog)this, (Character[])new Character[]{Character.valueOf("V".charAt(0))}) : PzDialogRJ.getRJ((PzDialog)this)))));
        if (this.rj != null) {
            this.setTitle("Otvaranje novog dokumenta u " + this.rj.getOgranak().getNaziv() + "-" + this.rj.getNaziv());
        } else {
            result = false;
        }
        return result;
    }

    private PzTextField getTekstKupca() {
        if (this.tekstKupca == null) {
            this.tekstKupca = new PzTextField();
            this.tekstKupca.setEditable(false);
            this.tekstKupca.setFocusable(false);
            this.tekstKupca.setSize(188, 24);
            this.tekstKupca.setPreferredSize(new Dimension(6, 24));
            this.tekstKupca.setCaretPosition(0);
        }
        return this.tekstKupca;
    }

    private InputVerifier getInputVerifier() {
        return new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                Date datPrometa = FakturaTransformerParametri.this.dfDatumPrometa.getVal();
                if (input == FakturaTransformerParametri.this.dfDatumPrometa) {
                    Date datIzrade = FakturaTransformerParametri.this.dfDatumIzrade.getVal();
                    int razlika = PzDateUtility.subtract((Date)datPrometa, (Date)datIzrade);
                    if (razlika > 0) {
                        JOptionPane.showMessageDialog(FakturaTransformerParametri.this.getParent(), "Datum prometa ne mo\u017ee biti posle datuma izrade!", "Informacija", 1);
                        return false;
                    }
                } else {
                    Date datValute = FakturaTransformerParametri.this.dfDatumValute.getVal();
                    int razlika = PzDateUtility.subtract((Date)datValute, (Date)datPrometa);
                    if (razlika < 0) {
                        JOptionPane.showMessageDialog(FakturaTransformerParametri.this.getParent(), "Datum valute ne mo\u017ee biti manji od datuma prometa!", "Informacija", 1);
                        return false;
                    }
                    FakturaTransformerParametri.this.nfBrDanaValute.setVal((Object)razlika);
                }
                return true;
            }
        };
    }
}

